# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191013;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"437258", "Bad\ Hall",
"432915", "Drosendorf\-Zissersdorf",
"437663", "Steinbach\ am\ Attersee",
"437754", "Waldzell",
"432862", "Heidenreichstein",
"436562", "Mittersill",
"432856", "Weitra",
"437224", "St\.\ Florian",
"432620", "Willendorf",
"436547", "Kaprun",
"432847", "Gross\-Siegharts",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"437728", "Schwand\ im\ Innkreis",
"435265", "Nassereith",
"435678", "Weissenbach\ am\ Lech",
"433576", "Bretstein",
"433622", "Bad\ Aussee",
"437616", "Grünau\ im\ Almtal",
"433616", "Selzthal",
"433148", "Kainach\ bei\ Voitsberg",
"437742", "Mattighofen",
"435518", "Mellau",
"433116", "Kirchbach\ in\ Steiermark",
"432823", "Grossglobnitz",
"436278", "Ostermiething",
"437238", "Mauthausen",
"435557", "St\.\ Gallenkirch",
"434278", "Gnesau",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"437767", "Eggerding",
"432951", "Guntersdorf",
"432983", "Sigmundsherberg",
"435286", "Ginzling",
"435445", "Kappl",
"432168", "Mannersdorf\ am\ Leithagebirge",
"435550", "Thüringen",
"434874", "Virgen",
"432275", "Atzenbrugg",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"433328", "Kukmirn",
"432736", "Paudorf",
"436589", "Unken",
"432253", "Oberwaltersdorf",
"433854", "Langenwang",
"435372", "Kufstein",
"435239", "Kühtai",
"432212", "Orth\ an\ der\ Donau",
"437412", "Ybbs\ an\ der\ Donau",
"432143", "Kittsee",
"433179", "Passail",
"433354", "Bernstein",
"432723", "Rabenstein\ an\ der\ Pielach",
"435331", "Brandenberg",
"432643", "Lichtenegg",
"432574", "Gaweinstal",
"436473", "Mariapfarr",
"432614", "Kleinwarasdorf",
"432747", "Ober\-Grafendorf",
"432627", "Pitten",
"436455", "Untertauern",
"433334", "Kaindorf",
"433842", "Leoben",
"433867", "Pernegg\ an\ der\ Mur",
"433453", "Ehrenhausen",
"433475", "Hürth",
"432756", "St\.\ Leonhard\ am\ Forst",
"437433", "Wallsee",
"432233", "Pressbaum",
"433834", "Wald\ am\ Schoberpass",
"432762", "Lilienfeld",
"434843", "Ausservillgraten",
"436466", "Werfenweng",
"4317", "Vienna",
"436452", "Radstadt",
"433845", "Mautern\ in\ Steiermark",
"432859", "Brand\-Nagelberg",
"432283", "Angern\ an\ der\ March",
"437483", "Oberndorf\ an\ der\ Melk",
"433884", "Wegscheid",
"432174", "Wallern\ im\ Burgenland",
"433472", "Mureck",
"432641", "Kirchberg\ am\ Wechsel",
"436413", "Wagrain",
"432674", "Weissenbach\ an\ der\ Triesting",
"435333", "Söll",
"434230", "Globasnitz",
"433579", "Pöls",
"432765", "Kaumberg",
"437619", "Kirchham",
"433619", "Oppenberg",
"435442", "Landeck",
"432527", "Wulzeshofen",
"436471", "Tweng",
"437472", "Amstetten",
"432272", "Tulln\ an\ der\ Donau",
"435353", "Waidring",
"433119", "St\.\ Marein\ bei\ Graz",
"435375", "Kössen",
"437415", "Altenmarkt\,\ Yspertal",
"432215", "Probstdorf",
"436432", "Bad\ Hofgastein",
"432231", "Purkersdorf",
"432786", "Oberwölbling",
"435289", "Häusling",
"437288", "Ulrichsberg",
"434246", "Radenthein",
"437563", "Spital\ am\ Pyhrn",
"437745", "Lochen",
"434714", "Dellach\ im\ Drautal",
"432739", "Tiefenfucha",
"435236", "Gries\ im\ Sellrain",
"433176", "Stubenberg",
"434257", "Fürnitz",
"436246", "Grödig",
"435578", "Höchst",
"435223", "Hall\ in\ Tirol",
"43512", "Innsbruck",
"434768", "Kleblach\-Lind",
"432912", "Geras",
"437676", "Ottnang\ am\ Hausruck",
"434264", "Klein\ St\.\ Paul",
"4313", "Vienna",
"433516", "Kleinlobming",
"436565", "Neukirchen\ am\ Grossvenediger",
"434237", "Miklauzhof",
"432865", "Litschau",
"437277", "Waizenkirchen",
"433125", "Übelbach",
"4318", "Vienna",
"436136", "Gosau",
"435262", "Telfs",
"432953", "Nappersdorf",
"435256", "Untergurgl",
"437955", "Königswiesen",
"432647", "Krumbach\,\ Lower\ Austria",
"432714", "Rossatz",
"435476", "Serfaus",
"432147", "Zurndorf",
"432246", "Gerasdorf\ bei\ Wien",
"432162", "Bruck\ an\ der\ Leitha",
"432257", "Klausen\-Leopoldsdorf",
"433464", "Gross\ St\.\ Florian",
"432662", "Gloggnitz",
"433322", "Güssing",
"434229", "Krumpendorf\ am\ Wörther\ See",
"4315", "Vienna",
"432237", "Gaaden",
"432264", "Rückersdorf\,\ Harmannsdorf",
"433457", "Gleinstätten",
"433863", "Turnau",
"432636", "Puchberg\ am\ Schneeberg",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"436477", "St\.\ Michael\ im\ Lungau",
"432743", "Böheimkirchen",
"436229", "Hof\ bei\ Salzburg",
"432623", "Pottendorf",
"433848", "Eisenerz",
"433363", "Rechnitz",
"432949", "Niederfladnitz",
"434283", "St\.\ Stefan\ im\ Gailtal",
"437722", "Braunau\ am\ Inn",
"435526", "Laterns",
"435672", "Reutte",
"436470", "Atzmannsdorf",
"436543", "Taxenbach",
"432843", "Dobersberg",
"437213", "Bad\ Leonfelden",
"437252", "Steyr",
"432230", "Schwadorf",
"437266", "Bad\ Kreuzen",
"434359", "Reichenfels",
"433584", "Neumarkt\ in\ Steiermark",
"432689", "Hornstein",
"437667", "St\.\ Georgen\ im\ Attergau",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"433134", "Heiligenkreuz\ am\ Waasen",
"437763", "Kopfing\ im\ Innkreis",
"436215", "Strasswalchen",
"437584", "Molln",
"434272", "Pörtschach\ am\ Wörther\ See",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"435553", "Raggal",
"435575", "Langen\ bei\ Bregenz",
"433634", "Hieflau",
"437285", "Hofkirchen\ im\ Mühlkreis",
"433142", "Voitsberg",
"437244", "Sattledt",
"432814", "Langschlag",
"437748", "Eggelsberg",
"434231", "Mittertrixen",
"432827", "Schönbach",
"435512", "Egg",
"437716", "Münzkirchen",
"435274", "Gries\ am\ Brenner",
"434215", "Liebenfels",
"436272", "Oberndorf\ bei\ Salzburg",
"435214", "Leutasch",
"437235", "Gallneukirchen",
"434253", "St\.\ Jakob\ im\ Rosental",
"436212", "Seekirchen\ am\ Wallersee",
"434736", "Innerkrems",
"434275", "Ebene\ Reichenau",
"432874", "Martinsberg",
"436541", "Saalbach",
"437211", "Reichenau\ im\ Mühlkreis",
"432841", "Vitis",
"435572", "Dornbirn",
"432249", "Gross\-Enzersdorf",
"433145", "Edelschrott",
"437282", "Neufelden",
"433184", "Wolfsberg\ im\ Schwarzautal",
"435515", "Au",
"434212", "St\.\ Veit\ an\ der\ Glan",
"433684", "St\.\ Martin\ am\ Grimming",
"435633", "Hägerau",
"437684", "Frankenmarkt",
"437480", "Langau\,\ Gaming",
"434226", "St\.\ Margareten\ im\ Rosental",
"432957", "Hohenwarth",
"433534", "Stadl\ an\ der\ Mur",
"435583", "Lech",
"435675", "Tannheim",
"436233", "Oberwang",
"432639", "Bad\ Fischau",
"437255", "Losenstein",
"434762", "Spittal\ an\ der\ Drau",
"434233", "Griffen",
"437273", "Aschach\ an\ der\ Donau",
"436226", "Fuschl\ am\ See",
"435243", "Maurach",
"432946", "Pulkau",
"435337", "Brixlegg",
"437944", "Sandl",
"436417", "Hüttschlag",
"437269", "Baumgartenberg",
"434356", "Lavamünd",
"436458", "Hüttau",
"432287", "Strasshof\ an\ der\ Nordbahn",
"437487", "Gresten",
"434847", "Obertilliach",
"432556", "Grosskrut",
"432686", "Drassburg",
"437952", "Weitersfelden",
"4316", "Vienna",
"434823", "Tresdorf\,\ Rangersdorf",
"432536", "Drösing",
"433861", "Aflenz",
"435448", "Pettneu\ am\ Arlberg",
"435357", "Kirchberg\ in\ Tirol",
"432165", "Hainburg\ a\.d\.\ Donau",
"432665", "Prein\ an\ der\ Rax",
"437719", "Taufkirchen\ an\ der\ Pram",
"437478", "Oed\-Oehling",
"432278", "Absdorf",
"432621", "Sieggraben",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"432774", "Innermanzing",
"432741", "Flinsbach",
"433115", "Studenzen",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"435232", "Kematen\ in\ Tirol",
"433631", "Unterlaussa",
"433533", "Turrach",
"436234", "Zell\ am\ Moos",
"437683", "Frankenburg\ am\ Hausruck",
"433615", "Trieben",
"434242", "Villach",
"435244", "Jenbach",
"434267", "Metnitz",
"435285", "Mayrhofen",
"436242", "Russbach\ am\ Pass\ Gschütt",
"437241", "Steinerkirchen\ an\ der\ Traun",
"437274", "Alkoven",
"433172", "Weiz",
"434234", "Ruden",
"433849", "Vordernberg",
"432855", "Waldenstein",
"432948", "Weitersfeld",
"432873", "Kottes",
"436228", "Faistenau",
"437672", "Vöcklabruck",
"433512", "Knittelfeld",
"435213", "Scharnitz",
"432916", "Riegersburg\,\ Hardegg",
"434254", "Faak\ am\ See",
"433575", "St\.\ Johann\ am\ Tauern",
"435252", "Oetz",
"435634", "Elbigenalp",
"433581", "Oberwölz",
"437615", "Scharnstein",
"432769", "Türnitz",
"433683", "Donnersbach",
"435266", "Ötztal\-Bahnhof",
"433151", "Gnas",
"436132", "Bad\ Ischl",
"434717", "Steinfeld",
"434228", "Feistritz\ im\ Rosental",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"432688", "Steinbrunn",
"434710", "Oberdrauburg",
"434358", "St\.\ Andrä",
"436456", "Obertauern",
"436462", "Bischofshofen",
"434824", "Heiligenblut",
"432773", "Eichgraben",
"432755", "Mank",
"432524", "Kautendorf",
"433476", "Bad\ Radkersburg",
"434858", "Nikolsdorf",
"435418", "Schönwies",
"432177", "Podersdorf\ am\ See",
"432276", "Reidling",
"437476", "Aschbach\-Markt",
"432735", "Hadersdorf\ am\ Kamp",
"433387", "Söchau",
"435446", "St\.\ Anton\ am\ Arlberg",
"432711", "Dürnstein",
"437943", "Windhaag\ bei\ Freistadt",
"432782", "Herzogenburg",
"432538", "Velm\-Götzendorf",
"433461", "Trahütten",
"435376", "Thiersee",
"437750", "Andrichsfurt",
"432263", "Grossrussbach",
"432732", "Krems\ an\ der\ Donau",
"433864", "St\.\ Marein\ im\ Mürztal",
"432624", "Ebenfurth",
"433364", "Hannersdorf",
"437448", "Kematen\ an\ der\ Ybbs",
"432248", "Markgrafneusiedl",
"437357", "Kleinreifling",
"432744", "Kasten\ bei\ Böheimkirchen",
"432617", "Drassmarkt",
"433337", "Vorau",
"437416", "Wieselburg",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"433846", "Kalwang",
"432713", "Spitz",
"432577", "Asparn\ an\ der\ Zaya",
"437941", "Neumarkt\ im\ Mühlkreis",
"433357", "Pinkafeld",
"432638", "Winzendorf\-Muthmannsdorf",
"434877", "Prägraten\ am\ Grossvenediger",
"432766", "Kleinzell",
"43732", "Linz",
"432752", "Melk",
"433857", "Neuberg\ an\ der\ Mürz",
"433463", "Stainz",
"432852", "Gmünd",
"433633", "Landl",
"436566", "Bramberg\ am\ Wildkogel",
"435554", "Sonntag",
"437675", "Ampflwang\ im\ Hausruckwald",
"437268", "Grein",
"437583", "Kremsmünster",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"437764", "Riedau",
"433133", "Nestelbach",
"433572", "Judenburg",
"437612", "Gmunden",
"435255", "Umhausen",
"435273", "Matrei\ am\ Brenner",
"436135", "Bad\ Goisern",
"437243", "Marchtrenk",
"433126", "Frohnleiten",
"432813", "Arbesbach",
"433112", "Gleisdorf",
"432610", "Horitschon",
"432844", "Karlstein\ an\ der\ Thaya",
"437214", "Reichenthal",
"436544", "Rauris",
"432279", "Kirchberg\ am\ Wagram",
"437479", "Ardagger",
"437718", "Waldkirchen\ am\ Wesen",
"437227", "Neuhofen\ an\ der\ Krems",
"437746", "Friedburg",
"435449", "Fliess",
"433612", "Liezen",
"434245", "Feistritz\ an\ der\ Drau",
"434284", "Kirchbach",
"437757", "Gurten",
"435282", "Zell\ am\ Ziller",
"433583", "Unzmarkt",
"436245", "Hallein",
"433175", "Anger",
"433153", "Riegersburg",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"432635", "Neunkirchen",
"435354", "Fieberbrunn",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"437729", "Neukirchen\ an\ der\ Enknach",
"434852", "Lienz",
"432682", "Eisenstadt",
"432552", "Poysdorf",
"434352", "Wolfsberg",
"437259", "Sierning",
"433680", "Donnersbachwald",
"436468", "Werfen",
"437484", "Göstling\ an\ der\ Ybbs",
"432284", "Oberweiden",
"433883", "Terz",
"432245", "Wolkersdorf\ im\ Weinviertel",
"437445", "Hollenstein\ an\ der\ Ybbs",
"432532", "Zistersdorf",
"434279", "Sirnitz",
"435475", "Feichten",
"437956", "Unterweissenbach",
"437239", "Lichtenberg",
"435412", "Imst",
"432673", "Altenmarkt\ an\ der\ Triesting",
"436414", "Grossarl",
"437947", "Kefermarkt",
"435334", "Westendorf",
"433383", "Burgau",
"432173", "Gols",
"435519", "Schröcken",
"433149", "Geistthal",
"435576", "Hohenems",
"434732", "Gmünd\ in\ Kärnten",
"436216", "Neumarkt\ am\ Wallersee",
"434263", "Hüttenberg",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"432954", "Göllersdorf",
"436588", "Lofer",
"435238", "Zirl",
"433329", "Jennersdorf",
"434785", "Ausserfragant",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"437286", "Lembach\ im\ Mühlkreis",
"434248", "Treffen",
"433537", "St\.\ Georgen\ ob\ Murau",
"4314", "Vienna",
"435525", "Nenzing",
"434713", "Techendorf",
"433687", "Schladming",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"437751", "St\.\ Martin\ im\ Innkreis",
"437564", "Hinterstoder",
"432942", "Retz",
"435224", "Wattens",
"437265", "Pabneukirchen",
"437221", "Hörsching",
"434766", "Millstatt",
"432877", "Grainbrunn",
"432824", "Allentsteig",
"433578", "Obdach",
"437618", "Neukirchen\,\ Altmünster",
"437247", "Kematen\ am\ Innbach",
"435522", "Feldkirch",
"435676", "Jungholz",
"434225", "Grafenstein",
"432984", "Eggenburg",
"437587", "Wartberg\ an\ der\ Krems",
"432858", "Moorbad\ Harbach",
"432945", "Zellerndorf",
"433460", "Soboth",
"433137", "Söding",
"436225", "Eugendorf",
"433637", "Gams\ bei\ Hieflau",
"437262", "Perg",
"437733", "Neumarkt\ im\ Hausruckkreis",
"437256", "Ternberg",
"435288", "Fügen",
"433157", "Kapfenstein",
"434735", "Kremsbrücke",
"437664", "Weyregg\ am\ Attersee",
"437753", "Eberschwang",
"434276", "Feldkirchen\ in\ Kärnten",
"437236", "Pregarten",
"433587", "Schönberg\-Lachtal",
"433118", "Sinabelkirchen",
"436276", "Nussdorf\ am\ Haunsberg",
"437712", "Schärding",
"434782", "Obervellach",
"435516", "Doren",
"433146", "Modriach",
"437223", "Enns",
"433618", "Hohentauern",
"435579", "Alberschwende",
"437442", "Waidhofen\ an\ der\ Ybbs",
"432242", "St\.\ Andrä\-Wördern",
"432535", "Hohenau\ an\ der\ March",
"433333", "Sebersdorf",
"436219", "Obertrum\ am\ See",
"437353", "Gaflenz",
"435472", "Prutz",
"432613", "Deutschkreutz",
"436474", "Tamsweg",
"432234", "Gramatneusiedl",
"437434", "Haag",
"433150", "Paldau",
"433833", "Traboch",
"432666", "Reichenau",
"433326", "Stegersbach",
"432738", "Fels\ am\ Wagram",
"432166", "Parndorf",
"437289", "Rohrbach\ in\ Oberösterreich",
"433454", "Leutschach",
"432267", "Sierndorf",
"432632", "Pernitz",
"433467", "Schwanberg",
"432254", "Ebreichsdorf",
"433853", "Spital\ am\ Semmering",
"432758", "Pöggstall",
"434873", "St\.\ Jakob\ in\ Defereggen",
"434855", "Assling",
"437240", "Sipbachzell",
"432685", "Rust",
"432717", "Unter\-Meisling",
"432573", "Wilfersdorf",
"432644", "Grimmenstein",
"433353", "Oberschützen",
"432555", "Herrnbaumgarten",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"434355", "Gemmersdorf",
"434769", "Möllbrücke",
"432144", "Deutsch\ Jahrndorf",
"433866", "Breitenau\ am\ Hochlantsch",
"432633", "Markt\ Piesting",
"433852", "Mürzzuschlag",
"435374", "Walchsee",
"432757", "Pöchlarn",
"434872", "Huben",
"436484", "Lessach",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"432746", "Wilhelmsburg",
"433352", "Oberwart",
"432626", "Mattersburg",
"432572", "Mistelbach",
"433366", "Kohfidisch",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432214", "Kopfstetten",
"437414", "Weins\-Isperdorf",
"437279", "Haibach\ ob\ der\ Donau",
"432718", "Lichtenau\ im\ Waldviertel",
"433332", "Hartberg",
"433844", "Kammern\ im\ Liesingtal",
"432243", "Klosterneuburg",
"433885", "Greith",
"437443", "Ybbsitz",
"432612", "Oberpullendorf",
"435473", "Nauders",
"432268", "Grossmugl",
"433385", "Ilz",
"432764", "Hainfeld",
"433832", "Kraubath\ an\ der\ Mur",
"435280", "Hochfügen",
"432175", "Apetlon",
"435556", "Schruns",
"432864", "Kautzen",
"436564", "Krimml",
"433588", "Katsch\ an\ der\ Mur",
"43316", "Graz",
"433158", "St\.\ Anna\ am\ Aigen",
"437766", "Andorf",
"435287", "Tux",
"434221", "Gallizien",
"437752", "Ried\ im\ Innkreis",
"434265", "Weitensfeld\ im\ Gurktal",
"437713", "Schardenberg",
"433617", "Gaishorn\ am\ See",
"436221", "Koppl",
"433624", "Pichl\-Kainisch",
"433124", "Gratkorn",
"434783", "Reisseck",
"433117", "Eggersdorf\ bei\ Graz",
"435523", "Götzis",
"434715", "Kötschach\-Mauthen",
"435278", "Navis",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"437216", "Helfenberg",
"432846", "Raabs\ an\ der\ Thaya",
"437248", "Grieskirchen",
"434286", "Weissbriach",
"437744", "Munderfing",
"437617", "Traunkirchen",
"433577", "Zeltweg",
"433638", "Palfau",
"437263", "Bad\ Zell",
"437588", "Ried\ im\ Traunkreis",
"432857", "Bad\ Grosspertholz",
"437732", "Haag\ am\ Hausruck",
"434712", "Greifenburg",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"436137", "Strobl",
"433688", "Tauplitz",
"434223", "Maria\ Saal",
"432878", "Traunstein",
"432749", "Prinzersdorf",
"436223", "Anthering",
"432629", "Warth\,\ Lower\ Austria",
"435246", "Achenkirch",
"437711", "Suben",
"432943", "Obritz",
"434236", "Eberndorf",
"437276", "Peuerbach",
"437735", "Gaspoltshofen",
"43662", "Salzburg",
"433177", "Puch\ bei\ Weiz",
"434256", "Nötsch\ im\ Gailtal",
"436247", "Grossgmain",
"432914", "Japons",
"434733", "Malta",
"434262", "Treibach",
"437755", "Mettmach",
"434247", "Afritz",
"435264", "Mieming",
"437225", "Hargelsberg",
"437261", "Schönau\ im\ Mühlkreis",
"4346", "Klagenfurt",
"435559", "Brand",
"433335", "Pöllau",
"432533", "Neusiedl\ an\ der\ Zaya",
"432631", "Pöttsching",
"433882", "Mariazell",
"434240", "Bad\ Kleinkirchheim",
"435230", "Sellrain",
"434826", "Mörtschach",
"432615", "Lutzmannsburg",
"437355", "Weyer",
"436454", "Mandling",
"433170", "Fischbach",
"432672", "Berndorf",
"433382", "Fürstenfeld",
"432526", "Stronsdorf",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"437948", "Hirschbach\ im\ Mühlkreis",
"432172", "Frauenkirchen",
"436240", "Krispl",
"433474", "Deutsch\ Goritz",
"437474", "Euratsfeld",
"432274", "Sieghartskirchen",
"436549", "Piesendorf",
"437219", "Vorderweissenbach",
"432849", "Schwarzenau",
"433855", "Krieglach",
"435444", "Ischgl",
"434853", "Ainet",
"434875", "Matrei\ in\ Osttirol",
"436467", "Mühlbach\ am\ Hochkönig",
"433355", "Stadtschlaining",
"432683", "Purbach\ am\ Neusiedler\ See",
"432575", "Ladendorf",
"434353", "Prebl",
"436434", "Bad\ Gastein",
"433535", "Krakaudorf",
"435674", "Bichlbach",
"435359", "Hochfilzen",
"432826", "Rastenfeld",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"433613", "Admont",
"437228", "Kematen\ an\ der\ Krems",
"437717", "St\.\ Aegidi",
"437724", "Mauerkirchen",
"433582", "Scheifling",
"432986", "Irnfritz",
"435283", "Kaltenbach",
"437254", "Grossraming",
"436131", "Obertraun",
"433152", "Feldbach",
"437758", "Obernberg\ am\ Inn",
"432875", "Grafenschlag",
"432289", "Matzen",
"432853", "Schrems",
"437489", "Purgstall\ an\ der\ Erlauf",
"437267", "Mönchdorf",
"433632", "St\.\ Gallen",
"437234", "Ottensheim",
"433132", "Kumberg",
"432630", "Ternitz",
"4319", "Vienna",
"437666", "Attersee",
"434274", "Velden\ am\ Wörther\ See",
"437582", "Kirchdorf\ an\ der\ Krems",
"435339", "Wildschönau",
"435272", "Steinach\ am\ Brenner",
"433573", "Fohnsdorf",
"436274", "Lamprechtshausen",
"437613", "Laakirchen",
"433685", "Gröbming",
"436241", "St\.\ Koloman",
"433171", "Gasen",
"433144", "Köflach",
"433185", "Preding",
"432812", "Gross\ Gerungs",
"437242", "Wels",
"435514", "Bezau",
"433358", "Litzelsdorf",
"436476", "St\.\ Margarethen\ im\ Lungau",
"432712", "Aggsbach",
"432664", "Semmering",
"433324", "Strem",
"437260", "Waldhausen",
"432753", "Gansbach",
"432959", "Sitzendorf\ an\ der\ Schmida",
"432236", "Mödling",
"433858", "Mitterdorf\ im\ Mürztal",
"433456", "Fresing",
"432164", "Rohrau",
"433462", "Deutschlandsberg",
"432637", "Grünbach\ am\ Schneeberg",
"432262", "Korneuburg",
"432733", "Schönberg\ am\ Kamp",
"432256", "Leobersdorf",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"436461", "Dienten\ am\ Hochkönig",
"432726", "Puchenstuben",
"433338", "Lafnitz",
"435477", "Tösens",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"432618", "Markt\ St\.\ Martin",
"432146", "Nickelsdorf",
"432247", "Deutsch\-Wagram",
"432265", "Hausleiten",
"435356", "Kitzbühel",
"432829", "Schweiggers",
"437942", "Freistadt",
"435417", "Roppen",
"432783", "Traismauer",
"432989", "Brunn\ an\ der\ Wild",
"4312", "Vienna",
"434357", "St\.\ Paul\ im\ Lavanttal",
"432731", "Idolsberg",
"432286", "Obersiebenbrunn",
"434220", "Köttmannsdorf",
"437486", "Lunz\ am\ See",
"432557", "Bernhardsthal",
"434846", "Abfaltersbach",
"437954", "St\.\ Georgen\ am\ Walde",
"436463", "Annaberg\-Lungötz",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"432687", "Siegendorf",
"436416", "Lend",
"435336", "Alpbach",
"432772", "Neulengbach",
"433465", "Pölfing\-Brunn",
"432872", "Ottenschlag",
"435574", "Bregenz",
"433635", "Radmer",
"435212", "Seefeld\ in\ Tirol",
"436227", "St\.\ Gilgen",
"436479", "Muhr",
"433135", "Kalsdorf\ bei\ Graz",
"437673", "Schwanenstadt",
"436214", "Henndorf\ am\ Wallersee",
"432947", "Theras",
"433611", "Johnsbach",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"433513", "Bischoffeld",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"434227", "Ferlach",
"435275", "Trins",
"434718", "Dellach",
"432956", "Ziersdorf",
"432239", "Breitenfurt\ bei\ Wien",
"434214", "Brückl",
"433682", "Stainach",
"435253", "Längenfeld",
"437284", "Oberkappel",
"432815", "Grossschönau",
"437245", "Lambach",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"433182", "Wildon",
"436133", "Ebensee",
"433532", "Murau",
"436583", "Leogang",
"432259", "Münchendorf",
"434243", "Bodensdorf",
"437682", "Vöcklamarkt",
"437566", "Rosenau\ am\ Hengstpass",
"433585", "St\.\ Lambrecht",
"436243", "Abtenau",
"433571", "Möderbrugg",
"435226", "Neustift\ im\ Stubaital",
"432649", "Mönichkirchen",
"433155", "Fehring",
"434268", "Friesach",
"433173", "Ratten",
"437759", "Antiesenhofen",
"437953", "Liebenau",
"434822", "Winklern",
"433886", "Weichselboden",
"432176", "Tadten",
"437229", "Traun",
"432277", "Zwentendorf",
"437477", "St\.\ Peter\ in\ der\ Au",
"435358", "Ellmau",
"432522", "Laa\ an\ der\ Thaya",
"435447", "Flirsch",
"433386", "Grosssteinbach",
"433477", "St\.\ Peter\ am\ Ottersbach",
"436418", "Kleinarl",
"433865", "Kindberg",
"435338", "Kundl",
"434848", "Kartitsch",
"432625", "Bad\ Sauerbrunn",
"437488", "Steinakirchen\ am\ Forst",
"436457", "Flachau",
"432288", "Auersthal",
"433365", "Deutsch\ Schützen\-Eisenberg",
"432745", "Pyhra",
"432784", "Perschling",
"434879", "St\.\ Veit\ in\ Defereggen",
"437231", "Herzogsdorf",
"434244", "Bad\ Bleiberg",
"434271", "Steuerberg",
"434285", "Tröpolach",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432958", "Maissau",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"435234", "Axams",
"432845", "Weikertschlag\ an\ der\ Thaya",
"437215", "Hellmonsödt",
"433859", "Mürzsteg",
"435582", "Klösterle",
"434716", "Lesachtal",
"436232", "Mondsee",
"437272", "Eferding",
"433141", "Hirschegg",
"433174", "Birkfeld",
"434232", "Völkermarkt",
"435242", "Schwaz",
"436244", "Golling\ an\ der\ Salzach",
"433359", "Loipersdorf\-Kitzladen",
"436213", "Oberhofen\ am\ Irrsee",
"437674", "Attnang\-Puchheim",
"433514", "Seckau",
"434266", "Strassburg",
"437765", "Lambrechten",
"434252", "Wernberg",
"432619", "Lackendorf",
"435573", "Hörbranz",
"433339", "Friedberg",
"436134", "Hallstatt",
"437251", "Schiedlberg",
"437283", "Sarleinsbach",
"434213", "Launsdorf",
"435254", "Sölden",
"435632", "Stanzach",
"434273", "Reifnitz",
"437233", "Feldkirchen\ an\ der\ Donau",
"437762", "Raab",
"434255", "Arnoldstein",
"432988", "Neupölla",
"432854", "Kirchberg\ am\ Walde",
"435552", "Bludenz",
"434761", "Stockenboi",
"435513", "Hittisau",
"437226", "Wilhering",
"433143", "Krottendorf",
"432828", "Rappottenstein",
"433574", "Pusterwald",
"437614", "Vorchdorf",
"437747", "Kirchberg\ bei\ Mattighofen",
"435635", "Elmen",
"437723", "Altheim",
"433614", "Rottenmann",
"434282", "Hermagor",
"433114", "Markt\ Hartmannsdorf",
"437212", "Zwettl\ an\ der\ Rodl",
"432842", "Waidhofen\ an\ der\ Thaya",
"436542", "Zell\ am\ See",
"433127", "Peggau",
"435585", "Dalaas",
"436235", "Thalgau",
"435673", "Ehrwald",
"437736", "Pram",
"437281", "Aigen\ im\ Mühlkreis",
"437253", "Wolfern",
"434235", "Bleiburg",
"435245", "Hinterriss",
"435284", "Gerlos",
"432767", "Hohenberg",
"434876", "Kals\ am\ Grossglockner",
"432238", "Kaltenleutgeben",
"433856", "Veitsch",
"432734", "Langenlois",
"433862", "Bruck\ an\ der\ Mur",
"433847", "Trofaiach",
"436478", "Zederhaus",
"432622", "Wiener\ Neustadt",
"433362", "Grosspetersdorf",
"432576", "Ernstbrunn",
"432742", "St\.\ Pölten",
"433356", "Markt\ Allhau",
"434269", "Flattnitz",
"434825", "Grosskirchheim",
"432616", "Lockenhaus",
"432648", "Hochneukirchen",
"433336", "Waldbach",
"432728", "Wienerbruck",
"432163", "Petronell\-Carnuntum",
"432258", "Alland",
"432663", "Schottwien",
"432525", "Gnadendorf",
"433323", "Eberau",
"432754", "Loosdorf",
"437665", "Unterach\ am\ Attersee",
"434734", "Rennweg",
"432719", "Dross",
"437278", "Neukirchen\ am\ Walde",
"432913", "Hötzelsdorf",
"434238", "Eisenkappel\-Vellach",
"435248", "Steinberg\ am\ Rofan",
"432876", "Els",
"434767", "Rothenthurn",
"433469", "St\.\ Oswald\ im\ Freiland",
"432952", "Hollabrunn",
"433686", "Haus",
"435263", "Silz",
"437562", "Windischgarsten",
"434224", "Pischeldorf",
"432825", "Göpfritz\ an\ der\ Wild",
"432269", "Niederfellabrunn",
"433536", "St\.\ Peter\ am\ Kammersberg",
"437287", "Peilstein\ im\ Mühlviertel",
"435577", "Lustenau",
"434258", "Gummern",
"432985", "Gars\ am\ Kamp",
"432944", "Haugsdorf",
"436217", "Mattsee",
"436224", "Hintersee",
"435443", "Galtür",
"437946", "Gutau",
"432255", "Deutsch\ Brodersdorf",
"432273", "Tulbing",
"437473", "Blindenmarkt",
"435352", "St\.\ Johann\ in\ Tirol",
"434354", "Preitenegg",
"436433", "Dorfgastein",
"433159", "Bad\ Gleichenberg",
"432145", "Prellenkirchen",
"432684", "Schützen\ am\ Gebirge",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"432645", "Wiesmath",
"432554", "Stützenhofen",
"432725", "Frankenfels",
"436453", "Filzmoos",
"434842", "Sillian",
"436475", "Ramingstein",
"437482", "Scheibbs",
"432282", "Gänserndorf",
"432534", "Niedersulz",
"433473", "Straden",
"437249", "Bad\ Schallerbach",
"433455", "Arnfels",
"437435", "St\.\ Valentin",
"432235", "Maria\-Lanzendorf",
"435414", "Wenns",
"436412", "St\.\ Johann\ im\ Pongau",
"435332", "Wörgl",
"435279", "St\.\ Jodok\ am\ Brenner",
"432716", "Gföhl",
"435474", "Pfunds",
"435441", "See",
"436472", "Mauterndorf",
"432285", "Marchegg",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"432628", "Felixdorf",
"437485", "Gaming",
"437444", "Opponitz",
"432271", "Ried\ am\ Riederberg",
"432244", "Langenzersdorf",
"437471", "Neustadtl\ an\ der\ Donau",
"432748", "Kilb",
"433466", "Eibiswald",
"433452", "Leibnitz",
"432232", "Fischamend",
"437432", "Strengberg",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"437250", "Maria\ Neustift",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"436415", "Schwarzach\ im\ Pongau",
"435335", "Hopfgarten\ im\ Brixental",
"433868", "Tragöss",
"436483", "Göriach",
"433327", "St\.\ Michael\ im\ Burgenland",
"432667", "Schwarzau\ im\ Gebirge",
"432252", "Baden",
"432634", "Gutenstein",
"435373", "Ebbs",
"432167", "Neusiedl\ am\ See",
"437230", "Altenberg\ bei\ Linz",
"432266", "Stockerau",
"435355", "Jochberg",
"437413", "Marbach\ an\ der\ Donau",
"432142", "Gattendorf",
"432213", "Lassee",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"432642", "Aspangberg\-St\.\ Peter",
"435510", "Damüls",
"432722", "Kirchberg\ an\ der\ Pielach",
"436277", "St\.\ Pantaleon",
"437743", "Maria\ Schmolln",
"437949", "Rainbach\ im\ Mühlkreis",
"437565", "St\.\ Pankraz",
"432822", "Zwettl\,\ Lower\ Austria",
"435517", "Riezlern",
"435524", "Satteins",
"433147", "Salla",
"437264", "Windhaag\ bei\ Perg",
"432982", "Horn",
"434277", "Glanegg",
"435225", "Fulpmes",
"433586", "Mühlen",
"435558", "Gaschurn",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432160", "Jois",
"437662", "Seewalchen\ am\ Attersee",
"437586", "Pettenbach",
"433136", "Dobl",
"433636", "Wildalpen",
"436563", "Uttendorf",
"432863", "Eggern",
"437257", "Grünburg",
"434784", "Mallnitz",
"435677", "Vils",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"437246", "Gunskirchen",
"432816", "Karlstift",
"432955", "Grossweikersdorf",
"437727", "Ach",
"437218", "Grosstraberg",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"433623", "Bad\ Mitterndorf",
"436548", "Niedernsill",
"437714", "Esternberg",
"435276", "Gschnitz",};
$areanames{de} = {"4316", "Wien",
"432686", "Draßburg",
"432556", "Großkrut",
"434226", "Sankt\ Margareten\ im\ Rosental",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"433684", "Sankt\ Martin\ am\ Grimming",
"434253", "Sankt\ Jakob\ im\ Rosental",
"432249", "Groß\-Enzersdorf",
"436215", "Straßwalchen",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"437667", "Sankt\ Georgen\ im\ Attergau",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"436477", "Sankt\ Michael\ im\ Lungau",
"4315", "Wien",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"433464", "Groß\ Sankt\ Florian",
"432647", "Krumbach\,\ Niederösterreich",
"4318", "Wien",
"4313", "Wien",
"434264", "Klein\ Sankt\ Paul",
"436565", "Neukirchen\ am\ Großvenediger",
"433119", "Sankt\ Marein\ bei\ Graz",
"432674", "Weißenbach\ an\ der\ Triesting",
"4317", "Wien",
"434843", "Außervillgraten",
"432233", "Preßbaum",
"433834", "Wald\ am\ Schoberpaß",
"432756", "Sankt\ Leonhard\ am\ Forst",
"435557", "Sankt\ Gallenkirch",
"432823", "Großglobnitz",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"432847", "Groß\-Siegharts",
"437224", "Sankt\ Florian",
"435678", "Weißenbach\ am\ Lech",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"432242", "Sankt\ Andrä\-Wördern",
"436276", "Nußdorf\ am\ Haunsberg",
"4314", "Wien",
"437751", "Sankt\ Martin\ im\ Innkreis",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"433537", "Sankt\ Georgen\ ob\ Murau",
"434785", "Außerfragant",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"436414", "Großarl",
"437956", "Unterweißenbach",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"435449", "Fließ",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"434877", "Prägraten\ am\ Großvenediger",
"432617", "Draßmarkt",
"432263", "Großrußbach",
"433864", "Sankt\ Marein\ im\ Mürztal",
"435446", "Sankt\ Anton\ am\ Arlberg",
"434358", "Sankt\ Andrä",
"433575", "Sankt\ Johann\ am\ Tauern",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"433585", "Sankt\ Lambrecht",
"437566", "Rosenau\ am\ Hengstpaß",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"432815", "Großschönau",
"436227", "Sankt\ Gilgen",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"437954", "Sankt\ Georgen\ am\ Walde",
"4312", "Wien",
"432618", "Markt\ Sankt\ Martin",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"436241", "Sankt\ Koloman",
"432812", "Groß\ Gerungs",
"433632", "Sankt\ Gallen",
"4319", "Wien",
"437254", "Großraming",
"437717", "Sankt\ Aegidi",
"437219", "Vorderweißenbach",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"436247", "Großgmain",
"432629", "Warth\,\ Niederösterreich",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"432857", "Bad\ Großpertholz",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"434286", "Weißbriach",
"434783", "Reißeck",
"433158", "Sankt\ Anna\ am\ Aigen",
"432268", "Großmugl",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"432955", "Großweikersdorf",
"437218", "Großtraberg",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"437565", "Sankt\ Pankraz",
"436277", "Sankt\ Pantaleon",
"432822", "Zwettl\-Niederösterreich",
"432642", "Aspangberg\-Sankt\ Peter",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"433327", "Sankt\ Michael\ im\ Burgenland",
"433868", "Tragöß",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"436412", "Sankt\ Johann\ im\ Pongau",
"435279", "Sankt\ Jodok\ am\ Brenner",
"437435", "Sankt\ Valentin",
"435352", "Sankt\ Johann\ in\ Tirol",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"433469", "Sankt\ Oswald\ im\ Freiland",
"432719", "Droß",
"434825", "Großkirchheim",
"432742", "Sankt\ Pölten",
"433362", "Großpetersdorf",
"434876", "Kals\ am\ Großglockner",
"435245", "Hinterriß",
"434266", "Straßburg",
"434879", "Sankt\ Veit\ in\ Defereggen",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"437477", "Sankt\ Peter\ in\ der\ Au",
"433386", "Großsteinbach",};
my $timezones = {
               '' => [
                       'Europe/Vienna'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;