package App::Manoc::DB::Result::Ip;
#ABSTRACT: A model object for information on IP addresses

use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->load_components(qw/+App::Manoc::DB::InflateColumn::IPv4/);

__PACKAGE__->table('ip');

__PACKAGE__->add_columns(
    'ipaddr' => {
        data_type    => 'varchar',
        is_nullable  => 0,
        size         => 15,
        ipv4_address => 1,
    },
    'description' => {
        data_type   => 'text',
        is_nullable => 1,
    },
    'assigned_to' => {
        data_type   => 'varchar',
        size        => 45,
        is_nullable => 1,
    },
    'phone' => {
        data_type   => 'varchar',
        size        => 30,
        is_nullable => 1,
    },
    'email' => {
        data_type   => 'varchar',
        is_nullable => 45,
    },
    'notes' => {
        data_type   => 'text',
        is_nullable => 1,
    },
);

__PACKAGE__->set_primary_key('ipaddr');

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::Ip - A model object for information on IP addresses

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
