/* Boolean */
#ifdef UA_TYPES_BOOLEAN

static void XS_pack_UA_Boolean(SV *out, UA_Boolean in)  __attribute__((unused));
static UA_Boolean XS_unpack_UA_Boolean(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* SByte */
#ifdef UA_TYPES_SBYTE

static void XS_pack_UA_SByte(SV *out, UA_SByte in)  __attribute__((unused));
static UA_SByte XS_unpack_UA_SByte(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Byte */
#ifdef UA_TYPES_BYTE

static void XS_pack_UA_Byte(SV *out, UA_Byte in)  __attribute__((unused));
static UA_Byte XS_unpack_UA_Byte(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Int16 */
#ifdef UA_TYPES_INT16

static void XS_pack_UA_Int16(SV *out, UA_Int16 in)  __attribute__((unused));
static UA_Int16 XS_unpack_UA_Int16(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* UInt16 */
#ifdef UA_TYPES_UINT16

static void XS_pack_UA_UInt16(SV *out, UA_UInt16 in)  __attribute__((unused));
static UA_UInt16 XS_unpack_UA_UInt16(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Int32 */
#ifdef UA_TYPES_INT32

static void XS_pack_UA_Int32(SV *out, UA_Int32 in)  __attribute__((unused));
static UA_Int32 XS_unpack_UA_Int32(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* UInt32 */
#ifdef UA_TYPES_UINT32

static void XS_pack_UA_UInt32(SV *out, UA_UInt32 in)  __attribute__((unused));
static UA_UInt32 XS_unpack_UA_UInt32(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Int64 */
#ifdef UA_TYPES_INT64

static void XS_pack_UA_Int64(SV *out, UA_Int64 in)  __attribute__((unused));
static UA_Int64 XS_unpack_UA_Int64(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* UInt64 */
#ifdef UA_TYPES_UINT64

static void XS_pack_UA_UInt64(SV *out, UA_UInt64 in)  __attribute__((unused));
static UA_UInt64 XS_unpack_UA_UInt64(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Float */
#ifdef UA_TYPES_FLOAT

static void XS_pack_UA_Float(SV *out, UA_Float in)  __attribute__((unused));
static UA_Float XS_unpack_UA_Float(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Double */
#ifdef UA_TYPES_DOUBLE

static void XS_pack_UA_Double(SV *out, UA_Double in)  __attribute__((unused));
static UA_Double XS_unpack_UA_Double(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* String */
#ifdef UA_TYPES_STRING

static void XS_pack_UA_String(SV *out, UA_String in)  __attribute__((unused));
static UA_String XS_unpack_UA_String(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* DateTime */
#ifdef UA_TYPES_DATETIME

static void XS_pack_UA_DateTime(SV *out, UA_DateTime in)  __attribute__((unused));
static UA_DateTime XS_unpack_UA_DateTime(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Guid */
#ifdef UA_TYPES_GUID

static void XS_pack_UA_Guid(SV *out, UA_Guid in)  __attribute__((unused));
static UA_Guid XS_unpack_UA_Guid(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* ByteString */
#ifdef UA_TYPES_BYTESTRING

static void XS_pack_UA_ByteString(SV *out, UA_ByteString in)  __attribute__((unused));
static UA_ByteString XS_unpack_UA_ByteString(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* XmlElement */
#ifdef UA_TYPES_XMLELEMENT

static void XS_pack_UA_XmlElement(SV *out, UA_XmlElement in)  __attribute__((unused));
static UA_XmlElement XS_unpack_UA_XmlElement(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* NodeId */
#ifdef UA_TYPES_NODEID

static void XS_pack_UA_NodeId(SV *out, UA_NodeId in)  __attribute__((unused));
static UA_NodeId XS_unpack_UA_NodeId(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* ExpandedNodeId */
#ifdef UA_TYPES_EXPANDEDNODEID

static void XS_pack_UA_ExpandedNodeId(SV *out, UA_ExpandedNodeId in)  __attribute__((unused));
static UA_ExpandedNodeId XS_unpack_UA_ExpandedNodeId(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* StatusCode */
#ifdef UA_TYPES_STATUSCODE

static void XS_pack_UA_StatusCode(SV *out, UA_StatusCode in)  __attribute__((unused));
static UA_StatusCode XS_unpack_UA_StatusCode(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* QualifiedName */
#ifdef UA_TYPES_QUALIFIEDNAME

static void XS_pack_UA_QualifiedName(SV *out, UA_QualifiedName in)  __attribute__((unused));
static UA_QualifiedName XS_unpack_UA_QualifiedName(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* LocalizedText */
#ifdef UA_TYPES_LOCALIZEDTEXT

static void XS_pack_UA_LocalizedText(SV *out, UA_LocalizedText in)  __attribute__((unused));
static UA_LocalizedText XS_unpack_UA_LocalizedText(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* ExtensionObject */
#ifdef UA_TYPES_EXTENSIONOBJECT

static void XS_pack_UA_ExtensionObject(SV *out, UA_ExtensionObject in)  __attribute__((unused));
static UA_ExtensionObject XS_unpack_UA_ExtensionObject(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* DataValue */
#ifdef UA_TYPES_DATAVALUE

static void XS_pack_UA_DataValue(SV *out, UA_DataValue in)  __attribute__((unused));
static UA_DataValue XS_unpack_UA_DataValue(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* Variant */
#ifdef UA_TYPES_VARIANT

static void XS_pack_UA_Variant(SV *out, UA_Variant in)  __attribute__((unused));
static UA_Variant XS_unpack_UA_Variant(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* DiagnosticInfo */
#ifdef UA_TYPES_DIAGNOSTICINFO

static void XS_pack_UA_DiagnosticInfo(SV *out, UA_DiagnosticInfo in)  __attribute__((unused));
static UA_DiagnosticInfo XS_unpack_UA_DiagnosticInfo(SV *in)  __attribute__((unused));
/* implemented in Open62541.xs */
#endif

/* NamingRuleType */
#ifdef UA_TYPES_NAMINGRULETYPE

static void XS_pack_UA_NamingRuleType(SV *out, UA_NamingRuleType in)  __attribute__((unused));
static void
XS_pack_UA_NamingRuleType(SV *out, UA_NamingRuleType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_NamingRuleType XS_unpack_UA_NamingRuleType(SV *in)  __attribute__((unused));
static UA_NamingRuleType
XS_unpack_UA_NamingRuleType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ImageBMP */
#ifdef UA_TYPES_IMAGEBMP

static void XS_pack_UA_ImageBMP(SV *out, UA_ImageBMP in)  __attribute__((unused));
static void
XS_pack_UA_ImageBMP(SV *out, UA_ImageBMP in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_ImageBMP XS_unpack_UA_ImageBMP(SV *in)  __attribute__((unused));
static UA_ImageBMP
XS_unpack_UA_ImageBMP(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* ImageGIF */
#ifdef UA_TYPES_IMAGEGIF

static void XS_pack_UA_ImageGIF(SV *out, UA_ImageGIF in)  __attribute__((unused));
static void
XS_pack_UA_ImageGIF(SV *out, UA_ImageGIF in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_ImageGIF XS_unpack_UA_ImageGIF(SV *in)  __attribute__((unused));
static UA_ImageGIF
XS_unpack_UA_ImageGIF(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* ImageJPG */
#ifdef UA_TYPES_IMAGEJPG

static void XS_pack_UA_ImageJPG(SV *out, UA_ImageJPG in)  __attribute__((unused));
static void
XS_pack_UA_ImageJPG(SV *out, UA_ImageJPG in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_ImageJPG XS_unpack_UA_ImageJPG(SV *in)  __attribute__((unused));
static UA_ImageJPG
XS_unpack_UA_ImageJPG(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* ImagePNG */
#ifdef UA_TYPES_IMAGEPNG

static void XS_pack_UA_ImagePNG(SV *out, UA_ImagePNG in)  __attribute__((unused));
static void
XS_pack_UA_ImagePNG(SV *out, UA_ImagePNG in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_ImagePNG XS_unpack_UA_ImagePNG(SV *in)  __attribute__((unused));
static UA_ImagePNG
XS_unpack_UA_ImagePNG(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* AudioDataType */
#ifdef UA_TYPES_AUDIODATATYPE

static void XS_pack_UA_AudioDataType(SV *out, UA_AudioDataType in)  __attribute__((unused));
static void
XS_pack_UA_AudioDataType(SV *out, UA_AudioDataType in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_AudioDataType XS_unpack_UA_AudioDataType(SV *in)  __attribute__((unused));
static UA_AudioDataType
XS_unpack_UA_AudioDataType(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* BitFieldMaskDataType */
#ifdef UA_TYPES_BITFIELDMASKDATATYPE

static void XS_pack_UA_BitFieldMaskDataType(SV *out, UA_BitFieldMaskDataType in)  __attribute__((unused));
static void
XS_pack_UA_BitFieldMaskDataType(SV *out, UA_BitFieldMaskDataType in)
{
	dTHX;
	XS_pack_UA_UInt64(out, in);
}

static UA_BitFieldMaskDataType XS_unpack_UA_BitFieldMaskDataType(SV *in)  __attribute__((unused));
static UA_BitFieldMaskDataType
XS_unpack_UA_BitFieldMaskDataType(SV *in)
{
	dTHX;
	return XS_unpack_UA_UInt64(in);
}
#endif

/* KeyValuePair */
#ifdef UA_TYPES_KEYVALUEPAIR

static void XS_pack_UA_KeyValuePair(SV *out, UA_KeyValuePair in)  __attribute__((unused));
static void
XS_pack_UA_KeyValuePair(SV *out, UA_KeyValuePair in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.key);
	hv_stores(hv, "KeyValuePair_key", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.value);
	hv_stores(hv, "KeyValuePair_value", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_KeyValuePair XS_unpack_UA_KeyValuePair(SV *in)  __attribute__((unused));
static UA_KeyValuePair
XS_unpack_UA_KeyValuePair(SV *in)
{
	dTHX;
	UA_KeyValuePair out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_KeyValuePair_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "KeyValuePair_key", 0);
	if (svp != NULL)
		out.key = XS_unpack_UA_QualifiedName(*svp);

	svp = hv_fetchs(hv, "KeyValuePair_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Variant(*svp);

	return out;
}
#endif

/* RationalNumber */
#ifdef UA_TYPES_RATIONALNUMBER

static void XS_pack_UA_RationalNumber(SV *out, UA_RationalNumber in)  __attribute__((unused));
static void
XS_pack_UA_RationalNumber(SV *out, UA_RationalNumber in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.numerator);
	hv_stores(hv, "RationalNumber_numerator", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.denominator);
	hv_stores(hv, "RationalNumber_denominator", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RationalNumber XS_unpack_UA_RationalNumber(SV *in)  __attribute__((unused));
static UA_RationalNumber
XS_unpack_UA_RationalNumber(SV *in)
{
	dTHX;
	UA_RationalNumber out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RationalNumber_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RationalNumber_numerator", 0);
	if (svp != NULL)
		out.numerator = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "RationalNumber_denominator", 0);
	if (svp != NULL)
		out.denominator = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* Vector */
#ifdef UA_TYPES_VECTOR

static void XS_pack_UA_Vector(SV *out, UA_Vector in)  __attribute__((unused));
static void
XS_pack_UA_Vector(SV *out, UA_Vector in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_Vector XS_unpack_UA_Vector(SV *in)  __attribute__((unused));
static UA_Vector
XS_unpack_UA_Vector(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ThreeDVector */
#ifdef UA_TYPES_THREEDVECTOR

static void XS_pack_UA_ThreeDVector(SV *out, UA_ThreeDVector in)  __attribute__((unused));
static void
XS_pack_UA_ThreeDVector(SV *out, UA_ThreeDVector in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.x);
	hv_stores(hv, "ThreeDVector_x", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.y);
	hv_stores(hv, "ThreeDVector_y", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.z);
	hv_stores(hv, "ThreeDVector_z", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ThreeDVector XS_unpack_UA_ThreeDVector(SV *in)  __attribute__((unused));
static UA_ThreeDVector
XS_unpack_UA_ThreeDVector(SV *in)
{
	dTHX;
	UA_ThreeDVector out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ThreeDVector_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ThreeDVector_x", 0);
	if (svp != NULL)
		out.x = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ThreeDVector_y", 0);
	if (svp != NULL)
		out.y = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ThreeDVector_z", 0);
	if (svp != NULL)
		out.z = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* CartesianCoordinates */
#ifdef UA_TYPES_CARTESIANCOORDINATES

static void XS_pack_UA_CartesianCoordinates(SV *out, UA_CartesianCoordinates in)  __attribute__((unused));
static void
XS_pack_UA_CartesianCoordinates(SV *out, UA_CartesianCoordinates in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_CartesianCoordinates XS_unpack_UA_CartesianCoordinates(SV *in)  __attribute__((unused));
static UA_CartesianCoordinates
XS_unpack_UA_CartesianCoordinates(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ThreeDCartesianCoordinates */
#ifdef UA_TYPES_THREEDCARTESIANCOORDINATES

static void XS_pack_UA_ThreeDCartesianCoordinates(SV *out, UA_ThreeDCartesianCoordinates in)  __attribute__((unused));
static void
XS_pack_UA_ThreeDCartesianCoordinates(SV *out, UA_ThreeDCartesianCoordinates in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.x);
	hv_stores(hv, "ThreeDCartesianCoordinates_x", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.y);
	hv_stores(hv, "ThreeDCartesianCoordinates_y", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.z);
	hv_stores(hv, "ThreeDCartesianCoordinates_z", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ThreeDCartesianCoordinates XS_unpack_UA_ThreeDCartesianCoordinates(SV *in)  __attribute__((unused));
static UA_ThreeDCartesianCoordinates
XS_unpack_UA_ThreeDCartesianCoordinates(SV *in)
{
	dTHX;
	UA_ThreeDCartesianCoordinates out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ThreeDCartesianCoordinates_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ThreeDCartesianCoordinates_x", 0);
	if (svp != NULL)
		out.x = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ThreeDCartesianCoordinates_y", 0);
	if (svp != NULL)
		out.y = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ThreeDCartesianCoordinates_z", 0);
	if (svp != NULL)
		out.z = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* Orientation */
#ifdef UA_TYPES_ORIENTATION

static void XS_pack_UA_Orientation(SV *out, UA_Orientation in)  __attribute__((unused));
static void
XS_pack_UA_Orientation(SV *out, UA_Orientation in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_Orientation XS_unpack_UA_Orientation(SV *in)  __attribute__((unused));
static UA_Orientation
XS_unpack_UA_Orientation(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ThreeDOrientation */
#ifdef UA_TYPES_THREEDORIENTATION

static void XS_pack_UA_ThreeDOrientation(SV *out, UA_ThreeDOrientation in)  __attribute__((unused));
static void
XS_pack_UA_ThreeDOrientation(SV *out, UA_ThreeDOrientation in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.a);
	hv_stores(hv, "ThreeDOrientation_a", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.b);
	hv_stores(hv, "ThreeDOrientation_b", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.c);
	hv_stores(hv, "ThreeDOrientation_c", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ThreeDOrientation XS_unpack_UA_ThreeDOrientation(SV *in)  __attribute__((unused));
static UA_ThreeDOrientation
XS_unpack_UA_ThreeDOrientation(SV *in)
{
	dTHX;
	UA_ThreeDOrientation out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ThreeDOrientation_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ThreeDOrientation_a", 0);
	if (svp != NULL)
		out.a = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ThreeDOrientation_b", 0);
	if (svp != NULL)
		out.b = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ThreeDOrientation_c", 0);
	if (svp != NULL)
		out.c = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* Frame */
#ifdef UA_TYPES_FRAME

static void XS_pack_UA_Frame(SV *out, UA_Frame in)  __attribute__((unused));
static void
XS_pack_UA_Frame(SV *out, UA_Frame in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_Frame XS_unpack_UA_Frame(SV *in)  __attribute__((unused));
static UA_Frame
XS_unpack_UA_Frame(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ThreeDFrame */
#ifdef UA_TYPES_THREEDFRAME

static void XS_pack_UA_ThreeDFrame(SV *out, UA_ThreeDFrame in)  __attribute__((unused));
static void
XS_pack_UA_ThreeDFrame(SV *out, UA_ThreeDFrame in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ThreeDCartesianCoordinates(sv, in.cartesianCoordinates);
	hv_stores(hv, "ThreeDFrame_cartesianCoordinates", sv);

	sv = newSV(0);
	XS_pack_UA_ThreeDOrientation(sv, in.orientation);
	hv_stores(hv, "ThreeDFrame_orientation", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ThreeDFrame XS_unpack_UA_ThreeDFrame(SV *in)  __attribute__((unused));
static UA_ThreeDFrame
XS_unpack_UA_ThreeDFrame(SV *in)
{
	dTHX;
	UA_ThreeDFrame out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ThreeDFrame_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ThreeDFrame_cartesianCoordinates", 0);
	if (svp != NULL)
		out.cartesianCoordinates = XS_unpack_UA_ThreeDCartesianCoordinates(*svp);

	svp = hv_fetchs(hv, "ThreeDFrame_orientation", 0);
	if (svp != NULL)
		out.orientation = XS_unpack_UA_ThreeDOrientation(*svp);

	return out;
}
#endif

/* OpenFileMode */
#ifdef UA_TYPES_OPENFILEMODE

static void XS_pack_UA_OpenFileMode(SV *out, UA_OpenFileMode in)  __attribute__((unused));
static void
XS_pack_UA_OpenFileMode(SV *out, UA_OpenFileMode in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_OpenFileMode XS_unpack_UA_OpenFileMode(SV *in)  __attribute__((unused));
static UA_OpenFileMode
XS_unpack_UA_OpenFileMode(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* IdentityCriteriaType */
#ifdef UA_TYPES_IDENTITYCRITERIATYPE

static void XS_pack_UA_IdentityCriteriaType(SV *out, UA_IdentityCriteriaType in)  __attribute__((unused));
static void
XS_pack_UA_IdentityCriteriaType(SV *out, UA_IdentityCriteriaType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_IdentityCriteriaType XS_unpack_UA_IdentityCriteriaType(SV *in)  __attribute__((unused));
static UA_IdentityCriteriaType
XS_unpack_UA_IdentityCriteriaType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* IdentityMappingRuleType */
#ifdef UA_TYPES_IDENTITYMAPPINGRULETYPE

static void XS_pack_UA_IdentityMappingRuleType(SV *out, UA_IdentityMappingRuleType in)  __attribute__((unused));
static void
XS_pack_UA_IdentityMappingRuleType(SV *out, UA_IdentityMappingRuleType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_IdentityCriteriaType(sv, in.criteriaType);
	hv_stores(hv, "IdentityMappingRuleType_criteriaType", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.criteria);
	hv_stores(hv, "IdentityMappingRuleType_criteria", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_IdentityMappingRuleType XS_unpack_UA_IdentityMappingRuleType(SV *in)  __attribute__((unused));
static UA_IdentityMappingRuleType
XS_unpack_UA_IdentityMappingRuleType(SV *in)
{
	dTHX;
	UA_IdentityMappingRuleType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_IdentityMappingRuleType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "IdentityMappingRuleType_criteriaType", 0);
	if (svp != NULL)
		out.criteriaType = XS_unpack_UA_IdentityCriteriaType(*svp);

	svp = hv_fetchs(hv, "IdentityMappingRuleType_criteria", 0);
	if (svp != NULL)
		out.criteria = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* CurrencyUnitType */
#ifdef UA_TYPES_CURRENCYUNITTYPE

static void XS_pack_UA_CurrencyUnitType(SV *out, UA_CurrencyUnitType in)  __attribute__((unused));
static void
XS_pack_UA_CurrencyUnitType(SV *out, UA_CurrencyUnitType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Int16(sv, in.numericCode);
	hv_stores(hv, "CurrencyUnitType_numericCode", sv);

	sv = newSV(0);
	XS_pack_UA_SByte(sv, in.exponent);
	hv_stores(hv, "CurrencyUnitType_exponent", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.alphabeticCode);
	hv_stores(hv, "CurrencyUnitType_alphabeticCode", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.currency);
	hv_stores(hv, "CurrencyUnitType_currency", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CurrencyUnitType XS_unpack_UA_CurrencyUnitType(SV *in)  __attribute__((unused));
static UA_CurrencyUnitType
XS_unpack_UA_CurrencyUnitType(SV *in)
{
	dTHX;
	UA_CurrencyUnitType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CurrencyUnitType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CurrencyUnitType_numericCode", 0);
	if (svp != NULL)
		out.numericCode = XS_unpack_UA_Int16(*svp);

	svp = hv_fetchs(hv, "CurrencyUnitType_exponent", 0);
	if (svp != NULL)
		out.exponent = XS_unpack_UA_SByte(*svp);

	svp = hv_fetchs(hv, "CurrencyUnitType_alphabeticCode", 0);
	if (svp != NULL)
		out.alphabeticCode = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "CurrencyUnitType_currency", 0);
	if (svp != NULL)
		out.currency = XS_unpack_UA_LocalizedText(*svp);

	return out;
}
#endif

/* TrustListMasks */
#ifdef UA_TYPES_TRUSTLISTMASKS

static void XS_pack_UA_TrustListMasks(SV *out, UA_TrustListMasks in)  __attribute__((unused));
static void
XS_pack_UA_TrustListMasks(SV *out, UA_TrustListMasks in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_TrustListMasks XS_unpack_UA_TrustListMasks(SV *in)  __attribute__((unused));
static UA_TrustListMasks
XS_unpack_UA_TrustListMasks(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* TrustListDataType */
#ifdef UA_TYPES_TRUSTLISTDATATYPE

static void XS_pack_UA_TrustListDataType(SV *out, UA_TrustListDataType in)  __attribute__((unused));
static void
XS_pack_UA_TrustListDataType(SV *out, UA_TrustListDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedLists);
	hv_stores(hv, "TrustListDataType_specifiedLists", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.trustedCertificatesSize);
	for (i = 0; i < in.trustedCertificatesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ByteString(sv, in.trustedCertificates[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TrustListDataType_trustedCertificates", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.trustedCrlsSize);
	for (i = 0; i < in.trustedCrlsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ByteString(sv, in.trustedCrls[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TrustListDataType_trustedCrls", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.issuerCertificatesSize);
	for (i = 0; i < in.issuerCertificatesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ByteString(sv, in.issuerCertificates[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TrustListDataType_issuerCertificates", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.issuerCrlsSize);
	for (i = 0; i < in.issuerCrlsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ByteString(sv, in.issuerCrls[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TrustListDataType_issuerCrls", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TrustListDataType XS_unpack_UA_TrustListDataType(SV *in)  __attribute__((unused));
static UA_TrustListDataType
XS_unpack_UA_TrustListDataType(SV *in)
{
	dTHX;
	UA_TrustListDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TrustListDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TrustListDataType_specifiedLists", 0);
	if (svp != NULL)
		out.specifiedLists = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "TrustListDataType_trustedCertificates", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TrustListDataType_trustedCertificates");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.trustedCertificates = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BYTESTRING]);
		if (out.trustedCertificates == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.trustedCertificates[i] = XS_unpack_UA_ByteString(*svp);
			}
		}
		out.trustedCertificatesSize = i;
	}

	svp = hv_fetchs(hv, "TrustListDataType_trustedCrls", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TrustListDataType_trustedCrls");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.trustedCrls = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BYTESTRING]);
		if (out.trustedCrls == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.trustedCrls[i] = XS_unpack_UA_ByteString(*svp);
			}
		}
		out.trustedCrlsSize = i;
	}

	svp = hv_fetchs(hv, "TrustListDataType_issuerCertificates", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TrustListDataType_issuerCertificates");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.issuerCertificates = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BYTESTRING]);
		if (out.issuerCertificates == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.issuerCertificates[i] = XS_unpack_UA_ByteString(*svp);
			}
		}
		out.issuerCertificatesSize = i;
	}

	svp = hv_fetchs(hv, "TrustListDataType_issuerCrls", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TrustListDataType_issuerCrls");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.issuerCrls = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BYTESTRING]);
		if (out.issuerCrls == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.issuerCrls[i] = XS_unpack_UA_ByteString(*svp);
			}
		}
		out.issuerCrlsSize = i;
	}

	return out;
}
#endif

/* DecimalDataType */
#ifdef UA_TYPES_DECIMALDATATYPE

static void XS_pack_UA_DecimalDataType(SV *out, UA_DecimalDataType in)  __attribute__((unused));
static void
XS_pack_UA_DecimalDataType(SV *out, UA_DecimalDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Int16(sv, in.scale);
	hv_stores(hv, "DecimalDataType_scale", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.value);
	hv_stores(hv, "DecimalDataType_value", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DecimalDataType XS_unpack_UA_DecimalDataType(SV *in)  __attribute__((unused));
static UA_DecimalDataType
XS_unpack_UA_DecimalDataType(SV *in)
{
	dTHX;
	UA_DecimalDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DecimalDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DecimalDataType_scale", 0);
	if (svp != NULL)
		out.scale = XS_unpack_UA_Int16(*svp);

	svp = hv_fetchs(hv, "DecimalDataType_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* DataTypeDescription */
#ifdef UA_TYPES_DATATYPEDESCRIPTION

static void XS_pack_UA_DataTypeDescription(SV *out, UA_DataTypeDescription in)  __attribute__((unused));
static void
XS_pack_UA_DataTypeDescription(SV *out, UA_DataTypeDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataTypeId);
	hv_stores(hv, "DataTypeDescription_dataTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.name);
	hv_stores(hv, "DataTypeDescription_name", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataTypeDescription XS_unpack_UA_DataTypeDescription(SV *in)  __attribute__((unused));
static UA_DataTypeDescription
XS_unpack_UA_DataTypeDescription(SV *in)
{
	dTHX;
	UA_DataTypeDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataTypeDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataTypeDescription_dataTypeId", 0);
	if (svp != NULL)
		out.dataTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "DataTypeDescription_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_QualifiedName(*svp);

	return out;
}
#endif

/* SimpleTypeDescription */
#ifdef UA_TYPES_SIMPLETYPEDESCRIPTION

static void XS_pack_UA_SimpleTypeDescription(SV *out, UA_SimpleTypeDescription in)  __attribute__((unused));
static void
XS_pack_UA_SimpleTypeDescription(SV *out, UA_SimpleTypeDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataTypeId);
	hv_stores(hv, "SimpleTypeDescription_dataTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.name);
	hv_stores(hv, "SimpleTypeDescription_name", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.baseDataType);
	hv_stores(hv, "SimpleTypeDescription_baseDataType", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.builtInType);
	hv_stores(hv, "SimpleTypeDescription_builtInType", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SimpleTypeDescription XS_unpack_UA_SimpleTypeDescription(SV *in)  __attribute__((unused));
static UA_SimpleTypeDescription
XS_unpack_UA_SimpleTypeDescription(SV *in)
{
	dTHX;
	UA_SimpleTypeDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SimpleTypeDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SimpleTypeDescription_dataTypeId", 0);
	if (svp != NULL)
		out.dataTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "SimpleTypeDescription_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_QualifiedName(*svp);

	svp = hv_fetchs(hv, "SimpleTypeDescription_baseDataType", 0);
	if (svp != NULL)
		out.baseDataType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "SimpleTypeDescription_builtInType", 0);
	if (svp != NULL)
		out.builtInType = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* PubSubState */
#ifdef UA_TYPES_PUBSUBSTATE

static void XS_pack_UA_PubSubState(SV *out, UA_PubSubState in)  __attribute__((unused));
static void
XS_pack_UA_PubSubState(SV *out, UA_PubSubState in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_PubSubState XS_unpack_UA_PubSubState(SV *in)  __attribute__((unused));
static UA_PubSubState
XS_unpack_UA_PubSubState(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* DataSetFieldFlags */
#ifdef UA_TYPES_DATASETFIELDFLAGS

static void XS_pack_UA_DataSetFieldFlags(SV *out, UA_DataSetFieldFlags in)  __attribute__((unused));
static void
XS_pack_UA_DataSetFieldFlags(SV *out, UA_DataSetFieldFlags in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_DataSetFieldFlags XS_unpack_UA_DataSetFieldFlags(SV *in)  __attribute__((unused));
static UA_DataSetFieldFlags
XS_unpack_UA_DataSetFieldFlags(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ConfigurationVersionDataType */
#ifdef UA_TYPES_CONFIGURATIONVERSIONDATATYPE

static void XS_pack_UA_ConfigurationVersionDataType(SV *out, UA_ConfigurationVersionDataType in)  __attribute__((unused));
static void
XS_pack_UA_ConfigurationVersionDataType(SV *out, UA_ConfigurationVersionDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.majorVersion);
	hv_stores(hv, "ConfigurationVersionDataType_majorVersion", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.minorVersion);
	hv_stores(hv, "ConfigurationVersionDataType_minorVersion", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ConfigurationVersionDataType XS_unpack_UA_ConfigurationVersionDataType(SV *in)  __attribute__((unused));
static UA_ConfigurationVersionDataType
XS_unpack_UA_ConfigurationVersionDataType(SV *in)
{
	dTHX;
	UA_ConfigurationVersionDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ConfigurationVersionDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ConfigurationVersionDataType_majorVersion", 0);
	if (svp != NULL)
		out.majorVersion = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ConfigurationVersionDataType_minorVersion", 0);
	if (svp != NULL)
		out.minorVersion = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* PublishedDataSetSourceDataType */
#ifdef UA_TYPES_PUBLISHEDDATASETSOURCEDATATYPE

static void XS_pack_UA_PublishedDataSetSourceDataType(SV *out, UA_PublishedDataSetSourceDataType in)  __attribute__((unused));
static void
XS_pack_UA_PublishedDataSetSourceDataType(SV *out, UA_PublishedDataSetSourceDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_PublishedDataSetSourceDataType XS_unpack_UA_PublishedDataSetSourceDataType(SV *in)  __attribute__((unused));
static UA_PublishedDataSetSourceDataType
XS_unpack_UA_PublishedDataSetSourceDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* PublishedVariableDataType */
#ifdef UA_TYPES_PUBLISHEDVARIABLEDATATYPE

static void XS_pack_UA_PublishedVariableDataType(SV *out, UA_PublishedVariableDataType in)  __attribute__((unused));
static void
XS_pack_UA_PublishedVariableDataType(SV *out, UA_PublishedVariableDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.publishedVariable);
	hv_stores(hv, "PublishedVariableDataType_publishedVariable", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "PublishedVariableDataType_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.samplingIntervalHint);
	hv_stores(hv, "PublishedVariableDataType_samplingIntervalHint", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.deadbandType);
	hv_stores(hv, "PublishedVariableDataType_deadbandType", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.deadbandValue);
	hv_stores(hv, "PublishedVariableDataType_deadbandValue", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.indexRange);
	hv_stores(hv, "PublishedVariableDataType_indexRange", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.substituteValue);
	hv_stores(hv, "PublishedVariableDataType_substituteValue", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.metaDataPropertiesSize);
	for (i = 0; i < in.metaDataPropertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_QualifiedName(sv, in.metaDataProperties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishedVariableDataType_metaDataProperties", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PublishedVariableDataType XS_unpack_UA_PublishedVariableDataType(SV *in)  __attribute__((unused));
static UA_PublishedVariableDataType
XS_unpack_UA_PublishedVariableDataType(SV *in)
{
	dTHX;
	UA_PublishedVariableDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PublishedVariableDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PublishedVariableDataType_publishedVariable", 0);
	if (svp != NULL)
		out.publishedVariable = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "PublishedVariableDataType_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "PublishedVariableDataType_samplingIntervalHint", 0);
	if (svp != NULL)
		out.samplingIntervalHint = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "PublishedVariableDataType_deadbandType", 0);
	if (svp != NULL)
		out.deadbandType = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "PublishedVariableDataType_deadbandValue", 0);
	if (svp != NULL)
		out.deadbandValue = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "PublishedVariableDataType_indexRange", 0);
	if (svp != NULL)
		out.indexRange = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "PublishedVariableDataType_substituteValue", 0);
	if (svp != NULL)
		out.substituteValue = XS_unpack_UA_Variant(*svp);

	svp = hv_fetchs(hv, "PublishedVariableDataType_metaDataProperties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishedVariableDataType_metaDataProperties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.metaDataProperties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_QUALIFIEDNAME]);
		if (out.metaDataProperties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.metaDataProperties[i] = XS_unpack_UA_QualifiedName(*svp);
			}
		}
		out.metaDataPropertiesSize = i;
	}

	return out;
}
#endif

/* PublishedDataItemsDataType */
#ifdef UA_TYPES_PUBLISHEDDATAITEMSDATATYPE

static void XS_pack_UA_PublishedDataItemsDataType(SV *out, UA_PublishedDataItemsDataType in)  __attribute__((unused));
static void
XS_pack_UA_PublishedDataItemsDataType(SV *out, UA_PublishedDataItemsDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.publishedDataSize);
	for (i = 0; i < in.publishedDataSize; i++) {
		sv = newSV(0);
		XS_pack_UA_PublishedVariableDataType(sv, in.publishedData[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishedDataItemsDataType_publishedData", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PublishedDataItemsDataType XS_unpack_UA_PublishedDataItemsDataType(SV *in)  __attribute__((unused));
static UA_PublishedDataItemsDataType
XS_unpack_UA_PublishedDataItemsDataType(SV *in)
{
	dTHX;
	UA_PublishedDataItemsDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PublishedDataItemsDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PublishedDataItemsDataType_publishedData", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishedDataItemsDataType_publishedData");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.publishedData = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_PUBLISHEDVARIABLEDATATYPE]);
		if (out.publishedData == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.publishedData[i] = XS_unpack_UA_PublishedVariableDataType(*svp);
			}
		}
		out.publishedDataSize = i;
	}

	return out;
}
#endif

/* DataSetFieldContentMask */
#ifdef UA_TYPES_DATASETFIELDCONTENTMASK

static void XS_pack_UA_DataSetFieldContentMask(SV *out, UA_DataSetFieldContentMask in)  __attribute__((unused));
static void
XS_pack_UA_DataSetFieldContentMask(SV *out, UA_DataSetFieldContentMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_DataSetFieldContentMask XS_unpack_UA_DataSetFieldContentMask(SV *in)  __attribute__((unused));
static UA_DataSetFieldContentMask
XS_unpack_UA_DataSetFieldContentMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* DataSetWriterDataType */
#ifdef UA_TYPES_DATASETWRITERDATATYPE

static void XS_pack_UA_DataSetWriterDataType(SV *out, UA_DataSetWriterDataType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetWriterDataType(SV *out, UA_DataSetWriterDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "DataSetWriterDataType_name", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.enabled);
	hv_stores(hv, "DataSetWriterDataType_enabled", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.dataSetWriterId);
	hv_stores(hv, "DataSetWriterDataType_dataSetWriterId", sv);

	sv = newSV(0);
	XS_pack_UA_DataSetFieldContentMask(sv, in.dataSetFieldContentMask);
	hv_stores(hv, "DataSetWriterDataType_dataSetFieldContentMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.keyFrameCount);
	hv_stores(hv, "DataSetWriterDataType_keyFrameCount", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.dataSetName);
	hv_stores(hv, "DataSetWriterDataType_dataSetName", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataSetWriterPropertiesSize);
	for (i = 0; i < in.dataSetWriterPropertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.dataSetWriterProperties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetWriterDataType_dataSetWriterProperties", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.transportSettings);
	hv_stores(hv, "DataSetWriterDataType_transportSettings", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.messageSettings);
	hv_stores(hv, "DataSetWriterDataType_messageSettings", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataSetWriterDataType XS_unpack_UA_DataSetWriterDataType(SV *in)  __attribute__((unused));
static UA_DataSetWriterDataType
XS_unpack_UA_DataSetWriterDataType(SV *in)
{
	dTHX;
	UA_DataSetWriterDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataSetWriterDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataSetWriterDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "DataSetWriterDataType_enabled", 0);
	if (svp != NULL)
		out.enabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "DataSetWriterDataType_dataSetWriterId", 0);
	if (svp != NULL)
		out.dataSetWriterId = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "DataSetWriterDataType_dataSetFieldContentMask", 0);
	if (svp != NULL)
		out.dataSetFieldContentMask = XS_unpack_UA_DataSetFieldContentMask(*svp);

	svp = hv_fetchs(hv, "DataSetWriterDataType_keyFrameCount", 0);
	if (svp != NULL)
		out.keyFrameCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "DataSetWriterDataType_dataSetName", 0);
	if (svp != NULL)
		out.dataSetName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "DataSetWriterDataType_dataSetWriterProperties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetWriterDataType_dataSetWriterProperties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataSetWriterProperties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.dataSetWriterProperties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataSetWriterProperties[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.dataSetWriterPropertiesSize = i;
	}

	svp = hv_fetchs(hv, "DataSetWriterDataType_transportSettings", 0);
	if (svp != NULL)
		out.transportSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "DataSetWriterDataType_messageSettings", 0);
	if (svp != NULL)
		out.messageSettings = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* DataSetWriterTransportDataType */
#ifdef UA_TYPES_DATASETWRITERTRANSPORTDATATYPE

static void XS_pack_UA_DataSetWriterTransportDataType(SV *out, UA_DataSetWriterTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetWriterTransportDataType(SV *out, UA_DataSetWriterTransportDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_DataSetWriterTransportDataType XS_unpack_UA_DataSetWriterTransportDataType(SV *in)  __attribute__((unused));
static UA_DataSetWriterTransportDataType
XS_unpack_UA_DataSetWriterTransportDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* DataSetWriterMessageDataType */
#ifdef UA_TYPES_DATASETWRITERMESSAGEDATATYPE

static void XS_pack_UA_DataSetWriterMessageDataType(SV *out, UA_DataSetWriterMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetWriterMessageDataType(SV *out, UA_DataSetWriterMessageDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_DataSetWriterMessageDataType XS_unpack_UA_DataSetWriterMessageDataType(SV *in)  __attribute__((unused));
static UA_DataSetWriterMessageDataType
XS_unpack_UA_DataSetWriterMessageDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* WriterGroupTransportDataType */
#ifdef UA_TYPES_WRITERGROUPTRANSPORTDATATYPE

static void XS_pack_UA_WriterGroupTransportDataType(SV *out, UA_WriterGroupTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_WriterGroupTransportDataType(SV *out, UA_WriterGroupTransportDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_WriterGroupTransportDataType XS_unpack_UA_WriterGroupTransportDataType(SV *in)  __attribute__((unused));
static UA_WriterGroupTransportDataType
XS_unpack_UA_WriterGroupTransportDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* WriterGroupMessageDataType */
#ifdef UA_TYPES_WRITERGROUPMESSAGEDATATYPE

static void XS_pack_UA_WriterGroupMessageDataType(SV *out, UA_WriterGroupMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_WriterGroupMessageDataType(SV *out, UA_WriterGroupMessageDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_WriterGroupMessageDataType XS_unpack_UA_WriterGroupMessageDataType(SV *in)  __attribute__((unused));
static UA_WriterGroupMessageDataType
XS_unpack_UA_WriterGroupMessageDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ConnectionTransportDataType */
#ifdef UA_TYPES_CONNECTIONTRANSPORTDATATYPE

static void XS_pack_UA_ConnectionTransportDataType(SV *out, UA_ConnectionTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_ConnectionTransportDataType(SV *out, UA_ConnectionTransportDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_ConnectionTransportDataType XS_unpack_UA_ConnectionTransportDataType(SV *in)  __attribute__((unused));
static UA_ConnectionTransportDataType
XS_unpack_UA_ConnectionTransportDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* NetworkAddressDataType */
#ifdef UA_TYPES_NETWORKADDRESSDATATYPE

static void XS_pack_UA_NetworkAddressDataType(SV *out, UA_NetworkAddressDataType in)  __attribute__((unused));
static void
XS_pack_UA_NetworkAddressDataType(SV *out, UA_NetworkAddressDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.networkInterface);
	hv_stores(hv, "NetworkAddressDataType_networkInterface", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_NetworkAddressDataType XS_unpack_UA_NetworkAddressDataType(SV *in)  __attribute__((unused));
static UA_NetworkAddressDataType
XS_unpack_UA_NetworkAddressDataType(SV *in)
{
	dTHX;
	UA_NetworkAddressDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_NetworkAddressDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "NetworkAddressDataType_networkInterface", 0);
	if (svp != NULL)
		out.networkInterface = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* NetworkAddressUrlDataType */
#ifdef UA_TYPES_NETWORKADDRESSURLDATATYPE

static void XS_pack_UA_NetworkAddressUrlDataType(SV *out, UA_NetworkAddressUrlDataType in)  __attribute__((unused));
static void
XS_pack_UA_NetworkAddressUrlDataType(SV *out, UA_NetworkAddressUrlDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.networkInterface);
	hv_stores(hv, "NetworkAddressUrlDataType_networkInterface", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.url);
	hv_stores(hv, "NetworkAddressUrlDataType_url", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_NetworkAddressUrlDataType XS_unpack_UA_NetworkAddressUrlDataType(SV *in)  __attribute__((unused));
static UA_NetworkAddressUrlDataType
XS_unpack_UA_NetworkAddressUrlDataType(SV *in)
{
	dTHX;
	UA_NetworkAddressUrlDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_NetworkAddressUrlDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "NetworkAddressUrlDataType_networkInterface", 0);
	if (svp != NULL)
		out.networkInterface = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "NetworkAddressUrlDataType_url", 0);
	if (svp != NULL)
		out.url = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* ReaderGroupTransportDataType */
#ifdef UA_TYPES_READERGROUPTRANSPORTDATATYPE

static void XS_pack_UA_ReaderGroupTransportDataType(SV *out, UA_ReaderGroupTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_ReaderGroupTransportDataType(SV *out, UA_ReaderGroupTransportDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_ReaderGroupTransportDataType XS_unpack_UA_ReaderGroupTransportDataType(SV *in)  __attribute__((unused));
static UA_ReaderGroupTransportDataType
XS_unpack_UA_ReaderGroupTransportDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ReaderGroupMessageDataType */
#ifdef UA_TYPES_READERGROUPMESSAGEDATATYPE

static void XS_pack_UA_ReaderGroupMessageDataType(SV *out, UA_ReaderGroupMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_ReaderGroupMessageDataType(SV *out, UA_ReaderGroupMessageDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_ReaderGroupMessageDataType XS_unpack_UA_ReaderGroupMessageDataType(SV *in)  __attribute__((unused));
static UA_ReaderGroupMessageDataType
XS_unpack_UA_ReaderGroupMessageDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* DataSetReaderTransportDataType */
#ifdef UA_TYPES_DATASETREADERTRANSPORTDATATYPE

static void XS_pack_UA_DataSetReaderTransportDataType(SV *out, UA_DataSetReaderTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetReaderTransportDataType(SV *out, UA_DataSetReaderTransportDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_DataSetReaderTransportDataType XS_unpack_UA_DataSetReaderTransportDataType(SV *in)  __attribute__((unused));
static UA_DataSetReaderTransportDataType
XS_unpack_UA_DataSetReaderTransportDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* DataSetReaderMessageDataType */
#ifdef UA_TYPES_DATASETREADERMESSAGEDATATYPE

static void XS_pack_UA_DataSetReaderMessageDataType(SV *out, UA_DataSetReaderMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetReaderMessageDataType(SV *out, UA_DataSetReaderMessageDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_DataSetReaderMessageDataType XS_unpack_UA_DataSetReaderMessageDataType(SV *in)  __attribute__((unused));
static UA_DataSetReaderMessageDataType
XS_unpack_UA_DataSetReaderMessageDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* SubscribedDataSetDataType */
#ifdef UA_TYPES_SUBSCRIBEDDATASETDATATYPE

static void XS_pack_UA_SubscribedDataSetDataType(SV *out, UA_SubscribedDataSetDataType in)  __attribute__((unused));
static void
XS_pack_UA_SubscribedDataSetDataType(SV *out, UA_SubscribedDataSetDataType in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_SubscribedDataSetDataType XS_unpack_UA_SubscribedDataSetDataType(SV *in)  __attribute__((unused));
static UA_SubscribedDataSetDataType
XS_unpack_UA_SubscribedDataSetDataType(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* OverrideValueHandling */
#ifdef UA_TYPES_OVERRIDEVALUEHANDLING

static void XS_pack_UA_OverrideValueHandling(SV *out, UA_OverrideValueHandling in)  __attribute__((unused));
static void
XS_pack_UA_OverrideValueHandling(SV *out, UA_OverrideValueHandling in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_OverrideValueHandling XS_unpack_UA_OverrideValueHandling(SV *in)  __attribute__((unused));
static UA_OverrideValueHandling
XS_unpack_UA_OverrideValueHandling(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* DataSetOrderingType */
#ifdef UA_TYPES_DATASETORDERINGTYPE

static void XS_pack_UA_DataSetOrderingType(SV *out, UA_DataSetOrderingType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetOrderingType(SV *out, UA_DataSetOrderingType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_DataSetOrderingType XS_unpack_UA_DataSetOrderingType(SV *in)  __attribute__((unused));
static UA_DataSetOrderingType
XS_unpack_UA_DataSetOrderingType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* UadpNetworkMessageContentMask */
#ifdef UA_TYPES_UADPNETWORKMESSAGECONTENTMASK

static void XS_pack_UA_UadpNetworkMessageContentMask(SV *out, UA_UadpNetworkMessageContentMask in)  __attribute__((unused));
static void
XS_pack_UA_UadpNetworkMessageContentMask(SV *out, UA_UadpNetworkMessageContentMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_UadpNetworkMessageContentMask XS_unpack_UA_UadpNetworkMessageContentMask(SV *in)  __attribute__((unused));
static UA_UadpNetworkMessageContentMask
XS_unpack_UA_UadpNetworkMessageContentMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* UadpWriterGroupMessageDataType */
#ifdef UA_TYPES_UADPWRITERGROUPMESSAGEDATATYPE

static void XS_pack_UA_UadpWriterGroupMessageDataType(SV *out, UA_UadpWriterGroupMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_UadpWriterGroupMessageDataType(SV *out, UA_UadpWriterGroupMessageDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.groupVersion);
	hv_stores(hv, "UadpWriterGroupMessageDataType_groupVersion", sv);

	sv = newSV(0);
	XS_pack_UA_DataSetOrderingType(sv, in.dataSetOrdering);
	hv_stores(hv, "UadpWriterGroupMessageDataType_dataSetOrdering", sv);

	sv = newSV(0);
	XS_pack_UA_UadpNetworkMessageContentMask(sv, in.networkMessageContentMask);
	hv_stores(hv, "UadpWriterGroupMessageDataType_networkMessageContentMask", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.samplingOffset);
	hv_stores(hv, "UadpWriterGroupMessageDataType_samplingOffset", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.publishingOffsetSize);
	for (i = 0; i < in.publishingOffsetSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Double(sv, in.publishingOffset[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UadpWriterGroupMessageDataType_publishingOffset", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UadpWriterGroupMessageDataType XS_unpack_UA_UadpWriterGroupMessageDataType(SV *in)  __attribute__((unused));
static UA_UadpWriterGroupMessageDataType
XS_unpack_UA_UadpWriterGroupMessageDataType(SV *in)
{
	dTHX;
	UA_UadpWriterGroupMessageDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UadpWriterGroupMessageDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UadpWriterGroupMessageDataType_groupVersion", 0);
	if (svp != NULL)
		out.groupVersion = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "UadpWriterGroupMessageDataType_dataSetOrdering", 0);
	if (svp != NULL)
		out.dataSetOrdering = XS_unpack_UA_DataSetOrderingType(*svp);

	svp = hv_fetchs(hv, "UadpWriterGroupMessageDataType_networkMessageContentMask", 0);
	if (svp != NULL)
		out.networkMessageContentMask = XS_unpack_UA_UadpNetworkMessageContentMask(*svp);

	svp = hv_fetchs(hv, "UadpWriterGroupMessageDataType_samplingOffset", 0);
	if (svp != NULL)
		out.samplingOffset = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "UadpWriterGroupMessageDataType_publishingOffset", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UadpWriterGroupMessageDataType_publishingOffset");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.publishingOffset = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DOUBLE]);
		if (out.publishingOffset == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.publishingOffset[i] = XS_unpack_UA_Double(*svp);
			}
		}
		out.publishingOffsetSize = i;
	}

	return out;
}
#endif

/* UadpDataSetMessageContentMask */
#ifdef UA_TYPES_UADPDATASETMESSAGECONTENTMASK

static void XS_pack_UA_UadpDataSetMessageContentMask(SV *out, UA_UadpDataSetMessageContentMask in)  __attribute__((unused));
static void
XS_pack_UA_UadpDataSetMessageContentMask(SV *out, UA_UadpDataSetMessageContentMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_UadpDataSetMessageContentMask XS_unpack_UA_UadpDataSetMessageContentMask(SV *in)  __attribute__((unused));
static UA_UadpDataSetMessageContentMask
XS_unpack_UA_UadpDataSetMessageContentMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* UadpDataSetWriterMessageDataType */
#ifdef UA_TYPES_UADPDATASETWRITERMESSAGEDATATYPE

static void XS_pack_UA_UadpDataSetWriterMessageDataType(SV *out, UA_UadpDataSetWriterMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_UadpDataSetWriterMessageDataType(SV *out, UA_UadpDataSetWriterMessageDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UadpDataSetMessageContentMask(sv, in.dataSetMessageContentMask);
	hv_stores(hv, "UadpDataSetWriterMessageDataType_dataSetMessageContentMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.configuredSize);
	hv_stores(hv, "UadpDataSetWriterMessageDataType_configuredSize", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.networkMessageNumber);
	hv_stores(hv, "UadpDataSetWriterMessageDataType_networkMessageNumber", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.dataSetOffset);
	hv_stores(hv, "UadpDataSetWriterMessageDataType_dataSetOffset", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UadpDataSetWriterMessageDataType XS_unpack_UA_UadpDataSetWriterMessageDataType(SV *in)  __attribute__((unused));
static UA_UadpDataSetWriterMessageDataType
XS_unpack_UA_UadpDataSetWriterMessageDataType(SV *in)
{
	dTHX;
	UA_UadpDataSetWriterMessageDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UadpDataSetWriterMessageDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UadpDataSetWriterMessageDataType_dataSetMessageContentMask", 0);
	if (svp != NULL)
		out.dataSetMessageContentMask = XS_unpack_UA_UadpDataSetMessageContentMask(*svp);

	svp = hv_fetchs(hv, "UadpDataSetWriterMessageDataType_configuredSize", 0);
	if (svp != NULL)
		out.configuredSize = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "UadpDataSetWriterMessageDataType_networkMessageNumber", 0);
	if (svp != NULL)
		out.networkMessageNumber = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "UadpDataSetWriterMessageDataType_dataSetOffset", 0);
	if (svp != NULL)
		out.dataSetOffset = XS_unpack_UA_UInt16(*svp);

	return out;
}
#endif

/* UadpDataSetReaderMessageDataType */
#ifdef UA_TYPES_UADPDATASETREADERMESSAGEDATATYPE

static void XS_pack_UA_UadpDataSetReaderMessageDataType(SV *out, UA_UadpDataSetReaderMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_UadpDataSetReaderMessageDataType(SV *out, UA_UadpDataSetReaderMessageDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.groupVersion);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_groupVersion", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.networkMessageNumber);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_networkMessageNumber", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.dataSetOffset);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_dataSetOffset", sv);

	sv = newSV(0);
	XS_pack_UA_Guid(sv, in.dataSetClassId);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_dataSetClassId", sv);

	sv = newSV(0);
	XS_pack_UA_UadpNetworkMessageContentMask(sv, in.networkMessageContentMask);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_networkMessageContentMask", sv);

	sv = newSV(0);
	XS_pack_UA_UadpDataSetMessageContentMask(sv, in.dataSetMessageContentMask);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_dataSetMessageContentMask", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.publishingInterval);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_publishingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.receiveOffset);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_receiveOffset", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.processingOffset);
	hv_stores(hv, "UadpDataSetReaderMessageDataType_processingOffset", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UadpDataSetReaderMessageDataType XS_unpack_UA_UadpDataSetReaderMessageDataType(SV *in)  __attribute__((unused));
static UA_UadpDataSetReaderMessageDataType
XS_unpack_UA_UadpDataSetReaderMessageDataType(SV *in)
{
	dTHX;
	UA_UadpDataSetReaderMessageDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UadpDataSetReaderMessageDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_groupVersion", 0);
	if (svp != NULL)
		out.groupVersion = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_networkMessageNumber", 0);
	if (svp != NULL)
		out.networkMessageNumber = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_dataSetOffset", 0);
	if (svp != NULL)
		out.dataSetOffset = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_dataSetClassId", 0);
	if (svp != NULL)
		out.dataSetClassId = XS_unpack_UA_Guid(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_networkMessageContentMask", 0);
	if (svp != NULL)
		out.networkMessageContentMask = XS_unpack_UA_UadpNetworkMessageContentMask(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_dataSetMessageContentMask", 0);
	if (svp != NULL)
		out.dataSetMessageContentMask = XS_unpack_UA_UadpDataSetMessageContentMask(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_publishingInterval", 0);
	if (svp != NULL)
		out.publishingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_receiveOffset", 0);
	if (svp != NULL)
		out.receiveOffset = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "UadpDataSetReaderMessageDataType_processingOffset", 0);
	if (svp != NULL)
		out.processingOffset = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* JsonNetworkMessageContentMask */
#ifdef UA_TYPES_JSONNETWORKMESSAGECONTENTMASK

static void XS_pack_UA_JsonNetworkMessageContentMask(SV *out, UA_JsonNetworkMessageContentMask in)  __attribute__((unused));
static void
XS_pack_UA_JsonNetworkMessageContentMask(SV *out, UA_JsonNetworkMessageContentMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_JsonNetworkMessageContentMask XS_unpack_UA_JsonNetworkMessageContentMask(SV *in)  __attribute__((unused));
static UA_JsonNetworkMessageContentMask
XS_unpack_UA_JsonNetworkMessageContentMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* JsonWriterGroupMessageDataType */
#ifdef UA_TYPES_JSONWRITERGROUPMESSAGEDATATYPE

static void XS_pack_UA_JsonWriterGroupMessageDataType(SV *out, UA_JsonWriterGroupMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_JsonWriterGroupMessageDataType(SV *out, UA_JsonWriterGroupMessageDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_JsonNetworkMessageContentMask(sv, in.networkMessageContentMask);
	hv_stores(hv, "JsonWriterGroupMessageDataType_networkMessageContentMask", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_JsonWriterGroupMessageDataType XS_unpack_UA_JsonWriterGroupMessageDataType(SV *in)  __attribute__((unused));
static UA_JsonWriterGroupMessageDataType
XS_unpack_UA_JsonWriterGroupMessageDataType(SV *in)
{
	dTHX;
	UA_JsonWriterGroupMessageDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_JsonWriterGroupMessageDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "JsonWriterGroupMessageDataType_networkMessageContentMask", 0);
	if (svp != NULL)
		out.networkMessageContentMask = XS_unpack_UA_JsonNetworkMessageContentMask(*svp);

	return out;
}
#endif

/* JsonDataSetMessageContentMask */
#ifdef UA_TYPES_JSONDATASETMESSAGECONTENTMASK

static void XS_pack_UA_JsonDataSetMessageContentMask(SV *out, UA_JsonDataSetMessageContentMask in)  __attribute__((unused));
static void
XS_pack_UA_JsonDataSetMessageContentMask(SV *out, UA_JsonDataSetMessageContentMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_JsonDataSetMessageContentMask XS_unpack_UA_JsonDataSetMessageContentMask(SV *in)  __attribute__((unused));
static UA_JsonDataSetMessageContentMask
XS_unpack_UA_JsonDataSetMessageContentMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* JsonDataSetWriterMessageDataType */
#ifdef UA_TYPES_JSONDATASETWRITERMESSAGEDATATYPE

static void XS_pack_UA_JsonDataSetWriterMessageDataType(SV *out, UA_JsonDataSetWriterMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_JsonDataSetWriterMessageDataType(SV *out, UA_JsonDataSetWriterMessageDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_JsonDataSetMessageContentMask(sv, in.dataSetMessageContentMask);
	hv_stores(hv, "JsonDataSetWriterMessageDataType_dataSetMessageContentMask", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_JsonDataSetWriterMessageDataType XS_unpack_UA_JsonDataSetWriterMessageDataType(SV *in)  __attribute__((unused));
static UA_JsonDataSetWriterMessageDataType
XS_unpack_UA_JsonDataSetWriterMessageDataType(SV *in)
{
	dTHX;
	UA_JsonDataSetWriterMessageDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_JsonDataSetWriterMessageDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "JsonDataSetWriterMessageDataType_dataSetMessageContentMask", 0);
	if (svp != NULL)
		out.dataSetMessageContentMask = XS_unpack_UA_JsonDataSetMessageContentMask(*svp);

	return out;
}
#endif

/* JsonDataSetReaderMessageDataType */
#ifdef UA_TYPES_JSONDATASETREADERMESSAGEDATATYPE

static void XS_pack_UA_JsonDataSetReaderMessageDataType(SV *out, UA_JsonDataSetReaderMessageDataType in)  __attribute__((unused));
static void
XS_pack_UA_JsonDataSetReaderMessageDataType(SV *out, UA_JsonDataSetReaderMessageDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_JsonNetworkMessageContentMask(sv, in.networkMessageContentMask);
	hv_stores(hv, "JsonDataSetReaderMessageDataType_networkMessageContentMask", sv);

	sv = newSV(0);
	XS_pack_UA_JsonDataSetMessageContentMask(sv, in.dataSetMessageContentMask);
	hv_stores(hv, "JsonDataSetReaderMessageDataType_dataSetMessageContentMask", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_JsonDataSetReaderMessageDataType XS_unpack_UA_JsonDataSetReaderMessageDataType(SV *in)  __attribute__((unused));
static UA_JsonDataSetReaderMessageDataType
XS_unpack_UA_JsonDataSetReaderMessageDataType(SV *in)
{
	dTHX;
	UA_JsonDataSetReaderMessageDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_JsonDataSetReaderMessageDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "JsonDataSetReaderMessageDataType_networkMessageContentMask", 0);
	if (svp != NULL)
		out.networkMessageContentMask = XS_unpack_UA_JsonNetworkMessageContentMask(*svp);

	svp = hv_fetchs(hv, "JsonDataSetReaderMessageDataType_dataSetMessageContentMask", 0);
	if (svp != NULL)
		out.dataSetMessageContentMask = XS_unpack_UA_JsonDataSetMessageContentMask(*svp);

	return out;
}
#endif

/* DatagramConnectionTransportDataType */
#ifdef UA_TYPES_DATAGRAMCONNECTIONTRANSPORTDATATYPE

static void XS_pack_UA_DatagramConnectionTransportDataType(SV *out, UA_DatagramConnectionTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_DatagramConnectionTransportDataType(SV *out, UA_DatagramConnectionTransportDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.discoveryAddress);
	hv_stores(hv, "DatagramConnectionTransportDataType_discoveryAddress", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DatagramConnectionTransportDataType XS_unpack_UA_DatagramConnectionTransportDataType(SV *in)  __attribute__((unused));
static UA_DatagramConnectionTransportDataType
XS_unpack_UA_DatagramConnectionTransportDataType(SV *in)
{
	dTHX;
	UA_DatagramConnectionTransportDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DatagramConnectionTransportDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DatagramConnectionTransportDataType_discoveryAddress", 0);
	if (svp != NULL)
		out.discoveryAddress = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* DatagramWriterGroupTransportDataType */
#ifdef UA_TYPES_DATAGRAMWRITERGROUPTRANSPORTDATATYPE

static void XS_pack_UA_DatagramWriterGroupTransportDataType(SV *out, UA_DatagramWriterGroupTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_DatagramWriterGroupTransportDataType(SV *out, UA_DatagramWriterGroupTransportDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.messageRepeatCount);
	hv_stores(hv, "DatagramWriterGroupTransportDataType_messageRepeatCount", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.messageRepeatDelay);
	hv_stores(hv, "DatagramWriterGroupTransportDataType_messageRepeatDelay", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DatagramWriterGroupTransportDataType XS_unpack_UA_DatagramWriterGroupTransportDataType(SV *in)  __attribute__((unused));
static UA_DatagramWriterGroupTransportDataType
XS_unpack_UA_DatagramWriterGroupTransportDataType(SV *in)
{
	dTHX;
	UA_DatagramWriterGroupTransportDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DatagramWriterGroupTransportDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DatagramWriterGroupTransportDataType_messageRepeatCount", 0);
	if (svp != NULL)
		out.messageRepeatCount = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "DatagramWriterGroupTransportDataType_messageRepeatDelay", 0);
	if (svp != NULL)
		out.messageRepeatDelay = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* BrokerConnectionTransportDataType */
#ifdef UA_TYPES_BROKERCONNECTIONTRANSPORTDATATYPE

static void XS_pack_UA_BrokerConnectionTransportDataType(SV *out, UA_BrokerConnectionTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_BrokerConnectionTransportDataType(SV *out, UA_BrokerConnectionTransportDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.resourceUri);
	hv_stores(hv, "BrokerConnectionTransportDataType_resourceUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.authenticationProfileUri);
	hv_stores(hv, "BrokerConnectionTransportDataType_authenticationProfileUri", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrokerConnectionTransportDataType XS_unpack_UA_BrokerConnectionTransportDataType(SV *in)  __attribute__((unused));
static UA_BrokerConnectionTransportDataType
XS_unpack_UA_BrokerConnectionTransportDataType(SV *in)
{
	dTHX;
	UA_BrokerConnectionTransportDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrokerConnectionTransportDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrokerConnectionTransportDataType_resourceUri", 0);
	if (svp != NULL)
		out.resourceUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerConnectionTransportDataType_authenticationProfileUri", 0);
	if (svp != NULL)
		out.authenticationProfileUri = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* BrokerTransportQualityOfService */
#ifdef UA_TYPES_BROKERTRANSPORTQUALITYOFSERVICE

static void XS_pack_UA_BrokerTransportQualityOfService(SV *out, UA_BrokerTransportQualityOfService in)  __attribute__((unused));
static void
XS_pack_UA_BrokerTransportQualityOfService(SV *out, UA_BrokerTransportQualityOfService in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_BrokerTransportQualityOfService XS_unpack_UA_BrokerTransportQualityOfService(SV *in)  __attribute__((unused));
static UA_BrokerTransportQualityOfService
XS_unpack_UA_BrokerTransportQualityOfService(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* BrokerWriterGroupTransportDataType */
#ifdef UA_TYPES_BROKERWRITERGROUPTRANSPORTDATATYPE

static void XS_pack_UA_BrokerWriterGroupTransportDataType(SV *out, UA_BrokerWriterGroupTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_BrokerWriterGroupTransportDataType(SV *out, UA_BrokerWriterGroupTransportDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.queueName);
	hv_stores(hv, "BrokerWriterGroupTransportDataType_queueName", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.resourceUri);
	hv_stores(hv, "BrokerWriterGroupTransportDataType_resourceUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.authenticationProfileUri);
	hv_stores(hv, "BrokerWriterGroupTransportDataType_authenticationProfileUri", sv);

	sv = newSV(0);
	XS_pack_UA_BrokerTransportQualityOfService(sv, in.requestedDeliveryGuarantee);
	hv_stores(hv, "BrokerWriterGroupTransportDataType_requestedDeliveryGuarantee", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrokerWriterGroupTransportDataType XS_unpack_UA_BrokerWriterGroupTransportDataType(SV *in)  __attribute__((unused));
static UA_BrokerWriterGroupTransportDataType
XS_unpack_UA_BrokerWriterGroupTransportDataType(SV *in)
{
	dTHX;
	UA_BrokerWriterGroupTransportDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrokerWriterGroupTransportDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrokerWriterGroupTransportDataType_queueName", 0);
	if (svp != NULL)
		out.queueName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerWriterGroupTransportDataType_resourceUri", 0);
	if (svp != NULL)
		out.resourceUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerWriterGroupTransportDataType_authenticationProfileUri", 0);
	if (svp != NULL)
		out.authenticationProfileUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerWriterGroupTransportDataType_requestedDeliveryGuarantee", 0);
	if (svp != NULL)
		out.requestedDeliveryGuarantee = XS_unpack_UA_BrokerTransportQualityOfService(*svp);

	return out;
}
#endif

/* BrokerDataSetWriterTransportDataType */
#ifdef UA_TYPES_BROKERDATASETWRITERTRANSPORTDATATYPE

static void XS_pack_UA_BrokerDataSetWriterTransportDataType(SV *out, UA_BrokerDataSetWriterTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_BrokerDataSetWriterTransportDataType(SV *out, UA_BrokerDataSetWriterTransportDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.queueName);
	hv_stores(hv, "BrokerDataSetWriterTransportDataType_queueName", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.resourceUri);
	hv_stores(hv, "BrokerDataSetWriterTransportDataType_resourceUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.authenticationProfileUri);
	hv_stores(hv, "BrokerDataSetWriterTransportDataType_authenticationProfileUri", sv);

	sv = newSV(0);
	XS_pack_UA_BrokerTransportQualityOfService(sv, in.requestedDeliveryGuarantee);
	hv_stores(hv, "BrokerDataSetWriterTransportDataType_requestedDeliveryGuarantee", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.metaDataQueueName);
	hv_stores(hv, "BrokerDataSetWriterTransportDataType_metaDataQueueName", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.metaDataUpdateTime);
	hv_stores(hv, "BrokerDataSetWriterTransportDataType_metaDataUpdateTime", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrokerDataSetWriterTransportDataType XS_unpack_UA_BrokerDataSetWriterTransportDataType(SV *in)  __attribute__((unused));
static UA_BrokerDataSetWriterTransportDataType
XS_unpack_UA_BrokerDataSetWriterTransportDataType(SV *in)
{
	dTHX;
	UA_BrokerDataSetWriterTransportDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrokerDataSetWriterTransportDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrokerDataSetWriterTransportDataType_queueName", 0);
	if (svp != NULL)
		out.queueName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetWriterTransportDataType_resourceUri", 0);
	if (svp != NULL)
		out.resourceUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetWriterTransportDataType_authenticationProfileUri", 0);
	if (svp != NULL)
		out.authenticationProfileUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetWriterTransportDataType_requestedDeliveryGuarantee", 0);
	if (svp != NULL)
		out.requestedDeliveryGuarantee = XS_unpack_UA_BrokerTransportQualityOfService(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetWriterTransportDataType_metaDataQueueName", 0);
	if (svp != NULL)
		out.metaDataQueueName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetWriterTransportDataType_metaDataUpdateTime", 0);
	if (svp != NULL)
		out.metaDataUpdateTime = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* BrokerDataSetReaderTransportDataType */
#ifdef UA_TYPES_BROKERDATASETREADERTRANSPORTDATATYPE

static void XS_pack_UA_BrokerDataSetReaderTransportDataType(SV *out, UA_BrokerDataSetReaderTransportDataType in)  __attribute__((unused));
static void
XS_pack_UA_BrokerDataSetReaderTransportDataType(SV *out, UA_BrokerDataSetReaderTransportDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.queueName);
	hv_stores(hv, "BrokerDataSetReaderTransportDataType_queueName", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.resourceUri);
	hv_stores(hv, "BrokerDataSetReaderTransportDataType_resourceUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.authenticationProfileUri);
	hv_stores(hv, "BrokerDataSetReaderTransportDataType_authenticationProfileUri", sv);

	sv = newSV(0);
	XS_pack_UA_BrokerTransportQualityOfService(sv, in.requestedDeliveryGuarantee);
	hv_stores(hv, "BrokerDataSetReaderTransportDataType_requestedDeliveryGuarantee", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.metaDataQueueName);
	hv_stores(hv, "BrokerDataSetReaderTransportDataType_metaDataQueueName", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrokerDataSetReaderTransportDataType XS_unpack_UA_BrokerDataSetReaderTransportDataType(SV *in)  __attribute__((unused));
static UA_BrokerDataSetReaderTransportDataType
XS_unpack_UA_BrokerDataSetReaderTransportDataType(SV *in)
{
	dTHX;
	UA_BrokerDataSetReaderTransportDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrokerDataSetReaderTransportDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrokerDataSetReaderTransportDataType_queueName", 0);
	if (svp != NULL)
		out.queueName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetReaderTransportDataType_resourceUri", 0);
	if (svp != NULL)
		out.resourceUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetReaderTransportDataType_authenticationProfileUri", 0);
	if (svp != NULL)
		out.authenticationProfileUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetReaderTransportDataType_requestedDeliveryGuarantee", 0);
	if (svp != NULL)
		out.requestedDeliveryGuarantee = XS_unpack_UA_BrokerTransportQualityOfService(*svp);

	svp = hv_fetchs(hv, "BrokerDataSetReaderTransportDataType_metaDataQueueName", 0);
	if (svp != NULL)
		out.metaDataQueueName = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* DiagnosticsLevel */
#ifdef UA_TYPES_DIAGNOSTICSLEVEL

static void XS_pack_UA_DiagnosticsLevel(SV *out, UA_DiagnosticsLevel in)  __attribute__((unused));
static void
XS_pack_UA_DiagnosticsLevel(SV *out, UA_DiagnosticsLevel in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_DiagnosticsLevel XS_unpack_UA_DiagnosticsLevel(SV *in)  __attribute__((unused));
static UA_DiagnosticsLevel
XS_unpack_UA_DiagnosticsLevel(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* PubSubDiagnosticsCounterClassification */
#ifdef UA_TYPES_PUBSUBDIAGNOSTICSCOUNTERCLASSIFICATION

static void XS_pack_UA_PubSubDiagnosticsCounterClassification(SV *out, UA_PubSubDiagnosticsCounterClassification in)  __attribute__((unused));
static void
XS_pack_UA_PubSubDiagnosticsCounterClassification(SV *out, UA_PubSubDiagnosticsCounterClassification in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_PubSubDiagnosticsCounterClassification XS_unpack_UA_PubSubDiagnosticsCounterClassification(SV *in)  __attribute__((unused));
static UA_PubSubDiagnosticsCounterClassification
XS_unpack_UA_PubSubDiagnosticsCounterClassification(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* IdType */
#ifdef UA_TYPES_IDTYPE

static void XS_pack_UA_IdType(SV *out, UA_IdType in)  __attribute__((unused));
static void
XS_pack_UA_IdType(SV *out, UA_IdType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_IdType XS_unpack_UA_IdType(SV *in)  __attribute__((unused));
static UA_IdType
XS_unpack_UA_IdType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* NodeClass */
#ifdef UA_TYPES_NODECLASS

static void XS_pack_UA_NodeClass(SV *out, UA_NodeClass in)  __attribute__((unused));
static void
XS_pack_UA_NodeClass(SV *out, UA_NodeClass in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_NodeClass XS_unpack_UA_NodeClass(SV *in)  __attribute__((unused));
static UA_NodeClass
XS_unpack_UA_NodeClass(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* PermissionType */
#ifdef UA_TYPES_PERMISSIONTYPE

static void XS_pack_UA_PermissionType(SV *out, UA_PermissionType in)  __attribute__((unused));
static void
XS_pack_UA_PermissionType(SV *out, UA_PermissionType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_PermissionType XS_unpack_UA_PermissionType(SV *in)  __attribute__((unused));
static UA_PermissionType
XS_unpack_UA_PermissionType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* AccessLevelType */
#ifdef UA_TYPES_ACCESSLEVELTYPE

static void XS_pack_UA_AccessLevelType(SV *out, UA_AccessLevelType in)  __attribute__((unused));
static void
XS_pack_UA_AccessLevelType(SV *out, UA_AccessLevelType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_AccessLevelType XS_unpack_UA_AccessLevelType(SV *in)  __attribute__((unused));
static UA_AccessLevelType
XS_unpack_UA_AccessLevelType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* AccessLevelExType */
#ifdef UA_TYPES_ACCESSLEVELEXTYPE

static void XS_pack_UA_AccessLevelExType(SV *out, UA_AccessLevelExType in)  __attribute__((unused));
static void
XS_pack_UA_AccessLevelExType(SV *out, UA_AccessLevelExType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_AccessLevelExType XS_unpack_UA_AccessLevelExType(SV *in)  __attribute__((unused));
static UA_AccessLevelExType
XS_unpack_UA_AccessLevelExType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* EventNotifierType */
#ifdef UA_TYPES_EVENTNOTIFIERTYPE

static void XS_pack_UA_EventNotifierType(SV *out, UA_EventNotifierType in)  __attribute__((unused));
static void
XS_pack_UA_EventNotifierType(SV *out, UA_EventNotifierType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_EventNotifierType XS_unpack_UA_EventNotifierType(SV *in)  __attribute__((unused));
static UA_EventNotifierType
XS_unpack_UA_EventNotifierType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* AccessRestrictionType */
#ifdef UA_TYPES_ACCESSRESTRICTIONTYPE

static void XS_pack_UA_AccessRestrictionType(SV *out, UA_AccessRestrictionType in)  __attribute__((unused));
static void
XS_pack_UA_AccessRestrictionType(SV *out, UA_AccessRestrictionType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_AccessRestrictionType XS_unpack_UA_AccessRestrictionType(SV *in)  __attribute__((unused));
static UA_AccessRestrictionType
XS_unpack_UA_AccessRestrictionType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* RolePermissionType */
#ifdef UA_TYPES_ROLEPERMISSIONTYPE

static void XS_pack_UA_RolePermissionType(SV *out, UA_RolePermissionType in)  __attribute__((unused));
static void
XS_pack_UA_RolePermissionType(SV *out, UA_RolePermissionType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.roleId);
	hv_stores(hv, "RolePermissionType_roleId", sv);

	sv = newSV(0);
	XS_pack_UA_PermissionType(sv, in.permissions);
	hv_stores(hv, "RolePermissionType_permissions", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RolePermissionType XS_unpack_UA_RolePermissionType(SV *in)  __attribute__((unused));
static UA_RolePermissionType
XS_unpack_UA_RolePermissionType(SV *in)
{
	dTHX;
	UA_RolePermissionType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RolePermissionType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RolePermissionType_roleId", 0);
	if (svp != NULL)
		out.roleId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "RolePermissionType_permissions", 0);
	if (svp != NULL)
		out.permissions = XS_unpack_UA_PermissionType(*svp);

	return out;
}
#endif

/* StructureType */
#ifdef UA_TYPES_STRUCTURETYPE

static void XS_pack_UA_StructureType(SV *out, UA_StructureType in)  __attribute__((unused));
static void
XS_pack_UA_StructureType(SV *out, UA_StructureType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_StructureType XS_unpack_UA_StructureType(SV *in)  __attribute__((unused));
static UA_StructureType
XS_unpack_UA_StructureType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* StructureField */
#ifdef UA_TYPES_STRUCTUREFIELD

static void XS_pack_UA_StructureField(SV *out, UA_StructureField in)  __attribute__((unused));
static void
XS_pack_UA_StructureField(SV *out, UA_StructureField in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "StructureField_name", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "StructureField_description", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataType);
	hv_stores(hv, "StructureField_dataType", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.valueRank);
	hv_stores(hv, "StructureField_valueRank", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.arrayDimensionsSize);
	for (i = 0; i < in.arrayDimensionsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.arrayDimensions[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "StructureField_arrayDimensions", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxStringLength);
	hv_stores(hv, "StructureField_maxStringLength", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isOptional);
	hv_stores(hv, "StructureField_isOptional", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_StructureField XS_unpack_UA_StructureField(SV *in)  __attribute__((unused));
static UA_StructureField
XS_unpack_UA_StructureField(SV *in)
{
	dTHX;
	UA_StructureField out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_StructureField_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "StructureField_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "StructureField_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "StructureField_dataType", 0);
	if (svp != NULL)
		out.dataType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "StructureField_valueRank", 0);
	if (svp != NULL)
		out.valueRank = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "StructureField_arrayDimensions", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for StructureField_arrayDimensions");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.arrayDimensions = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.arrayDimensions == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.arrayDimensions[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.arrayDimensionsSize = i;
	}

	svp = hv_fetchs(hv, "StructureField_maxStringLength", 0);
	if (svp != NULL)
		out.maxStringLength = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "StructureField_isOptional", 0);
	if (svp != NULL)
		out.isOptional = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* StructureDefinition */
#ifdef UA_TYPES_STRUCTUREDEFINITION

static void XS_pack_UA_StructureDefinition(SV *out, UA_StructureDefinition in)  __attribute__((unused));
static void
XS_pack_UA_StructureDefinition(SV *out, UA_StructureDefinition in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.defaultEncodingId);
	hv_stores(hv, "StructureDefinition_defaultEncodingId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.baseDataType);
	hv_stores(hv, "StructureDefinition_baseDataType", sv);

	sv = newSV(0);
	XS_pack_UA_StructureType(sv, in.structureType);
	hv_stores(hv, "StructureDefinition_structureType", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.fieldsSize);
	for (i = 0; i < in.fieldsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StructureField(sv, in.fields[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "StructureDefinition_fields", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_StructureDefinition XS_unpack_UA_StructureDefinition(SV *in)  __attribute__((unused));
static UA_StructureDefinition
XS_unpack_UA_StructureDefinition(SV *in)
{
	dTHX;
	UA_StructureDefinition out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_StructureDefinition_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "StructureDefinition_defaultEncodingId", 0);
	if (svp != NULL)
		out.defaultEncodingId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "StructureDefinition_baseDataType", 0);
	if (svp != NULL)
		out.baseDataType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "StructureDefinition_structureType", 0);
	if (svp != NULL)
		out.structureType = XS_unpack_UA_StructureType(*svp);

	svp = hv_fetchs(hv, "StructureDefinition_fields", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for StructureDefinition_fields");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.fields = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRUCTUREFIELD]);
		if (out.fields == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.fields[i] = XS_unpack_UA_StructureField(*svp);
			}
		}
		out.fieldsSize = i;
	}

	return out;
}
#endif

/* ReferenceNode */
#ifdef UA_TYPES_REFERENCENODE

static void XS_pack_UA_ReferenceNode(SV *out, UA_ReferenceNode in)  __attribute__((unused));
static void
XS_pack_UA_ReferenceNode(SV *out, UA_ReferenceNode in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "ReferenceNode_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isInverse);
	hv_stores(hv, "ReferenceNode_isInverse", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.targetId);
	hv_stores(hv, "ReferenceNode_targetId", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReferenceNode XS_unpack_UA_ReferenceNode(SV *in)  __attribute__((unused));
static UA_ReferenceNode
XS_unpack_UA_ReferenceNode(SV *in)
{
	dTHX;
	UA_ReferenceNode out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReferenceNode_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReferenceNode_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ReferenceNode_isInverse", 0);
	if (svp != NULL)
		out.isInverse = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "ReferenceNode_targetId", 0);
	if (svp != NULL)
		out.targetId = XS_unpack_UA_ExpandedNodeId(*svp);

	return out;
}
#endif

/* Argument */
#ifdef UA_TYPES_ARGUMENT

static void XS_pack_UA_Argument(SV *out, UA_Argument in)  __attribute__((unused));
static void
XS_pack_UA_Argument(SV *out, UA_Argument in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "Argument_name", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataType);
	hv_stores(hv, "Argument_dataType", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.valueRank);
	hv_stores(hv, "Argument_valueRank", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.arrayDimensionsSize);
	for (i = 0; i < in.arrayDimensionsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.arrayDimensions[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "Argument_arrayDimensions", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "Argument_description", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_Argument XS_unpack_UA_Argument(SV *in)  __attribute__((unused));
static UA_Argument
XS_unpack_UA_Argument(SV *in)
{
	dTHX;
	UA_Argument out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_Argument_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "Argument_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "Argument_dataType", 0);
	if (svp != NULL)
		out.dataType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "Argument_valueRank", 0);
	if (svp != NULL)
		out.valueRank = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "Argument_arrayDimensions", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for Argument_arrayDimensions");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.arrayDimensions = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.arrayDimensions == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.arrayDimensions[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.arrayDimensionsSize = i;
	}

	svp = hv_fetchs(hv, "Argument_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	return out;
}
#endif

/* EnumValueType */
#ifdef UA_TYPES_ENUMVALUETYPE

static void XS_pack_UA_EnumValueType(SV *out, UA_EnumValueType in)  __attribute__((unused));
static void
XS_pack_UA_EnumValueType(SV *out, UA_EnumValueType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Int64(sv, in.value);
	hv_stores(hv, "EnumValueType_value", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "EnumValueType_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "EnumValueType_description", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EnumValueType XS_unpack_UA_EnumValueType(SV *in)  __attribute__((unused));
static UA_EnumValueType
XS_unpack_UA_EnumValueType(SV *in)
{
	dTHX;
	UA_EnumValueType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EnumValueType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EnumValueType_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Int64(*svp);

	svp = hv_fetchs(hv, "EnumValueType_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "EnumValueType_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	return out;
}
#endif

/* EnumField */
#ifdef UA_TYPES_ENUMFIELD

static void XS_pack_UA_EnumField(SV *out, UA_EnumField in)  __attribute__((unused));
static void
XS_pack_UA_EnumField(SV *out, UA_EnumField in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Int64(sv, in.value);
	hv_stores(hv, "EnumField_value", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "EnumField_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "EnumField_description", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "EnumField_name", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EnumField XS_unpack_UA_EnumField(SV *in)  __attribute__((unused));
static UA_EnumField
XS_unpack_UA_EnumField(SV *in)
{
	dTHX;
	UA_EnumField out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EnumField_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EnumField_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Int64(*svp);

	svp = hv_fetchs(hv, "EnumField_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "EnumField_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "EnumField_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* OptionSet */
#ifdef UA_TYPES_OPTIONSET

static void XS_pack_UA_OptionSet(SV *out, UA_OptionSet in)  __attribute__((unused));
static void
XS_pack_UA_OptionSet(SV *out, UA_OptionSet in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.value);
	hv_stores(hv, "OptionSet_value", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.validBits);
	hv_stores(hv, "OptionSet_validBits", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_OptionSet XS_unpack_UA_OptionSet(SV *in)  __attribute__((unused));
static UA_OptionSet
XS_unpack_UA_OptionSet(SV *in)
{
	dTHX;
	UA_OptionSet out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_OptionSet_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "OptionSet_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "OptionSet_validBits", 0);
	if (svp != NULL)
		out.validBits = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* Union */
#ifdef UA_TYPES_UNION

static void XS_pack_UA_Union(SV *out, UA_Union in)  __attribute__((unused));
static void
XS_pack_UA_Union(SV *out, UA_Union in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_Union XS_unpack_UA_Union(SV *in)  __attribute__((unused));
static UA_Union
XS_unpack_UA_Union(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* NormalizedString */
#ifdef UA_TYPES_NORMALIZEDSTRING

static void XS_pack_UA_NormalizedString(SV *out, UA_NormalizedString in)  __attribute__((unused));
static void
XS_pack_UA_NormalizedString(SV *out, UA_NormalizedString in)
{
	dTHX;
	XS_pack_UA_String(out, in);
}

static UA_NormalizedString XS_unpack_UA_NormalizedString(SV *in)  __attribute__((unused));
static UA_NormalizedString
XS_unpack_UA_NormalizedString(SV *in)
{
	dTHX;
	return XS_unpack_UA_String(in);
}
#endif

/* DecimalString */
#ifdef UA_TYPES_DECIMALSTRING

static void XS_pack_UA_DecimalString(SV *out, UA_DecimalString in)  __attribute__((unused));
static void
XS_pack_UA_DecimalString(SV *out, UA_DecimalString in)
{
	dTHX;
	XS_pack_UA_String(out, in);
}

static UA_DecimalString XS_unpack_UA_DecimalString(SV *in)  __attribute__((unused));
static UA_DecimalString
XS_unpack_UA_DecimalString(SV *in)
{
	dTHX;
	return XS_unpack_UA_String(in);
}
#endif

/* DurationString */
#ifdef UA_TYPES_DURATIONSTRING

static void XS_pack_UA_DurationString(SV *out, UA_DurationString in)  __attribute__((unused));
static void
XS_pack_UA_DurationString(SV *out, UA_DurationString in)
{
	dTHX;
	XS_pack_UA_String(out, in);
}

static UA_DurationString XS_unpack_UA_DurationString(SV *in)  __attribute__((unused));
static UA_DurationString
XS_unpack_UA_DurationString(SV *in)
{
	dTHX;
	return XS_unpack_UA_String(in);
}
#endif

/* TimeString */
#ifdef UA_TYPES_TIMESTRING

static void XS_pack_UA_TimeString(SV *out, UA_TimeString in)  __attribute__((unused));
static void
XS_pack_UA_TimeString(SV *out, UA_TimeString in)
{
	dTHX;
	XS_pack_UA_String(out, in);
}

static UA_TimeString XS_unpack_UA_TimeString(SV *in)  __attribute__((unused));
static UA_TimeString
XS_unpack_UA_TimeString(SV *in)
{
	dTHX;
	return XS_unpack_UA_String(in);
}
#endif

/* DateString */
#ifdef UA_TYPES_DATESTRING

static void XS_pack_UA_DateString(SV *out, UA_DateString in)  __attribute__((unused));
static void
XS_pack_UA_DateString(SV *out, UA_DateString in)
{
	dTHX;
	XS_pack_UA_String(out, in);
}

static UA_DateString XS_unpack_UA_DateString(SV *in)  __attribute__((unused));
static UA_DateString
XS_unpack_UA_DateString(SV *in)
{
	dTHX;
	return XS_unpack_UA_String(in);
}
#endif

/* Duration */
#ifdef UA_TYPES_DURATION

static void XS_pack_UA_Duration(SV *out, UA_Duration in)  __attribute__((unused));
static void
XS_pack_UA_Duration(SV *out, UA_Duration in)
{
	dTHX;
	XS_pack_UA_Double(out, in);
}

static UA_Duration XS_unpack_UA_Duration(SV *in)  __attribute__((unused));
static UA_Duration
XS_unpack_UA_Duration(SV *in)
{
	dTHX;
	return XS_unpack_UA_Double(in);
}
#endif

/* UtcTime */
#ifdef UA_TYPES_UTCTIME

static void XS_pack_UA_UtcTime(SV *out, UA_UtcTime in)  __attribute__((unused));
static void
XS_pack_UA_UtcTime(SV *out, UA_UtcTime in)
{
	dTHX;
	XS_pack_UA_DateTime(out, in);
}

static UA_UtcTime XS_unpack_UA_UtcTime(SV *in)  __attribute__((unused));
static UA_UtcTime
XS_unpack_UA_UtcTime(SV *in)
{
	dTHX;
	return XS_unpack_UA_DateTime(in);
}
#endif

/* LocaleId */
#ifdef UA_TYPES_LOCALEID

static void XS_pack_UA_LocaleId(SV *out, UA_LocaleId in)  __attribute__((unused));
static void
XS_pack_UA_LocaleId(SV *out, UA_LocaleId in)
{
	dTHX;
	XS_pack_UA_String(out, in);
}

static UA_LocaleId XS_unpack_UA_LocaleId(SV *in)  __attribute__((unused));
static UA_LocaleId
XS_unpack_UA_LocaleId(SV *in)
{
	dTHX;
	return XS_unpack_UA_String(in);
}
#endif

/* TimeZoneDataType */
#ifdef UA_TYPES_TIMEZONEDATATYPE

static void XS_pack_UA_TimeZoneDataType(SV *out, UA_TimeZoneDataType in)  __attribute__((unused));
static void
XS_pack_UA_TimeZoneDataType(SV *out, UA_TimeZoneDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Int16(sv, in.offset);
	hv_stores(hv, "TimeZoneDataType_offset", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.daylightSavingInOffset);
	hv_stores(hv, "TimeZoneDataType_daylightSavingInOffset", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TimeZoneDataType XS_unpack_UA_TimeZoneDataType(SV *in)  __attribute__((unused));
static UA_TimeZoneDataType
XS_unpack_UA_TimeZoneDataType(SV *in)
{
	dTHX;
	UA_TimeZoneDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TimeZoneDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TimeZoneDataType_offset", 0);
	if (svp != NULL)
		out.offset = XS_unpack_UA_Int16(*svp);

	svp = hv_fetchs(hv, "TimeZoneDataType_daylightSavingInOffset", 0);
	if (svp != NULL)
		out.daylightSavingInOffset = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* Index */
#ifdef UA_TYPES_INDEX

static void XS_pack_UA_Index(SV *out, UA_Index in)  __attribute__((unused));
static void
XS_pack_UA_Index(SV *out, UA_Index in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_Index XS_unpack_UA_Index(SV *in)  __attribute__((unused));
static UA_Index
XS_unpack_UA_Index(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* IntegerId */
#ifdef UA_TYPES_INTEGERID

static void XS_pack_UA_IntegerId(SV *out, UA_IntegerId in)  __attribute__((unused));
static void
XS_pack_UA_IntegerId(SV *out, UA_IntegerId in)
{
	dTHX;
	XS_pack_UA_UInt32(out, in);
}

static UA_IntegerId XS_unpack_UA_IntegerId(SV *in)  __attribute__((unused));
static UA_IntegerId
XS_unpack_UA_IntegerId(SV *in)
{
	dTHX;
	return XS_unpack_UA_UInt32(in);
}
#endif

/* ApplicationType */
#ifdef UA_TYPES_APPLICATIONTYPE

static void XS_pack_UA_ApplicationType(SV *out, UA_ApplicationType in)  __attribute__((unused));
static void
XS_pack_UA_ApplicationType(SV *out, UA_ApplicationType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_ApplicationType XS_unpack_UA_ApplicationType(SV *in)  __attribute__((unused));
static UA_ApplicationType
XS_unpack_UA_ApplicationType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ApplicationDescription */
#ifdef UA_TYPES_APPLICATIONDESCRIPTION

static void XS_pack_UA_ApplicationDescription(SV *out, UA_ApplicationDescription in)  __attribute__((unused));
static void
XS_pack_UA_ApplicationDescription(SV *out, UA_ApplicationDescription in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.applicationUri);
	hv_stores(hv, "ApplicationDescription_applicationUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.productUri);
	hv_stores(hv, "ApplicationDescription_productUri", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.applicationName);
	hv_stores(hv, "ApplicationDescription_applicationName", sv);

	sv = newSV(0);
	XS_pack_UA_ApplicationType(sv, in.applicationType);
	hv_stores(hv, "ApplicationDescription_applicationType", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.gatewayServerUri);
	hv_stores(hv, "ApplicationDescription_gatewayServerUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.discoveryProfileUri);
	hv_stores(hv, "ApplicationDescription_discoveryProfileUri", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.discoveryUrlsSize);
	for (i = 0; i < in.discoveryUrlsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.discoveryUrls[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ApplicationDescription_discoveryUrls", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ApplicationDescription XS_unpack_UA_ApplicationDescription(SV *in)  __attribute__((unused));
static UA_ApplicationDescription
XS_unpack_UA_ApplicationDescription(SV *in)
{
	dTHX;
	UA_ApplicationDescription out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ApplicationDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ApplicationDescription_applicationUri", 0);
	if (svp != NULL)
		out.applicationUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ApplicationDescription_productUri", 0);
	if (svp != NULL)
		out.productUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ApplicationDescription_applicationName", 0);
	if (svp != NULL)
		out.applicationName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ApplicationDescription_applicationType", 0);
	if (svp != NULL)
		out.applicationType = XS_unpack_UA_ApplicationType(*svp);

	svp = hv_fetchs(hv, "ApplicationDescription_gatewayServerUri", 0);
	if (svp != NULL)
		out.gatewayServerUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ApplicationDescription_discoveryProfileUri", 0);
	if (svp != NULL)
		out.discoveryProfileUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ApplicationDescription_discoveryUrls", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ApplicationDescription_discoveryUrls");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.discoveryUrls = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.discoveryUrls == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.discoveryUrls[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.discoveryUrlsSize = i;
	}

	return out;
}
#endif

/* RequestHeader */
#ifdef UA_TYPES_REQUESTHEADER

static void XS_pack_UA_RequestHeader(SV *out, UA_RequestHeader in)  __attribute__((unused));
static void
XS_pack_UA_RequestHeader(SV *out, UA_RequestHeader in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.authenticationToken);
	hv_stores(hv, "RequestHeader_authenticationToken", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.timestamp);
	hv_stores(hv, "RequestHeader_timestamp", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestHandle);
	hv_stores(hv, "RequestHeader_requestHandle", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.returnDiagnostics);
	hv_stores(hv, "RequestHeader_returnDiagnostics", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.auditEntryId);
	hv_stores(hv, "RequestHeader_auditEntryId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.timeoutHint);
	hv_stores(hv, "RequestHeader_timeoutHint", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.additionalHeader);
	hv_stores(hv, "RequestHeader_additionalHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RequestHeader XS_unpack_UA_RequestHeader(SV *in)  __attribute__((unused));
static UA_RequestHeader
XS_unpack_UA_RequestHeader(SV *in)
{
	dTHX;
	UA_RequestHeader out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RequestHeader_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RequestHeader_authenticationToken", 0);
	if (svp != NULL)
		out.authenticationToken = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "RequestHeader_timestamp", 0);
	if (svp != NULL)
		out.timestamp = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "RequestHeader_requestHandle", 0);
	if (svp != NULL)
		out.requestHandle = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "RequestHeader_returnDiagnostics", 0);
	if (svp != NULL)
		out.returnDiagnostics = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "RequestHeader_auditEntryId", 0);
	if (svp != NULL)
		out.auditEntryId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "RequestHeader_timeoutHint", 0);
	if (svp != NULL)
		out.timeoutHint = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "RequestHeader_additionalHeader", 0);
	if (svp != NULL)
		out.additionalHeader = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* ResponseHeader */
#ifdef UA_TYPES_RESPONSEHEADER

static void XS_pack_UA_ResponseHeader(SV *out, UA_ResponseHeader in)  __attribute__((unused));
static void
XS_pack_UA_ResponseHeader(SV *out, UA_ResponseHeader in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.timestamp);
	hv_stores(hv, "ResponseHeader_timestamp", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestHandle);
	hv_stores(hv, "ResponseHeader_requestHandle", sv);

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.serviceResult);
	hv_stores(hv, "ResponseHeader_serviceResult", sv);

	sv = newSV(0);
	XS_pack_UA_DiagnosticInfo(sv, in.serviceDiagnostics);
	hv_stores(hv, "ResponseHeader_serviceDiagnostics", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.stringTableSize);
	for (i = 0; i < in.stringTableSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.stringTable[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ResponseHeader_stringTable", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.additionalHeader);
	hv_stores(hv, "ResponseHeader_additionalHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ResponseHeader XS_unpack_UA_ResponseHeader(SV *in)  __attribute__((unused));
static UA_ResponseHeader
XS_unpack_UA_ResponseHeader(SV *in)
{
	dTHX;
	UA_ResponseHeader out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ResponseHeader_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ResponseHeader_timestamp", 0);
	if (svp != NULL)
		out.timestamp = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ResponseHeader_requestHandle", 0);
	if (svp != NULL)
		out.requestHandle = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ResponseHeader_serviceResult", 0);
	if (svp != NULL)
		out.serviceResult = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "ResponseHeader_serviceDiagnostics", 0);
	if (svp != NULL)
		out.serviceDiagnostics = XS_unpack_UA_DiagnosticInfo(*svp);

	svp = hv_fetchs(hv, "ResponseHeader_stringTable", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ResponseHeader_stringTable");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.stringTable = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.stringTable == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.stringTable[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.stringTableSize = i;
	}

	svp = hv_fetchs(hv, "ResponseHeader_additionalHeader", 0);
	if (svp != NULL)
		out.additionalHeader = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* VersionTime */
#ifdef UA_TYPES_VERSIONTIME

static void XS_pack_UA_VersionTime(SV *out, UA_VersionTime in)  __attribute__((unused));
static void
XS_pack_UA_VersionTime(SV *out, UA_VersionTime in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_VersionTime XS_unpack_UA_VersionTime(SV *in)  __attribute__((unused));
static UA_VersionTime
XS_unpack_UA_VersionTime(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* ServiceFault */
#ifdef UA_TYPES_SERVICEFAULT

static void XS_pack_UA_ServiceFault(SV *out, UA_ServiceFault in)  __attribute__((unused));
static void
XS_pack_UA_ServiceFault(SV *out, UA_ServiceFault in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "ServiceFault_responseHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ServiceFault XS_unpack_UA_ServiceFault(SV *in)  __attribute__((unused));
static UA_ServiceFault
XS_unpack_UA_ServiceFault(SV *in)
{
	dTHX;
	UA_ServiceFault out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ServiceFault_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ServiceFault_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	return out;
}
#endif

/* SessionlessInvokeRequestType */
#ifdef UA_TYPES_SESSIONLESSINVOKEREQUESTTYPE

static void XS_pack_UA_SessionlessInvokeRequestType(SV *out, UA_SessionlessInvokeRequestType in)  __attribute__((unused));
static void
XS_pack_UA_SessionlessInvokeRequestType(SV *out, UA_SessionlessInvokeRequestType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.urisVersionSize);
	for (i = 0; i < in.urisVersionSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.urisVersion[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionlessInvokeRequestType_urisVersion", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.namespaceUrisSize);
	for (i = 0; i < in.namespaceUrisSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.namespaceUris[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionlessInvokeRequestType_namespaceUris", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverUrisSize);
	for (i = 0; i < in.serverUrisSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.serverUris[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionlessInvokeRequestType_serverUris", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.localeIdsSize);
	for (i = 0; i < in.localeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.localeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionlessInvokeRequestType_localeIds", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.serviceId);
	hv_stores(hv, "SessionlessInvokeRequestType_serviceId", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SessionlessInvokeRequestType XS_unpack_UA_SessionlessInvokeRequestType(SV *in)  __attribute__((unused));
static UA_SessionlessInvokeRequestType
XS_unpack_UA_SessionlessInvokeRequestType(SV *in)
{
	dTHX;
	UA_SessionlessInvokeRequestType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SessionlessInvokeRequestType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SessionlessInvokeRequestType_urisVersion", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionlessInvokeRequestType_urisVersion");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.urisVersion = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.urisVersion == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.urisVersion[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.urisVersionSize = i;
	}

	svp = hv_fetchs(hv, "SessionlessInvokeRequestType_namespaceUris", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionlessInvokeRequestType_namespaceUris");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.namespaceUris = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.namespaceUris == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.namespaceUris[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.namespaceUrisSize = i;
	}

	svp = hv_fetchs(hv, "SessionlessInvokeRequestType_serverUris", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionlessInvokeRequestType_serverUris");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverUris = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.serverUris == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverUris[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.serverUrisSize = i;
	}

	svp = hv_fetchs(hv, "SessionlessInvokeRequestType_localeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionlessInvokeRequestType_localeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.localeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.localeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.localeIds[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.localeIdsSize = i;
	}

	svp = hv_fetchs(hv, "SessionlessInvokeRequestType_serviceId", 0);
	if (svp != NULL)
		out.serviceId = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* SessionlessInvokeResponseType */
#ifdef UA_TYPES_SESSIONLESSINVOKERESPONSETYPE

static void XS_pack_UA_SessionlessInvokeResponseType(SV *out, UA_SessionlessInvokeResponseType in)  __attribute__((unused));
static void
XS_pack_UA_SessionlessInvokeResponseType(SV *out, UA_SessionlessInvokeResponseType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.namespaceUrisSize);
	for (i = 0; i < in.namespaceUrisSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.namespaceUris[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionlessInvokeResponseType_namespaceUris", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverUrisSize);
	for (i = 0; i < in.serverUrisSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.serverUris[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionlessInvokeResponseType_serverUris", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.serviceId);
	hv_stores(hv, "SessionlessInvokeResponseType_serviceId", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SessionlessInvokeResponseType XS_unpack_UA_SessionlessInvokeResponseType(SV *in)  __attribute__((unused));
static UA_SessionlessInvokeResponseType
XS_unpack_UA_SessionlessInvokeResponseType(SV *in)
{
	dTHX;
	UA_SessionlessInvokeResponseType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SessionlessInvokeResponseType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SessionlessInvokeResponseType_namespaceUris", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionlessInvokeResponseType_namespaceUris");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.namespaceUris = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.namespaceUris == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.namespaceUris[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.namespaceUrisSize = i;
	}

	svp = hv_fetchs(hv, "SessionlessInvokeResponseType_serverUris", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionlessInvokeResponseType_serverUris");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverUris = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.serverUris == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverUris[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.serverUrisSize = i;
	}

	svp = hv_fetchs(hv, "SessionlessInvokeResponseType_serviceId", 0);
	if (svp != NULL)
		out.serviceId = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* FindServersRequest */
#ifdef UA_TYPES_FINDSERVERSREQUEST

static void XS_pack_UA_FindServersRequest(SV *out, UA_FindServersRequest in)  __attribute__((unused));
static void
XS_pack_UA_FindServersRequest(SV *out, UA_FindServersRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "FindServersRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.endpointUrl);
	hv_stores(hv, "FindServersRequest_endpointUrl", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.localeIdsSize);
	for (i = 0; i < in.localeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.localeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "FindServersRequest_localeIds", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverUrisSize);
	for (i = 0; i < in.serverUrisSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.serverUris[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "FindServersRequest_serverUris", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_FindServersRequest XS_unpack_UA_FindServersRequest(SV *in)  __attribute__((unused));
static UA_FindServersRequest
XS_unpack_UA_FindServersRequest(SV *in)
{
	dTHX;
	UA_FindServersRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_FindServersRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "FindServersRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "FindServersRequest_endpointUrl", 0);
	if (svp != NULL)
		out.endpointUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "FindServersRequest_localeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for FindServersRequest_localeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.localeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.localeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.localeIds[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.localeIdsSize = i;
	}

	svp = hv_fetchs(hv, "FindServersRequest_serverUris", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for FindServersRequest_serverUris");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverUris = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.serverUris == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverUris[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.serverUrisSize = i;
	}

	return out;
}
#endif

/* FindServersResponse */
#ifdef UA_TYPES_FINDSERVERSRESPONSE

static void XS_pack_UA_FindServersResponse(SV *out, UA_FindServersResponse in)  __attribute__((unused));
static void
XS_pack_UA_FindServersResponse(SV *out, UA_FindServersResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "FindServersResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serversSize);
	for (i = 0; i < in.serversSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ApplicationDescription(sv, in.servers[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "FindServersResponse_servers", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_FindServersResponse XS_unpack_UA_FindServersResponse(SV *in)  __attribute__((unused));
static UA_FindServersResponse
XS_unpack_UA_FindServersResponse(SV *in)
{
	dTHX;
	UA_FindServersResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_FindServersResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "FindServersResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "FindServersResponse_servers", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for FindServersResponse_servers");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.servers = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_APPLICATIONDESCRIPTION]);
		if (out.servers == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.servers[i] = XS_unpack_UA_ApplicationDescription(*svp);
			}
		}
		out.serversSize = i;
	}

	return out;
}
#endif

/* ServerOnNetwork */
#ifdef UA_TYPES_SERVERONNETWORK

static void XS_pack_UA_ServerOnNetwork(SV *out, UA_ServerOnNetwork in)  __attribute__((unused));
static void
XS_pack_UA_ServerOnNetwork(SV *out, UA_ServerOnNetwork in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.recordId);
	hv_stores(hv, "ServerOnNetwork_recordId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.serverName);
	hv_stores(hv, "ServerOnNetwork_serverName", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.discoveryUrl);
	hv_stores(hv, "ServerOnNetwork_discoveryUrl", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverCapabilitiesSize);
	for (i = 0; i < in.serverCapabilitiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.serverCapabilities[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ServerOnNetwork_serverCapabilities", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ServerOnNetwork XS_unpack_UA_ServerOnNetwork(SV *in)  __attribute__((unused));
static UA_ServerOnNetwork
XS_unpack_UA_ServerOnNetwork(SV *in)
{
	dTHX;
	UA_ServerOnNetwork out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ServerOnNetwork_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ServerOnNetwork_recordId", 0);
	if (svp != NULL)
		out.recordId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerOnNetwork_serverName", 0);
	if (svp != NULL)
		out.serverName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ServerOnNetwork_discoveryUrl", 0);
	if (svp != NULL)
		out.discoveryUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ServerOnNetwork_serverCapabilities", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ServerOnNetwork_serverCapabilities");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverCapabilities = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.serverCapabilities == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverCapabilities[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.serverCapabilitiesSize = i;
	}

	return out;
}
#endif

/* FindServersOnNetworkRequest */
#ifdef UA_TYPES_FINDSERVERSONNETWORKREQUEST

static void XS_pack_UA_FindServersOnNetworkRequest(SV *out, UA_FindServersOnNetworkRequest in)  __attribute__((unused));
static void
XS_pack_UA_FindServersOnNetworkRequest(SV *out, UA_FindServersOnNetworkRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "FindServersOnNetworkRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.startingRecordId);
	hv_stores(hv, "FindServersOnNetworkRequest_startingRecordId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxRecordsToReturn);
	hv_stores(hv, "FindServersOnNetworkRequest_maxRecordsToReturn", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverCapabilityFilterSize);
	for (i = 0; i < in.serverCapabilityFilterSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.serverCapabilityFilter[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "FindServersOnNetworkRequest_serverCapabilityFilter", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_FindServersOnNetworkRequest XS_unpack_UA_FindServersOnNetworkRequest(SV *in)  __attribute__((unused));
static UA_FindServersOnNetworkRequest
XS_unpack_UA_FindServersOnNetworkRequest(SV *in)
{
	dTHX;
	UA_FindServersOnNetworkRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_FindServersOnNetworkRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "FindServersOnNetworkRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "FindServersOnNetworkRequest_startingRecordId", 0);
	if (svp != NULL)
		out.startingRecordId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "FindServersOnNetworkRequest_maxRecordsToReturn", 0);
	if (svp != NULL)
		out.maxRecordsToReturn = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "FindServersOnNetworkRequest_serverCapabilityFilter", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for FindServersOnNetworkRequest_serverCapabilityFilter");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverCapabilityFilter = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.serverCapabilityFilter == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverCapabilityFilter[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.serverCapabilityFilterSize = i;
	}

	return out;
}
#endif

/* FindServersOnNetworkResponse */
#ifdef UA_TYPES_FINDSERVERSONNETWORKRESPONSE

static void XS_pack_UA_FindServersOnNetworkResponse(SV *out, UA_FindServersOnNetworkResponse in)  __attribute__((unused));
static void
XS_pack_UA_FindServersOnNetworkResponse(SV *out, UA_FindServersOnNetworkResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "FindServersOnNetworkResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.lastCounterResetTime);
	hv_stores(hv, "FindServersOnNetworkResponse_lastCounterResetTime", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serversSize);
	for (i = 0; i < in.serversSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ServerOnNetwork(sv, in.servers[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "FindServersOnNetworkResponse_servers", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_FindServersOnNetworkResponse XS_unpack_UA_FindServersOnNetworkResponse(SV *in)  __attribute__((unused));
static UA_FindServersOnNetworkResponse
XS_unpack_UA_FindServersOnNetworkResponse(SV *in)
{
	dTHX;
	UA_FindServersOnNetworkResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_FindServersOnNetworkResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "FindServersOnNetworkResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "FindServersOnNetworkResponse_lastCounterResetTime", 0);
	if (svp != NULL)
		out.lastCounterResetTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "FindServersOnNetworkResponse_servers", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for FindServersOnNetworkResponse_servers");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.servers = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SERVERONNETWORK]);
		if (out.servers == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.servers[i] = XS_unpack_UA_ServerOnNetwork(*svp);
			}
		}
		out.serversSize = i;
	}

	return out;
}
#endif

/* ApplicationInstanceCertificate */
#ifdef UA_TYPES_APPLICATIONINSTANCECERTIFICATE

static void XS_pack_UA_ApplicationInstanceCertificate(SV *out, UA_ApplicationInstanceCertificate in)  __attribute__((unused));
static void
XS_pack_UA_ApplicationInstanceCertificate(SV *out, UA_ApplicationInstanceCertificate in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_ApplicationInstanceCertificate XS_unpack_UA_ApplicationInstanceCertificate(SV *in)  __attribute__((unused));
static UA_ApplicationInstanceCertificate
XS_unpack_UA_ApplicationInstanceCertificate(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* MessageSecurityMode */
#ifdef UA_TYPES_MESSAGESECURITYMODE

static void XS_pack_UA_MessageSecurityMode(SV *out, UA_MessageSecurityMode in)  __attribute__((unused));
static void
XS_pack_UA_MessageSecurityMode(SV *out, UA_MessageSecurityMode in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_MessageSecurityMode XS_unpack_UA_MessageSecurityMode(SV *in)  __attribute__((unused));
static UA_MessageSecurityMode
XS_unpack_UA_MessageSecurityMode(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* UserTokenType */
#ifdef UA_TYPES_USERTOKENTYPE

static void XS_pack_UA_UserTokenType(SV *out, UA_UserTokenType in)  __attribute__((unused));
static void
XS_pack_UA_UserTokenType(SV *out, UA_UserTokenType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_UserTokenType XS_unpack_UA_UserTokenType(SV *in)  __attribute__((unused));
static UA_UserTokenType
XS_unpack_UA_UserTokenType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* UserTokenPolicy */
#ifdef UA_TYPES_USERTOKENPOLICY

static void XS_pack_UA_UserTokenPolicy(SV *out, UA_UserTokenPolicy in)  __attribute__((unused));
static void
XS_pack_UA_UserTokenPolicy(SV *out, UA_UserTokenPolicy in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.policyId);
	hv_stores(hv, "UserTokenPolicy_policyId", sv);

	sv = newSV(0);
	XS_pack_UA_UserTokenType(sv, in.tokenType);
	hv_stores(hv, "UserTokenPolicy_tokenType", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.issuedTokenType);
	hv_stores(hv, "UserTokenPolicy_issuedTokenType", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.issuerEndpointUrl);
	hv_stores(hv, "UserTokenPolicy_issuerEndpointUrl", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityPolicyUri);
	hv_stores(hv, "UserTokenPolicy_securityPolicyUri", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UserTokenPolicy XS_unpack_UA_UserTokenPolicy(SV *in)  __attribute__((unused));
static UA_UserTokenPolicy
XS_unpack_UA_UserTokenPolicy(SV *in)
{
	dTHX;
	UA_UserTokenPolicy out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UserTokenPolicy_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UserTokenPolicy_policyId", 0);
	if (svp != NULL)
		out.policyId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "UserTokenPolicy_tokenType", 0);
	if (svp != NULL)
		out.tokenType = XS_unpack_UA_UserTokenType(*svp);

	svp = hv_fetchs(hv, "UserTokenPolicy_issuedTokenType", 0);
	if (svp != NULL)
		out.issuedTokenType = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "UserTokenPolicy_issuerEndpointUrl", 0);
	if (svp != NULL)
		out.issuerEndpointUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "UserTokenPolicy_securityPolicyUri", 0);
	if (svp != NULL)
		out.securityPolicyUri = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* EndpointDescription */
#ifdef UA_TYPES_ENDPOINTDESCRIPTION

static void XS_pack_UA_EndpointDescription(SV *out, UA_EndpointDescription in)  __attribute__((unused));
static void
XS_pack_UA_EndpointDescription(SV *out, UA_EndpointDescription in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.endpointUrl);
	hv_stores(hv, "EndpointDescription_endpointUrl", sv);

	sv = newSV(0);
	XS_pack_UA_ApplicationDescription(sv, in.server);
	hv_stores(hv, "EndpointDescription_server", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.serverCertificate);
	hv_stores(hv, "EndpointDescription_serverCertificate", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "EndpointDescription_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityPolicyUri);
	hv_stores(hv, "EndpointDescription_securityPolicyUri", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.userIdentityTokensSize);
	for (i = 0; i < in.userIdentityTokensSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UserTokenPolicy(sv, in.userIdentityTokens[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EndpointDescription_userIdentityTokens", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_String(sv, in.transportProfileUri);
	hv_stores(hv, "EndpointDescription_transportProfileUri", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.securityLevel);
	hv_stores(hv, "EndpointDescription_securityLevel", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EndpointDescription XS_unpack_UA_EndpointDescription(SV *in)  __attribute__((unused));
static UA_EndpointDescription
XS_unpack_UA_EndpointDescription(SV *in)
{
	dTHX;
	UA_EndpointDescription out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EndpointDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EndpointDescription_endpointUrl", 0);
	if (svp != NULL)
		out.endpointUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "EndpointDescription_server", 0);
	if (svp != NULL)
		out.server = XS_unpack_UA_ApplicationDescription(*svp);

	svp = hv_fetchs(hv, "EndpointDescription_serverCertificate", 0);
	if (svp != NULL)
		out.serverCertificate = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "EndpointDescription_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "EndpointDescription_securityPolicyUri", 0);
	if (svp != NULL)
		out.securityPolicyUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "EndpointDescription_userIdentityTokens", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EndpointDescription_userIdentityTokens");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.userIdentityTokens = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_USERTOKENPOLICY]);
		if (out.userIdentityTokens == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.userIdentityTokens[i] = XS_unpack_UA_UserTokenPolicy(*svp);
			}
		}
		out.userIdentityTokensSize = i;
	}

	svp = hv_fetchs(hv, "EndpointDescription_transportProfileUri", 0);
	if (svp != NULL)
		out.transportProfileUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "EndpointDescription_securityLevel", 0);
	if (svp != NULL)
		out.securityLevel = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* GetEndpointsRequest */
#ifdef UA_TYPES_GETENDPOINTSREQUEST

static void XS_pack_UA_GetEndpointsRequest(SV *out, UA_GetEndpointsRequest in)  __attribute__((unused));
static void
XS_pack_UA_GetEndpointsRequest(SV *out, UA_GetEndpointsRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "GetEndpointsRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.endpointUrl);
	hv_stores(hv, "GetEndpointsRequest_endpointUrl", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.localeIdsSize);
	for (i = 0; i < in.localeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.localeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "GetEndpointsRequest_localeIds", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.profileUrisSize);
	for (i = 0; i < in.profileUrisSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.profileUris[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "GetEndpointsRequest_profileUris", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_GetEndpointsRequest XS_unpack_UA_GetEndpointsRequest(SV *in)  __attribute__((unused));
static UA_GetEndpointsRequest
XS_unpack_UA_GetEndpointsRequest(SV *in)
{
	dTHX;
	UA_GetEndpointsRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_GetEndpointsRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "GetEndpointsRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "GetEndpointsRequest_endpointUrl", 0);
	if (svp != NULL)
		out.endpointUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "GetEndpointsRequest_localeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for GetEndpointsRequest_localeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.localeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.localeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.localeIds[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.localeIdsSize = i;
	}

	svp = hv_fetchs(hv, "GetEndpointsRequest_profileUris", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for GetEndpointsRequest_profileUris");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.profileUris = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.profileUris == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.profileUris[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.profileUrisSize = i;
	}

	return out;
}
#endif

/* GetEndpointsResponse */
#ifdef UA_TYPES_GETENDPOINTSRESPONSE

static void XS_pack_UA_GetEndpointsResponse(SV *out, UA_GetEndpointsResponse in)  __attribute__((unused));
static void
XS_pack_UA_GetEndpointsResponse(SV *out, UA_GetEndpointsResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "GetEndpointsResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.endpointsSize);
	for (i = 0; i < in.endpointsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EndpointDescription(sv, in.endpoints[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "GetEndpointsResponse_endpoints", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_GetEndpointsResponse XS_unpack_UA_GetEndpointsResponse(SV *in)  __attribute__((unused));
static UA_GetEndpointsResponse
XS_unpack_UA_GetEndpointsResponse(SV *in)
{
	dTHX;
	UA_GetEndpointsResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_GetEndpointsResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "GetEndpointsResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "GetEndpointsResponse_endpoints", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for GetEndpointsResponse_endpoints");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.endpoints = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENDPOINTDESCRIPTION]);
		if (out.endpoints == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.endpoints[i] = XS_unpack_UA_EndpointDescription(*svp);
			}
		}
		out.endpointsSize = i;
	}

	return out;
}
#endif

/* RegisteredServer */
#ifdef UA_TYPES_REGISTEREDSERVER

static void XS_pack_UA_RegisteredServer(SV *out, UA_RegisteredServer in)  __attribute__((unused));
static void
XS_pack_UA_RegisteredServer(SV *out, UA_RegisteredServer in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.serverUri);
	hv_stores(hv, "RegisteredServer_serverUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.productUri);
	hv_stores(hv, "RegisteredServer_productUri", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverNamesSize);
	for (i = 0; i < in.serverNamesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_LocalizedText(sv, in.serverNames[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RegisteredServer_serverNames", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ApplicationType(sv, in.serverType);
	hv_stores(hv, "RegisteredServer_serverType", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.gatewayServerUri);
	hv_stores(hv, "RegisteredServer_gatewayServerUri", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.discoveryUrlsSize);
	for (i = 0; i < in.discoveryUrlsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.discoveryUrls[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RegisteredServer_discoveryUrls", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_String(sv, in.semaphoreFilePath);
	hv_stores(hv, "RegisteredServer_semaphoreFilePath", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isOnline);
	hv_stores(hv, "RegisteredServer_isOnline", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RegisteredServer XS_unpack_UA_RegisteredServer(SV *in)  __attribute__((unused));
static UA_RegisteredServer
XS_unpack_UA_RegisteredServer(SV *in)
{
	dTHX;
	UA_RegisteredServer out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RegisteredServer_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RegisteredServer_serverUri", 0);
	if (svp != NULL)
		out.serverUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "RegisteredServer_productUri", 0);
	if (svp != NULL)
		out.productUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "RegisteredServer_serverNames", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RegisteredServer_serverNames");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverNames = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_LOCALIZEDTEXT]);
		if (out.serverNames == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverNames[i] = XS_unpack_UA_LocalizedText(*svp);
			}
		}
		out.serverNamesSize = i;
	}

	svp = hv_fetchs(hv, "RegisteredServer_serverType", 0);
	if (svp != NULL)
		out.serverType = XS_unpack_UA_ApplicationType(*svp);

	svp = hv_fetchs(hv, "RegisteredServer_gatewayServerUri", 0);
	if (svp != NULL)
		out.gatewayServerUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "RegisteredServer_discoveryUrls", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RegisteredServer_discoveryUrls");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.discoveryUrls = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.discoveryUrls == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.discoveryUrls[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.discoveryUrlsSize = i;
	}

	svp = hv_fetchs(hv, "RegisteredServer_semaphoreFilePath", 0);
	if (svp != NULL)
		out.semaphoreFilePath = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "RegisteredServer_isOnline", 0);
	if (svp != NULL)
		out.isOnline = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* RegisterServerRequest */
#ifdef UA_TYPES_REGISTERSERVERREQUEST

static void XS_pack_UA_RegisterServerRequest(SV *out, UA_RegisterServerRequest in)  __attribute__((unused));
static void
XS_pack_UA_RegisterServerRequest(SV *out, UA_RegisterServerRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "RegisterServerRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_RegisteredServer(sv, in.server);
	hv_stores(hv, "RegisterServerRequest_server", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RegisterServerRequest XS_unpack_UA_RegisterServerRequest(SV *in)  __attribute__((unused));
static UA_RegisterServerRequest
XS_unpack_UA_RegisterServerRequest(SV *in)
{
	dTHX;
	UA_RegisterServerRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RegisterServerRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RegisterServerRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "RegisterServerRequest_server", 0);
	if (svp != NULL)
		out.server = XS_unpack_UA_RegisteredServer(*svp);

	return out;
}
#endif

/* RegisterServerResponse */
#ifdef UA_TYPES_REGISTERSERVERRESPONSE

static void XS_pack_UA_RegisterServerResponse(SV *out, UA_RegisterServerResponse in)  __attribute__((unused));
static void
XS_pack_UA_RegisterServerResponse(SV *out, UA_RegisterServerResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "RegisterServerResponse_responseHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RegisterServerResponse XS_unpack_UA_RegisterServerResponse(SV *in)  __attribute__((unused));
static UA_RegisterServerResponse
XS_unpack_UA_RegisterServerResponse(SV *in)
{
	dTHX;
	UA_RegisterServerResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RegisterServerResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RegisterServerResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	return out;
}
#endif

/* DiscoveryConfiguration */
#ifdef UA_TYPES_DISCOVERYCONFIGURATION

static void XS_pack_UA_DiscoveryConfiguration(SV *out, UA_DiscoveryConfiguration in)  __attribute__((unused));
static void
XS_pack_UA_DiscoveryConfiguration(SV *out, UA_DiscoveryConfiguration in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_DiscoveryConfiguration XS_unpack_UA_DiscoveryConfiguration(SV *in)  __attribute__((unused));
static UA_DiscoveryConfiguration
XS_unpack_UA_DiscoveryConfiguration(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* MdnsDiscoveryConfiguration */
#ifdef UA_TYPES_MDNSDISCOVERYCONFIGURATION

static void XS_pack_UA_MdnsDiscoveryConfiguration(SV *out, UA_MdnsDiscoveryConfiguration in)  __attribute__((unused));
static void
XS_pack_UA_MdnsDiscoveryConfiguration(SV *out, UA_MdnsDiscoveryConfiguration in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.mdnsServerName);
	hv_stores(hv, "MdnsDiscoveryConfiguration_mdnsServerName", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverCapabilitiesSize);
	for (i = 0; i < in.serverCapabilitiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.serverCapabilities[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "MdnsDiscoveryConfiguration_serverCapabilities", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MdnsDiscoveryConfiguration XS_unpack_UA_MdnsDiscoveryConfiguration(SV *in)  __attribute__((unused));
static UA_MdnsDiscoveryConfiguration
XS_unpack_UA_MdnsDiscoveryConfiguration(SV *in)
{
	dTHX;
	UA_MdnsDiscoveryConfiguration out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MdnsDiscoveryConfiguration_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MdnsDiscoveryConfiguration_mdnsServerName", 0);
	if (svp != NULL)
		out.mdnsServerName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "MdnsDiscoveryConfiguration_serverCapabilities", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for MdnsDiscoveryConfiguration_serverCapabilities");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverCapabilities = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.serverCapabilities == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverCapabilities[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.serverCapabilitiesSize = i;
	}

	return out;
}
#endif

/* RegisterServer2Request */
#ifdef UA_TYPES_REGISTERSERVER2REQUEST

static void XS_pack_UA_RegisterServer2Request(SV *out, UA_RegisterServer2Request in)  __attribute__((unused));
static void
XS_pack_UA_RegisterServer2Request(SV *out, UA_RegisterServer2Request in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "RegisterServer2Request_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_RegisteredServer(sv, in.server);
	hv_stores(hv, "RegisterServer2Request_server", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.discoveryConfigurationSize);
	for (i = 0; i < in.discoveryConfigurationSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ExtensionObject(sv, in.discoveryConfiguration[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RegisterServer2Request_discoveryConfiguration", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RegisterServer2Request XS_unpack_UA_RegisterServer2Request(SV *in)  __attribute__((unused));
static UA_RegisterServer2Request
XS_unpack_UA_RegisterServer2Request(SV *in)
{
	dTHX;
	UA_RegisterServer2Request out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RegisterServer2Request_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RegisterServer2Request_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "RegisterServer2Request_server", 0);
	if (svp != NULL)
		out.server = XS_unpack_UA_RegisteredServer(*svp);

	svp = hv_fetchs(hv, "RegisterServer2Request_discoveryConfiguration", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RegisterServer2Request_discoveryConfiguration");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.discoveryConfiguration = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_EXTENSIONOBJECT]);
		if (out.discoveryConfiguration == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.discoveryConfiguration[i] = XS_unpack_UA_ExtensionObject(*svp);
			}
		}
		out.discoveryConfigurationSize = i;
	}

	return out;
}
#endif

/* RegisterServer2Response */
#ifdef UA_TYPES_REGISTERSERVER2RESPONSE

static void XS_pack_UA_RegisterServer2Response(SV *out, UA_RegisterServer2Response in)  __attribute__((unused));
static void
XS_pack_UA_RegisterServer2Response(SV *out, UA_RegisterServer2Response in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "RegisterServer2Response_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.configurationResultsSize);
	for (i = 0; i < in.configurationResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.configurationResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RegisterServer2Response_configurationResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RegisterServer2Response_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RegisterServer2Response XS_unpack_UA_RegisterServer2Response(SV *in)  __attribute__((unused));
static UA_RegisterServer2Response
XS_unpack_UA_RegisterServer2Response(SV *in)
{
	dTHX;
	UA_RegisterServer2Response out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RegisterServer2Response_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RegisterServer2Response_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "RegisterServer2Response_configurationResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RegisterServer2Response_configurationResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.configurationResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.configurationResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.configurationResults[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.configurationResultsSize = i;
	}

	svp = hv_fetchs(hv, "RegisterServer2Response_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RegisterServer2Response_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* SecurityTokenRequestType */
#ifdef UA_TYPES_SECURITYTOKENREQUESTTYPE

static void XS_pack_UA_SecurityTokenRequestType(SV *out, UA_SecurityTokenRequestType in)  __attribute__((unused));
static void
XS_pack_UA_SecurityTokenRequestType(SV *out, UA_SecurityTokenRequestType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_SecurityTokenRequestType XS_unpack_UA_SecurityTokenRequestType(SV *in)  __attribute__((unused));
static UA_SecurityTokenRequestType
XS_unpack_UA_SecurityTokenRequestType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ChannelSecurityToken */
#ifdef UA_TYPES_CHANNELSECURITYTOKEN

static void XS_pack_UA_ChannelSecurityToken(SV *out, UA_ChannelSecurityToken in)  __attribute__((unused));
static void
XS_pack_UA_ChannelSecurityToken(SV *out, UA_ChannelSecurityToken in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.channelId);
	hv_stores(hv, "ChannelSecurityToken_channelId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.tokenId);
	hv_stores(hv, "ChannelSecurityToken_tokenId", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.createdAt);
	hv_stores(hv, "ChannelSecurityToken_createdAt", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.revisedLifetime);
	hv_stores(hv, "ChannelSecurityToken_revisedLifetime", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ChannelSecurityToken XS_unpack_UA_ChannelSecurityToken(SV *in)  __attribute__((unused));
static UA_ChannelSecurityToken
XS_unpack_UA_ChannelSecurityToken(SV *in)
{
	dTHX;
	UA_ChannelSecurityToken out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ChannelSecurityToken_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ChannelSecurityToken_channelId", 0);
	if (svp != NULL)
		out.channelId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ChannelSecurityToken_tokenId", 0);
	if (svp != NULL)
		out.tokenId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ChannelSecurityToken_createdAt", 0);
	if (svp != NULL)
		out.createdAt = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ChannelSecurityToken_revisedLifetime", 0);
	if (svp != NULL)
		out.revisedLifetime = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* OpenSecureChannelRequest */
#ifdef UA_TYPES_OPENSECURECHANNELREQUEST

static void XS_pack_UA_OpenSecureChannelRequest(SV *out, UA_OpenSecureChannelRequest in)  __attribute__((unused));
static void
XS_pack_UA_OpenSecureChannelRequest(SV *out, UA_OpenSecureChannelRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "OpenSecureChannelRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.clientProtocolVersion);
	hv_stores(hv, "OpenSecureChannelRequest_clientProtocolVersion", sv);

	sv = newSV(0);
	XS_pack_UA_SecurityTokenRequestType(sv, in.requestType);
	hv_stores(hv, "OpenSecureChannelRequest_requestType", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "OpenSecureChannelRequest_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.clientNonce);
	hv_stores(hv, "OpenSecureChannelRequest_clientNonce", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestedLifetime);
	hv_stores(hv, "OpenSecureChannelRequest_requestedLifetime", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_OpenSecureChannelRequest XS_unpack_UA_OpenSecureChannelRequest(SV *in)  __attribute__((unused));
static UA_OpenSecureChannelRequest
XS_unpack_UA_OpenSecureChannelRequest(SV *in)
{
	dTHX;
	UA_OpenSecureChannelRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_OpenSecureChannelRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "OpenSecureChannelRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelRequest_clientProtocolVersion", 0);
	if (svp != NULL)
		out.clientProtocolVersion = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelRequest_requestType", 0);
	if (svp != NULL)
		out.requestType = XS_unpack_UA_SecurityTokenRequestType(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelRequest_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelRequest_clientNonce", 0);
	if (svp != NULL)
		out.clientNonce = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelRequest_requestedLifetime", 0);
	if (svp != NULL)
		out.requestedLifetime = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* OpenSecureChannelResponse */
#ifdef UA_TYPES_OPENSECURECHANNELRESPONSE

static void XS_pack_UA_OpenSecureChannelResponse(SV *out, UA_OpenSecureChannelResponse in)  __attribute__((unused));
static void
XS_pack_UA_OpenSecureChannelResponse(SV *out, UA_OpenSecureChannelResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "OpenSecureChannelResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.serverProtocolVersion);
	hv_stores(hv, "OpenSecureChannelResponse_serverProtocolVersion", sv);

	sv = newSV(0);
	XS_pack_UA_ChannelSecurityToken(sv, in.securityToken);
	hv_stores(hv, "OpenSecureChannelResponse_securityToken", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.serverNonce);
	hv_stores(hv, "OpenSecureChannelResponse_serverNonce", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_OpenSecureChannelResponse XS_unpack_UA_OpenSecureChannelResponse(SV *in)  __attribute__((unused));
static UA_OpenSecureChannelResponse
XS_unpack_UA_OpenSecureChannelResponse(SV *in)
{
	dTHX;
	UA_OpenSecureChannelResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_OpenSecureChannelResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "OpenSecureChannelResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelResponse_serverProtocolVersion", 0);
	if (svp != NULL)
		out.serverProtocolVersion = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelResponse_securityToken", 0);
	if (svp != NULL)
		out.securityToken = XS_unpack_UA_ChannelSecurityToken(*svp);

	svp = hv_fetchs(hv, "OpenSecureChannelResponse_serverNonce", 0);
	if (svp != NULL)
		out.serverNonce = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* CloseSecureChannelRequest */
#ifdef UA_TYPES_CLOSESECURECHANNELREQUEST

static void XS_pack_UA_CloseSecureChannelRequest(SV *out, UA_CloseSecureChannelRequest in)  __attribute__((unused));
static void
XS_pack_UA_CloseSecureChannelRequest(SV *out, UA_CloseSecureChannelRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "CloseSecureChannelRequest_requestHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CloseSecureChannelRequest XS_unpack_UA_CloseSecureChannelRequest(SV *in)  __attribute__((unused));
static UA_CloseSecureChannelRequest
XS_unpack_UA_CloseSecureChannelRequest(SV *in)
{
	dTHX;
	UA_CloseSecureChannelRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CloseSecureChannelRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CloseSecureChannelRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	return out;
}
#endif

/* CloseSecureChannelResponse */
#ifdef UA_TYPES_CLOSESECURECHANNELRESPONSE

static void XS_pack_UA_CloseSecureChannelResponse(SV *out, UA_CloseSecureChannelResponse in)  __attribute__((unused));
static void
XS_pack_UA_CloseSecureChannelResponse(SV *out, UA_CloseSecureChannelResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "CloseSecureChannelResponse_responseHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CloseSecureChannelResponse XS_unpack_UA_CloseSecureChannelResponse(SV *in)  __attribute__((unused));
static UA_CloseSecureChannelResponse
XS_unpack_UA_CloseSecureChannelResponse(SV *in)
{
	dTHX;
	UA_CloseSecureChannelResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CloseSecureChannelResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CloseSecureChannelResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	return out;
}
#endif

/* SignedSoftwareCertificate */
#ifdef UA_TYPES_SIGNEDSOFTWARECERTIFICATE

static void XS_pack_UA_SignedSoftwareCertificate(SV *out, UA_SignedSoftwareCertificate in)  __attribute__((unused));
static void
XS_pack_UA_SignedSoftwareCertificate(SV *out, UA_SignedSoftwareCertificate in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.certificateData);
	hv_stores(hv, "SignedSoftwareCertificate_certificateData", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.signature);
	hv_stores(hv, "SignedSoftwareCertificate_signature", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SignedSoftwareCertificate XS_unpack_UA_SignedSoftwareCertificate(SV *in)  __attribute__((unused));
static UA_SignedSoftwareCertificate
XS_unpack_UA_SignedSoftwareCertificate(SV *in)
{
	dTHX;
	UA_SignedSoftwareCertificate out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SignedSoftwareCertificate_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SignedSoftwareCertificate_certificateData", 0);
	if (svp != NULL)
		out.certificateData = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "SignedSoftwareCertificate_signature", 0);
	if (svp != NULL)
		out.signature = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* SessionAuthenticationToken */
#ifdef UA_TYPES_SESSIONAUTHENTICATIONTOKEN

static void XS_pack_UA_SessionAuthenticationToken(SV *out, UA_SessionAuthenticationToken in)  __attribute__((unused));
static void
XS_pack_UA_SessionAuthenticationToken(SV *out, UA_SessionAuthenticationToken in)
{
	dTHX;
	XS_pack_UA_NodeId(out, in);
}

static UA_SessionAuthenticationToken XS_unpack_UA_SessionAuthenticationToken(SV *in)  __attribute__((unused));
static UA_SessionAuthenticationToken
XS_unpack_UA_SessionAuthenticationToken(SV *in)
{
	dTHX;
	return XS_unpack_UA_NodeId(in);
}
#endif

/* SignatureData */
#ifdef UA_TYPES_SIGNATUREDATA

static void XS_pack_UA_SignatureData(SV *out, UA_SignatureData in)  __attribute__((unused));
static void
XS_pack_UA_SignatureData(SV *out, UA_SignatureData in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.algorithm);
	hv_stores(hv, "SignatureData_algorithm", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.signature);
	hv_stores(hv, "SignatureData_signature", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SignatureData XS_unpack_UA_SignatureData(SV *in)  __attribute__((unused));
static UA_SignatureData
XS_unpack_UA_SignatureData(SV *in)
{
	dTHX;
	UA_SignatureData out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SignatureData_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SignatureData_algorithm", 0);
	if (svp != NULL)
		out.algorithm = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SignatureData_signature", 0);
	if (svp != NULL)
		out.signature = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* CreateSessionRequest */
#ifdef UA_TYPES_CREATESESSIONREQUEST

static void XS_pack_UA_CreateSessionRequest(SV *out, UA_CreateSessionRequest in)  __attribute__((unused));
static void
XS_pack_UA_CreateSessionRequest(SV *out, UA_CreateSessionRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "CreateSessionRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_ApplicationDescription(sv, in.clientDescription);
	hv_stores(hv, "CreateSessionRequest_clientDescription", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.serverUri);
	hv_stores(hv, "CreateSessionRequest_serverUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.endpointUrl);
	hv_stores(hv, "CreateSessionRequest_endpointUrl", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.sessionName);
	hv_stores(hv, "CreateSessionRequest_sessionName", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.clientNonce);
	hv_stores(hv, "CreateSessionRequest_clientNonce", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.clientCertificate);
	hv_stores(hv, "CreateSessionRequest_clientCertificate", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.requestedSessionTimeout);
	hv_stores(hv, "CreateSessionRequest_requestedSessionTimeout", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxResponseMessageSize);
	hv_stores(hv, "CreateSessionRequest_maxResponseMessageSize", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CreateSessionRequest XS_unpack_UA_CreateSessionRequest(SV *in)  __attribute__((unused));
static UA_CreateSessionRequest
XS_unpack_UA_CreateSessionRequest(SV *in)
{
	dTHX;
	UA_CreateSessionRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CreateSessionRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CreateSessionRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_clientDescription", 0);
	if (svp != NULL)
		out.clientDescription = XS_unpack_UA_ApplicationDescription(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_serverUri", 0);
	if (svp != NULL)
		out.serverUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_endpointUrl", 0);
	if (svp != NULL)
		out.endpointUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_sessionName", 0);
	if (svp != NULL)
		out.sessionName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_clientNonce", 0);
	if (svp != NULL)
		out.clientNonce = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_clientCertificate", 0);
	if (svp != NULL)
		out.clientCertificate = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_requestedSessionTimeout", 0);
	if (svp != NULL)
		out.requestedSessionTimeout = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "CreateSessionRequest_maxResponseMessageSize", 0);
	if (svp != NULL)
		out.maxResponseMessageSize = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* CreateSessionResponse */
#ifdef UA_TYPES_CREATESESSIONRESPONSE

static void XS_pack_UA_CreateSessionResponse(SV *out, UA_CreateSessionResponse in)  __attribute__((unused));
static void
XS_pack_UA_CreateSessionResponse(SV *out, UA_CreateSessionResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "CreateSessionResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.sessionId);
	hv_stores(hv, "CreateSessionResponse_sessionId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.authenticationToken);
	hv_stores(hv, "CreateSessionResponse_authenticationToken", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.revisedSessionTimeout);
	hv_stores(hv, "CreateSessionResponse_revisedSessionTimeout", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.serverNonce);
	hv_stores(hv, "CreateSessionResponse_serverNonce", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.serverCertificate);
	hv_stores(hv, "CreateSessionResponse_serverCertificate", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverEndpointsSize);
	for (i = 0; i < in.serverEndpointsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EndpointDescription(sv, in.serverEndpoints[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CreateSessionResponse_serverEndpoints", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.serverSoftwareCertificatesSize);
	for (i = 0; i < in.serverSoftwareCertificatesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SignedSoftwareCertificate(sv, in.serverSoftwareCertificates[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CreateSessionResponse_serverSoftwareCertificates", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_SignatureData(sv, in.serverSignature);
	hv_stores(hv, "CreateSessionResponse_serverSignature", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxRequestMessageSize);
	hv_stores(hv, "CreateSessionResponse_maxRequestMessageSize", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CreateSessionResponse XS_unpack_UA_CreateSessionResponse(SV *in)  __attribute__((unused));
static UA_CreateSessionResponse
XS_unpack_UA_CreateSessionResponse(SV *in)
{
	dTHX;
	UA_CreateSessionResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CreateSessionResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CreateSessionResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "CreateSessionResponse_sessionId", 0);
	if (svp != NULL)
		out.sessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "CreateSessionResponse_authenticationToken", 0);
	if (svp != NULL)
		out.authenticationToken = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "CreateSessionResponse_revisedSessionTimeout", 0);
	if (svp != NULL)
		out.revisedSessionTimeout = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "CreateSessionResponse_serverNonce", 0);
	if (svp != NULL)
		out.serverNonce = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "CreateSessionResponse_serverCertificate", 0);
	if (svp != NULL)
		out.serverCertificate = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "CreateSessionResponse_serverEndpoints", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CreateSessionResponse_serverEndpoints");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverEndpoints = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENDPOINTDESCRIPTION]);
		if (out.serverEndpoints == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverEndpoints[i] = XS_unpack_UA_EndpointDescription(*svp);
			}
		}
		out.serverEndpointsSize = i;
	}

	svp = hv_fetchs(hv, "CreateSessionResponse_serverSoftwareCertificates", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CreateSessionResponse_serverSoftwareCertificates");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.serverSoftwareCertificates = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SIGNEDSOFTWARECERTIFICATE]);
		if (out.serverSoftwareCertificates == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.serverSoftwareCertificates[i] = XS_unpack_UA_SignedSoftwareCertificate(*svp);
			}
		}
		out.serverSoftwareCertificatesSize = i;
	}

	svp = hv_fetchs(hv, "CreateSessionResponse_serverSignature", 0);
	if (svp != NULL)
		out.serverSignature = XS_unpack_UA_SignatureData(*svp);

	svp = hv_fetchs(hv, "CreateSessionResponse_maxRequestMessageSize", 0);
	if (svp != NULL)
		out.maxRequestMessageSize = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* UserIdentityToken */
#ifdef UA_TYPES_USERIDENTITYTOKEN

static void XS_pack_UA_UserIdentityToken(SV *out, UA_UserIdentityToken in)  __attribute__((unused));
static void
XS_pack_UA_UserIdentityToken(SV *out, UA_UserIdentityToken in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.policyId);
	hv_stores(hv, "UserIdentityToken_policyId", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UserIdentityToken XS_unpack_UA_UserIdentityToken(SV *in)  __attribute__((unused));
static UA_UserIdentityToken
XS_unpack_UA_UserIdentityToken(SV *in)
{
	dTHX;
	UA_UserIdentityToken out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UserIdentityToken_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UserIdentityToken_policyId", 0);
	if (svp != NULL)
		out.policyId = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* AnonymousIdentityToken */
#ifdef UA_TYPES_ANONYMOUSIDENTITYTOKEN

static void XS_pack_UA_AnonymousIdentityToken(SV *out, UA_AnonymousIdentityToken in)  __attribute__((unused));
static void
XS_pack_UA_AnonymousIdentityToken(SV *out, UA_AnonymousIdentityToken in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.policyId);
	hv_stores(hv, "AnonymousIdentityToken_policyId", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AnonymousIdentityToken XS_unpack_UA_AnonymousIdentityToken(SV *in)  __attribute__((unused));
static UA_AnonymousIdentityToken
XS_unpack_UA_AnonymousIdentityToken(SV *in)
{
	dTHX;
	UA_AnonymousIdentityToken out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AnonymousIdentityToken_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AnonymousIdentityToken_policyId", 0);
	if (svp != NULL)
		out.policyId = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* UserNameIdentityToken */
#ifdef UA_TYPES_USERNAMEIDENTITYTOKEN

static void XS_pack_UA_UserNameIdentityToken(SV *out, UA_UserNameIdentityToken in)  __attribute__((unused));
static void
XS_pack_UA_UserNameIdentityToken(SV *out, UA_UserNameIdentityToken in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.policyId);
	hv_stores(hv, "UserNameIdentityToken_policyId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.userName);
	hv_stores(hv, "UserNameIdentityToken_userName", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.password);
	hv_stores(hv, "UserNameIdentityToken_password", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.encryptionAlgorithm);
	hv_stores(hv, "UserNameIdentityToken_encryptionAlgorithm", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UserNameIdentityToken XS_unpack_UA_UserNameIdentityToken(SV *in)  __attribute__((unused));
static UA_UserNameIdentityToken
XS_unpack_UA_UserNameIdentityToken(SV *in)
{
	dTHX;
	UA_UserNameIdentityToken out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UserNameIdentityToken_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UserNameIdentityToken_policyId", 0);
	if (svp != NULL)
		out.policyId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "UserNameIdentityToken_userName", 0);
	if (svp != NULL)
		out.userName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "UserNameIdentityToken_password", 0);
	if (svp != NULL)
		out.password = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "UserNameIdentityToken_encryptionAlgorithm", 0);
	if (svp != NULL)
		out.encryptionAlgorithm = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* X509IdentityToken */
#ifdef UA_TYPES_X509IDENTITYTOKEN

static void XS_pack_UA_X509IdentityToken(SV *out, UA_X509IdentityToken in)  __attribute__((unused));
static void
XS_pack_UA_X509IdentityToken(SV *out, UA_X509IdentityToken in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.policyId);
	hv_stores(hv, "X509IdentityToken_policyId", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.certificateData);
	hv_stores(hv, "X509IdentityToken_certificateData", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_X509IdentityToken XS_unpack_UA_X509IdentityToken(SV *in)  __attribute__((unused));
static UA_X509IdentityToken
XS_unpack_UA_X509IdentityToken(SV *in)
{
	dTHX;
	UA_X509IdentityToken out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_X509IdentityToken_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "X509IdentityToken_policyId", 0);
	if (svp != NULL)
		out.policyId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "X509IdentityToken_certificateData", 0);
	if (svp != NULL)
		out.certificateData = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* IssuedIdentityToken */
#ifdef UA_TYPES_ISSUEDIDENTITYTOKEN

static void XS_pack_UA_IssuedIdentityToken(SV *out, UA_IssuedIdentityToken in)  __attribute__((unused));
static void
XS_pack_UA_IssuedIdentityToken(SV *out, UA_IssuedIdentityToken in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.policyId);
	hv_stores(hv, "IssuedIdentityToken_policyId", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.tokenData);
	hv_stores(hv, "IssuedIdentityToken_tokenData", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.encryptionAlgorithm);
	hv_stores(hv, "IssuedIdentityToken_encryptionAlgorithm", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_IssuedIdentityToken XS_unpack_UA_IssuedIdentityToken(SV *in)  __attribute__((unused));
static UA_IssuedIdentityToken
XS_unpack_UA_IssuedIdentityToken(SV *in)
{
	dTHX;
	UA_IssuedIdentityToken out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_IssuedIdentityToken_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "IssuedIdentityToken_policyId", 0);
	if (svp != NULL)
		out.policyId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "IssuedIdentityToken_tokenData", 0);
	if (svp != NULL)
		out.tokenData = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "IssuedIdentityToken_encryptionAlgorithm", 0);
	if (svp != NULL)
		out.encryptionAlgorithm = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* RsaEncryptedSecret */
#ifdef UA_TYPES_RSAENCRYPTEDSECRET

static void XS_pack_UA_RsaEncryptedSecret(SV *out, UA_RsaEncryptedSecret in)  __attribute__((unused));
static void
XS_pack_UA_RsaEncryptedSecret(SV *out, UA_RsaEncryptedSecret in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_RsaEncryptedSecret XS_unpack_UA_RsaEncryptedSecret(SV *in)  __attribute__((unused));
static UA_RsaEncryptedSecret
XS_unpack_UA_RsaEncryptedSecret(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* ActivateSessionRequest */
#ifdef UA_TYPES_ACTIVATESESSIONREQUEST

static void XS_pack_UA_ActivateSessionRequest(SV *out, UA_ActivateSessionRequest in)  __attribute__((unused));
static void
XS_pack_UA_ActivateSessionRequest(SV *out, UA_ActivateSessionRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "ActivateSessionRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_SignatureData(sv, in.clientSignature);
	hv_stores(hv, "ActivateSessionRequest_clientSignature", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.clientSoftwareCertificatesSize);
	for (i = 0; i < in.clientSoftwareCertificatesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SignedSoftwareCertificate(sv, in.clientSoftwareCertificates[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ActivateSessionRequest_clientSoftwareCertificates", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.localeIdsSize);
	for (i = 0; i < in.localeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.localeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ActivateSessionRequest_localeIds", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.userIdentityToken);
	hv_stores(hv, "ActivateSessionRequest_userIdentityToken", sv);

	sv = newSV(0);
	XS_pack_UA_SignatureData(sv, in.userTokenSignature);
	hv_stores(hv, "ActivateSessionRequest_userTokenSignature", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ActivateSessionRequest XS_unpack_UA_ActivateSessionRequest(SV *in)  __attribute__((unused));
static UA_ActivateSessionRequest
XS_unpack_UA_ActivateSessionRequest(SV *in)
{
	dTHX;
	UA_ActivateSessionRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ActivateSessionRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ActivateSessionRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "ActivateSessionRequest_clientSignature", 0);
	if (svp != NULL)
		out.clientSignature = XS_unpack_UA_SignatureData(*svp);

	svp = hv_fetchs(hv, "ActivateSessionRequest_clientSoftwareCertificates", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ActivateSessionRequest_clientSoftwareCertificates");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.clientSoftwareCertificates = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SIGNEDSOFTWARECERTIFICATE]);
		if (out.clientSoftwareCertificates == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.clientSoftwareCertificates[i] = XS_unpack_UA_SignedSoftwareCertificate(*svp);
			}
		}
		out.clientSoftwareCertificatesSize = i;
	}

	svp = hv_fetchs(hv, "ActivateSessionRequest_localeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ActivateSessionRequest_localeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.localeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.localeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.localeIds[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.localeIdsSize = i;
	}

	svp = hv_fetchs(hv, "ActivateSessionRequest_userIdentityToken", 0);
	if (svp != NULL)
		out.userIdentityToken = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "ActivateSessionRequest_userTokenSignature", 0);
	if (svp != NULL)
		out.userTokenSignature = XS_unpack_UA_SignatureData(*svp);

	return out;
}
#endif

/* ActivateSessionResponse */
#ifdef UA_TYPES_ACTIVATESESSIONRESPONSE

static void XS_pack_UA_ActivateSessionResponse(SV *out, UA_ActivateSessionResponse in)  __attribute__((unused));
static void
XS_pack_UA_ActivateSessionResponse(SV *out, UA_ActivateSessionResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "ActivateSessionResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.serverNonce);
	hv_stores(hv, "ActivateSessionResponse_serverNonce", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ActivateSessionResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ActivateSessionResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ActivateSessionResponse XS_unpack_UA_ActivateSessionResponse(SV *in)  __attribute__((unused));
static UA_ActivateSessionResponse
XS_unpack_UA_ActivateSessionResponse(SV *in)
{
	dTHX;
	UA_ActivateSessionResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ActivateSessionResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ActivateSessionResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "ActivateSessionResponse_serverNonce", 0);
	if (svp != NULL)
		out.serverNonce = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "ActivateSessionResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ActivateSessionResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "ActivateSessionResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ActivateSessionResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* CloseSessionRequest */
#ifdef UA_TYPES_CLOSESESSIONREQUEST

static void XS_pack_UA_CloseSessionRequest(SV *out, UA_CloseSessionRequest in)  __attribute__((unused));
static void
XS_pack_UA_CloseSessionRequest(SV *out, UA_CloseSessionRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "CloseSessionRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.deleteSubscriptions);
	hv_stores(hv, "CloseSessionRequest_deleteSubscriptions", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CloseSessionRequest XS_unpack_UA_CloseSessionRequest(SV *in)  __attribute__((unused));
static UA_CloseSessionRequest
XS_unpack_UA_CloseSessionRequest(SV *in)
{
	dTHX;
	UA_CloseSessionRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CloseSessionRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CloseSessionRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "CloseSessionRequest_deleteSubscriptions", 0);
	if (svp != NULL)
		out.deleteSubscriptions = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* CloseSessionResponse */
#ifdef UA_TYPES_CLOSESESSIONRESPONSE

static void XS_pack_UA_CloseSessionResponse(SV *out, UA_CloseSessionResponse in)  __attribute__((unused));
static void
XS_pack_UA_CloseSessionResponse(SV *out, UA_CloseSessionResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "CloseSessionResponse_responseHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CloseSessionResponse XS_unpack_UA_CloseSessionResponse(SV *in)  __attribute__((unused));
static UA_CloseSessionResponse
XS_unpack_UA_CloseSessionResponse(SV *in)
{
	dTHX;
	UA_CloseSessionResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CloseSessionResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CloseSessionResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	return out;
}
#endif

/* CancelRequest */
#ifdef UA_TYPES_CANCELREQUEST

static void XS_pack_UA_CancelRequest(SV *out, UA_CancelRequest in)  __attribute__((unused));
static void
XS_pack_UA_CancelRequest(SV *out, UA_CancelRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "CancelRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestHandle);
	hv_stores(hv, "CancelRequest_requestHandle", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CancelRequest XS_unpack_UA_CancelRequest(SV *in)  __attribute__((unused));
static UA_CancelRequest
XS_unpack_UA_CancelRequest(SV *in)
{
	dTHX;
	UA_CancelRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CancelRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CancelRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "CancelRequest_requestHandle", 0);
	if (svp != NULL)
		out.requestHandle = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* CancelResponse */
#ifdef UA_TYPES_CANCELRESPONSE

static void XS_pack_UA_CancelResponse(SV *out, UA_CancelResponse in)  __attribute__((unused));
static void
XS_pack_UA_CancelResponse(SV *out, UA_CancelResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "CancelResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.cancelCount);
	hv_stores(hv, "CancelResponse_cancelCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CancelResponse XS_unpack_UA_CancelResponse(SV *in)  __attribute__((unused));
static UA_CancelResponse
XS_unpack_UA_CancelResponse(SV *in)
{
	dTHX;
	UA_CancelResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CancelResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CancelResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "CancelResponse_cancelCount", 0);
	if (svp != NULL)
		out.cancelCount = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* NodeAttributesMask */
#ifdef UA_TYPES_NODEATTRIBUTESMASK

static void XS_pack_UA_NodeAttributesMask(SV *out, UA_NodeAttributesMask in)  __attribute__((unused));
static void
XS_pack_UA_NodeAttributesMask(SV *out, UA_NodeAttributesMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_NodeAttributesMask XS_unpack_UA_NodeAttributesMask(SV *in)  __attribute__((unused));
static UA_NodeAttributesMask
XS_unpack_UA_NodeAttributesMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* NodeAttributes */
#ifdef UA_TYPES_NODEATTRIBUTES

static void XS_pack_UA_NodeAttributes(SV *out, UA_NodeAttributes in)  __attribute__((unused));
static void
XS_pack_UA_NodeAttributes(SV *out, UA_NodeAttributes in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "NodeAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "NodeAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "NodeAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "NodeAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "NodeAttributes_userWriteMask", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_NodeAttributes XS_unpack_UA_NodeAttributes(SV *in)  __attribute__((unused));
static UA_NodeAttributes
XS_unpack_UA_NodeAttributes(SV *in)
{
	dTHX;
	UA_NodeAttributes out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_NodeAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "NodeAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "NodeAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "NodeAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "NodeAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "NodeAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* ObjectAttributes */
#ifdef UA_TYPES_OBJECTATTRIBUTES

static void XS_pack_UA_ObjectAttributes(SV *out, UA_ObjectAttributes in)  __attribute__((unused));
static void
XS_pack_UA_ObjectAttributes(SV *out, UA_ObjectAttributes in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "ObjectAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "ObjectAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "ObjectAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "ObjectAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "ObjectAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.eventNotifier);
	hv_stores(hv, "ObjectAttributes_eventNotifier", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ObjectAttributes XS_unpack_UA_ObjectAttributes(SV *in)  __attribute__((unused));
static UA_ObjectAttributes
XS_unpack_UA_ObjectAttributes(SV *in)
{
	dTHX;
	UA_ObjectAttributes out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ObjectAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ObjectAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ObjectAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ObjectAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ObjectAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ObjectAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ObjectAttributes_eventNotifier", 0);
	if (svp != NULL)
		out.eventNotifier = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* VariableAttributes */
#ifdef UA_TYPES_VARIABLEATTRIBUTES

static void XS_pack_UA_VariableAttributes(SV *out, UA_VariableAttributes in)  __attribute__((unused));
static void
XS_pack_UA_VariableAttributes(SV *out, UA_VariableAttributes in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "VariableAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "VariableAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "VariableAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "VariableAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "VariableAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.value);
	hv_stores(hv, "VariableAttributes_value", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataType);
	hv_stores(hv, "VariableAttributes_dataType", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.valueRank);
	hv_stores(hv, "VariableAttributes_valueRank", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.arrayDimensionsSize);
	for (i = 0; i < in.arrayDimensionsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.arrayDimensions[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "VariableAttributes_arrayDimensions", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.accessLevel);
	hv_stores(hv, "VariableAttributes_accessLevel", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.userAccessLevel);
	hv_stores(hv, "VariableAttributes_userAccessLevel", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.minimumSamplingInterval);
	hv_stores(hv, "VariableAttributes_minimumSamplingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.historizing);
	hv_stores(hv, "VariableAttributes_historizing", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_VariableAttributes XS_unpack_UA_VariableAttributes(SV *in)  __attribute__((unused));
static UA_VariableAttributes
XS_unpack_UA_VariableAttributes(SV *in)
{
	dTHX;
	UA_VariableAttributes out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_VariableAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "VariableAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Variant(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_dataType", 0);
	if (svp != NULL)
		out.dataType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_valueRank", 0);
	if (svp != NULL)
		out.valueRank = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_arrayDimensions", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for VariableAttributes_arrayDimensions");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.arrayDimensions = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.arrayDimensions == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.arrayDimensions[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.arrayDimensionsSize = i;
	}

	svp = hv_fetchs(hv, "VariableAttributes_accessLevel", 0);
	if (svp != NULL)
		out.accessLevel = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_userAccessLevel", 0);
	if (svp != NULL)
		out.userAccessLevel = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_minimumSamplingInterval", 0);
	if (svp != NULL)
		out.minimumSamplingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "VariableAttributes_historizing", 0);
	if (svp != NULL)
		out.historizing = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* MethodAttributes */
#ifdef UA_TYPES_METHODATTRIBUTES

static void XS_pack_UA_MethodAttributes(SV *out, UA_MethodAttributes in)  __attribute__((unused));
static void
XS_pack_UA_MethodAttributes(SV *out, UA_MethodAttributes in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "MethodAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "MethodAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "MethodAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "MethodAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "MethodAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.executable);
	hv_stores(hv, "MethodAttributes_executable", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.userExecutable);
	hv_stores(hv, "MethodAttributes_userExecutable", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MethodAttributes XS_unpack_UA_MethodAttributes(SV *in)  __attribute__((unused));
static UA_MethodAttributes
XS_unpack_UA_MethodAttributes(SV *in)
{
	dTHX;
	UA_MethodAttributes out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MethodAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MethodAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MethodAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "MethodAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "MethodAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MethodAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MethodAttributes_executable", 0);
	if (svp != NULL)
		out.executable = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "MethodAttributes_userExecutable", 0);
	if (svp != NULL)
		out.userExecutable = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* ObjectTypeAttributes */
#ifdef UA_TYPES_OBJECTTYPEATTRIBUTES

static void XS_pack_UA_ObjectTypeAttributes(SV *out, UA_ObjectTypeAttributes in)  __attribute__((unused));
static void
XS_pack_UA_ObjectTypeAttributes(SV *out, UA_ObjectTypeAttributes in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "ObjectTypeAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "ObjectTypeAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "ObjectTypeAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "ObjectTypeAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "ObjectTypeAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isAbstract);
	hv_stores(hv, "ObjectTypeAttributes_isAbstract", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ObjectTypeAttributes XS_unpack_UA_ObjectTypeAttributes(SV *in)  __attribute__((unused));
static UA_ObjectTypeAttributes
XS_unpack_UA_ObjectTypeAttributes(SV *in)
{
	dTHX;
	UA_ObjectTypeAttributes out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ObjectTypeAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ObjectTypeAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ObjectTypeAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ObjectTypeAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ObjectTypeAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ObjectTypeAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ObjectTypeAttributes_isAbstract", 0);
	if (svp != NULL)
		out.isAbstract = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* VariableTypeAttributes */
#ifdef UA_TYPES_VARIABLETYPEATTRIBUTES

static void XS_pack_UA_VariableTypeAttributes(SV *out, UA_VariableTypeAttributes in)  __attribute__((unused));
static void
XS_pack_UA_VariableTypeAttributes(SV *out, UA_VariableTypeAttributes in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "VariableTypeAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "VariableTypeAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "VariableTypeAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "VariableTypeAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "VariableTypeAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.value);
	hv_stores(hv, "VariableTypeAttributes_value", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataType);
	hv_stores(hv, "VariableTypeAttributes_dataType", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.valueRank);
	hv_stores(hv, "VariableTypeAttributes_valueRank", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.arrayDimensionsSize);
	for (i = 0; i < in.arrayDimensionsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.arrayDimensions[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "VariableTypeAttributes_arrayDimensions", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isAbstract);
	hv_stores(hv, "VariableTypeAttributes_isAbstract", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_VariableTypeAttributes XS_unpack_UA_VariableTypeAttributes(SV *in)  __attribute__((unused));
static UA_VariableTypeAttributes
XS_unpack_UA_VariableTypeAttributes(SV *in)
{
	dTHX;
	UA_VariableTypeAttributes out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_VariableTypeAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "VariableTypeAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Variant(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_dataType", 0);
	if (svp != NULL)
		out.dataType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_valueRank", 0);
	if (svp != NULL)
		out.valueRank = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "VariableTypeAttributes_arrayDimensions", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for VariableTypeAttributes_arrayDimensions");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.arrayDimensions = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.arrayDimensions == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.arrayDimensions[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.arrayDimensionsSize = i;
	}

	svp = hv_fetchs(hv, "VariableTypeAttributes_isAbstract", 0);
	if (svp != NULL)
		out.isAbstract = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* ReferenceTypeAttributes */
#ifdef UA_TYPES_REFERENCETYPEATTRIBUTES

static void XS_pack_UA_ReferenceTypeAttributes(SV *out, UA_ReferenceTypeAttributes in)  __attribute__((unused));
static void
XS_pack_UA_ReferenceTypeAttributes(SV *out, UA_ReferenceTypeAttributes in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "ReferenceTypeAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "ReferenceTypeAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "ReferenceTypeAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "ReferenceTypeAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "ReferenceTypeAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isAbstract);
	hv_stores(hv, "ReferenceTypeAttributes_isAbstract", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.symmetric);
	hv_stores(hv, "ReferenceTypeAttributes_symmetric", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.inverseName);
	hv_stores(hv, "ReferenceTypeAttributes_inverseName", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReferenceTypeAttributes XS_unpack_UA_ReferenceTypeAttributes(SV *in)  __attribute__((unused));
static UA_ReferenceTypeAttributes
XS_unpack_UA_ReferenceTypeAttributes(SV *in)
{
	dTHX;
	UA_ReferenceTypeAttributes out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReferenceTypeAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_isAbstract", 0);
	if (svp != NULL)
		out.isAbstract = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_symmetric", 0);
	if (svp != NULL)
		out.symmetric = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "ReferenceTypeAttributes_inverseName", 0);
	if (svp != NULL)
		out.inverseName = XS_unpack_UA_LocalizedText(*svp);

	return out;
}
#endif

/* DataTypeAttributes */
#ifdef UA_TYPES_DATATYPEATTRIBUTES

static void XS_pack_UA_DataTypeAttributes(SV *out, UA_DataTypeAttributes in)  __attribute__((unused));
static void
XS_pack_UA_DataTypeAttributes(SV *out, UA_DataTypeAttributes in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "DataTypeAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "DataTypeAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "DataTypeAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "DataTypeAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "DataTypeAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isAbstract);
	hv_stores(hv, "DataTypeAttributes_isAbstract", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataTypeAttributes XS_unpack_UA_DataTypeAttributes(SV *in)  __attribute__((unused));
static UA_DataTypeAttributes
XS_unpack_UA_DataTypeAttributes(SV *in)
{
	dTHX;
	UA_DataTypeAttributes out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataTypeAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataTypeAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "DataTypeAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "DataTypeAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "DataTypeAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "DataTypeAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "DataTypeAttributes_isAbstract", 0);
	if (svp != NULL)
		out.isAbstract = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* ViewAttributes */
#ifdef UA_TYPES_VIEWATTRIBUTES

static void XS_pack_UA_ViewAttributes(SV *out, UA_ViewAttributes in)  __attribute__((unused));
static void
XS_pack_UA_ViewAttributes(SV *out, UA_ViewAttributes in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "ViewAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "ViewAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "ViewAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "ViewAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "ViewAttributes_userWriteMask", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.containsNoLoops);
	hv_stores(hv, "ViewAttributes_containsNoLoops", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.eventNotifier);
	hv_stores(hv, "ViewAttributes_eventNotifier", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ViewAttributes XS_unpack_UA_ViewAttributes(SV *in)  __attribute__((unused));
static UA_ViewAttributes
XS_unpack_UA_ViewAttributes(SV *in)
{
	dTHX;
	UA_ViewAttributes out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ViewAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ViewAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ViewAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ViewAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ViewAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ViewAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ViewAttributes_containsNoLoops", 0);
	if (svp != NULL)
		out.containsNoLoops = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "ViewAttributes_eventNotifier", 0);
	if (svp != NULL)
		out.eventNotifier = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* GenericAttributeValue */
#ifdef UA_TYPES_GENERICATTRIBUTEVALUE

static void XS_pack_UA_GenericAttributeValue(SV *out, UA_GenericAttributeValue in)  __attribute__((unused));
static void
XS_pack_UA_GenericAttributeValue(SV *out, UA_GenericAttributeValue in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "GenericAttributeValue_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.value);
	hv_stores(hv, "GenericAttributeValue_value", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_GenericAttributeValue XS_unpack_UA_GenericAttributeValue(SV *in)  __attribute__((unused));
static UA_GenericAttributeValue
XS_unpack_UA_GenericAttributeValue(SV *in)
{
	dTHX;
	UA_GenericAttributeValue out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_GenericAttributeValue_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "GenericAttributeValue_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "GenericAttributeValue_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Variant(*svp);

	return out;
}
#endif

/* GenericAttributes */
#ifdef UA_TYPES_GENERICATTRIBUTES

static void XS_pack_UA_GenericAttributes(SV *out, UA_GenericAttributes in)  __attribute__((unused));
static void
XS_pack_UA_GenericAttributes(SV *out, UA_GenericAttributes in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.specifiedAttributes);
	hv_stores(hv, "GenericAttributes_specifiedAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "GenericAttributes_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "GenericAttributes_description", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.writeMask);
	hv_stores(hv, "GenericAttributes_writeMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.userWriteMask);
	hv_stores(hv, "GenericAttributes_userWriteMask", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.attributeValuesSize);
	for (i = 0; i < in.attributeValuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_GenericAttributeValue(sv, in.attributeValues[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "GenericAttributes_attributeValues", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_GenericAttributes XS_unpack_UA_GenericAttributes(SV *in)  __attribute__((unused));
static UA_GenericAttributes
XS_unpack_UA_GenericAttributes(SV *in)
{
	dTHX;
	UA_GenericAttributes out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_GenericAttributes_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "GenericAttributes_specifiedAttributes", 0);
	if (svp != NULL)
		out.specifiedAttributes = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "GenericAttributes_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "GenericAttributes_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "GenericAttributes_writeMask", 0);
	if (svp != NULL)
		out.writeMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "GenericAttributes_userWriteMask", 0);
	if (svp != NULL)
		out.userWriteMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "GenericAttributes_attributeValues", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for GenericAttributes_attributeValues");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.attributeValues = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_GENERICATTRIBUTEVALUE]);
		if (out.attributeValues == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.attributeValues[i] = XS_unpack_UA_GenericAttributeValue(*svp);
			}
		}
		out.attributeValuesSize = i;
	}

	return out;
}
#endif

/* AddNodesItem */
#ifdef UA_TYPES_ADDNODESITEM

static void XS_pack_UA_AddNodesItem(SV *out, UA_AddNodesItem in)  __attribute__((unused));
static void
XS_pack_UA_AddNodesItem(SV *out, UA_AddNodesItem in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.parentNodeId);
	hv_stores(hv, "AddNodesItem_parentNodeId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "AddNodesItem_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.requestedNewNodeId);
	hv_stores(hv, "AddNodesItem_requestedNewNodeId", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.browseName);
	hv_stores(hv, "AddNodesItem_browseName", sv);

	sv = newSV(0);
	XS_pack_UA_NodeClass(sv, in.nodeClass);
	hv_stores(hv, "AddNodesItem_nodeClass", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.nodeAttributes);
	hv_stores(hv, "AddNodesItem_nodeAttributes", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.typeDefinition);
	hv_stores(hv, "AddNodesItem_typeDefinition", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AddNodesItem XS_unpack_UA_AddNodesItem(SV *in)  __attribute__((unused));
static UA_AddNodesItem
XS_unpack_UA_AddNodesItem(SV *in)
{
	dTHX;
	UA_AddNodesItem out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AddNodesItem_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AddNodesItem_parentNodeId", 0);
	if (svp != NULL)
		out.parentNodeId = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "AddNodesItem_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "AddNodesItem_requestedNewNodeId", 0);
	if (svp != NULL)
		out.requestedNewNodeId = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "AddNodesItem_browseName", 0);
	if (svp != NULL)
		out.browseName = XS_unpack_UA_QualifiedName(*svp);

	svp = hv_fetchs(hv, "AddNodesItem_nodeClass", 0);
	if (svp != NULL)
		out.nodeClass = XS_unpack_UA_NodeClass(*svp);

	svp = hv_fetchs(hv, "AddNodesItem_nodeAttributes", 0);
	if (svp != NULL)
		out.nodeAttributes = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "AddNodesItem_typeDefinition", 0);
	if (svp != NULL)
		out.typeDefinition = XS_unpack_UA_ExpandedNodeId(*svp);

	return out;
}
#endif

/* AddNodesResult */
#ifdef UA_TYPES_ADDNODESRESULT

static void XS_pack_UA_AddNodesResult(SV *out, UA_AddNodesResult in)  __attribute__((unused));
static void
XS_pack_UA_AddNodesResult(SV *out, UA_AddNodesResult in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "AddNodesResult_statusCode", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.addedNodeId);
	hv_stores(hv, "AddNodesResult_addedNodeId", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AddNodesResult XS_unpack_UA_AddNodesResult(SV *in)  __attribute__((unused));
static UA_AddNodesResult
XS_unpack_UA_AddNodesResult(SV *in)
{
	dTHX;
	UA_AddNodesResult out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AddNodesResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AddNodesResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "AddNodesResult_addedNodeId", 0);
	if (svp != NULL)
		out.addedNodeId = XS_unpack_UA_NodeId(*svp);

	return out;
}
#endif

/* AddNodesRequest */
#ifdef UA_TYPES_ADDNODESREQUEST

static void XS_pack_UA_AddNodesRequest(SV *out, UA_AddNodesRequest in)  __attribute__((unused));
static void
XS_pack_UA_AddNodesRequest(SV *out, UA_AddNodesRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "AddNodesRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToAddSize);
	for (i = 0; i < in.nodesToAddSize; i++) {
		sv = newSV(0);
		XS_pack_UA_AddNodesItem(sv, in.nodesToAdd[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "AddNodesRequest_nodesToAdd", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AddNodesRequest XS_unpack_UA_AddNodesRequest(SV *in)  __attribute__((unused));
static UA_AddNodesRequest
XS_unpack_UA_AddNodesRequest(SV *in)
{
	dTHX;
	UA_AddNodesRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AddNodesRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AddNodesRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "AddNodesRequest_nodesToAdd", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for AddNodesRequest_nodesToAdd");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToAdd = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ADDNODESITEM]);
		if (out.nodesToAdd == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToAdd[i] = XS_unpack_UA_AddNodesItem(*svp);
			}
		}
		out.nodesToAddSize = i;
	}

	return out;
}
#endif

/* AddNodesResponse */
#ifdef UA_TYPES_ADDNODESRESPONSE

static void XS_pack_UA_AddNodesResponse(SV *out, UA_AddNodesResponse in)  __attribute__((unused));
static void
XS_pack_UA_AddNodesResponse(SV *out, UA_AddNodesResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "AddNodesResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_AddNodesResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "AddNodesResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "AddNodesResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AddNodesResponse XS_unpack_UA_AddNodesResponse(SV *in)  __attribute__((unused));
static UA_AddNodesResponse
XS_unpack_UA_AddNodesResponse(SV *in)
{
	dTHX;
	UA_AddNodesResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AddNodesResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AddNodesResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "AddNodesResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for AddNodesResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ADDNODESRESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_AddNodesResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "AddNodesResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for AddNodesResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* AddReferencesItem */
#ifdef UA_TYPES_ADDREFERENCESITEM

static void XS_pack_UA_AddReferencesItem(SV *out, UA_AddReferencesItem in)  __attribute__((unused));
static void
XS_pack_UA_AddReferencesItem(SV *out, UA_AddReferencesItem in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.sourceNodeId);
	hv_stores(hv, "AddReferencesItem_sourceNodeId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "AddReferencesItem_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isForward);
	hv_stores(hv, "AddReferencesItem_isForward", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.targetServerUri);
	hv_stores(hv, "AddReferencesItem_targetServerUri", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.targetNodeId);
	hv_stores(hv, "AddReferencesItem_targetNodeId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeClass(sv, in.targetNodeClass);
	hv_stores(hv, "AddReferencesItem_targetNodeClass", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AddReferencesItem XS_unpack_UA_AddReferencesItem(SV *in)  __attribute__((unused));
static UA_AddReferencesItem
XS_unpack_UA_AddReferencesItem(SV *in)
{
	dTHX;
	UA_AddReferencesItem out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AddReferencesItem_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AddReferencesItem_sourceNodeId", 0);
	if (svp != NULL)
		out.sourceNodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "AddReferencesItem_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "AddReferencesItem_isForward", 0);
	if (svp != NULL)
		out.isForward = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "AddReferencesItem_targetServerUri", 0);
	if (svp != NULL)
		out.targetServerUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "AddReferencesItem_targetNodeId", 0);
	if (svp != NULL)
		out.targetNodeId = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "AddReferencesItem_targetNodeClass", 0);
	if (svp != NULL)
		out.targetNodeClass = XS_unpack_UA_NodeClass(*svp);

	return out;
}
#endif

/* AddReferencesRequest */
#ifdef UA_TYPES_ADDREFERENCESREQUEST

static void XS_pack_UA_AddReferencesRequest(SV *out, UA_AddReferencesRequest in)  __attribute__((unused));
static void
XS_pack_UA_AddReferencesRequest(SV *out, UA_AddReferencesRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "AddReferencesRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.referencesToAddSize);
	for (i = 0; i < in.referencesToAddSize; i++) {
		sv = newSV(0);
		XS_pack_UA_AddReferencesItem(sv, in.referencesToAdd[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "AddReferencesRequest_referencesToAdd", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AddReferencesRequest XS_unpack_UA_AddReferencesRequest(SV *in)  __attribute__((unused));
static UA_AddReferencesRequest
XS_unpack_UA_AddReferencesRequest(SV *in)
{
	dTHX;
	UA_AddReferencesRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AddReferencesRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AddReferencesRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "AddReferencesRequest_referencesToAdd", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for AddReferencesRequest_referencesToAdd");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.referencesToAdd = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ADDREFERENCESITEM]);
		if (out.referencesToAdd == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.referencesToAdd[i] = XS_unpack_UA_AddReferencesItem(*svp);
			}
		}
		out.referencesToAddSize = i;
	}

	return out;
}
#endif

/* AddReferencesResponse */
#ifdef UA_TYPES_ADDREFERENCESRESPONSE

static void XS_pack_UA_AddReferencesResponse(SV *out, UA_AddReferencesResponse in)  __attribute__((unused));
static void
XS_pack_UA_AddReferencesResponse(SV *out, UA_AddReferencesResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "AddReferencesResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "AddReferencesResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "AddReferencesResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AddReferencesResponse XS_unpack_UA_AddReferencesResponse(SV *in)  __attribute__((unused));
static UA_AddReferencesResponse
XS_unpack_UA_AddReferencesResponse(SV *in)
{
	dTHX;
	UA_AddReferencesResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AddReferencesResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AddReferencesResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "AddReferencesResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for AddReferencesResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "AddReferencesResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for AddReferencesResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* DeleteNodesItem */
#ifdef UA_TYPES_DELETENODESITEM

static void XS_pack_UA_DeleteNodesItem(SV *out, UA_DeleteNodesItem in)  __attribute__((unused));
static void
XS_pack_UA_DeleteNodesItem(SV *out, UA_DeleteNodesItem in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "DeleteNodesItem_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.deleteTargetReferences);
	hv_stores(hv, "DeleteNodesItem_deleteTargetReferences", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteNodesItem XS_unpack_UA_DeleteNodesItem(SV *in)  __attribute__((unused));
static UA_DeleteNodesItem
XS_unpack_UA_DeleteNodesItem(SV *in)
{
	dTHX;
	UA_DeleteNodesItem out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteNodesItem_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteNodesItem_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "DeleteNodesItem_deleteTargetReferences", 0);
	if (svp != NULL)
		out.deleteTargetReferences = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* DeleteNodesRequest */
#ifdef UA_TYPES_DELETENODESREQUEST

static void XS_pack_UA_DeleteNodesRequest(SV *out, UA_DeleteNodesRequest in)  __attribute__((unused));
static void
XS_pack_UA_DeleteNodesRequest(SV *out, UA_DeleteNodesRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "DeleteNodesRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToDeleteSize);
	for (i = 0; i < in.nodesToDeleteSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DeleteNodesItem(sv, in.nodesToDelete[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteNodesRequest_nodesToDelete", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteNodesRequest XS_unpack_UA_DeleteNodesRequest(SV *in)  __attribute__((unused));
static UA_DeleteNodesRequest
XS_unpack_UA_DeleteNodesRequest(SV *in)
{
	dTHX;
	UA_DeleteNodesRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteNodesRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteNodesRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "DeleteNodesRequest_nodesToDelete", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteNodesRequest_nodesToDelete");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToDelete = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DELETENODESITEM]);
		if (out.nodesToDelete == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToDelete[i] = XS_unpack_UA_DeleteNodesItem(*svp);
			}
		}
		out.nodesToDeleteSize = i;
	}

	return out;
}
#endif

/* DeleteNodesResponse */
#ifdef UA_TYPES_DELETENODESRESPONSE

static void XS_pack_UA_DeleteNodesResponse(SV *out, UA_DeleteNodesResponse in)  __attribute__((unused));
static void
XS_pack_UA_DeleteNodesResponse(SV *out, UA_DeleteNodesResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "DeleteNodesResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteNodesResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteNodesResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteNodesResponse XS_unpack_UA_DeleteNodesResponse(SV *in)  __attribute__((unused));
static UA_DeleteNodesResponse
XS_unpack_UA_DeleteNodesResponse(SV *in)
{
	dTHX;
	UA_DeleteNodesResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteNodesResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteNodesResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "DeleteNodesResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteNodesResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "DeleteNodesResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteNodesResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* DeleteReferencesItem */
#ifdef UA_TYPES_DELETEREFERENCESITEM

static void XS_pack_UA_DeleteReferencesItem(SV *out, UA_DeleteReferencesItem in)  __attribute__((unused));
static void
XS_pack_UA_DeleteReferencesItem(SV *out, UA_DeleteReferencesItem in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.sourceNodeId);
	hv_stores(hv, "DeleteReferencesItem_sourceNodeId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "DeleteReferencesItem_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isForward);
	hv_stores(hv, "DeleteReferencesItem_isForward", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.targetNodeId);
	hv_stores(hv, "DeleteReferencesItem_targetNodeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.deleteBidirectional);
	hv_stores(hv, "DeleteReferencesItem_deleteBidirectional", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteReferencesItem XS_unpack_UA_DeleteReferencesItem(SV *in)  __attribute__((unused));
static UA_DeleteReferencesItem
XS_unpack_UA_DeleteReferencesItem(SV *in)
{
	dTHX;
	UA_DeleteReferencesItem out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteReferencesItem_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteReferencesItem_sourceNodeId", 0);
	if (svp != NULL)
		out.sourceNodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "DeleteReferencesItem_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "DeleteReferencesItem_isForward", 0);
	if (svp != NULL)
		out.isForward = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "DeleteReferencesItem_targetNodeId", 0);
	if (svp != NULL)
		out.targetNodeId = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "DeleteReferencesItem_deleteBidirectional", 0);
	if (svp != NULL)
		out.deleteBidirectional = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* DeleteReferencesRequest */
#ifdef UA_TYPES_DELETEREFERENCESREQUEST

static void XS_pack_UA_DeleteReferencesRequest(SV *out, UA_DeleteReferencesRequest in)  __attribute__((unused));
static void
XS_pack_UA_DeleteReferencesRequest(SV *out, UA_DeleteReferencesRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "DeleteReferencesRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.referencesToDeleteSize);
	for (i = 0; i < in.referencesToDeleteSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DeleteReferencesItem(sv, in.referencesToDelete[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteReferencesRequest_referencesToDelete", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteReferencesRequest XS_unpack_UA_DeleteReferencesRequest(SV *in)  __attribute__((unused));
static UA_DeleteReferencesRequest
XS_unpack_UA_DeleteReferencesRequest(SV *in)
{
	dTHX;
	UA_DeleteReferencesRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteReferencesRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteReferencesRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "DeleteReferencesRequest_referencesToDelete", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteReferencesRequest_referencesToDelete");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.referencesToDelete = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DELETEREFERENCESITEM]);
		if (out.referencesToDelete == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.referencesToDelete[i] = XS_unpack_UA_DeleteReferencesItem(*svp);
			}
		}
		out.referencesToDeleteSize = i;
	}

	return out;
}
#endif

/* DeleteReferencesResponse */
#ifdef UA_TYPES_DELETEREFERENCESRESPONSE

static void XS_pack_UA_DeleteReferencesResponse(SV *out, UA_DeleteReferencesResponse in)  __attribute__((unused));
static void
XS_pack_UA_DeleteReferencesResponse(SV *out, UA_DeleteReferencesResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "DeleteReferencesResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteReferencesResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteReferencesResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteReferencesResponse XS_unpack_UA_DeleteReferencesResponse(SV *in)  __attribute__((unused));
static UA_DeleteReferencesResponse
XS_unpack_UA_DeleteReferencesResponse(SV *in)
{
	dTHX;
	UA_DeleteReferencesResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteReferencesResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteReferencesResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "DeleteReferencesResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteReferencesResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "DeleteReferencesResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteReferencesResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* AttributeWriteMask */
#ifdef UA_TYPES_ATTRIBUTEWRITEMASK

static void XS_pack_UA_AttributeWriteMask(SV *out, UA_AttributeWriteMask in)  __attribute__((unused));
static void
XS_pack_UA_AttributeWriteMask(SV *out, UA_AttributeWriteMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_AttributeWriteMask XS_unpack_UA_AttributeWriteMask(SV *in)  __attribute__((unused));
static UA_AttributeWriteMask
XS_unpack_UA_AttributeWriteMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* BrowseDirection */
#ifdef UA_TYPES_BROWSEDIRECTION

static void XS_pack_UA_BrowseDirection(SV *out, UA_BrowseDirection in)  __attribute__((unused));
static void
XS_pack_UA_BrowseDirection(SV *out, UA_BrowseDirection in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_BrowseDirection XS_unpack_UA_BrowseDirection(SV *in)  __attribute__((unused));
static UA_BrowseDirection
XS_unpack_UA_BrowseDirection(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ViewDescription */
#ifdef UA_TYPES_VIEWDESCRIPTION

static void XS_pack_UA_ViewDescription(SV *out, UA_ViewDescription in)  __attribute__((unused));
static void
XS_pack_UA_ViewDescription(SV *out, UA_ViewDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.viewId);
	hv_stores(hv, "ViewDescription_viewId", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.timestamp);
	hv_stores(hv, "ViewDescription_timestamp", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.viewVersion);
	hv_stores(hv, "ViewDescription_viewVersion", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ViewDescription XS_unpack_UA_ViewDescription(SV *in)  __attribute__((unused));
static UA_ViewDescription
XS_unpack_UA_ViewDescription(SV *in)
{
	dTHX;
	UA_ViewDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ViewDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ViewDescription_viewId", 0);
	if (svp != NULL)
		out.viewId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ViewDescription_timestamp", 0);
	if (svp != NULL)
		out.timestamp = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ViewDescription_viewVersion", 0);
	if (svp != NULL)
		out.viewVersion = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* BrowseDescription */
#ifdef UA_TYPES_BROWSEDESCRIPTION

static void XS_pack_UA_BrowseDescription(SV *out, UA_BrowseDescription in)  __attribute__((unused));
static void
XS_pack_UA_BrowseDescription(SV *out, UA_BrowseDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "BrowseDescription_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_BrowseDirection(sv, in.browseDirection);
	hv_stores(hv, "BrowseDescription_browseDirection", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "BrowseDescription_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.includeSubtypes);
	hv_stores(hv, "BrowseDescription_includeSubtypes", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.nodeClassMask);
	hv_stores(hv, "BrowseDescription_nodeClassMask", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.resultMask);
	hv_stores(hv, "BrowseDescription_resultMask", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowseDescription XS_unpack_UA_BrowseDescription(SV *in)  __attribute__((unused));
static UA_BrowseDescription
XS_unpack_UA_BrowseDescription(SV *in)
{
	dTHX;
	UA_BrowseDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowseDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowseDescription_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "BrowseDescription_browseDirection", 0);
	if (svp != NULL)
		out.browseDirection = XS_unpack_UA_BrowseDirection(*svp);

	svp = hv_fetchs(hv, "BrowseDescription_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "BrowseDescription_includeSubtypes", 0);
	if (svp != NULL)
		out.includeSubtypes = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "BrowseDescription_nodeClassMask", 0);
	if (svp != NULL)
		out.nodeClassMask = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "BrowseDescription_resultMask", 0);
	if (svp != NULL)
		out.resultMask = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* BrowseResultMask */
#ifdef UA_TYPES_BROWSERESULTMASK

static void XS_pack_UA_BrowseResultMask(SV *out, UA_BrowseResultMask in)  __attribute__((unused));
static void
XS_pack_UA_BrowseResultMask(SV *out, UA_BrowseResultMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_BrowseResultMask XS_unpack_UA_BrowseResultMask(SV *in)  __attribute__((unused));
static UA_BrowseResultMask
XS_unpack_UA_BrowseResultMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ReferenceDescription */
#ifdef UA_TYPES_REFERENCEDESCRIPTION

static void XS_pack_UA_ReferenceDescription(SV *out, UA_ReferenceDescription in)  __attribute__((unused));
static void
XS_pack_UA_ReferenceDescription(SV *out, UA_ReferenceDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "ReferenceDescription_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isForward);
	hv_stores(hv, "ReferenceDescription_isForward", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.nodeId);
	hv_stores(hv, "ReferenceDescription_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.browseName);
	hv_stores(hv, "ReferenceDescription_browseName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "ReferenceDescription_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_NodeClass(sv, in.nodeClass);
	hv_stores(hv, "ReferenceDescription_nodeClass", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.typeDefinition);
	hv_stores(hv, "ReferenceDescription_typeDefinition", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReferenceDescription XS_unpack_UA_ReferenceDescription(SV *in)  __attribute__((unused));
static UA_ReferenceDescription
XS_unpack_UA_ReferenceDescription(SV *in)
{
	dTHX;
	UA_ReferenceDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReferenceDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReferenceDescription_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ReferenceDescription_isForward", 0);
	if (svp != NULL)
		out.isForward = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "ReferenceDescription_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "ReferenceDescription_browseName", 0);
	if (svp != NULL)
		out.browseName = XS_unpack_UA_QualifiedName(*svp);

	svp = hv_fetchs(hv, "ReferenceDescription_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "ReferenceDescription_nodeClass", 0);
	if (svp != NULL)
		out.nodeClass = XS_unpack_UA_NodeClass(*svp);

	svp = hv_fetchs(hv, "ReferenceDescription_typeDefinition", 0);
	if (svp != NULL)
		out.typeDefinition = XS_unpack_UA_ExpandedNodeId(*svp);

	return out;
}
#endif

/* ContinuationPoint */
#ifdef UA_TYPES_CONTINUATIONPOINT

static void XS_pack_UA_ContinuationPoint(SV *out, UA_ContinuationPoint in)  __attribute__((unused));
static void
XS_pack_UA_ContinuationPoint(SV *out, UA_ContinuationPoint in)
{
	dTHX;
	XS_pack_UA_ByteString(out, in);
}

static UA_ContinuationPoint XS_unpack_UA_ContinuationPoint(SV *in)  __attribute__((unused));
static UA_ContinuationPoint
XS_unpack_UA_ContinuationPoint(SV *in)
{
	dTHX;
	return XS_unpack_UA_ByteString(in);
}
#endif

/* BrowseResult */
#ifdef UA_TYPES_BROWSERESULT

static void XS_pack_UA_BrowseResult(SV *out, UA_BrowseResult in)  __attribute__((unused));
static void
XS_pack_UA_BrowseResult(SV *out, UA_BrowseResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "BrowseResult_statusCode", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.continuationPoint);
	hv_stores(hv, "BrowseResult_continuationPoint", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.referencesSize);
	for (i = 0; i < in.referencesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ReferenceDescription(sv, in.references[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowseResult_references", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowseResult XS_unpack_UA_BrowseResult(SV *in)  __attribute__((unused));
static UA_BrowseResult
XS_unpack_UA_BrowseResult(SV *in)
{
	dTHX;
	UA_BrowseResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowseResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowseResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "BrowseResult_continuationPoint", 0);
	if (svp != NULL)
		out.continuationPoint = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "BrowseResult_references", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowseResult_references");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.references = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_REFERENCEDESCRIPTION]);
		if (out.references == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.references[i] = XS_unpack_UA_ReferenceDescription(*svp);
			}
		}
		out.referencesSize = i;
	}

	return out;
}
#endif

/* BrowseRequest */
#ifdef UA_TYPES_BROWSEREQUEST

static void XS_pack_UA_BrowseRequest(SV *out, UA_BrowseRequest in)  __attribute__((unused));
static void
XS_pack_UA_BrowseRequest(SV *out, UA_BrowseRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "BrowseRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_ViewDescription(sv, in.view);
	hv_stores(hv, "BrowseRequest_view", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestedMaxReferencesPerNode);
	hv_stores(hv, "BrowseRequest_requestedMaxReferencesPerNode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToBrowseSize);
	for (i = 0; i < in.nodesToBrowseSize; i++) {
		sv = newSV(0);
		XS_pack_UA_BrowseDescription(sv, in.nodesToBrowse[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowseRequest_nodesToBrowse", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowseRequest XS_unpack_UA_BrowseRequest(SV *in)  __attribute__((unused));
static UA_BrowseRequest
XS_unpack_UA_BrowseRequest(SV *in)
{
	dTHX;
	UA_BrowseRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowseRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowseRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "BrowseRequest_view", 0);
	if (svp != NULL)
		out.view = XS_unpack_UA_ViewDescription(*svp);

	svp = hv_fetchs(hv, "BrowseRequest_requestedMaxReferencesPerNode", 0);
	if (svp != NULL)
		out.requestedMaxReferencesPerNode = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "BrowseRequest_nodesToBrowse", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowseRequest_nodesToBrowse");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToBrowse = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BROWSEDESCRIPTION]);
		if (out.nodesToBrowse == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToBrowse[i] = XS_unpack_UA_BrowseDescription(*svp);
			}
		}
		out.nodesToBrowseSize = i;
	}

	return out;
}
#endif

/* BrowseResponse */
#ifdef UA_TYPES_BROWSERESPONSE

static void XS_pack_UA_BrowseResponse(SV *out, UA_BrowseResponse in)  __attribute__((unused));
static void
XS_pack_UA_BrowseResponse(SV *out, UA_BrowseResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "BrowseResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_BrowseResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowseResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowseResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowseResponse XS_unpack_UA_BrowseResponse(SV *in)  __attribute__((unused));
static UA_BrowseResponse
XS_unpack_UA_BrowseResponse(SV *in)
{
	dTHX;
	UA_BrowseResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowseResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowseResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "BrowseResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowseResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BROWSERESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_BrowseResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "BrowseResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowseResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* BrowseNextRequest */
#ifdef UA_TYPES_BROWSENEXTREQUEST

static void XS_pack_UA_BrowseNextRequest(SV *out, UA_BrowseNextRequest in)  __attribute__((unused));
static void
XS_pack_UA_BrowseNextRequest(SV *out, UA_BrowseNextRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "BrowseNextRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.releaseContinuationPoints);
	hv_stores(hv, "BrowseNextRequest_releaseContinuationPoints", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.continuationPointsSize);
	for (i = 0; i < in.continuationPointsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ByteString(sv, in.continuationPoints[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowseNextRequest_continuationPoints", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowseNextRequest XS_unpack_UA_BrowseNextRequest(SV *in)  __attribute__((unused));
static UA_BrowseNextRequest
XS_unpack_UA_BrowseNextRequest(SV *in)
{
	dTHX;
	UA_BrowseNextRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowseNextRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowseNextRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "BrowseNextRequest_releaseContinuationPoints", 0);
	if (svp != NULL)
		out.releaseContinuationPoints = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "BrowseNextRequest_continuationPoints", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowseNextRequest_continuationPoints");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.continuationPoints = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BYTESTRING]);
		if (out.continuationPoints == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.continuationPoints[i] = XS_unpack_UA_ByteString(*svp);
			}
		}
		out.continuationPointsSize = i;
	}

	return out;
}
#endif

/* BrowseNextResponse */
#ifdef UA_TYPES_BROWSENEXTRESPONSE

static void XS_pack_UA_BrowseNextResponse(SV *out, UA_BrowseNextResponse in)  __attribute__((unused));
static void
XS_pack_UA_BrowseNextResponse(SV *out, UA_BrowseNextResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "BrowseNextResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_BrowseResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowseNextResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowseNextResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowseNextResponse XS_unpack_UA_BrowseNextResponse(SV *in)  __attribute__((unused));
static UA_BrowseNextResponse
XS_unpack_UA_BrowseNextResponse(SV *in)
{
	dTHX;
	UA_BrowseNextResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowseNextResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowseNextResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "BrowseNextResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowseNextResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BROWSERESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_BrowseResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "BrowseNextResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowseNextResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* RelativePathElement */
#ifdef UA_TYPES_RELATIVEPATHELEMENT

static void XS_pack_UA_RelativePathElement(SV *out, UA_RelativePathElement in)  __attribute__((unused));
static void
XS_pack_UA_RelativePathElement(SV *out, UA_RelativePathElement in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "RelativePathElement_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isInverse);
	hv_stores(hv, "RelativePathElement_isInverse", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.includeSubtypes);
	hv_stores(hv, "RelativePathElement_includeSubtypes", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.targetName);
	hv_stores(hv, "RelativePathElement_targetName", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RelativePathElement XS_unpack_UA_RelativePathElement(SV *in)  __attribute__((unused));
static UA_RelativePathElement
XS_unpack_UA_RelativePathElement(SV *in)
{
	dTHX;
	UA_RelativePathElement out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RelativePathElement_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RelativePathElement_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "RelativePathElement_isInverse", 0);
	if (svp != NULL)
		out.isInverse = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "RelativePathElement_includeSubtypes", 0);
	if (svp != NULL)
		out.includeSubtypes = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "RelativePathElement_targetName", 0);
	if (svp != NULL)
		out.targetName = XS_unpack_UA_QualifiedName(*svp);

	return out;
}
#endif

/* RelativePath */
#ifdef UA_TYPES_RELATIVEPATH

static void XS_pack_UA_RelativePath(SV *out, UA_RelativePath in)  __attribute__((unused));
static void
XS_pack_UA_RelativePath(SV *out, UA_RelativePath in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.elementsSize);
	for (i = 0; i < in.elementsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_RelativePathElement(sv, in.elements[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RelativePath_elements", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RelativePath XS_unpack_UA_RelativePath(SV *in)  __attribute__((unused));
static UA_RelativePath
XS_unpack_UA_RelativePath(SV *in)
{
	dTHX;
	UA_RelativePath out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RelativePath_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RelativePath_elements", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RelativePath_elements");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.elements = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_RELATIVEPATHELEMENT]);
		if (out.elements == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.elements[i] = XS_unpack_UA_RelativePathElement(*svp);
			}
		}
		out.elementsSize = i;
	}

	return out;
}
#endif

/* BrowsePath */
#ifdef UA_TYPES_BROWSEPATH

static void XS_pack_UA_BrowsePath(SV *out, UA_BrowsePath in)  __attribute__((unused));
static void
XS_pack_UA_BrowsePath(SV *out, UA_BrowsePath in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.startingNode);
	hv_stores(hv, "BrowsePath_startingNode", sv);

	sv = newSV(0);
	XS_pack_UA_RelativePath(sv, in.relativePath);
	hv_stores(hv, "BrowsePath_relativePath", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowsePath XS_unpack_UA_BrowsePath(SV *in)  __attribute__((unused));
static UA_BrowsePath
XS_unpack_UA_BrowsePath(SV *in)
{
	dTHX;
	UA_BrowsePath out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowsePath_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowsePath_startingNode", 0);
	if (svp != NULL)
		out.startingNode = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "BrowsePath_relativePath", 0);
	if (svp != NULL)
		out.relativePath = XS_unpack_UA_RelativePath(*svp);

	return out;
}
#endif

/* BrowsePathTarget */
#ifdef UA_TYPES_BROWSEPATHTARGET

static void XS_pack_UA_BrowsePathTarget(SV *out, UA_BrowsePathTarget in)  __attribute__((unused));
static void
XS_pack_UA_BrowsePathTarget(SV *out, UA_BrowsePathTarget in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.targetId);
	hv_stores(hv, "BrowsePathTarget_targetId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.remainingPathIndex);
	hv_stores(hv, "BrowsePathTarget_remainingPathIndex", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowsePathTarget XS_unpack_UA_BrowsePathTarget(SV *in)  __attribute__((unused));
static UA_BrowsePathTarget
XS_unpack_UA_BrowsePathTarget(SV *in)
{
	dTHX;
	UA_BrowsePathTarget out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowsePathTarget_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowsePathTarget_targetId", 0);
	if (svp != NULL)
		out.targetId = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "BrowsePathTarget_remainingPathIndex", 0);
	if (svp != NULL)
		out.remainingPathIndex = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* BrowsePathResult */
#ifdef UA_TYPES_BROWSEPATHRESULT

static void XS_pack_UA_BrowsePathResult(SV *out, UA_BrowsePathResult in)  __attribute__((unused));
static void
XS_pack_UA_BrowsePathResult(SV *out, UA_BrowsePathResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "BrowsePathResult_statusCode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.targetsSize);
	for (i = 0; i < in.targetsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_BrowsePathTarget(sv, in.targets[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "BrowsePathResult_targets", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BrowsePathResult XS_unpack_UA_BrowsePathResult(SV *in)  __attribute__((unused));
static UA_BrowsePathResult
XS_unpack_UA_BrowsePathResult(SV *in)
{
	dTHX;
	UA_BrowsePathResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BrowsePathResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BrowsePathResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "BrowsePathResult_targets", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for BrowsePathResult_targets");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.targets = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BROWSEPATHTARGET]);
		if (out.targets == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.targets[i] = XS_unpack_UA_BrowsePathTarget(*svp);
			}
		}
		out.targetsSize = i;
	}

	return out;
}
#endif

/* TranslateBrowsePathsToNodeIdsRequest */
#ifdef UA_TYPES_TRANSLATEBROWSEPATHSTONODEIDSREQUEST

static void XS_pack_UA_TranslateBrowsePathsToNodeIdsRequest(SV *out, UA_TranslateBrowsePathsToNodeIdsRequest in)  __attribute__((unused));
static void
XS_pack_UA_TranslateBrowsePathsToNodeIdsRequest(SV *out, UA_TranslateBrowsePathsToNodeIdsRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "TranslateBrowsePathsToNodeIdsRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.browsePathsSize);
	for (i = 0; i < in.browsePathsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_BrowsePath(sv, in.browsePaths[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TranslateBrowsePathsToNodeIdsRequest_browsePaths", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TranslateBrowsePathsToNodeIdsRequest XS_unpack_UA_TranslateBrowsePathsToNodeIdsRequest(SV *in)  __attribute__((unused));
static UA_TranslateBrowsePathsToNodeIdsRequest
XS_unpack_UA_TranslateBrowsePathsToNodeIdsRequest(SV *in)
{
	dTHX;
	UA_TranslateBrowsePathsToNodeIdsRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TranslateBrowsePathsToNodeIdsRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TranslateBrowsePathsToNodeIdsRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "TranslateBrowsePathsToNodeIdsRequest_browsePaths", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TranslateBrowsePathsToNodeIdsRequest_browsePaths");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.browsePaths = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BROWSEPATH]);
		if (out.browsePaths == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.browsePaths[i] = XS_unpack_UA_BrowsePath(*svp);
			}
		}
		out.browsePathsSize = i;
	}

	return out;
}
#endif

/* TranslateBrowsePathsToNodeIdsResponse */
#ifdef UA_TYPES_TRANSLATEBROWSEPATHSTONODEIDSRESPONSE

static void XS_pack_UA_TranslateBrowsePathsToNodeIdsResponse(SV *out, UA_TranslateBrowsePathsToNodeIdsResponse in)  __attribute__((unused));
static void
XS_pack_UA_TranslateBrowsePathsToNodeIdsResponse(SV *out, UA_TranslateBrowsePathsToNodeIdsResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "TranslateBrowsePathsToNodeIdsResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_BrowsePathResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TranslateBrowsePathsToNodeIdsResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TranslateBrowsePathsToNodeIdsResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TranslateBrowsePathsToNodeIdsResponse XS_unpack_UA_TranslateBrowsePathsToNodeIdsResponse(SV *in)  __attribute__((unused));
static UA_TranslateBrowsePathsToNodeIdsResponse
XS_unpack_UA_TranslateBrowsePathsToNodeIdsResponse(SV *in)
{
	dTHX;
	UA_TranslateBrowsePathsToNodeIdsResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TranslateBrowsePathsToNodeIdsResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TranslateBrowsePathsToNodeIdsResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "TranslateBrowsePathsToNodeIdsResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TranslateBrowsePathsToNodeIdsResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BROWSEPATHRESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_BrowsePathResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "TranslateBrowsePathsToNodeIdsResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TranslateBrowsePathsToNodeIdsResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* RegisterNodesRequest */
#ifdef UA_TYPES_REGISTERNODESREQUEST

static void XS_pack_UA_RegisterNodesRequest(SV *out, UA_RegisterNodesRequest in)  __attribute__((unused));
static void
XS_pack_UA_RegisterNodesRequest(SV *out, UA_RegisterNodesRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "RegisterNodesRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToRegisterSize);
	for (i = 0; i < in.nodesToRegisterSize; i++) {
		sv = newSV(0);
		XS_pack_UA_NodeId(sv, in.nodesToRegister[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RegisterNodesRequest_nodesToRegister", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RegisterNodesRequest XS_unpack_UA_RegisterNodesRequest(SV *in)  __attribute__((unused));
static UA_RegisterNodesRequest
XS_unpack_UA_RegisterNodesRequest(SV *in)
{
	dTHX;
	UA_RegisterNodesRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RegisterNodesRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RegisterNodesRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "RegisterNodesRequest_nodesToRegister", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RegisterNodesRequest_nodesToRegister");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToRegister = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_NODEID]);
		if (out.nodesToRegister == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToRegister[i] = XS_unpack_UA_NodeId(*svp);
			}
		}
		out.nodesToRegisterSize = i;
	}

	return out;
}
#endif

/* RegisterNodesResponse */
#ifdef UA_TYPES_REGISTERNODESRESPONSE

static void XS_pack_UA_RegisterNodesResponse(SV *out, UA_RegisterNodesResponse in)  __attribute__((unused));
static void
XS_pack_UA_RegisterNodesResponse(SV *out, UA_RegisterNodesResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "RegisterNodesResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.registeredNodeIdsSize);
	for (i = 0; i < in.registeredNodeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_NodeId(sv, in.registeredNodeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "RegisterNodesResponse_registeredNodeIds", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RegisterNodesResponse XS_unpack_UA_RegisterNodesResponse(SV *in)  __attribute__((unused));
static UA_RegisterNodesResponse
XS_unpack_UA_RegisterNodesResponse(SV *in)
{
	dTHX;
	UA_RegisterNodesResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RegisterNodesResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RegisterNodesResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "RegisterNodesResponse_registeredNodeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for RegisterNodesResponse_registeredNodeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.registeredNodeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_NODEID]);
		if (out.registeredNodeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.registeredNodeIds[i] = XS_unpack_UA_NodeId(*svp);
			}
		}
		out.registeredNodeIdsSize = i;
	}

	return out;
}
#endif

/* UnregisterNodesRequest */
#ifdef UA_TYPES_UNREGISTERNODESREQUEST

static void XS_pack_UA_UnregisterNodesRequest(SV *out, UA_UnregisterNodesRequest in)  __attribute__((unused));
static void
XS_pack_UA_UnregisterNodesRequest(SV *out, UA_UnregisterNodesRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "UnregisterNodesRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToUnregisterSize);
	for (i = 0; i < in.nodesToUnregisterSize; i++) {
		sv = newSV(0);
		XS_pack_UA_NodeId(sv, in.nodesToUnregister[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UnregisterNodesRequest_nodesToUnregister", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UnregisterNodesRequest XS_unpack_UA_UnregisterNodesRequest(SV *in)  __attribute__((unused));
static UA_UnregisterNodesRequest
XS_unpack_UA_UnregisterNodesRequest(SV *in)
{
	dTHX;
	UA_UnregisterNodesRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UnregisterNodesRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UnregisterNodesRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "UnregisterNodesRequest_nodesToUnregister", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UnregisterNodesRequest_nodesToUnregister");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToUnregister = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_NODEID]);
		if (out.nodesToUnregister == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToUnregister[i] = XS_unpack_UA_NodeId(*svp);
			}
		}
		out.nodesToUnregisterSize = i;
	}

	return out;
}
#endif

/* UnregisterNodesResponse */
#ifdef UA_TYPES_UNREGISTERNODESRESPONSE

static void XS_pack_UA_UnregisterNodesResponse(SV *out, UA_UnregisterNodesResponse in)  __attribute__((unused));
static void
XS_pack_UA_UnregisterNodesResponse(SV *out, UA_UnregisterNodesResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "UnregisterNodesResponse_responseHeader", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UnregisterNodesResponse XS_unpack_UA_UnregisterNodesResponse(SV *in)  __attribute__((unused));
static UA_UnregisterNodesResponse
XS_unpack_UA_UnregisterNodesResponse(SV *in)
{
	dTHX;
	UA_UnregisterNodesResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UnregisterNodesResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UnregisterNodesResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	return out;
}
#endif

/* Counter */
#ifdef UA_TYPES_COUNTER

static void XS_pack_UA_Counter(SV *out, UA_Counter in)  __attribute__((unused));
static void
XS_pack_UA_Counter(SV *out, UA_Counter in)
{
	dTHX;
	XS_pack_UA_UInt32(out, in);
}

static UA_Counter XS_unpack_UA_Counter(SV *in)  __attribute__((unused));
static UA_Counter
XS_unpack_UA_Counter(SV *in)
{
	dTHX;
	return XS_unpack_UA_UInt32(in);
}
#endif

/* Time */
#ifdef UA_TYPES_TIME

static void XS_pack_UA_Time(SV *out, UA_Time in)  __attribute__((unused));
static void
XS_pack_UA_Time(SV *out, UA_Time in)
{
	dTHX;
	XS_pack_UA_String(out, in);
}

static UA_Time XS_unpack_UA_Time(SV *in)  __attribute__((unused));
static UA_Time
XS_unpack_UA_Time(SV *in)
{
	dTHX;
	return XS_unpack_UA_String(in);
}
#endif

/* Date */
#ifdef UA_TYPES_DATE

static void XS_pack_UA_Date(SV *out, UA_Date in)  __attribute__((unused));
static void
XS_pack_UA_Date(SV *out, UA_Date in)
{
	dTHX;
	XS_pack_UA_DateTime(out, in);
}

static UA_Date XS_unpack_UA_Date(SV *in)  __attribute__((unused));
static UA_Date
XS_unpack_UA_Date(SV *in)
{
	dTHX;
	return XS_unpack_UA_DateTime(in);
}
#endif

/* EndpointConfiguration */
#ifdef UA_TYPES_ENDPOINTCONFIGURATION

static void XS_pack_UA_EndpointConfiguration(SV *out, UA_EndpointConfiguration in)  __attribute__((unused));
static void
XS_pack_UA_EndpointConfiguration(SV *out, UA_EndpointConfiguration in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.operationTimeout);
	hv_stores(hv, "EndpointConfiguration_operationTimeout", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.useBinaryEncoding);
	hv_stores(hv, "EndpointConfiguration_useBinaryEncoding", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.maxStringLength);
	hv_stores(hv, "EndpointConfiguration_maxStringLength", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.maxByteStringLength);
	hv_stores(hv, "EndpointConfiguration_maxByteStringLength", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.maxArrayLength);
	hv_stores(hv, "EndpointConfiguration_maxArrayLength", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.maxMessageSize);
	hv_stores(hv, "EndpointConfiguration_maxMessageSize", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.maxBufferSize);
	hv_stores(hv, "EndpointConfiguration_maxBufferSize", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.channelLifetime);
	hv_stores(hv, "EndpointConfiguration_channelLifetime", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.securityTokenLifetime);
	hv_stores(hv, "EndpointConfiguration_securityTokenLifetime", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EndpointConfiguration XS_unpack_UA_EndpointConfiguration(SV *in)  __attribute__((unused));
static UA_EndpointConfiguration
XS_unpack_UA_EndpointConfiguration(SV *in)
{
	dTHX;
	UA_EndpointConfiguration out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EndpointConfiguration_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EndpointConfiguration_operationTimeout", 0);
	if (svp != NULL)
		out.operationTimeout = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_useBinaryEncoding", 0);
	if (svp != NULL)
		out.useBinaryEncoding = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_maxStringLength", 0);
	if (svp != NULL)
		out.maxStringLength = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_maxByteStringLength", 0);
	if (svp != NULL)
		out.maxByteStringLength = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_maxArrayLength", 0);
	if (svp != NULL)
		out.maxArrayLength = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_maxMessageSize", 0);
	if (svp != NULL)
		out.maxMessageSize = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_maxBufferSize", 0);
	if (svp != NULL)
		out.maxBufferSize = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_channelLifetime", 0);
	if (svp != NULL)
		out.channelLifetime = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EndpointConfiguration_securityTokenLifetime", 0);
	if (svp != NULL)
		out.securityTokenLifetime = XS_unpack_UA_Int32(*svp);

	return out;
}
#endif

/* QueryDataDescription */
#ifdef UA_TYPES_QUERYDATADESCRIPTION

static void XS_pack_UA_QueryDataDescription(SV *out, UA_QueryDataDescription in)  __attribute__((unused));
static void
XS_pack_UA_QueryDataDescription(SV *out, UA_QueryDataDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RelativePath(sv, in.relativePath);
	hv_stores(hv, "QueryDataDescription_relativePath", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "QueryDataDescription_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.indexRange);
	hv_stores(hv, "QueryDataDescription_indexRange", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_QueryDataDescription XS_unpack_UA_QueryDataDescription(SV *in)  __attribute__((unused));
static UA_QueryDataDescription
XS_unpack_UA_QueryDataDescription(SV *in)
{
	dTHX;
	UA_QueryDataDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_QueryDataDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "QueryDataDescription_relativePath", 0);
	if (svp != NULL)
		out.relativePath = XS_unpack_UA_RelativePath(*svp);

	svp = hv_fetchs(hv, "QueryDataDescription_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "QueryDataDescription_indexRange", 0);
	if (svp != NULL)
		out.indexRange = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* NodeTypeDescription */
#ifdef UA_TYPES_NODETYPEDESCRIPTION

static void XS_pack_UA_NodeTypeDescription(SV *out, UA_NodeTypeDescription in)  __attribute__((unused));
static void
XS_pack_UA_NodeTypeDescription(SV *out, UA_NodeTypeDescription in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.typeDefinitionNode);
	hv_stores(hv, "NodeTypeDescription_typeDefinitionNode", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.includeSubTypes);
	hv_stores(hv, "NodeTypeDescription_includeSubTypes", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataToReturnSize);
	for (i = 0; i < in.dataToReturnSize; i++) {
		sv = newSV(0);
		XS_pack_UA_QueryDataDescription(sv, in.dataToReturn[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "NodeTypeDescription_dataToReturn", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_NodeTypeDescription XS_unpack_UA_NodeTypeDescription(SV *in)  __attribute__((unused));
static UA_NodeTypeDescription
XS_unpack_UA_NodeTypeDescription(SV *in)
{
	dTHX;
	UA_NodeTypeDescription out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_NodeTypeDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "NodeTypeDescription_typeDefinitionNode", 0);
	if (svp != NULL)
		out.typeDefinitionNode = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "NodeTypeDescription_includeSubTypes", 0);
	if (svp != NULL)
		out.includeSubTypes = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "NodeTypeDescription_dataToReturn", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for NodeTypeDescription_dataToReturn");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataToReturn = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_QUERYDATADESCRIPTION]);
		if (out.dataToReturn == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataToReturn[i] = XS_unpack_UA_QueryDataDescription(*svp);
			}
		}
		out.dataToReturnSize = i;
	}

	return out;
}
#endif

/* FilterOperator */
#ifdef UA_TYPES_FILTEROPERATOR

static void XS_pack_UA_FilterOperator(SV *out, UA_FilterOperator in)  __attribute__((unused));
static void
XS_pack_UA_FilterOperator(SV *out, UA_FilterOperator in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_FilterOperator XS_unpack_UA_FilterOperator(SV *in)  __attribute__((unused));
static UA_FilterOperator
XS_unpack_UA_FilterOperator(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* QueryDataSet */
#ifdef UA_TYPES_QUERYDATASET

static void XS_pack_UA_QueryDataSet(SV *out, UA_QueryDataSet in)  __attribute__((unused));
static void
XS_pack_UA_QueryDataSet(SV *out, UA_QueryDataSet in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.nodeId);
	hv_stores(hv, "QueryDataSet_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_ExpandedNodeId(sv, in.typeDefinitionNode);
	hv_stores(hv, "QueryDataSet_typeDefinitionNode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.valuesSize);
	for (i = 0; i < in.valuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Variant(sv, in.values[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "QueryDataSet_values", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_QueryDataSet XS_unpack_UA_QueryDataSet(SV *in)  __attribute__((unused));
static UA_QueryDataSet
XS_unpack_UA_QueryDataSet(SV *in)
{
	dTHX;
	UA_QueryDataSet out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_QueryDataSet_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "QueryDataSet_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "QueryDataSet_typeDefinitionNode", 0);
	if (svp != NULL)
		out.typeDefinitionNode = XS_unpack_UA_ExpandedNodeId(*svp);

	svp = hv_fetchs(hv, "QueryDataSet_values", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for QueryDataSet_values");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.values = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_VARIANT]);
		if (out.values == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.values[i] = XS_unpack_UA_Variant(*svp);
			}
		}
		out.valuesSize = i;
	}

	return out;
}
#endif

/* NodeReference */
#ifdef UA_TYPES_NODEREFERENCE

static void XS_pack_UA_NodeReference(SV *out, UA_NodeReference in)  __attribute__((unused));
static void
XS_pack_UA_NodeReference(SV *out, UA_NodeReference in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "NodeReference_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.referenceTypeId);
	hv_stores(hv, "NodeReference_referenceTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isForward);
	hv_stores(hv, "NodeReference_isForward", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.referencedNodeIdsSize);
	for (i = 0; i < in.referencedNodeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_NodeId(sv, in.referencedNodeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "NodeReference_referencedNodeIds", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_NodeReference XS_unpack_UA_NodeReference(SV *in)  __attribute__((unused));
static UA_NodeReference
XS_unpack_UA_NodeReference(SV *in)
{
	dTHX;
	UA_NodeReference out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_NodeReference_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "NodeReference_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "NodeReference_referenceTypeId", 0);
	if (svp != NULL)
		out.referenceTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "NodeReference_isForward", 0);
	if (svp != NULL)
		out.isForward = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "NodeReference_referencedNodeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for NodeReference_referencedNodeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.referencedNodeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_NODEID]);
		if (out.referencedNodeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.referencedNodeIds[i] = XS_unpack_UA_NodeId(*svp);
			}
		}
		out.referencedNodeIdsSize = i;
	}

	return out;
}
#endif

/* ContentFilterElement */
#ifdef UA_TYPES_CONTENTFILTERELEMENT

static void XS_pack_UA_ContentFilterElement(SV *out, UA_ContentFilterElement in)  __attribute__((unused));
static void
XS_pack_UA_ContentFilterElement(SV *out, UA_ContentFilterElement in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_FilterOperator(sv, in.filterOperator);
	hv_stores(hv, "ContentFilterElement_filterOperator", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.filterOperandsSize);
	for (i = 0; i < in.filterOperandsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ExtensionObject(sv, in.filterOperands[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ContentFilterElement_filterOperands", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ContentFilterElement XS_unpack_UA_ContentFilterElement(SV *in)  __attribute__((unused));
static UA_ContentFilterElement
XS_unpack_UA_ContentFilterElement(SV *in)
{
	dTHX;
	UA_ContentFilterElement out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ContentFilterElement_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ContentFilterElement_filterOperator", 0);
	if (svp != NULL)
		out.filterOperator = XS_unpack_UA_FilterOperator(*svp);

	svp = hv_fetchs(hv, "ContentFilterElement_filterOperands", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ContentFilterElement_filterOperands");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.filterOperands = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_EXTENSIONOBJECT]);
		if (out.filterOperands == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.filterOperands[i] = XS_unpack_UA_ExtensionObject(*svp);
			}
		}
		out.filterOperandsSize = i;
	}

	return out;
}
#endif

/* ContentFilter */
#ifdef UA_TYPES_CONTENTFILTER

static void XS_pack_UA_ContentFilter(SV *out, UA_ContentFilter in)  __attribute__((unused));
static void
XS_pack_UA_ContentFilter(SV *out, UA_ContentFilter in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.elementsSize);
	for (i = 0; i < in.elementsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ContentFilterElement(sv, in.elements[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ContentFilter_elements", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ContentFilter XS_unpack_UA_ContentFilter(SV *in)  __attribute__((unused));
static UA_ContentFilter
XS_unpack_UA_ContentFilter(SV *in)
{
	dTHX;
	UA_ContentFilter out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ContentFilter_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ContentFilter_elements", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ContentFilter_elements");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.elements = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_CONTENTFILTERELEMENT]);
		if (out.elements == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.elements[i] = XS_unpack_UA_ContentFilterElement(*svp);
			}
		}
		out.elementsSize = i;
	}

	return out;
}
#endif

/* FilterOperand */
#ifdef UA_TYPES_FILTEROPERAND

static void XS_pack_UA_FilterOperand(SV *out, UA_FilterOperand in)  __attribute__((unused));
static void
XS_pack_UA_FilterOperand(SV *out, UA_FilterOperand in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_FilterOperand XS_unpack_UA_FilterOperand(SV *in)  __attribute__((unused));
static UA_FilterOperand
XS_unpack_UA_FilterOperand(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ElementOperand */
#ifdef UA_TYPES_ELEMENTOPERAND

static void XS_pack_UA_ElementOperand(SV *out, UA_ElementOperand in)  __attribute__((unused));
static void
XS_pack_UA_ElementOperand(SV *out, UA_ElementOperand in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.index);
	hv_stores(hv, "ElementOperand_index", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ElementOperand XS_unpack_UA_ElementOperand(SV *in)  __attribute__((unused));
static UA_ElementOperand
XS_unpack_UA_ElementOperand(SV *in)
{
	dTHX;
	UA_ElementOperand out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ElementOperand_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ElementOperand_index", 0);
	if (svp != NULL)
		out.index = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* LiteralOperand */
#ifdef UA_TYPES_LITERALOPERAND

static void XS_pack_UA_LiteralOperand(SV *out, UA_LiteralOperand in)  __attribute__((unused));
static void
XS_pack_UA_LiteralOperand(SV *out, UA_LiteralOperand in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.value);
	hv_stores(hv, "LiteralOperand_value", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_LiteralOperand XS_unpack_UA_LiteralOperand(SV *in)  __attribute__((unused));
static UA_LiteralOperand
XS_unpack_UA_LiteralOperand(SV *in)
{
	dTHX;
	UA_LiteralOperand out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_LiteralOperand_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "LiteralOperand_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Variant(*svp);

	return out;
}
#endif

/* AttributeOperand */
#ifdef UA_TYPES_ATTRIBUTEOPERAND

static void XS_pack_UA_AttributeOperand(SV *out, UA_AttributeOperand in)  __attribute__((unused));
static void
XS_pack_UA_AttributeOperand(SV *out, UA_AttributeOperand in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "AttributeOperand_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.alias);
	hv_stores(hv, "AttributeOperand_alias", sv);

	sv = newSV(0);
	XS_pack_UA_RelativePath(sv, in.browsePath);
	hv_stores(hv, "AttributeOperand_browsePath", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "AttributeOperand_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.indexRange);
	hv_stores(hv, "AttributeOperand_indexRange", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AttributeOperand XS_unpack_UA_AttributeOperand(SV *in)  __attribute__((unused));
static UA_AttributeOperand
XS_unpack_UA_AttributeOperand(SV *in)
{
	dTHX;
	UA_AttributeOperand out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AttributeOperand_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AttributeOperand_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "AttributeOperand_alias", 0);
	if (svp != NULL)
		out.alias = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "AttributeOperand_browsePath", 0);
	if (svp != NULL)
		out.browsePath = XS_unpack_UA_RelativePath(*svp);

	svp = hv_fetchs(hv, "AttributeOperand_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "AttributeOperand_indexRange", 0);
	if (svp != NULL)
		out.indexRange = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* SimpleAttributeOperand */
#ifdef UA_TYPES_SIMPLEATTRIBUTEOPERAND

static void XS_pack_UA_SimpleAttributeOperand(SV *out, UA_SimpleAttributeOperand in)  __attribute__((unused));
static void
XS_pack_UA_SimpleAttributeOperand(SV *out, UA_SimpleAttributeOperand in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.typeDefinitionId);
	hv_stores(hv, "SimpleAttributeOperand_typeDefinitionId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.browsePathSize);
	for (i = 0; i < in.browsePathSize; i++) {
		sv = newSV(0);
		XS_pack_UA_QualifiedName(sv, in.browsePath[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SimpleAttributeOperand_browsePath", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "SimpleAttributeOperand_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.indexRange);
	hv_stores(hv, "SimpleAttributeOperand_indexRange", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SimpleAttributeOperand XS_unpack_UA_SimpleAttributeOperand(SV *in)  __attribute__((unused));
static UA_SimpleAttributeOperand
XS_unpack_UA_SimpleAttributeOperand(SV *in)
{
	dTHX;
	UA_SimpleAttributeOperand out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SimpleAttributeOperand_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SimpleAttributeOperand_typeDefinitionId", 0);
	if (svp != NULL)
		out.typeDefinitionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "SimpleAttributeOperand_browsePath", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SimpleAttributeOperand_browsePath");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.browsePath = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_QUALIFIEDNAME]);
		if (out.browsePath == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.browsePath[i] = XS_unpack_UA_QualifiedName(*svp);
			}
		}
		out.browsePathSize = i;
	}

	svp = hv_fetchs(hv, "SimpleAttributeOperand_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SimpleAttributeOperand_indexRange", 0);
	if (svp != NULL)
		out.indexRange = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* ContentFilterElementResult */
#ifdef UA_TYPES_CONTENTFILTERELEMENTRESULT

static void XS_pack_UA_ContentFilterElementResult(SV *out, UA_ContentFilterElementResult in)  __attribute__((unused));
static void
XS_pack_UA_ContentFilterElementResult(SV *out, UA_ContentFilterElementResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "ContentFilterElementResult_statusCode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.operandStatusCodesSize);
	for (i = 0; i < in.operandStatusCodesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.operandStatusCodes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ContentFilterElementResult_operandStatusCodes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.operandDiagnosticInfosSize);
	for (i = 0; i < in.operandDiagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.operandDiagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ContentFilterElementResult_operandDiagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ContentFilterElementResult XS_unpack_UA_ContentFilterElementResult(SV *in)  __attribute__((unused));
static UA_ContentFilterElementResult
XS_unpack_UA_ContentFilterElementResult(SV *in)
{
	dTHX;
	UA_ContentFilterElementResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ContentFilterElementResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ContentFilterElementResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "ContentFilterElementResult_operandStatusCodes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ContentFilterElementResult_operandStatusCodes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.operandStatusCodes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.operandStatusCodes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.operandStatusCodes[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.operandStatusCodesSize = i;
	}

	svp = hv_fetchs(hv, "ContentFilterElementResult_operandDiagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ContentFilterElementResult_operandDiagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.operandDiagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.operandDiagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.operandDiagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.operandDiagnosticInfosSize = i;
	}

	return out;
}
#endif

/* ContentFilterResult */
#ifdef UA_TYPES_CONTENTFILTERRESULT

static void XS_pack_UA_ContentFilterResult(SV *out, UA_ContentFilterResult in)  __attribute__((unused));
static void
XS_pack_UA_ContentFilterResult(SV *out, UA_ContentFilterResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.elementResultsSize);
	for (i = 0; i < in.elementResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ContentFilterElementResult(sv, in.elementResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ContentFilterResult_elementResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.elementDiagnosticInfosSize);
	for (i = 0; i < in.elementDiagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.elementDiagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ContentFilterResult_elementDiagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ContentFilterResult XS_unpack_UA_ContentFilterResult(SV *in)  __attribute__((unused));
static UA_ContentFilterResult
XS_unpack_UA_ContentFilterResult(SV *in)
{
	dTHX;
	UA_ContentFilterResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ContentFilterResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ContentFilterResult_elementResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ContentFilterResult_elementResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.elementResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_CONTENTFILTERELEMENTRESULT]);
		if (out.elementResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.elementResults[i] = XS_unpack_UA_ContentFilterElementResult(*svp);
			}
		}
		out.elementResultsSize = i;
	}

	svp = hv_fetchs(hv, "ContentFilterResult_elementDiagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ContentFilterResult_elementDiagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.elementDiagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.elementDiagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.elementDiagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.elementDiagnosticInfosSize = i;
	}

	return out;
}
#endif

/* ParsingResult */
#ifdef UA_TYPES_PARSINGRESULT

static void XS_pack_UA_ParsingResult(SV *out, UA_ParsingResult in)  __attribute__((unused));
static void
XS_pack_UA_ParsingResult(SV *out, UA_ParsingResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "ParsingResult_statusCode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataStatusCodesSize);
	for (i = 0; i < in.dataStatusCodesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.dataStatusCodes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ParsingResult_dataStatusCodes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataDiagnosticInfosSize);
	for (i = 0; i < in.dataDiagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.dataDiagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ParsingResult_dataDiagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ParsingResult XS_unpack_UA_ParsingResult(SV *in)  __attribute__((unused));
static UA_ParsingResult
XS_unpack_UA_ParsingResult(SV *in)
{
	dTHX;
	UA_ParsingResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ParsingResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ParsingResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "ParsingResult_dataStatusCodes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ParsingResult_dataStatusCodes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataStatusCodes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.dataStatusCodes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataStatusCodes[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.dataStatusCodesSize = i;
	}

	svp = hv_fetchs(hv, "ParsingResult_dataDiagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ParsingResult_dataDiagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataDiagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.dataDiagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataDiagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.dataDiagnosticInfosSize = i;
	}

	return out;
}
#endif

/* QueryFirstRequest */
#ifdef UA_TYPES_QUERYFIRSTREQUEST

static void XS_pack_UA_QueryFirstRequest(SV *out, UA_QueryFirstRequest in)  __attribute__((unused));
static void
XS_pack_UA_QueryFirstRequest(SV *out, UA_QueryFirstRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "QueryFirstRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_ViewDescription(sv, in.view);
	hv_stores(hv, "QueryFirstRequest_view", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodeTypesSize);
	for (i = 0; i < in.nodeTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_NodeTypeDescription(sv, in.nodeTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "QueryFirstRequest_nodeTypes", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ContentFilter(sv, in.filter);
	hv_stores(hv, "QueryFirstRequest_filter", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxDataSetsToReturn);
	hv_stores(hv, "QueryFirstRequest_maxDataSetsToReturn", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxReferencesToReturn);
	hv_stores(hv, "QueryFirstRequest_maxReferencesToReturn", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_QueryFirstRequest XS_unpack_UA_QueryFirstRequest(SV *in)  __attribute__((unused));
static UA_QueryFirstRequest
XS_unpack_UA_QueryFirstRequest(SV *in)
{
	dTHX;
	UA_QueryFirstRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_QueryFirstRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "QueryFirstRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "QueryFirstRequest_view", 0);
	if (svp != NULL)
		out.view = XS_unpack_UA_ViewDescription(*svp);

	svp = hv_fetchs(hv, "QueryFirstRequest_nodeTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for QueryFirstRequest_nodeTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodeTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_NODETYPEDESCRIPTION]);
		if (out.nodeTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodeTypes[i] = XS_unpack_UA_NodeTypeDescription(*svp);
			}
		}
		out.nodeTypesSize = i;
	}

	svp = hv_fetchs(hv, "QueryFirstRequest_filter", 0);
	if (svp != NULL)
		out.filter = XS_unpack_UA_ContentFilter(*svp);

	svp = hv_fetchs(hv, "QueryFirstRequest_maxDataSetsToReturn", 0);
	if (svp != NULL)
		out.maxDataSetsToReturn = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "QueryFirstRequest_maxReferencesToReturn", 0);
	if (svp != NULL)
		out.maxReferencesToReturn = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* QueryFirstResponse */
#ifdef UA_TYPES_QUERYFIRSTRESPONSE

static void XS_pack_UA_QueryFirstResponse(SV *out, UA_QueryFirstResponse in)  __attribute__((unused));
static void
XS_pack_UA_QueryFirstResponse(SV *out, UA_QueryFirstResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "QueryFirstResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.queryDataSetsSize);
	for (i = 0; i < in.queryDataSetsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_QueryDataSet(sv, in.queryDataSets[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "QueryFirstResponse_queryDataSets", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.continuationPoint);
	hv_stores(hv, "QueryFirstResponse_continuationPoint", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.parsingResultsSize);
	for (i = 0; i < in.parsingResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ParsingResult(sv, in.parsingResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "QueryFirstResponse_parsingResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "QueryFirstResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ContentFilterResult(sv, in.filterResult);
	hv_stores(hv, "QueryFirstResponse_filterResult", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_QueryFirstResponse XS_unpack_UA_QueryFirstResponse(SV *in)  __attribute__((unused));
static UA_QueryFirstResponse
XS_unpack_UA_QueryFirstResponse(SV *in)
{
	dTHX;
	UA_QueryFirstResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_QueryFirstResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "QueryFirstResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "QueryFirstResponse_queryDataSets", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for QueryFirstResponse_queryDataSets");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.queryDataSets = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_QUERYDATASET]);
		if (out.queryDataSets == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.queryDataSets[i] = XS_unpack_UA_QueryDataSet(*svp);
			}
		}
		out.queryDataSetsSize = i;
	}

	svp = hv_fetchs(hv, "QueryFirstResponse_continuationPoint", 0);
	if (svp != NULL)
		out.continuationPoint = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "QueryFirstResponse_parsingResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for QueryFirstResponse_parsingResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.parsingResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_PARSINGRESULT]);
		if (out.parsingResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.parsingResults[i] = XS_unpack_UA_ParsingResult(*svp);
			}
		}
		out.parsingResultsSize = i;
	}

	svp = hv_fetchs(hv, "QueryFirstResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for QueryFirstResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	svp = hv_fetchs(hv, "QueryFirstResponse_filterResult", 0);
	if (svp != NULL)
		out.filterResult = XS_unpack_UA_ContentFilterResult(*svp);

	return out;
}
#endif

/* QueryNextRequest */
#ifdef UA_TYPES_QUERYNEXTREQUEST

static void XS_pack_UA_QueryNextRequest(SV *out, UA_QueryNextRequest in)  __attribute__((unused));
static void
XS_pack_UA_QueryNextRequest(SV *out, UA_QueryNextRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "QueryNextRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.releaseContinuationPoint);
	hv_stores(hv, "QueryNextRequest_releaseContinuationPoint", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.continuationPoint);
	hv_stores(hv, "QueryNextRequest_continuationPoint", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_QueryNextRequest XS_unpack_UA_QueryNextRequest(SV *in)  __attribute__((unused));
static UA_QueryNextRequest
XS_unpack_UA_QueryNextRequest(SV *in)
{
	dTHX;
	UA_QueryNextRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_QueryNextRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "QueryNextRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "QueryNextRequest_releaseContinuationPoint", 0);
	if (svp != NULL)
		out.releaseContinuationPoint = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "QueryNextRequest_continuationPoint", 0);
	if (svp != NULL)
		out.continuationPoint = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* QueryNextResponse */
#ifdef UA_TYPES_QUERYNEXTRESPONSE

static void XS_pack_UA_QueryNextResponse(SV *out, UA_QueryNextResponse in)  __attribute__((unused));
static void
XS_pack_UA_QueryNextResponse(SV *out, UA_QueryNextResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "QueryNextResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.queryDataSetsSize);
	for (i = 0; i < in.queryDataSetsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_QueryDataSet(sv, in.queryDataSets[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "QueryNextResponse_queryDataSets", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.revisedContinuationPoint);
	hv_stores(hv, "QueryNextResponse_revisedContinuationPoint", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_QueryNextResponse XS_unpack_UA_QueryNextResponse(SV *in)  __attribute__((unused));
static UA_QueryNextResponse
XS_unpack_UA_QueryNextResponse(SV *in)
{
	dTHX;
	UA_QueryNextResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_QueryNextResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "QueryNextResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "QueryNextResponse_queryDataSets", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for QueryNextResponse_queryDataSets");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.queryDataSets = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_QUERYDATASET]);
		if (out.queryDataSets == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.queryDataSets[i] = XS_unpack_UA_QueryDataSet(*svp);
			}
		}
		out.queryDataSetsSize = i;
	}

	svp = hv_fetchs(hv, "QueryNextResponse_revisedContinuationPoint", 0);
	if (svp != NULL)
		out.revisedContinuationPoint = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* TimestampsToReturn */
#ifdef UA_TYPES_TIMESTAMPSTORETURN

static void XS_pack_UA_TimestampsToReturn(SV *out, UA_TimestampsToReturn in)  __attribute__((unused));
static void
XS_pack_UA_TimestampsToReturn(SV *out, UA_TimestampsToReturn in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_TimestampsToReturn XS_unpack_UA_TimestampsToReturn(SV *in)  __attribute__((unused));
static UA_TimestampsToReturn
XS_unpack_UA_TimestampsToReturn(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ReadValueId */
#ifdef UA_TYPES_READVALUEID

static void XS_pack_UA_ReadValueId(SV *out, UA_ReadValueId in)  __attribute__((unused));
static void
XS_pack_UA_ReadValueId(SV *out, UA_ReadValueId in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "ReadValueId_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "ReadValueId_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.indexRange);
	hv_stores(hv, "ReadValueId_indexRange", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.dataEncoding);
	hv_stores(hv, "ReadValueId_dataEncoding", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadValueId XS_unpack_UA_ReadValueId(SV *in)  __attribute__((unused));
static UA_ReadValueId
XS_unpack_UA_ReadValueId(SV *in)
{
	dTHX;
	UA_ReadValueId out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadValueId_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadValueId_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ReadValueId_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ReadValueId_indexRange", 0);
	if (svp != NULL)
		out.indexRange = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ReadValueId_dataEncoding", 0);
	if (svp != NULL)
		out.dataEncoding = XS_unpack_UA_QualifiedName(*svp);

	return out;
}
#endif

/* ReadRequest */
#ifdef UA_TYPES_READREQUEST

static void XS_pack_UA_ReadRequest(SV *out, UA_ReadRequest in)  __attribute__((unused));
static void
XS_pack_UA_ReadRequest(SV *out, UA_ReadRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "ReadRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.maxAge);
	hv_stores(hv, "ReadRequest_maxAge", sv);

	sv = newSV(0);
	XS_pack_UA_TimestampsToReturn(sv, in.timestampsToReturn);
	hv_stores(hv, "ReadRequest_timestampsToReturn", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToReadSize);
	for (i = 0; i < in.nodesToReadSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ReadValueId(sv, in.nodesToRead[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReadRequest_nodesToRead", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadRequest XS_unpack_UA_ReadRequest(SV *in)  __attribute__((unused));
static UA_ReadRequest
XS_unpack_UA_ReadRequest(SV *in)
{
	dTHX;
	UA_ReadRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "ReadRequest_maxAge", 0);
	if (svp != NULL)
		out.maxAge = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ReadRequest_timestampsToReturn", 0);
	if (svp != NULL)
		out.timestampsToReturn = XS_unpack_UA_TimestampsToReturn(*svp);

	svp = hv_fetchs(hv, "ReadRequest_nodesToRead", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReadRequest_nodesToRead");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToRead = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_READVALUEID]);
		if (out.nodesToRead == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToRead[i] = XS_unpack_UA_ReadValueId(*svp);
			}
		}
		out.nodesToReadSize = i;
	}

	return out;
}
#endif

/* ReadResponse */
#ifdef UA_TYPES_READRESPONSE

static void XS_pack_UA_ReadResponse(SV *out, UA_ReadResponse in)  __attribute__((unused));
static void
XS_pack_UA_ReadResponse(SV *out, UA_ReadResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "ReadResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DataValue(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReadResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReadResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadResponse XS_unpack_UA_ReadResponse(SV *in)  __attribute__((unused));
static UA_ReadResponse
XS_unpack_UA_ReadResponse(SV *in)
{
	dTHX;
	UA_ReadResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "ReadResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReadResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATAVALUE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_DataValue(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "ReadResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReadResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* HistoryReadValueId */
#ifdef UA_TYPES_HISTORYREADVALUEID

static void XS_pack_UA_HistoryReadValueId(SV *out, UA_HistoryReadValueId in)  __attribute__((unused));
static void
XS_pack_UA_HistoryReadValueId(SV *out, UA_HistoryReadValueId in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "HistoryReadValueId_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.indexRange);
	hv_stores(hv, "HistoryReadValueId_indexRange", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.dataEncoding);
	hv_stores(hv, "HistoryReadValueId_dataEncoding", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.continuationPoint);
	hv_stores(hv, "HistoryReadValueId_continuationPoint", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryReadValueId XS_unpack_UA_HistoryReadValueId(SV *in)  __attribute__((unused));
static UA_HistoryReadValueId
XS_unpack_UA_HistoryReadValueId(SV *in)
{
	dTHX;
	UA_HistoryReadValueId out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryReadValueId_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryReadValueId_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "HistoryReadValueId_indexRange", 0);
	if (svp != NULL)
		out.indexRange = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "HistoryReadValueId_dataEncoding", 0);
	if (svp != NULL)
		out.dataEncoding = XS_unpack_UA_QualifiedName(*svp);

	svp = hv_fetchs(hv, "HistoryReadValueId_continuationPoint", 0);
	if (svp != NULL)
		out.continuationPoint = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* HistoryReadResult */
#ifdef UA_TYPES_HISTORYREADRESULT

static void XS_pack_UA_HistoryReadResult(SV *out, UA_HistoryReadResult in)  __attribute__((unused));
static void
XS_pack_UA_HistoryReadResult(SV *out, UA_HistoryReadResult in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "HistoryReadResult_statusCode", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.continuationPoint);
	hv_stores(hv, "HistoryReadResult_continuationPoint", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.historyData);
	hv_stores(hv, "HistoryReadResult_historyData", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryReadResult XS_unpack_UA_HistoryReadResult(SV *in)  __attribute__((unused));
static UA_HistoryReadResult
XS_unpack_UA_HistoryReadResult(SV *in)
{
	dTHX;
	UA_HistoryReadResult out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryReadResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryReadResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "HistoryReadResult_continuationPoint", 0);
	if (svp != NULL)
		out.continuationPoint = XS_unpack_UA_ByteString(*svp);

	svp = hv_fetchs(hv, "HistoryReadResult_historyData", 0);
	if (svp != NULL)
		out.historyData = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* HistoryReadDetails */
#ifdef UA_TYPES_HISTORYREADDETAILS

static void XS_pack_UA_HistoryReadDetails(SV *out, UA_HistoryReadDetails in)  __attribute__((unused));
static void
XS_pack_UA_HistoryReadDetails(SV *out, UA_HistoryReadDetails in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_HistoryReadDetails XS_unpack_UA_HistoryReadDetails(SV *in)  __attribute__((unused));
static UA_HistoryReadDetails
XS_unpack_UA_HistoryReadDetails(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* ReadRawModifiedDetails */
#ifdef UA_TYPES_READRAWMODIFIEDDETAILS

static void XS_pack_UA_ReadRawModifiedDetails(SV *out, UA_ReadRawModifiedDetails in)  __attribute__((unused));
static void
XS_pack_UA_ReadRawModifiedDetails(SV *out, UA_ReadRawModifiedDetails in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isReadModified);
	hv_stores(hv, "ReadRawModifiedDetails_isReadModified", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.startTime);
	hv_stores(hv, "ReadRawModifiedDetails_startTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.endTime);
	hv_stores(hv, "ReadRawModifiedDetails_endTime", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.numValuesPerNode);
	hv_stores(hv, "ReadRawModifiedDetails_numValuesPerNode", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.returnBounds);
	hv_stores(hv, "ReadRawModifiedDetails_returnBounds", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadRawModifiedDetails XS_unpack_UA_ReadRawModifiedDetails(SV *in)  __attribute__((unused));
static UA_ReadRawModifiedDetails
XS_unpack_UA_ReadRawModifiedDetails(SV *in)
{
	dTHX;
	UA_ReadRawModifiedDetails out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadRawModifiedDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadRawModifiedDetails_isReadModified", 0);
	if (svp != NULL)
		out.isReadModified = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "ReadRawModifiedDetails_startTime", 0);
	if (svp != NULL)
		out.startTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ReadRawModifiedDetails_endTime", 0);
	if (svp != NULL)
		out.endTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ReadRawModifiedDetails_numValuesPerNode", 0);
	if (svp != NULL)
		out.numValuesPerNode = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ReadRawModifiedDetails_returnBounds", 0);
	if (svp != NULL)
		out.returnBounds = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* ReadAtTimeDetails */
#ifdef UA_TYPES_READATTIMEDETAILS

static void XS_pack_UA_ReadAtTimeDetails(SV *out, UA_ReadAtTimeDetails in)  __attribute__((unused));
static void
XS_pack_UA_ReadAtTimeDetails(SV *out, UA_ReadAtTimeDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.reqTimesSize);
	for (i = 0; i < in.reqTimesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DateTime(sv, in.reqTimes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReadAtTimeDetails_reqTimes", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.useSimpleBounds);
	hv_stores(hv, "ReadAtTimeDetails_useSimpleBounds", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadAtTimeDetails XS_unpack_UA_ReadAtTimeDetails(SV *in)  __attribute__((unused));
static UA_ReadAtTimeDetails
XS_unpack_UA_ReadAtTimeDetails(SV *in)
{
	dTHX;
	UA_ReadAtTimeDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadAtTimeDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadAtTimeDetails_reqTimes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReadAtTimeDetails_reqTimes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.reqTimes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATETIME]);
		if (out.reqTimes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.reqTimes[i] = XS_unpack_UA_DateTime(*svp);
			}
		}
		out.reqTimesSize = i;
	}

	svp = hv_fetchs(hv, "ReadAtTimeDetails_useSimpleBounds", 0);
	if (svp != NULL)
		out.useSimpleBounds = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* ReadAnnotationDataDetails */
#ifdef UA_TYPES_READANNOTATIONDATADETAILS

static void XS_pack_UA_ReadAnnotationDataDetails(SV *out, UA_ReadAnnotationDataDetails in)  __attribute__((unused));
static void
XS_pack_UA_ReadAnnotationDataDetails(SV *out, UA_ReadAnnotationDataDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.reqTimesSize);
	for (i = 0; i < in.reqTimesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DateTime(sv, in.reqTimes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReadAnnotationDataDetails_reqTimes", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadAnnotationDataDetails XS_unpack_UA_ReadAnnotationDataDetails(SV *in)  __attribute__((unused));
static UA_ReadAnnotationDataDetails
XS_unpack_UA_ReadAnnotationDataDetails(SV *in)
{
	dTHX;
	UA_ReadAnnotationDataDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadAnnotationDataDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadAnnotationDataDetails_reqTimes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReadAnnotationDataDetails_reqTimes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.reqTimes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATETIME]);
		if (out.reqTimes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.reqTimes[i] = XS_unpack_UA_DateTime(*svp);
			}
		}
		out.reqTimesSize = i;
	}

	return out;
}
#endif

/* HistoryData */
#ifdef UA_TYPES_HISTORYDATA

static void XS_pack_UA_HistoryData(SV *out, UA_HistoryData in)  __attribute__((unused));
static void
XS_pack_UA_HistoryData(SV *out, UA_HistoryData in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataValuesSize);
	for (i = 0; i < in.dataValuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DataValue(sv, in.dataValues[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryData_dataValues", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryData XS_unpack_UA_HistoryData(SV *in)  __attribute__((unused));
static UA_HistoryData
XS_unpack_UA_HistoryData(SV *in)
{
	dTHX;
	UA_HistoryData out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryData_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryData_dataValues", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryData_dataValues");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataValues = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATAVALUE]);
		if (out.dataValues == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataValues[i] = XS_unpack_UA_DataValue(*svp);
			}
		}
		out.dataValuesSize = i;
	}

	return out;
}
#endif

/* HistoryReadRequest */
#ifdef UA_TYPES_HISTORYREADREQUEST

static void XS_pack_UA_HistoryReadRequest(SV *out, UA_HistoryReadRequest in)  __attribute__((unused));
static void
XS_pack_UA_HistoryReadRequest(SV *out, UA_HistoryReadRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "HistoryReadRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.historyReadDetails);
	hv_stores(hv, "HistoryReadRequest_historyReadDetails", sv);

	sv = newSV(0);
	XS_pack_UA_TimestampsToReturn(sv, in.timestampsToReturn);
	hv_stores(hv, "HistoryReadRequest_timestampsToReturn", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.releaseContinuationPoints);
	hv_stores(hv, "HistoryReadRequest_releaseContinuationPoints", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToReadSize);
	for (i = 0; i < in.nodesToReadSize; i++) {
		sv = newSV(0);
		XS_pack_UA_HistoryReadValueId(sv, in.nodesToRead[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryReadRequest_nodesToRead", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryReadRequest XS_unpack_UA_HistoryReadRequest(SV *in)  __attribute__((unused));
static UA_HistoryReadRequest
XS_unpack_UA_HistoryReadRequest(SV *in)
{
	dTHX;
	UA_HistoryReadRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryReadRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryReadRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "HistoryReadRequest_historyReadDetails", 0);
	if (svp != NULL)
		out.historyReadDetails = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "HistoryReadRequest_timestampsToReturn", 0);
	if (svp != NULL)
		out.timestampsToReturn = XS_unpack_UA_TimestampsToReturn(*svp);

	svp = hv_fetchs(hv, "HistoryReadRequest_releaseContinuationPoints", 0);
	if (svp != NULL)
		out.releaseContinuationPoints = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "HistoryReadRequest_nodesToRead", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryReadRequest_nodesToRead");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToRead = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_HISTORYREADVALUEID]);
		if (out.nodesToRead == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToRead[i] = XS_unpack_UA_HistoryReadValueId(*svp);
			}
		}
		out.nodesToReadSize = i;
	}

	return out;
}
#endif

/* HistoryReadResponse */
#ifdef UA_TYPES_HISTORYREADRESPONSE

static void XS_pack_UA_HistoryReadResponse(SV *out, UA_HistoryReadResponse in)  __attribute__((unused));
static void
XS_pack_UA_HistoryReadResponse(SV *out, UA_HistoryReadResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "HistoryReadResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_HistoryReadResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryReadResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryReadResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryReadResponse XS_unpack_UA_HistoryReadResponse(SV *in)  __attribute__((unused));
static UA_HistoryReadResponse
XS_unpack_UA_HistoryReadResponse(SV *in)
{
	dTHX;
	UA_HistoryReadResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryReadResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryReadResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "HistoryReadResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryReadResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_HISTORYREADRESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_HistoryReadResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "HistoryReadResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryReadResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* WriteValue */
#ifdef UA_TYPES_WRITEVALUE

static void XS_pack_UA_WriteValue(SV *out, UA_WriteValue in)  __attribute__((unused));
static void
XS_pack_UA_WriteValue(SV *out, UA_WriteValue in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "WriteValue_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "WriteValue_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.indexRange);
	hv_stores(hv, "WriteValue_indexRange", sv);

	sv = newSV(0);
	XS_pack_UA_DataValue(sv, in.value);
	hv_stores(hv, "WriteValue_value", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_WriteValue XS_unpack_UA_WriteValue(SV *in)  __attribute__((unused));
static UA_WriteValue
XS_unpack_UA_WriteValue(SV *in)
{
	dTHX;
	UA_WriteValue out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_WriteValue_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "WriteValue_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "WriteValue_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "WriteValue_indexRange", 0);
	if (svp != NULL)
		out.indexRange = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "WriteValue_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_DataValue(*svp);

	return out;
}
#endif

/* WriteRequest */
#ifdef UA_TYPES_WRITEREQUEST

static void XS_pack_UA_WriteRequest(SV *out, UA_WriteRequest in)  __attribute__((unused));
static void
XS_pack_UA_WriteRequest(SV *out, UA_WriteRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "WriteRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.nodesToWriteSize);
	for (i = 0; i < in.nodesToWriteSize; i++) {
		sv = newSV(0);
		XS_pack_UA_WriteValue(sv, in.nodesToWrite[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "WriteRequest_nodesToWrite", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_WriteRequest XS_unpack_UA_WriteRequest(SV *in)  __attribute__((unused));
static UA_WriteRequest
XS_unpack_UA_WriteRequest(SV *in)
{
	dTHX;
	UA_WriteRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_WriteRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "WriteRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "WriteRequest_nodesToWrite", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for WriteRequest_nodesToWrite");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.nodesToWrite = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_WRITEVALUE]);
		if (out.nodesToWrite == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.nodesToWrite[i] = XS_unpack_UA_WriteValue(*svp);
			}
		}
		out.nodesToWriteSize = i;
	}

	return out;
}
#endif

/* WriteResponse */
#ifdef UA_TYPES_WRITERESPONSE

static void XS_pack_UA_WriteResponse(SV *out, UA_WriteResponse in)  __attribute__((unused));
static void
XS_pack_UA_WriteResponse(SV *out, UA_WriteResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "WriteResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "WriteResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "WriteResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_WriteResponse XS_unpack_UA_WriteResponse(SV *in)  __attribute__((unused));
static UA_WriteResponse
XS_unpack_UA_WriteResponse(SV *in)
{
	dTHX;
	UA_WriteResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_WriteResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "WriteResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "WriteResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for WriteResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "WriteResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for WriteResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* HistoryUpdateDetails */
#ifdef UA_TYPES_HISTORYUPDATEDETAILS

static void XS_pack_UA_HistoryUpdateDetails(SV *out, UA_HistoryUpdateDetails in)  __attribute__((unused));
static void
XS_pack_UA_HistoryUpdateDetails(SV *out, UA_HistoryUpdateDetails in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "HistoryUpdateDetails_nodeId", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryUpdateDetails XS_unpack_UA_HistoryUpdateDetails(SV *in)  __attribute__((unused));
static UA_HistoryUpdateDetails
XS_unpack_UA_HistoryUpdateDetails(SV *in)
{
	dTHX;
	UA_HistoryUpdateDetails out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryUpdateDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryUpdateDetails_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	return out;
}
#endif

/* HistoryUpdateType */
#ifdef UA_TYPES_HISTORYUPDATETYPE

static void XS_pack_UA_HistoryUpdateType(SV *out, UA_HistoryUpdateType in)  __attribute__((unused));
static void
XS_pack_UA_HistoryUpdateType(SV *out, UA_HistoryUpdateType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_HistoryUpdateType XS_unpack_UA_HistoryUpdateType(SV *in)  __attribute__((unused));
static UA_HistoryUpdateType
XS_unpack_UA_HistoryUpdateType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* PerformUpdateType */
#ifdef UA_TYPES_PERFORMUPDATETYPE

static void XS_pack_UA_PerformUpdateType(SV *out, UA_PerformUpdateType in)  __attribute__((unused));
static void
XS_pack_UA_PerformUpdateType(SV *out, UA_PerformUpdateType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_PerformUpdateType XS_unpack_UA_PerformUpdateType(SV *in)  __attribute__((unused));
static UA_PerformUpdateType
XS_unpack_UA_PerformUpdateType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* UpdateDataDetails */
#ifdef UA_TYPES_UPDATEDATADETAILS

static void XS_pack_UA_UpdateDataDetails(SV *out, UA_UpdateDataDetails in)  __attribute__((unused));
static void
XS_pack_UA_UpdateDataDetails(SV *out, UA_UpdateDataDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "UpdateDataDetails_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_PerformUpdateType(sv, in.performInsertReplace);
	hv_stores(hv, "UpdateDataDetails_performInsertReplace", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.updateValuesSize);
	for (i = 0; i < in.updateValuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DataValue(sv, in.updateValues[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UpdateDataDetails_updateValues", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UpdateDataDetails XS_unpack_UA_UpdateDataDetails(SV *in)  __attribute__((unused));
static UA_UpdateDataDetails
XS_unpack_UA_UpdateDataDetails(SV *in)
{
	dTHX;
	UA_UpdateDataDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UpdateDataDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UpdateDataDetails_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "UpdateDataDetails_performInsertReplace", 0);
	if (svp != NULL)
		out.performInsertReplace = XS_unpack_UA_PerformUpdateType(*svp);

	svp = hv_fetchs(hv, "UpdateDataDetails_updateValues", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UpdateDataDetails_updateValues");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.updateValues = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATAVALUE]);
		if (out.updateValues == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.updateValues[i] = XS_unpack_UA_DataValue(*svp);
			}
		}
		out.updateValuesSize = i;
	}

	return out;
}
#endif

/* UpdateStructureDataDetails */
#ifdef UA_TYPES_UPDATESTRUCTUREDATADETAILS

static void XS_pack_UA_UpdateStructureDataDetails(SV *out, UA_UpdateStructureDataDetails in)  __attribute__((unused));
static void
XS_pack_UA_UpdateStructureDataDetails(SV *out, UA_UpdateStructureDataDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "UpdateStructureDataDetails_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_PerformUpdateType(sv, in.performInsertReplace);
	hv_stores(hv, "UpdateStructureDataDetails_performInsertReplace", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.updateValuesSize);
	for (i = 0; i < in.updateValuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DataValue(sv, in.updateValues[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UpdateStructureDataDetails_updateValues", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UpdateStructureDataDetails XS_unpack_UA_UpdateStructureDataDetails(SV *in)  __attribute__((unused));
static UA_UpdateStructureDataDetails
XS_unpack_UA_UpdateStructureDataDetails(SV *in)
{
	dTHX;
	UA_UpdateStructureDataDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UpdateStructureDataDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UpdateStructureDataDetails_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "UpdateStructureDataDetails_performInsertReplace", 0);
	if (svp != NULL)
		out.performInsertReplace = XS_unpack_UA_PerformUpdateType(*svp);

	svp = hv_fetchs(hv, "UpdateStructureDataDetails_updateValues", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UpdateStructureDataDetails_updateValues");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.updateValues = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATAVALUE]);
		if (out.updateValues == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.updateValues[i] = XS_unpack_UA_DataValue(*svp);
			}
		}
		out.updateValuesSize = i;
	}

	return out;
}
#endif

/* DeleteRawModifiedDetails */
#ifdef UA_TYPES_DELETERAWMODIFIEDDETAILS

static void XS_pack_UA_DeleteRawModifiedDetails(SV *out, UA_DeleteRawModifiedDetails in)  __attribute__((unused));
static void
XS_pack_UA_DeleteRawModifiedDetails(SV *out, UA_DeleteRawModifiedDetails in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "DeleteRawModifiedDetails_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.isDeleteModified);
	hv_stores(hv, "DeleteRawModifiedDetails_isDeleteModified", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.startTime);
	hv_stores(hv, "DeleteRawModifiedDetails_startTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.endTime);
	hv_stores(hv, "DeleteRawModifiedDetails_endTime", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteRawModifiedDetails XS_unpack_UA_DeleteRawModifiedDetails(SV *in)  __attribute__((unused));
static UA_DeleteRawModifiedDetails
XS_unpack_UA_DeleteRawModifiedDetails(SV *in)
{
	dTHX;
	UA_DeleteRawModifiedDetails out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteRawModifiedDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteRawModifiedDetails_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "DeleteRawModifiedDetails_isDeleteModified", 0);
	if (svp != NULL)
		out.isDeleteModified = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "DeleteRawModifiedDetails_startTime", 0);
	if (svp != NULL)
		out.startTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "DeleteRawModifiedDetails_endTime", 0);
	if (svp != NULL)
		out.endTime = XS_unpack_UA_DateTime(*svp);

	return out;
}
#endif

/* DeleteAtTimeDetails */
#ifdef UA_TYPES_DELETEATTIMEDETAILS

static void XS_pack_UA_DeleteAtTimeDetails(SV *out, UA_DeleteAtTimeDetails in)  __attribute__((unused));
static void
XS_pack_UA_DeleteAtTimeDetails(SV *out, UA_DeleteAtTimeDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "DeleteAtTimeDetails_nodeId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.reqTimesSize);
	for (i = 0; i < in.reqTimesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DateTime(sv, in.reqTimes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteAtTimeDetails_reqTimes", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteAtTimeDetails XS_unpack_UA_DeleteAtTimeDetails(SV *in)  __attribute__((unused));
static UA_DeleteAtTimeDetails
XS_unpack_UA_DeleteAtTimeDetails(SV *in)
{
	dTHX;
	UA_DeleteAtTimeDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteAtTimeDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteAtTimeDetails_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "DeleteAtTimeDetails_reqTimes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteAtTimeDetails_reqTimes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.reqTimes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATETIME]);
		if (out.reqTimes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.reqTimes[i] = XS_unpack_UA_DateTime(*svp);
			}
		}
		out.reqTimesSize = i;
	}

	return out;
}
#endif

/* DeleteEventDetails */
#ifdef UA_TYPES_DELETEEVENTDETAILS

static void XS_pack_UA_DeleteEventDetails(SV *out, UA_DeleteEventDetails in)  __attribute__((unused));
static void
XS_pack_UA_DeleteEventDetails(SV *out, UA_DeleteEventDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "DeleteEventDetails_nodeId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.eventIdsSize);
	for (i = 0; i < in.eventIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ByteString(sv, in.eventIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteEventDetails_eventIds", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteEventDetails XS_unpack_UA_DeleteEventDetails(SV *in)  __attribute__((unused));
static UA_DeleteEventDetails
XS_unpack_UA_DeleteEventDetails(SV *in)
{
	dTHX;
	UA_DeleteEventDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteEventDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteEventDetails_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "DeleteEventDetails_eventIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteEventDetails_eventIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.eventIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_BYTESTRING]);
		if (out.eventIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.eventIds[i] = XS_unpack_UA_ByteString(*svp);
			}
		}
		out.eventIdsSize = i;
	}

	return out;
}
#endif

/* HistoryUpdateResult */
#ifdef UA_TYPES_HISTORYUPDATERESULT

static void XS_pack_UA_HistoryUpdateResult(SV *out, UA_HistoryUpdateResult in)  __attribute__((unused));
static void
XS_pack_UA_HistoryUpdateResult(SV *out, UA_HistoryUpdateResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "HistoryUpdateResult_statusCode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.operationResultsSize);
	for (i = 0; i < in.operationResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.operationResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryUpdateResult_operationResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryUpdateResult_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryUpdateResult XS_unpack_UA_HistoryUpdateResult(SV *in)  __attribute__((unused));
static UA_HistoryUpdateResult
XS_unpack_UA_HistoryUpdateResult(SV *in)
{
	dTHX;
	UA_HistoryUpdateResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryUpdateResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryUpdateResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "HistoryUpdateResult_operationResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryUpdateResult_operationResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.operationResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.operationResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.operationResults[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.operationResultsSize = i;
	}

	svp = hv_fetchs(hv, "HistoryUpdateResult_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryUpdateResult_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* HistoryUpdateRequest */
#ifdef UA_TYPES_HISTORYUPDATEREQUEST

static void XS_pack_UA_HistoryUpdateRequest(SV *out, UA_HistoryUpdateRequest in)  __attribute__((unused));
static void
XS_pack_UA_HistoryUpdateRequest(SV *out, UA_HistoryUpdateRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "HistoryUpdateRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.historyUpdateDetailsSize);
	for (i = 0; i < in.historyUpdateDetailsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ExtensionObject(sv, in.historyUpdateDetails[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryUpdateRequest_historyUpdateDetails", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryUpdateRequest XS_unpack_UA_HistoryUpdateRequest(SV *in)  __attribute__((unused));
static UA_HistoryUpdateRequest
XS_unpack_UA_HistoryUpdateRequest(SV *in)
{
	dTHX;
	UA_HistoryUpdateRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryUpdateRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryUpdateRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "HistoryUpdateRequest_historyUpdateDetails", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryUpdateRequest_historyUpdateDetails");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.historyUpdateDetails = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_EXTENSIONOBJECT]);
		if (out.historyUpdateDetails == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.historyUpdateDetails[i] = XS_unpack_UA_ExtensionObject(*svp);
			}
		}
		out.historyUpdateDetailsSize = i;
	}

	return out;
}
#endif

/* HistoryUpdateResponse */
#ifdef UA_TYPES_HISTORYUPDATERESPONSE

static void XS_pack_UA_HistoryUpdateResponse(SV *out, UA_HistoryUpdateResponse in)  __attribute__((unused));
static void
XS_pack_UA_HistoryUpdateResponse(SV *out, UA_HistoryUpdateResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "HistoryUpdateResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_HistoryUpdateResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryUpdateResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryUpdateResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryUpdateResponse XS_unpack_UA_HistoryUpdateResponse(SV *in)  __attribute__((unused));
static UA_HistoryUpdateResponse
XS_unpack_UA_HistoryUpdateResponse(SV *in)
{
	dTHX;
	UA_HistoryUpdateResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryUpdateResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryUpdateResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "HistoryUpdateResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryUpdateResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_HISTORYUPDATERESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_HistoryUpdateResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "HistoryUpdateResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryUpdateResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* CallMethodRequest */
#ifdef UA_TYPES_CALLMETHODREQUEST

static void XS_pack_UA_CallMethodRequest(SV *out, UA_CallMethodRequest in)  __attribute__((unused));
static void
XS_pack_UA_CallMethodRequest(SV *out, UA_CallMethodRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.objectId);
	hv_stores(hv, "CallMethodRequest_objectId", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.methodId);
	hv_stores(hv, "CallMethodRequest_methodId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.inputArgumentsSize);
	for (i = 0; i < in.inputArgumentsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Variant(sv, in.inputArguments[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CallMethodRequest_inputArguments", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CallMethodRequest XS_unpack_UA_CallMethodRequest(SV *in)  __attribute__((unused));
static UA_CallMethodRequest
XS_unpack_UA_CallMethodRequest(SV *in)
{
	dTHX;
	UA_CallMethodRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CallMethodRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CallMethodRequest_objectId", 0);
	if (svp != NULL)
		out.objectId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "CallMethodRequest_methodId", 0);
	if (svp != NULL)
		out.methodId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "CallMethodRequest_inputArguments", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CallMethodRequest_inputArguments");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.inputArguments = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_VARIANT]);
		if (out.inputArguments == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.inputArguments[i] = XS_unpack_UA_Variant(*svp);
			}
		}
		out.inputArgumentsSize = i;
	}

	return out;
}
#endif

/* CallMethodResult */
#ifdef UA_TYPES_CALLMETHODRESULT

static void XS_pack_UA_CallMethodResult(SV *out, UA_CallMethodResult in)  __attribute__((unused));
static void
XS_pack_UA_CallMethodResult(SV *out, UA_CallMethodResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "CallMethodResult_statusCode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.inputArgumentResultsSize);
	for (i = 0; i < in.inputArgumentResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.inputArgumentResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CallMethodResult_inputArgumentResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.inputArgumentDiagnosticInfosSize);
	for (i = 0; i < in.inputArgumentDiagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.inputArgumentDiagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CallMethodResult_inputArgumentDiagnosticInfos", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.outputArgumentsSize);
	for (i = 0; i < in.outputArgumentsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Variant(sv, in.outputArguments[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CallMethodResult_outputArguments", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CallMethodResult XS_unpack_UA_CallMethodResult(SV *in)  __attribute__((unused));
static UA_CallMethodResult
XS_unpack_UA_CallMethodResult(SV *in)
{
	dTHX;
	UA_CallMethodResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CallMethodResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CallMethodResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "CallMethodResult_inputArgumentResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CallMethodResult_inputArgumentResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.inputArgumentResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.inputArgumentResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.inputArgumentResults[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.inputArgumentResultsSize = i;
	}

	svp = hv_fetchs(hv, "CallMethodResult_inputArgumentDiagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CallMethodResult_inputArgumentDiagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.inputArgumentDiagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.inputArgumentDiagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.inputArgumentDiagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.inputArgumentDiagnosticInfosSize = i;
	}

	svp = hv_fetchs(hv, "CallMethodResult_outputArguments", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CallMethodResult_outputArguments");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.outputArguments = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_VARIANT]);
		if (out.outputArguments == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.outputArguments[i] = XS_unpack_UA_Variant(*svp);
			}
		}
		out.outputArgumentsSize = i;
	}

	return out;
}
#endif

/* CallRequest */
#ifdef UA_TYPES_CALLREQUEST

static void XS_pack_UA_CallRequest(SV *out, UA_CallRequest in)  __attribute__((unused));
static void
XS_pack_UA_CallRequest(SV *out, UA_CallRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "CallRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.methodsToCallSize);
	for (i = 0; i < in.methodsToCallSize; i++) {
		sv = newSV(0);
		XS_pack_UA_CallMethodRequest(sv, in.methodsToCall[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CallRequest_methodsToCall", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CallRequest XS_unpack_UA_CallRequest(SV *in)  __attribute__((unused));
static UA_CallRequest
XS_unpack_UA_CallRequest(SV *in)
{
	dTHX;
	UA_CallRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CallRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CallRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "CallRequest_methodsToCall", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CallRequest_methodsToCall");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.methodsToCall = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_CALLMETHODREQUEST]);
		if (out.methodsToCall == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.methodsToCall[i] = XS_unpack_UA_CallMethodRequest(*svp);
			}
		}
		out.methodsToCallSize = i;
	}

	return out;
}
#endif

/* CallResponse */
#ifdef UA_TYPES_CALLRESPONSE

static void XS_pack_UA_CallResponse(SV *out, UA_CallResponse in)  __attribute__((unused));
static void
XS_pack_UA_CallResponse(SV *out, UA_CallResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "CallResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_CallMethodResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CallResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CallResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CallResponse XS_unpack_UA_CallResponse(SV *in)  __attribute__((unused));
static UA_CallResponse
XS_unpack_UA_CallResponse(SV *in)
{
	dTHX;
	UA_CallResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CallResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CallResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "CallResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CallResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_CALLMETHODRESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_CallMethodResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "CallResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CallResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* MonitoringMode */
#ifdef UA_TYPES_MONITORINGMODE

static void XS_pack_UA_MonitoringMode(SV *out, UA_MonitoringMode in)  __attribute__((unused));
static void
XS_pack_UA_MonitoringMode(SV *out, UA_MonitoringMode in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_MonitoringMode XS_unpack_UA_MonitoringMode(SV *in)  __attribute__((unused));
static UA_MonitoringMode
XS_unpack_UA_MonitoringMode(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* DataChangeTrigger */
#ifdef UA_TYPES_DATACHANGETRIGGER

static void XS_pack_UA_DataChangeTrigger(SV *out, UA_DataChangeTrigger in)  __attribute__((unused));
static void
XS_pack_UA_DataChangeTrigger(SV *out, UA_DataChangeTrigger in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_DataChangeTrigger XS_unpack_UA_DataChangeTrigger(SV *in)  __attribute__((unused));
static UA_DataChangeTrigger
XS_unpack_UA_DataChangeTrigger(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* DeadbandType */
#ifdef UA_TYPES_DEADBANDTYPE

static void XS_pack_UA_DeadbandType(SV *out, UA_DeadbandType in)  __attribute__((unused));
static void
XS_pack_UA_DeadbandType(SV *out, UA_DeadbandType in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_DeadbandType XS_unpack_UA_DeadbandType(SV *in)  __attribute__((unused));
static UA_DeadbandType
XS_unpack_UA_DeadbandType(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* MonitoringFilter */
#ifdef UA_TYPES_MONITORINGFILTER

static void XS_pack_UA_MonitoringFilter(SV *out, UA_MonitoringFilter in)  __attribute__((unused));
static void
XS_pack_UA_MonitoringFilter(SV *out, UA_MonitoringFilter in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_MonitoringFilter XS_unpack_UA_MonitoringFilter(SV *in)  __attribute__((unused));
static UA_MonitoringFilter
XS_unpack_UA_MonitoringFilter(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* DataChangeFilter */
#ifdef UA_TYPES_DATACHANGEFILTER

static void XS_pack_UA_DataChangeFilter(SV *out, UA_DataChangeFilter in)  __attribute__((unused));
static void
XS_pack_UA_DataChangeFilter(SV *out, UA_DataChangeFilter in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_DataChangeTrigger(sv, in.trigger);
	hv_stores(hv, "DataChangeFilter_trigger", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.deadbandType);
	hv_stores(hv, "DataChangeFilter_deadbandType", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.deadbandValue);
	hv_stores(hv, "DataChangeFilter_deadbandValue", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataChangeFilter XS_unpack_UA_DataChangeFilter(SV *in)  __attribute__((unused));
static UA_DataChangeFilter
XS_unpack_UA_DataChangeFilter(SV *in)
{
	dTHX;
	UA_DataChangeFilter out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataChangeFilter_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataChangeFilter_trigger", 0);
	if (svp != NULL)
		out.trigger = XS_unpack_UA_DataChangeTrigger(*svp);

	svp = hv_fetchs(hv, "DataChangeFilter_deadbandType", 0);
	if (svp != NULL)
		out.deadbandType = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "DataChangeFilter_deadbandValue", 0);
	if (svp != NULL)
		out.deadbandValue = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* EventFilter */
#ifdef UA_TYPES_EVENTFILTER

static void XS_pack_UA_EventFilter(SV *out, UA_EventFilter in)  __attribute__((unused));
static void
XS_pack_UA_EventFilter(SV *out, UA_EventFilter in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.selectClausesSize);
	for (i = 0; i < in.selectClausesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SimpleAttributeOperand(sv, in.selectClauses[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EventFilter_selectClauses", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ContentFilter(sv, in.whereClause);
	hv_stores(hv, "EventFilter_whereClause", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EventFilter XS_unpack_UA_EventFilter(SV *in)  __attribute__((unused));
static UA_EventFilter
XS_unpack_UA_EventFilter(SV *in)
{
	dTHX;
	UA_EventFilter out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EventFilter_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EventFilter_selectClauses", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EventFilter_selectClauses");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.selectClauses = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SIMPLEATTRIBUTEOPERAND]);
		if (out.selectClauses == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.selectClauses[i] = XS_unpack_UA_SimpleAttributeOperand(*svp);
			}
		}
		out.selectClausesSize = i;
	}

	svp = hv_fetchs(hv, "EventFilter_whereClause", 0);
	if (svp != NULL)
		out.whereClause = XS_unpack_UA_ContentFilter(*svp);

	return out;
}
#endif

/* AggregateConfiguration */
#ifdef UA_TYPES_AGGREGATECONFIGURATION

static void XS_pack_UA_AggregateConfiguration(SV *out, UA_AggregateConfiguration in)  __attribute__((unused));
static void
XS_pack_UA_AggregateConfiguration(SV *out, UA_AggregateConfiguration in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.useServerCapabilitiesDefaults);
	hv_stores(hv, "AggregateConfiguration_useServerCapabilitiesDefaults", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.treatUncertainAsBad);
	hv_stores(hv, "AggregateConfiguration_treatUncertainAsBad", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.percentDataBad);
	hv_stores(hv, "AggregateConfiguration_percentDataBad", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.percentDataGood);
	hv_stores(hv, "AggregateConfiguration_percentDataGood", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.useSlopedExtrapolation);
	hv_stores(hv, "AggregateConfiguration_useSlopedExtrapolation", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AggregateConfiguration XS_unpack_UA_AggregateConfiguration(SV *in)  __attribute__((unused));
static UA_AggregateConfiguration
XS_unpack_UA_AggregateConfiguration(SV *in)
{
	dTHX;
	UA_AggregateConfiguration out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AggregateConfiguration_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AggregateConfiguration_useServerCapabilitiesDefaults", 0);
	if (svp != NULL)
		out.useServerCapabilitiesDefaults = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "AggregateConfiguration_treatUncertainAsBad", 0);
	if (svp != NULL)
		out.treatUncertainAsBad = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "AggregateConfiguration_percentDataBad", 0);
	if (svp != NULL)
		out.percentDataBad = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "AggregateConfiguration_percentDataGood", 0);
	if (svp != NULL)
		out.percentDataGood = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "AggregateConfiguration_useSlopedExtrapolation", 0);
	if (svp != NULL)
		out.useSlopedExtrapolation = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* AggregateFilter */
#ifdef UA_TYPES_AGGREGATEFILTER

static void XS_pack_UA_AggregateFilter(SV *out, UA_AggregateFilter in)  __attribute__((unused));
static void
XS_pack_UA_AggregateFilter(SV *out, UA_AggregateFilter in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.startTime);
	hv_stores(hv, "AggregateFilter_startTime", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.aggregateType);
	hv_stores(hv, "AggregateFilter_aggregateType", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.processingInterval);
	hv_stores(hv, "AggregateFilter_processingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_AggregateConfiguration(sv, in.aggregateConfiguration);
	hv_stores(hv, "AggregateFilter_aggregateConfiguration", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AggregateFilter XS_unpack_UA_AggregateFilter(SV *in)  __attribute__((unused));
static UA_AggregateFilter
XS_unpack_UA_AggregateFilter(SV *in)
{
	dTHX;
	UA_AggregateFilter out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AggregateFilter_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AggregateFilter_startTime", 0);
	if (svp != NULL)
		out.startTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "AggregateFilter_aggregateType", 0);
	if (svp != NULL)
		out.aggregateType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "AggregateFilter_processingInterval", 0);
	if (svp != NULL)
		out.processingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "AggregateFilter_aggregateConfiguration", 0);
	if (svp != NULL)
		out.aggregateConfiguration = XS_unpack_UA_AggregateConfiguration(*svp);

	return out;
}
#endif

/* MonitoringFilterResult */
#ifdef UA_TYPES_MONITORINGFILTERRESULT

static void XS_pack_UA_MonitoringFilterResult(SV *out, UA_MonitoringFilterResult in)  __attribute__((unused));
static void
XS_pack_UA_MonitoringFilterResult(SV *out, UA_MonitoringFilterResult in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_MonitoringFilterResult XS_unpack_UA_MonitoringFilterResult(SV *in)  __attribute__((unused));
static UA_MonitoringFilterResult
XS_unpack_UA_MonitoringFilterResult(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* EventFilterResult */
#ifdef UA_TYPES_EVENTFILTERRESULT

static void XS_pack_UA_EventFilterResult(SV *out, UA_EventFilterResult in)  __attribute__((unused));
static void
XS_pack_UA_EventFilterResult(SV *out, UA_EventFilterResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.selectClauseResultsSize);
	for (i = 0; i < in.selectClauseResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.selectClauseResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EventFilterResult_selectClauseResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.selectClauseDiagnosticInfosSize);
	for (i = 0; i < in.selectClauseDiagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.selectClauseDiagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EventFilterResult_selectClauseDiagnosticInfos", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ContentFilterResult(sv, in.whereClauseResult);
	hv_stores(hv, "EventFilterResult_whereClauseResult", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EventFilterResult XS_unpack_UA_EventFilterResult(SV *in)  __attribute__((unused));
static UA_EventFilterResult
XS_unpack_UA_EventFilterResult(SV *in)
{
	dTHX;
	UA_EventFilterResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EventFilterResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EventFilterResult_selectClauseResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EventFilterResult_selectClauseResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.selectClauseResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.selectClauseResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.selectClauseResults[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.selectClauseResultsSize = i;
	}

	svp = hv_fetchs(hv, "EventFilterResult_selectClauseDiagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EventFilterResult_selectClauseDiagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.selectClauseDiagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.selectClauseDiagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.selectClauseDiagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.selectClauseDiagnosticInfosSize = i;
	}

	svp = hv_fetchs(hv, "EventFilterResult_whereClauseResult", 0);
	if (svp != NULL)
		out.whereClauseResult = XS_unpack_UA_ContentFilterResult(*svp);

	return out;
}
#endif

/* AggregateFilterResult */
#ifdef UA_TYPES_AGGREGATEFILTERRESULT

static void XS_pack_UA_AggregateFilterResult(SV *out, UA_AggregateFilterResult in)  __attribute__((unused));
static void
XS_pack_UA_AggregateFilterResult(SV *out, UA_AggregateFilterResult in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.revisedStartTime);
	hv_stores(hv, "AggregateFilterResult_revisedStartTime", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.revisedProcessingInterval);
	hv_stores(hv, "AggregateFilterResult_revisedProcessingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_AggregateConfiguration(sv, in.revisedAggregateConfiguration);
	hv_stores(hv, "AggregateFilterResult_revisedAggregateConfiguration", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AggregateFilterResult XS_unpack_UA_AggregateFilterResult(SV *in)  __attribute__((unused));
static UA_AggregateFilterResult
XS_unpack_UA_AggregateFilterResult(SV *in)
{
	dTHX;
	UA_AggregateFilterResult out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AggregateFilterResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AggregateFilterResult_revisedStartTime", 0);
	if (svp != NULL)
		out.revisedStartTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "AggregateFilterResult_revisedProcessingInterval", 0);
	if (svp != NULL)
		out.revisedProcessingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "AggregateFilterResult_revisedAggregateConfiguration", 0);
	if (svp != NULL)
		out.revisedAggregateConfiguration = XS_unpack_UA_AggregateConfiguration(*svp);

	return out;
}
#endif

/* MonitoringParameters */
#ifdef UA_TYPES_MONITORINGPARAMETERS

static void XS_pack_UA_MonitoringParameters(SV *out, UA_MonitoringParameters in)  __attribute__((unused));
static void
XS_pack_UA_MonitoringParameters(SV *out, UA_MonitoringParameters in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.clientHandle);
	hv_stores(hv, "MonitoringParameters_clientHandle", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.samplingInterval);
	hv_stores(hv, "MonitoringParameters_samplingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.filter);
	hv_stores(hv, "MonitoringParameters_filter", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.queueSize);
	hv_stores(hv, "MonitoringParameters_queueSize", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.discardOldest);
	hv_stores(hv, "MonitoringParameters_discardOldest", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MonitoringParameters XS_unpack_UA_MonitoringParameters(SV *in)  __attribute__((unused));
static UA_MonitoringParameters
XS_unpack_UA_MonitoringParameters(SV *in)
{
	dTHX;
	UA_MonitoringParameters out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MonitoringParameters_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MonitoringParameters_clientHandle", 0);
	if (svp != NULL)
		out.clientHandle = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MonitoringParameters_samplingInterval", 0);
	if (svp != NULL)
		out.samplingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "MonitoringParameters_filter", 0);
	if (svp != NULL)
		out.filter = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "MonitoringParameters_queueSize", 0);
	if (svp != NULL)
		out.queueSize = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MonitoringParameters_discardOldest", 0);
	if (svp != NULL)
		out.discardOldest = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* MonitoredItemCreateRequest */
#ifdef UA_TYPES_MONITOREDITEMCREATEREQUEST

static void XS_pack_UA_MonitoredItemCreateRequest(SV *out, UA_MonitoredItemCreateRequest in)  __attribute__((unused));
static void
XS_pack_UA_MonitoredItemCreateRequest(SV *out, UA_MonitoredItemCreateRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ReadValueId(sv, in.itemToMonitor);
	hv_stores(hv, "MonitoredItemCreateRequest_itemToMonitor", sv);

	sv = newSV(0);
	XS_pack_UA_MonitoringMode(sv, in.monitoringMode);
	hv_stores(hv, "MonitoredItemCreateRequest_monitoringMode", sv);

	sv = newSV(0);
	XS_pack_UA_MonitoringParameters(sv, in.requestedParameters);
	hv_stores(hv, "MonitoredItemCreateRequest_requestedParameters", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MonitoredItemCreateRequest XS_unpack_UA_MonitoredItemCreateRequest(SV *in)  __attribute__((unused));
static UA_MonitoredItemCreateRequest
XS_unpack_UA_MonitoredItemCreateRequest(SV *in)
{
	dTHX;
	UA_MonitoredItemCreateRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MonitoredItemCreateRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MonitoredItemCreateRequest_itemToMonitor", 0);
	if (svp != NULL)
		out.itemToMonitor = XS_unpack_UA_ReadValueId(*svp);

	svp = hv_fetchs(hv, "MonitoredItemCreateRequest_monitoringMode", 0);
	if (svp != NULL)
		out.monitoringMode = XS_unpack_UA_MonitoringMode(*svp);

	svp = hv_fetchs(hv, "MonitoredItemCreateRequest_requestedParameters", 0);
	if (svp != NULL)
		out.requestedParameters = XS_unpack_UA_MonitoringParameters(*svp);

	return out;
}
#endif

/* MonitoredItemCreateResult */
#ifdef UA_TYPES_MONITOREDITEMCREATERESULT

static void XS_pack_UA_MonitoredItemCreateResult(SV *out, UA_MonitoredItemCreateResult in)  __attribute__((unused));
static void
XS_pack_UA_MonitoredItemCreateResult(SV *out, UA_MonitoredItemCreateResult in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "MonitoredItemCreateResult_statusCode", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.monitoredItemId);
	hv_stores(hv, "MonitoredItemCreateResult_monitoredItemId", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.revisedSamplingInterval);
	hv_stores(hv, "MonitoredItemCreateResult_revisedSamplingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.revisedQueueSize);
	hv_stores(hv, "MonitoredItemCreateResult_revisedQueueSize", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.filterResult);
	hv_stores(hv, "MonitoredItemCreateResult_filterResult", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MonitoredItemCreateResult XS_unpack_UA_MonitoredItemCreateResult(SV *in)  __attribute__((unused));
static UA_MonitoredItemCreateResult
XS_unpack_UA_MonitoredItemCreateResult(SV *in)
{
	dTHX;
	UA_MonitoredItemCreateResult out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MonitoredItemCreateResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MonitoredItemCreateResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "MonitoredItemCreateResult_monitoredItemId", 0);
	if (svp != NULL)
		out.monitoredItemId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MonitoredItemCreateResult_revisedSamplingInterval", 0);
	if (svp != NULL)
		out.revisedSamplingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "MonitoredItemCreateResult_revisedQueueSize", 0);
	if (svp != NULL)
		out.revisedQueueSize = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MonitoredItemCreateResult_filterResult", 0);
	if (svp != NULL)
		out.filterResult = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* CreateMonitoredItemsRequest */
#ifdef UA_TYPES_CREATEMONITOREDITEMSREQUEST

static void XS_pack_UA_CreateMonitoredItemsRequest(SV *out, UA_CreateMonitoredItemsRequest in)  __attribute__((unused));
static void
XS_pack_UA_CreateMonitoredItemsRequest(SV *out, UA_CreateMonitoredItemsRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "CreateMonitoredItemsRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "CreateMonitoredItemsRequest_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_TimestampsToReturn(sv, in.timestampsToReturn);
	hv_stores(hv, "CreateMonitoredItemsRequest_timestampsToReturn", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.itemsToCreateSize);
	for (i = 0; i < in.itemsToCreateSize; i++) {
		sv = newSV(0);
		XS_pack_UA_MonitoredItemCreateRequest(sv, in.itemsToCreate[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CreateMonitoredItemsRequest_itemsToCreate", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CreateMonitoredItemsRequest XS_unpack_UA_CreateMonitoredItemsRequest(SV *in)  __attribute__((unused));
static UA_CreateMonitoredItemsRequest
XS_unpack_UA_CreateMonitoredItemsRequest(SV *in)
{
	dTHX;
	UA_CreateMonitoredItemsRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CreateMonitoredItemsRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CreateMonitoredItemsRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "CreateMonitoredItemsRequest_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "CreateMonitoredItemsRequest_timestampsToReturn", 0);
	if (svp != NULL)
		out.timestampsToReturn = XS_unpack_UA_TimestampsToReturn(*svp);

	svp = hv_fetchs(hv, "CreateMonitoredItemsRequest_itemsToCreate", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CreateMonitoredItemsRequest_itemsToCreate");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.itemsToCreate = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_MONITOREDITEMCREATEREQUEST]);
		if (out.itemsToCreate == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.itemsToCreate[i] = XS_unpack_UA_MonitoredItemCreateRequest(*svp);
			}
		}
		out.itemsToCreateSize = i;
	}

	return out;
}
#endif

/* CreateMonitoredItemsResponse */
#ifdef UA_TYPES_CREATEMONITOREDITEMSRESPONSE

static void XS_pack_UA_CreateMonitoredItemsResponse(SV *out, UA_CreateMonitoredItemsResponse in)  __attribute__((unused));
static void
XS_pack_UA_CreateMonitoredItemsResponse(SV *out, UA_CreateMonitoredItemsResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "CreateMonitoredItemsResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_MonitoredItemCreateResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CreateMonitoredItemsResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "CreateMonitoredItemsResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CreateMonitoredItemsResponse XS_unpack_UA_CreateMonitoredItemsResponse(SV *in)  __attribute__((unused));
static UA_CreateMonitoredItemsResponse
XS_unpack_UA_CreateMonitoredItemsResponse(SV *in)
{
	dTHX;
	UA_CreateMonitoredItemsResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CreateMonitoredItemsResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CreateMonitoredItemsResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "CreateMonitoredItemsResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CreateMonitoredItemsResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_MONITOREDITEMCREATERESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_MonitoredItemCreateResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "CreateMonitoredItemsResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for CreateMonitoredItemsResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* MonitoredItemModifyRequest */
#ifdef UA_TYPES_MONITOREDITEMMODIFYREQUEST

static void XS_pack_UA_MonitoredItemModifyRequest(SV *out, UA_MonitoredItemModifyRequest in)  __attribute__((unused));
static void
XS_pack_UA_MonitoredItemModifyRequest(SV *out, UA_MonitoredItemModifyRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.monitoredItemId);
	hv_stores(hv, "MonitoredItemModifyRequest_monitoredItemId", sv);

	sv = newSV(0);
	XS_pack_UA_MonitoringParameters(sv, in.requestedParameters);
	hv_stores(hv, "MonitoredItemModifyRequest_requestedParameters", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MonitoredItemModifyRequest XS_unpack_UA_MonitoredItemModifyRequest(SV *in)  __attribute__((unused));
static UA_MonitoredItemModifyRequest
XS_unpack_UA_MonitoredItemModifyRequest(SV *in)
{
	dTHX;
	UA_MonitoredItemModifyRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MonitoredItemModifyRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MonitoredItemModifyRequest_monitoredItemId", 0);
	if (svp != NULL)
		out.monitoredItemId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MonitoredItemModifyRequest_requestedParameters", 0);
	if (svp != NULL)
		out.requestedParameters = XS_unpack_UA_MonitoringParameters(*svp);

	return out;
}
#endif

/* MonitoredItemModifyResult */
#ifdef UA_TYPES_MONITOREDITEMMODIFYRESULT

static void XS_pack_UA_MonitoredItemModifyResult(SV *out, UA_MonitoredItemModifyResult in)  __attribute__((unused));
static void
XS_pack_UA_MonitoredItemModifyResult(SV *out, UA_MonitoredItemModifyResult in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "MonitoredItemModifyResult_statusCode", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.revisedSamplingInterval);
	hv_stores(hv, "MonitoredItemModifyResult_revisedSamplingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.revisedQueueSize);
	hv_stores(hv, "MonitoredItemModifyResult_revisedQueueSize", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.filterResult);
	hv_stores(hv, "MonitoredItemModifyResult_filterResult", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MonitoredItemModifyResult XS_unpack_UA_MonitoredItemModifyResult(SV *in)  __attribute__((unused));
static UA_MonitoredItemModifyResult
XS_unpack_UA_MonitoredItemModifyResult(SV *in)
{
	dTHX;
	UA_MonitoredItemModifyResult out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MonitoredItemModifyResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MonitoredItemModifyResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "MonitoredItemModifyResult_revisedSamplingInterval", 0);
	if (svp != NULL)
		out.revisedSamplingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "MonitoredItemModifyResult_revisedQueueSize", 0);
	if (svp != NULL)
		out.revisedQueueSize = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MonitoredItemModifyResult_filterResult", 0);
	if (svp != NULL)
		out.filterResult = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* ModifyMonitoredItemsRequest */
#ifdef UA_TYPES_MODIFYMONITOREDITEMSREQUEST

static void XS_pack_UA_ModifyMonitoredItemsRequest(SV *out, UA_ModifyMonitoredItemsRequest in)  __attribute__((unused));
static void
XS_pack_UA_ModifyMonitoredItemsRequest(SV *out, UA_ModifyMonitoredItemsRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "ModifyMonitoredItemsRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "ModifyMonitoredItemsRequest_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_TimestampsToReturn(sv, in.timestampsToReturn);
	hv_stores(hv, "ModifyMonitoredItemsRequest_timestampsToReturn", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.itemsToModifySize);
	for (i = 0; i < in.itemsToModifySize; i++) {
		sv = newSV(0);
		XS_pack_UA_MonitoredItemModifyRequest(sv, in.itemsToModify[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ModifyMonitoredItemsRequest_itemsToModify", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ModifyMonitoredItemsRequest XS_unpack_UA_ModifyMonitoredItemsRequest(SV *in)  __attribute__((unused));
static UA_ModifyMonitoredItemsRequest
XS_unpack_UA_ModifyMonitoredItemsRequest(SV *in)
{
	dTHX;
	UA_ModifyMonitoredItemsRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ModifyMonitoredItemsRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ModifyMonitoredItemsRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "ModifyMonitoredItemsRequest_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ModifyMonitoredItemsRequest_timestampsToReturn", 0);
	if (svp != NULL)
		out.timestampsToReturn = XS_unpack_UA_TimestampsToReturn(*svp);

	svp = hv_fetchs(hv, "ModifyMonitoredItemsRequest_itemsToModify", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ModifyMonitoredItemsRequest_itemsToModify");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.itemsToModify = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_MONITOREDITEMMODIFYREQUEST]);
		if (out.itemsToModify == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.itemsToModify[i] = XS_unpack_UA_MonitoredItemModifyRequest(*svp);
			}
		}
		out.itemsToModifySize = i;
	}

	return out;
}
#endif

/* ModifyMonitoredItemsResponse */
#ifdef UA_TYPES_MODIFYMONITOREDITEMSRESPONSE

static void XS_pack_UA_ModifyMonitoredItemsResponse(SV *out, UA_ModifyMonitoredItemsResponse in)  __attribute__((unused));
static void
XS_pack_UA_ModifyMonitoredItemsResponse(SV *out, UA_ModifyMonitoredItemsResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "ModifyMonitoredItemsResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_MonitoredItemModifyResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ModifyMonitoredItemsResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ModifyMonitoredItemsResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ModifyMonitoredItemsResponse XS_unpack_UA_ModifyMonitoredItemsResponse(SV *in)  __attribute__((unused));
static UA_ModifyMonitoredItemsResponse
XS_unpack_UA_ModifyMonitoredItemsResponse(SV *in)
{
	dTHX;
	UA_ModifyMonitoredItemsResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ModifyMonitoredItemsResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ModifyMonitoredItemsResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "ModifyMonitoredItemsResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ModifyMonitoredItemsResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_MONITOREDITEMMODIFYRESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_MonitoredItemModifyResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "ModifyMonitoredItemsResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ModifyMonitoredItemsResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* SetMonitoringModeRequest */
#ifdef UA_TYPES_SETMONITORINGMODEREQUEST

static void XS_pack_UA_SetMonitoringModeRequest(SV *out, UA_SetMonitoringModeRequest in)  __attribute__((unused));
static void
XS_pack_UA_SetMonitoringModeRequest(SV *out, UA_SetMonitoringModeRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "SetMonitoringModeRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "SetMonitoringModeRequest_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_MonitoringMode(sv, in.monitoringMode);
	hv_stores(hv, "SetMonitoringModeRequest_monitoringMode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.monitoredItemIdsSize);
	for (i = 0; i < in.monitoredItemIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.monitoredItemIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetMonitoringModeRequest_monitoredItemIds", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SetMonitoringModeRequest XS_unpack_UA_SetMonitoringModeRequest(SV *in)  __attribute__((unused));
static UA_SetMonitoringModeRequest
XS_unpack_UA_SetMonitoringModeRequest(SV *in)
{
	dTHX;
	UA_SetMonitoringModeRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SetMonitoringModeRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SetMonitoringModeRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "SetMonitoringModeRequest_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SetMonitoringModeRequest_monitoringMode", 0);
	if (svp != NULL)
		out.monitoringMode = XS_unpack_UA_MonitoringMode(*svp);

	svp = hv_fetchs(hv, "SetMonitoringModeRequest_monitoredItemIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetMonitoringModeRequest_monitoredItemIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.monitoredItemIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.monitoredItemIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.monitoredItemIds[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.monitoredItemIdsSize = i;
	}

	return out;
}
#endif

/* SetMonitoringModeResponse */
#ifdef UA_TYPES_SETMONITORINGMODERESPONSE

static void XS_pack_UA_SetMonitoringModeResponse(SV *out, UA_SetMonitoringModeResponse in)  __attribute__((unused));
static void
XS_pack_UA_SetMonitoringModeResponse(SV *out, UA_SetMonitoringModeResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "SetMonitoringModeResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetMonitoringModeResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetMonitoringModeResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SetMonitoringModeResponse XS_unpack_UA_SetMonitoringModeResponse(SV *in)  __attribute__((unused));
static UA_SetMonitoringModeResponse
XS_unpack_UA_SetMonitoringModeResponse(SV *in)
{
	dTHX;
	UA_SetMonitoringModeResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SetMonitoringModeResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SetMonitoringModeResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "SetMonitoringModeResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetMonitoringModeResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "SetMonitoringModeResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetMonitoringModeResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* SetTriggeringRequest */
#ifdef UA_TYPES_SETTRIGGERINGREQUEST

static void XS_pack_UA_SetTriggeringRequest(SV *out, UA_SetTriggeringRequest in)  __attribute__((unused));
static void
XS_pack_UA_SetTriggeringRequest(SV *out, UA_SetTriggeringRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "SetTriggeringRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "SetTriggeringRequest_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.triggeringItemId);
	hv_stores(hv, "SetTriggeringRequest_triggeringItemId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.linksToAddSize);
	for (i = 0; i < in.linksToAddSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.linksToAdd[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetTriggeringRequest_linksToAdd", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.linksToRemoveSize);
	for (i = 0; i < in.linksToRemoveSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.linksToRemove[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetTriggeringRequest_linksToRemove", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SetTriggeringRequest XS_unpack_UA_SetTriggeringRequest(SV *in)  __attribute__((unused));
static UA_SetTriggeringRequest
XS_unpack_UA_SetTriggeringRequest(SV *in)
{
	dTHX;
	UA_SetTriggeringRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SetTriggeringRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SetTriggeringRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "SetTriggeringRequest_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SetTriggeringRequest_triggeringItemId", 0);
	if (svp != NULL)
		out.triggeringItemId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SetTriggeringRequest_linksToAdd", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetTriggeringRequest_linksToAdd");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.linksToAdd = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.linksToAdd == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.linksToAdd[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.linksToAddSize = i;
	}

	svp = hv_fetchs(hv, "SetTriggeringRequest_linksToRemove", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetTriggeringRequest_linksToRemove");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.linksToRemove = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.linksToRemove == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.linksToRemove[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.linksToRemoveSize = i;
	}

	return out;
}
#endif

/* SetTriggeringResponse */
#ifdef UA_TYPES_SETTRIGGERINGRESPONSE

static void XS_pack_UA_SetTriggeringResponse(SV *out, UA_SetTriggeringResponse in)  __attribute__((unused));
static void
XS_pack_UA_SetTriggeringResponse(SV *out, UA_SetTriggeringResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "SetTriggeringResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.addResultsSize);
	for (i = 0; i < in.addResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.addResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetTriggeringResponse_addResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.addDiagnosticInfosSize);
	for (i = 0; i < in.addDiagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.addDiagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetTriggeringResponse_addDiagnosticInfos", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.removeResultsSize);
	for (i = 0; i < in.removeResultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.removeResults[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetTriggeringResponse_removeResults", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.removeDiagnosticInfosSize);
	for (i = 0; i < in.removeDiagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.removeDiagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetTriggeringResponse_removeDiagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SetTriggeringResponse XS_unpack_UA_SetTriggeringResponse(SV *in)  __attribute__((unused));
static UA_SetTriggeringResponse
XS_unpack_UA_SetTriggeringResponse(SV *in)
{
	dTHX;
	UA_SetTriggeringResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SetTriggeringResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SetTriggeringResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "SetTriggeringResponse_addResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetTriggeringResponse_addResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.addResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.addResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.addResults[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.addResultsSize = i;
	}

	svp = hv_fetchs(hv, "SetTriggeringResponse_addDiagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetTriggeringResponse_addDiagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.addDiagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.addDiagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.addDiagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.addDiagnosticInfosSize = i;
	}

	svp = hv_fetchs(hv, "SetTriggeringResponse_removeResults", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetTriggeringResponse_removeResults");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.removeResults = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.removeResults == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.removeResults[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.removeResultsSize = i;
	}

	svp = hv_fetchs(hv, "SetTriggeringResponse_removeDiagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetTriggeringResponse_removeDiagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.removeDiagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.removeDiagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.removeDiagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.removeDiagnosticInfosSize = i;
	}

	return out;
}
#endif

/* DeleteMonitoredItemsRequest */
#ifdef UA_TYPES_DELETEMONITOREDITEMSREQUEST

static void XS_pack_UA_DeleteMonitoredItemsRequest(SV *out, UA_DeleteMonitoredItemsRequest in)  __attribute__((unused));
static void
XS_pack_UA_DeleteMonitoredItemsRequest(SV *out, UA_DeleteMonitoredItemsRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "DeleteMonitoredItemsRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "DeleteMonitoredItemsRequest_subscriptionId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.monitoredItemIdsSize);
	for (i = 0; i < in.monitoredItemIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.monitoredItemIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteMonitoredItemsRequest_monitoredItemIds", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteMonitoredItemsRequest XS_unpack_UA_DeleteMonitoredItemsRequest(SV *in)  __attribute__((unused));
static UA_DeleteMonitoredItemsRequest
XS_unpack_UA_DeleteMonitoredItemsRequest(SV *in)
{
	dTHX;
	UA_DeleteMonitoredItemsRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteMonitoredItemsRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteMonitoredItemsRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "DeleteMonitoredItemsRequest_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "DeleteMonitoredItemsRequest_monitoredItemIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteMonitoredItemsRequest_monitoredItemIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.monitoredItemIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.monitoredItemIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.monitoredItemIds[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.monitoredItemIdsSize = i;
	}

	return out;
}
#endif

/* DeleteMonitoredItemsResponse */
#ifdef UA_TYPES_DELETEMONITOREDITEMSRESPONSE

static void XS_pack_UA_DeleteMonitoredItemsResponse(SV *out, UA_DeleteMonitoredItemsResponse in)  __attribute__((unused));
static void
XS_pack_UA_DeleteMonitoredItemsResponse(SV *out, UA_DeleteMonitoredItemsResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "DeleteMonitoredItemsResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteMonitoredItemsResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteMonitoredItemsResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteMonitoredItemsResponse XS_unpack_UA_DeleteMonitoredItemsResponse(SV *in)  __attribute__((unused));
static UA_DeleteMonitoredItemsResponse
XS_unpack_UA_DeleteMonitoredItemsResponse(SV *in)
{
	dTHX;
	UA_DeleteMonitoredItemsResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteMonitoredItemsResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteMonitoredItemsResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "DeleteMonitoredItemsResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteMonitoredItemsResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "DeleteMonitoredItemsResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteMonitoredItemsResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* CreateSubscriptionRequest */
#ifdef UA_TYPES_CREATESUBSCRIPTIONREQUEST

static void XS_pack_UA_CreateSubscriptionRequest(SV *out, UA_CreateSubscriptionRequest in)  __attribute__((unused));
static void
XS_pack_UA_CreateSubscriptionRequest(SV *out, UA_CreateSubscriptionRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "CreateSubscriptionRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.requestedPublishingInterval);
	hv_stores(hv, "CreateSubscriptionRequest_requestedPublishingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestedLifetimeCount);
	hv_stores(hv, "CreateSubscriptionRequest_requestedLifetimeCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestedMaxKeepAliveCount);
	hv_stores(hv, "CreateSubscriptionRequest_requestedMaxKeepAliveCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxNotificationsPerPublish);
	hv_stores(hv, "CreateSubscriptionRequest_maxNotificationsPerPublish", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.publishingEnabled);
	hv_stores(hv, "CreateSubscriptionRequest_publishingEnabled", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.priority);
	hv_stores(hv, "CreateSubscriptionRequest_priority", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CreateSubscriptionRequest XS_unpack_UA_CreateSubscriptionRequest(SV *in)  __attribute__((unused));
static UA_CreateSubscriptionRequest
XS_unpack_UA_CreateSubscriptionRequest(SV *in)
{
	dTHX;
	UA_CreateSubscriptionRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CreateSubscriptionRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CreateSubscriptionRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionRequest_requestedPublishingInterval", 0);
	if (svp != NULL)
		out.requestedPublishingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionRequest_requestedLifetimeCount", 0);
	if (svp != NULL)
		out.requestedLifetimeCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionRequest_requestedMaxKeepAliveCount", 0);
	if (svp != NULL)
		out.requestedMaxKeepAliveCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionRequest_maxNotificationsPerPublish", 0);
	if (svp != NULL)
		out.maxNotificationsPerPublish = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionRequest_publishingEnabled", 0);
	if (svp != NULL)
		out.publishingEnabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionRequest_priority", 0);
	if (svp != NULL)
		out.priority = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* CreateSubscriptionResponse */
#ifdef UA_TYPES_CREATESUBSCRIPTIONRESPONSE

static void XS_pack_UA_CreateSubscriptionResponse(SV *out, UA_CreateSubscriptionResponse in)  __attribute__((unused));
static void
XS_pack_UA_CreateSubscriptionResponse(SV *out, UA_CreateSubscriptionResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "CreateSubscriptionResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "CreateSubscriptionResponse_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.revisedPublishingInterval);
	hv_stores(hv, "CreateSubscriptionResponse_revisedPublishingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.revisedLifetimeCount);
	hv_stores(hv, "CreateSubscriptionResponse_revisedLifetimeCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.revisedMaxKeepAliveCount);
	hv_stores(hv, "CreateSubscriptionResponse_revisedMaxKeepAliveCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_CreateSubscriptionResponse XS_unpack_UA_CreateSubscriptionResponse(SV *in)  __attribute__((unused));
static UA_CreateSubscriptionResponse
XS_unpack_UA_CreateSubscriptionResponse(SV *in)
{
	dTHX;
	UA_CreateSubscriptionResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_CreateSubscriptionResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "CreateSubscriptionResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionResponse_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionResponse_revisedPublishingInterval", 0);
	if (svp != NULL)
		out.revisedPublishingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionResponse_revisedLifetimeCount", 0);
	if (svp != NULL)
		out.revisedLifetimeCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "CreateSubscriptionResponse_revisedMaxKeepAliveCount", 0);
	if (svp != NULL)
		out.revisedMaxKeepAliveCount = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* ModifySubscriptionRequest */
#ifdef UA_TYPES_MODIFYSUBSCRIPTIONREQUEST

static void XS_pack_UA_ModifySubscriptionRequest(SV *out, UA_ModifySubscriptionRequest in)  __attribute__((unused));
static void
XS_pack_UA_ModifySubscriptionRequest(SV *out, UA_ModifySubscriptionRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "ModifySubscriptionRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "ModifySubscriptionRequest_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.requestedPublishingInterval);
	hv_stores(hv, "ModifySubscriptionRequest_requestedPublishingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestedLifetimeCount);
	hv_stores(hv, "ModifySubscriptionRequest_requestedLifetimeCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.requestedMaxKeepAliveCount);
	hv_stores(hv, "ModifySubscriptionRequest_requestedMaxKeepAliveCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxNotificationsPerPublish);
	hv_stores(hv, "ModifySubscriptionRequest_maxNotificationsPerPublish", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.priority);
	hv_stores(hv, "ModifySubscriptionRequest_priority", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ModifySubscriptionRequest XS_unpack_UA_ModifySubscriptionRequest(SV *in)  __attribute__((unused));
static UA_ModifySubscriptionRequest
XS_unpack_UA_ModifySubscriptionRequest(SV *in)
{
	dTHX;
	UA_ModifySubscriptionRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ModifySubscriptionRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ModifySubscriptionRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionRequest_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionRequest_requestedPublishingInterval", 0);
	if (svp != NULL)
		out.requestedPublishingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionRequest_requestedLifetimeCount", 0);
	if (svp != NULL)
		out.requestedLifetimeCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionRequest_requestedMaxKeepAliveCount", 0);
	if (svp != NULL)
		out.requestedMaxKeepAliveCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionRequest_maxNotificationsPerPublish", 0);
	if (svp != NULL)
		out.maxNotificationsPerPublish = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionRequest_priority", 0);
	if (svp != NULL)
		out.priority = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* ModifySubscriptionResponse */
#ifdef UA_TYPES_MODIFYSUBSCRIPTIONRESPONSE

static void XS_pack_UA_ModifySubscriptionResponse(SV *out, UA_ModifySubscriptionResponse in)  __attribute__((unused));
static void
XS_pack_UA_ModifySubscriptionResponse(SV *out, UA_ModifySubscriptionResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "ModifySubscriptionResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.revisedPublishingInterval);
	hv_stores(hv, "ModifySubscriptionResponse_revisedPublishingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.revisedLifetimeCount);
	hv_stores(hv, "ModifySubscriptionResponse_revisedLifetimeCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.revisedMaxKeepAliveCount);
	hv_stores(hv, "ModifySubscriptionResponse_revisedMaxKeepAliveCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ModifySubscriptionResponse XS_unpack_UA_ModifySubscriptionResponse(SV *in)  __attribute__((unused));
static UA_ModifySubscriptionResponse
XS_unpack_UA_ModifySubscriptionResponse(SV *in)
{
	dTHX;
	UA_ModifySubscriptionResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ModifySubscriptionResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ModifySubscriptionResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionResponse_revisedPublishingInterval", 0);
	if (svp != NULL)
		out.revisedPublishingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionResponse_revisedLifetimeCount", 0);
	if (svp != NULL)
		out.revisedLifetimeCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ModifySubscriptionResponse_revisedMaxKeepAliveCount", 0);
	if (svp != NULL)
		out.revisedMaxKeepAliveCount = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* SetPublishingModeRequest */
#ifdef UA_TYPES_SETPUBLISHINGMODEREQUEST

static void XS_pack_UA_SetPublishingModeRequest(SV *out, UA_SetPublishingModeRequest in)  __attribute__((unused));
static void
XS_pack_UA_SetPublishingModeRequest(SV *out, UA_SetPublishingModeRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "SetPublishingModeRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.publishingEnabled);
	hv_stores(hv, "SetPublishingModeRequest_publishingEnabled", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.subscriptionIdsSize);
	for (i = 0; i < in.subscriptionIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.subscriptionIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetPublishingModeRequest_subscriptionIds", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SetPublishingModeRequest XS_unpack_UA_SetPublishingModeRequest(SV *in)  __attribute__((unused));
static UA_SetPublishingModeRequest
XS_unpack_UA_SetPublishingModeRequest(SV *in)
{
	dTHX;
	UA_SetPublishingModeRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SetPublishingModeRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SetPublishingModeRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "SetPublishingModeRequest_publishingEnabled", 0);
	if (svp != NULL)
		out.publishingEnabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "SetPublishingModeRequest_subscriptionIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetPublishingModeRequest_subscriptionIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.subscriptionIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.subscriptionIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.subscriptionIds[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.subscriptionIdsSize = i;
	}

	return out;
}
#endif

/* SetPublishingModeResponse */
#ifdef UA_TYPES_SETPUBLISHINGMODERESPONSE

static void XS_pack_UA_SetPublishingModeResponse(SV *out, UA_SetPublishingModeResponse in)  __attribute__((unused));
static void
XS_pack_UA_SetPublishingModeResponse(SV *out, UA_SetPublishingModeResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "SetPublishingModeResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetPublishingModeResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SetPublishingModeResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SetPublishingModeResponse XS_unpack_UA_SetPublishingModeResponse(SV *in)  __attribute__((unused));
static UA_SetPublishingModeResponse
XS_unpack_UA_SetPublishingModeResponse(SV *in)
{
	dTHX;
	UA_SetPublishingModeResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SetPublishingModeResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SetPublishingModeResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "SetPublishingModeResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetPublishingModeResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "SetPublishingModeResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SetPublishingModeResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* NotificationMessage */
#ifdef UA_TYPES_NOTIFICATIONMESSAGE

static void XS_pack_UA_NotificationMessage(SV *out, UA_NotificationMessage in)  __attribute__((unused));
static void
XS_pack_UA_NotificationMessage(SV *out, UA_NotificationMessage in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.sequenceNumber);
	hv_stores(hv, "NotificationMessage_sequenceNumber", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.publishTime);
	hv_stores(hv, "NotificationMessage_publishTime", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.notificationDataSize);
	for (i = 0; i < in.notificationDataSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ExtensionObject(sv, in.notificationData[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "NotificationMessage_notificationData", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_NotificationMessage XS_unpack_UA_NotificationMessage(SV *in)  __attribute__((unused));
static UA_NotificationMessage
XS_unpack_UA_NotificationMessage(SV *in)
{
	dTHX;
	UA_NotificationMessage out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_NotificationMessage_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "NotificationMessage_sequenceNumber", 0);
	if (svp != NULL)
		out.sequenceNumber = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "NotificationMessage_publishTime", 0);
	if (svp != NULL)
		out.publishTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "NotificationMessage_notificationData", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for NotificationMessage_notificationData");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.notificationData = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_EXTENSIONOBJECT]);
		if (out.notificationData == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.notificationData[i] = XS_unpack_UA_ExtensionObject(*svp);
			}
		}
		out.notificationDataSize = i;
	}

	return out;
}
#endif

/* NotificationData */
#ifdef UA_TYPES_NOTIFICATIONDATA

static void XS_pack_UA_NotificationData(SV *out, UA_NotificationData in)  __attribute__((unused));
static void
XS_pack_UA_NotificationData(SV *out, UA_NotificationData in)
{
	dTHX;
	CROAK("No conversion implemented");
}

static UA_NotificationData XS_unpack_UA_NotificationData(SV *in)  __attribute__((unused));
static UA_NotificationData
XS_unpack_UA_NotificationData(SV *in)
{
	dTHX;
	CROAK("No conversion implemented");
}
#endif

/* MonitoredItemNotification */
#ifdef UA_TYPES_MONITOREDITEMNOTIFICATION

static void XS_pack_UA_MonitoredItemNotification(SV *out, UA_MonitoredItemNotification in)  __attribute__((unused));
static void
XS_pack_UA_MonitoredItemNotification(SV *out, UA_MonitoredItemNotification in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.clientHandle);
	hv_stores(hv, "MonitoredItemNotification_clientHandle", sv);

	sv = newSV(0);
	XS_pack_UA_DataValue(sv, in.value);
	hv_stores(hv, "MonitoredItemNotification_value", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_MonitoredItemNotification XS_unpack_UA_MonitoredItemNotification(SV *in)  __attribute__((unused));
static UA_MonitoredItemNotification
XS_unpack_UA_MonitoredItemNotification(SV *in)
{
	dTHX;
	UA_MonitoredItemNotification out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_MonitoredItemNotification_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "MonitoredItemNotification_clientHandle", 0);
	if (svp != NULL)
		out.clientHandle = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "MonitoredItemNotification_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_DataValue(*svp);

	return out;
}
#endif

/* EventFieldList */
#ifdef UA_TYPES_EVENTFIELDLIST

static void XS_pack_UA_EventFieldList(SV *out, UA_EventFieldList in)  __attribute__((unused));
static void
XS_pack_UA_EventFieldList(SV *out, UA_EventFieldList in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.clientHandle);
	hv_stores(hv, "EventFieldList_clientHandle", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.eventFieldsSize);
	for (i = 0; i < in.eventFieldsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Variant(sv, in.eventFields[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EventFieldList_eventFields", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EventFieldList XS_unpack_UA_EventFieldList(SV *in)  __attribute__((unused));
static UA_EventFieldList
XS_unpack_UA_EventFieldList(SV *in)
{
	dTHX;
	UA_EventFieldList out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EventFieldList_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EventFieldList_clientHandle", 0);
	if (svp != NULL)
		out.clientHandle = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "EventFieldList_eventFields", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EventFieldList_eventFields");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.eventFields = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_VARIANT]);
		if (out.eventFields == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.eventFields[i] = XS_unpack_UA_Variant(*svp);
			}
		}
		out.eventFieldsSize = i;
	}

	return out;
}
#endif

/* HistoryEventFieldList */
#ifdef UA_TYPES_HISTORYEVENTFIELDLIST

static void XS_pack_UA_HistoryEventFieldList(SV *out, UA_HistoryEventFieldList in)  __attribute__((unused));
static void
XS_pack_UA_HistoryEventFieldList(SV *out, UA_HistoryEventFieldList in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.eventFieldsSize);
	for (i = 0; i < in.eventFieldsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Variant(sv, in.eventFields[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryEventFieldList_eventFields", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryEventFieldList XS_unpack_UA_HistoryEventFieldList(SV *in)  __attribute__((unused));
static UA_HistoryEventFieldList
XS_unpack_UA_HistoryEventFieldList(SV *in)
{
	dTHX;
	UA_HistoryEventFieldList out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryEventFieldList_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryEventFieldList_eventFields", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryEventFieldList_eventFields");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.eventFields = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_VARIANT]);
		if (out.eventFields == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.eventFields[i] = XS_unpack_UA_Variant(*svp);
			}
		}
		out.eventFieldsSize = i;
	}

	return out;
}
#endif

/* StatusChangeNotification */
#ifdef UA_TYPES_STATUSCHANGENOTIFICATION

static void XS_pack_UA_StatusChangeNotification(SV *out, UA_StatusChangeNotification in)  __attribute__((unused));
static void
XS_pack_UA_StatusChangeNotification(SV *out, UA_StatusChangeNotification in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.status);
	hv_stores(hv, "StatusChangeNotification_status", sv);

	sv = newSV(0);
	XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfo);
	hv_stores(hv, "StatusChangeNotification_diagnosticInfo", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_StatusChangeNotification XS_unpack_UA_StatusChangeNotification(SV *in)  __attribute__((unused));
static UA_StatusChangeNotification
XS_unpack_UA_StatusChangeNotification(SV *in)
{
	dTHX;
	UA_StatusChangeNotification out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_StatusChangeNotification_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "StatusChangeNotification_status", 0);
	if (svp != NULL)
		out.status = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "StatusChangeNotification_diagnosticInfo", 0);
	if (svp != NULL)
		out.diagnosticInfo = XS_unpack_UA_DiagnosticInfo(*svp);

	return out;
}
#endif

/* SubscriptionAcknowledgement */
#ifdef UA_TYPES_SUBSCRIPTIONACKNOWLEDGEMENT

static void XS_pack_UA_SubscriptionAcknowledgement(SV *out, UA_SubscriptionAcknowledgement in)  __attribute__((unused));
static void
XS_pack_UA_SubscriptionAcknowledgement(SV *out, UA_SubscriptionAcknowledgement in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "SubscriptionAcknowledgement_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.sequenceNumber);
	hv_stores(hv, "SubscriptionAcknowledgement_sequenceNumber", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SubscriptionAcknowledgement XS_unpack_UA_SubscriptionAcknowledgement(SV *in)  __attribute__((unused));
static UA_SubscriptionAcknowledgement
XS_unpack_UA_SubscriptionAcknowledgement(SV *in)
{
	dTHX;
	UA_SubscriptionAcknowledgement out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SubscriptionAcknowledgement_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SubscriptionAcknowledgement_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionAcknowledgement_sequenceNumber", 0);
	if (svp != NULL)
		out.sequenceNumber = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* PublishRequest */
#ifdef UA_TYPES_PUBLISHREQUEST

static void XS_pack_UA_PublishRequest(SV *out, UA_PublishRequest in)  __attribute__((unused));
static void
XS_pack_UA_PublishRequest(SV *out, UA_PublishRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "PublishRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.subscriptionAcknowledgementsSize);
	for (i = 0; i < in.subscriptionAcknowledgementsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SubscriptionAcknowledgement(sv, in.subscriptionAcknowledgements[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishRequest_subscriptionAcknowledgements", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PublishRequest XS_unpack_UA_PublishRequest(SV *in)  __attribute__((unused));
static UA_PublishRequest
XS_unpack_UA_PublishRequest(SV *in)
{
	dTHX;
	UA_PublishRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PublishRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PublishRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "PublishRequest_subscriptionAcknowledgements", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishRequest_subscriptionAcknowledgements");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.subscriptionAcknowledgements = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SUBSCRIPTIONACKNOWLEDGEMENT]);
		if (out.subscriptionAcknowledgements == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.subscriptionAcknowledgements[i] = XS_unpack_UA_SubscriptionAcknowledgement(*svp);
			}
		}
		out.subscriptionAcknowledgementsSize = i;
	}

	return out;
}
#endif

/* PublishResponse */
#ifdef UA_TYPES_PUBLISHRESPONSE

static void XS_pack_UA_PublishResponse(SV *out, UA_PublishResponse in)  __attribute__((unused));
static void
XS_pack_UA_PublishResponse(SV *out, UA_PublishResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "PublishResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "PublishResponse_subscriptionId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.availableSequenceNumbersSize);
	for (i = 0; i < in.availableSequenceNumbersSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.availableSequenceNumbers[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishResponse_availableSequenceNumbers", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.moreNotifications);
	hv_stores(hv, "PublishResponse_moreNotifications", sv);

	sv = newSV(0);
	XS_pack_UA_NotificationMessage(sv, in.notificationMessage);
	hv_stores(hv, "PublishResponse_notificationMessage", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PublishResponse XS_unpack_UA_PublishResponse(SV *in)  __attribute__((unused));
static UA_PublishResponse
XS_unpack_UA_PublishResponse(SV *in)
{
	dTHX;
	UA_PublishResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PublishResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PublishResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "PublishResponse_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "PublishResponse_availableSequenceNumbers", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishResponse_availableSequenceNumbers");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.availableSequenceNumbers = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.availableSequenceNumbers == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.availableSequenceNumbers[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.availableSequenceNumbersSize = i;
	}

	svp = hv_fetchs(hv, "PublishResponse_moreNotifications", 0);
	if (svp != NULL)
		out.moreNotifications = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "PublishResponse_notificationMessage", 0);
	if (svp != NULL)
		out.notificationMessage = XS_unpack_UA_NotificationMessage(*svp);

	svp = hv_fetchs(hv, "PublishResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "PublishResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* RepublishRequest */
#ifdef UA_TYPES_REPUBLISHREQUEST

static void XS_pack_UA_RepublishRequest(SV *out, UA_RepublishRequest in)  __attribute__((unused));
static void
XS_pack_UA_RepublishRequest(SV *out, UA_RepublishRequest in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "RepublishRequest_requestHeader", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "RepublishRequest_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.retransmitSequenceNumber);
	hv_stores(hv, "RepublishRequest_retransmitSequenceNumber", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RepublishRequest XS_unpack_UA_RepublishRequest(SV *in)  __attribute__((unused));
static UA_RepublishRequest
XS_unpack_UA_RepublishRequest(SV *in)
{
	dTHX;
	UA_RepublishRequest out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RepublishRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RepublishRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "RepublishRequest_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "RepublishRequest_retransmitSequenceNumber", 0);
	if (svp != NULL)
		out.retransmitSequenceNumber = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* RepublishResponse */
#ifdef UA_TYPES_REPUBLISHRESPONSE

static void XS_pack_UA_RepublishResponse(SV *out, UA_RepublishResponse in)  __attribute__((unused));
static void
XS_pack_UA_RepublishResponse(SV *out, UA_RepublishResponse in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "RepublishResponse_responseHeader", sv);

	sv = newSV(0);
	XS_pack_UA_NotificationMessage(sv, in.notificationMessage);
	hv_stores(hv, "RepublishResponse_notificationMessage", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RepublishResponse XS_unpack_UA_RepublishResponse(SV *in)  __attribute__((unused));
static UA_RepublishResponse
XS_unpack_UA_RepublishResponse(SV *in)
{
	dTHX;
	UA_RepublishResponse out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RepublishResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RepublishResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "RepublishResponse_notificationMessage", 0);
	if (svp != NULL)
		out.notificationMessage = XS_unpack_UA_NotificationMessage(*svp);

	return out;
}
#endif

/* TransferResult */
#ifdef UA_TYPES_TRANSFERRESULT

static void XS_pack_UA_TransferResult(SV *out, UA_TransferResult in)  __attribute__((unused));
static void
XS_pack_UA_TransferResult(SV *out, UA_TransferResult in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "TransferResult_statusCode", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.availableSequenceNumbersSize);
	for (i = 0; i < in.availableSequenceNumbersSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.availableSequenceNumbers[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TransferResult_availableSequenceNumbers", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TransferResult XS_unpack_UA_TransferResult(SV *in)  __attribute__((unused));
static UA_TransferResult
XS_unpack_UA_TransferResult(SV *in)
{
	dTHX;
	UA_TransferResult out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TransferResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TransferResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "TransferResult_availableSequenceNumbers", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TransferResult_availableSequenceNumbers");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.availableSequenceNumbers = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.availableSequenceNumbers == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.availableSequenceNumbers[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.availableSequenceNumbersSize = i;
	}

	return out;
}
#endif

/* TransferSubscriptionsRequest */
#ifdef UA_TYPES_TRANSFERSUBSCRIPTIONSREQUEST

static void XS_pack_UA_TransferSubscriptionsRequest(SV *out, UA_TransferSubscriptionsRequest in)  __attribute__((unused));
static void
XS_pack_UA_TransferSubscriptionsRequest(SV *out, UA_TransferSubscriptionsRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "TransferSubscriptionsRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.subscriptionIdsSize);
	for (i = 0; i < in.subscriptionIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.subscriptionIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TransferSubscriptionsRequest_subscriptionIds", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.sendInitialValues);
	hv_stores(hv, "TransferSubscriptionsRequest_sendInitialValues", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TransferSubscriptionsRequest XS_unpack_UA_TransferSubscriptionsRequest(SV *in)  __attribute__((unused));
static UA_TransferSubscriptionsRequest
XS_unpack_UA_TransferSubscriptionsRequest(SV *in)
{
	dTHX;
	UA_TransferSubscriptionsRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TransferSubscriptionsRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TransferSubscriptionsRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "TransferSubscriptionsRequest_subscriptionIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TransferSubscriptionsRequest_subscriptionIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.subscriptionIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.subscriptionIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.subscriptionIds[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.subscriptionIdsSize = i;
	}

	svp = hv_fetchs(hv, "TransferSubscriptionsRequest_sendInitialValues", 0);
	if (svp != NULL)
		out.sendInitialValues = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif

/* TransferSubscriptionsResponse */
#ifdef UA_TYPES_TRANSFERSUBSCRIPTIONSRESPONSE

static void XS_pack_UA_TransferSubscriptionsResponse(SV *out, UA_TransferSubscriptionsResponse in)  __attribute__((unused));
static void
XS_pack_UA_TransferSubscriptionsResponse(SV *out, UA_TransferSubscriptionsResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "TransferSubscriptionsResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_TransferResult(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TransferSubscriptionsResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TransferSubscriptionsResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TransferSubscriptionsResponse XS_unpack_UA_TransferSubscriptionsResponse(SV *in)  __attribute__((unused));
static UA_TransferSubscriptionsResponse
XS_unpack_UA_TransferSubscriptionsResponse(SV *in)
{
	dTHX;
	UA_TransferSubscriptionsResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TransferSubscriptionsResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TransferSubscriptionsResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "TransferSubscriptionsResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TransferSubscriptionsResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_TRANSFERRESULT]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_TransferResult(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "TransferSubscriptionsResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TransferSubscriptionsResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* DeleteSubscriptionsRequest */
#ifdef UA_TYPES_DELETESUBSCRIPTIONSREQUEST

static void XS_pack_UA_DeleteSubscriptionsRequest(SV *out, UA_DeleteSubscriptionsRequest in)  __attribute__((unused));
static void
XS_pack_UA_DeleteSubscriptionsRequest(SV *out, UA_DeleteSubscriptionsRequest in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_RequestHeader(sv, in.requestHeader);
	hv_stores(hv, "DeleteSubscriptionsRequest_requestHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.subscriptionIdsSize);
	for (i = 0; i < in.subscriptionIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.subscriptionIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteSubscriptionsRequest_subscriptionIds", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteSubscriptionsRequest XS_unpack_UA_DeleteSubscriptionsRequest(SV *in)  __attribute__((unused));
static UA_DeleteSubscriptionsRequest
XS_unpack_UA_DeleteSubscriptionsRequest(SV *in)
{
	dTHX;
	UA_DeleteSubscriptionsRequest out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteSubscriptionsRequest_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteSubscriptionsRequest_requestHeader", 0);
	if (svp != NULL)
		out.requestHeader = XS_unpack_UA_RequestHeader(*svp);

	svp = hv_fetchs(hv, "DeleteSubscriptionsRequest_subscriptionIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteSubscriptionsRequest_subscriptionIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.subscriptionIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.subscriptionIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.subscriptionIds[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.subscriptionIdsSize = i;
	}

	return out;
}
#endif

/* DeleteSubscriptionsResponse */
#ifdef UA_TYPES_DELETESUBSCRIPTIONSRESPONSE

static void XS_pack_UA_DeleteSubscriptionsResponse(SV *out, UA_DeleteSubscriptionsResponse in)  __attribute__((unused));
static void
XS_pack_UA_DeleteSubscriptionsResponse(SV *out, UA_DeleteSubscriptionsResponse in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_ResponseHeader(sv, in.responseHeader);
	hv_stores(hv, "DeleteSubscriptionsResponse_responseHeader", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.resultsSize);
	for (i = 0; i < in.resultsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StatusCode(sv, in.results[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteSubscriptionsResponse_results", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DeleteSubscriptionsResponse_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DeleteSubscriptionsResponse XS_unpack_UA_DeleteSubscriptionsResponse(SV *in)  __attribute__((unused));
static UA_DeleteSubscriptionsResponse
XS_unpack_UA_DeleteSubscriptionsResponse(SV *in)
{
	dTHX;
	UA_DeleteSubscriptionsResponse out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DeleteSubscriptionsResponse_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DeleteSubscriptionsResponse_responseHeader", 0);
	if (svp != NULL)
		out.responseHeader = XS_unpack_UA_ResponseHeader(*svp);

	svp = hv_fetchs(hv, "DeleteSubscriptionsResponse_results", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteSubscriptionsResponse_results");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.results = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STATUSCODE]);
		if (out.results == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.results[i] = XS_unpack_UA_StatusCode(*svp);
			}
		}
		out.resultsSize = i;
	}

	svp = hv_fetchs(hv, "DeleteSubscriptionsResponse_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DeleteSubscriptionsResponse_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* BuildInfo */
#ifdef UA_TYPES_BUILDINFO

static void XS_pack_UA_BuildInfo(SV *out, UA_BuildInfo in)  __attribute__((unused));
static void
XS_pack_UA_BuildInfo(SV *out, UA_BuildInfo in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.productUri);
	hv_stores(hv, "BuildInfo_productUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.manufacturerName);
	hv_stores(hv, "BuildInfo_manufacturerName", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.productName);
	hv_stores(hv, "BuildInfo_productName", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.softwareVersion);
	hv_stores(hv, "BuildInfo_softwareVersion", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.buildNumber);
	hv_stores(hv, "BuildInfo_buildNumber", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.buildDate);
	hv_stores(hv, "BuildInfo_buildDate", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_BuildInfo XS_unpack_UA_BuildInfo(SV *in)  __attribute__((unused));
static UA_BuildInfo
XS_unpack_UA_BuildInfo(SV *in)
{
	dTHX;
	UA_BuildInfo out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_BuildInfo_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "BuildInfo_productUri", 0);
	if (svp != NULL)
		out.productUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BuildInfo_manufacturerName", 0);
	if (svp != NULL)
		out.manufacturerName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BuildInfo_productName", 0);
	if (svp != NULL)
		out.productName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BuildInfo_softwareVersion", 0);
	if (svp != NULL)
		out.softwareVersion = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BuildInfo_buildNumber", 0);
	if (svp != NULL)
		out.buildNumber = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "BuildInfo_buildDate", 0);
	if (svp != NULL)
		out.buildDate = XS_unpack_UA_DateTime(*svp);

	return out;
}
#endif

/* RedundancySupport */
#ifdef UA_TYPES_REDUNDANCYSUPPORT

static void XS_pack_UA_RedundancySupport(SV *out, UA_RedundancySupport in)  __attribute__((unused));
static void
XS_pack_UA_RedundancySupport(SV *out, UA_RedundancySupport in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_RedundancySupport XS_unpack_UA_RedundancySupport(SV *in)  __attribute__((unused));
static UA_RedundancySupport
XS_unpack_UA_RedundancySupport(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ServerState */
#ifdef UA_TYPES_SERVERSTATE

static void XS_pack_UA_ServerState(SV *out, UA_ServerState in)  __attribute__((unused));
static void
XS_pack_UA_ServerState(SV *out, UA_ServerState in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_ServerState XS_unpack_UA_ServerState(SV *in)  __attribute__((unused));
static UA_ServerState
XS_unpack_UA_ServerState(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* RedundantServerDataType */
#ifdef UA_TYPES_REDUNDANTSERVERDATATYPE

static void XS_pack_UA_RedundantServerDataType(SV *out, UA_RedundantServerDataType in)  __attribute__((unused));
static void
XS_pack_UA_RedundantServerDataType(SV *out, UA_RedundantServerDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.serverId);
	hv_stores(hv, "RedundantServerDataType_serverId", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.serviceLevel);
	hv_stores(hv, "RedundantServerDataType_serviceLevel", sv);

	sv = newSV(0);
	XS_pack_UA_ServerState(sv, in.serverState);
	hv_stores(hv, "RedundantServerDataType_serverState", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_RedundantServerDataType XS_unpack_UA_RedundantServerDataType(SV *in)  __attribute__((unused));
static UA_RedundantServerDataType
XS_unpack_UA_RedundantServerDataType(SV *in)
{
	dTHX;
	UA_RedundantServerDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_RedundantServerDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "RedundantServerDataType_serverId", 0);
	if (svp != NULL)
		out.serverId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "RedundantServerDataType_serviceLevel", 0);
	if (svp != NULL)
		out.serviceLevel = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "RedundantServerDataType_serverState", 0);
	if (svp != NULL)
		out.serverState = XS_unpack_UA_ServerState(*svp);

	return out;
}
#endif

/* EndpointUrlListDataType */
#ifdef UA_TYPES_ENDPOINTURLLISTDATATYPE

static void XS_pack_UA_EndpointUrlListDataType(SV *out, UA_EndpointUrlListDataType in)  __attribute__((unused));
static void
XS_pack_UA_EndpointUrlListDataType(SV *out, UA_EndpointUrlListDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.endpointUrlListSize);
	for (i = 0; i < in.endpointUrlListSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.endpointUrlList[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EndpointUrlListDataType_endpointUrlList", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EndpointUrlListDataType XS_unpack_UA_EndpointUrlListDataType(SV *in)  __attribute__((unused));
static UA_EndpointUrlListDataType
XS_unpack_UA_EndpointUrlListDataType(SV *in)
{
	dTHX;
	UA_EndpointUrlListDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EndpointUrlListDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EndpointUrlListDataType_endpointUrlList", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EndpointUrlListDataType_endpointUrlList");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.endpointUrlList = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.endpointUrlList == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.endpointUrlList[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.endpointUrlListSize = i;
	}

	return out;
}
#endif

/* NetworkGroupDataType */
#ifdef UA_TYPES_NETWORKGROUPDATATYPE

static void XS_pack_UA_NetworkGroupDataType(SV *out, UA_NetworkGroupDataType in)  __attribute__((unused));
static void
XS_pack_UA_NetworkGroupDataType(SV *out, UA_NetworkGroupDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.serverUri);
	hv_stores(hv, "NetworkGroupDataType_serverUri", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.networkPathsSize);
	for (i = 0; i < in.networkPathsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EndpointUrlListDataType(sv, in.networkPaths[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "NetworkGroupDataType_networkPaths", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_NetworkGroupDataType XS_unpack_UA_NetworkGroupDataType(SV *in)  __attribute__((unused));
static UA_NetworkGroupDataType
XS_unpack_UA_NetworkGroupDataType(SV *in)
{
	dTHX;
	UA_NetworkGroupDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_NetworkGroupDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "NetworkGroupDataType_serverUri", 0);
	if (svp != NULL)
		out.serverUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "NetworkGroupDataType_networkPaths", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for NetworkGroupDataType_networkPaths");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.networkPaths = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENDPOINTURLLISTDATATYPE]);
		if (out.networkPaths == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.networkPaths[i] = XS_unpack_UA_EndpointUrlListDataType(*svp);
			}
		}
		out.networkPathsSize = i;
	}

	return out;
}
#endif

/* SamplingIntervalDiagnosticsDataType */
#ifdef UA_TYPES_SAMPLINGINTERVALDIAGNOSTICSDATATYPE

static void XS_pack_UA_SamplingIntervalDiagnosticsDataType(SV *out, UA_SamplingIntervalDiagnosticsDataType in)  __attribute__((unused));
static void
XS_pack_UA_SamplingIntervalDiagnosticsDataType(SV *out, UA_SamplingIntervalDiagnosticsDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.samplingInterval);
	hv_stores(hv, "SamplingIntervalDiagnosticsDataType_samplingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.monitoredItemCount);
	hv_stores(hv, "SamplingIntervalDiagnosticsDataType_monitoredItemCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxMonitoredItemCount);
	hv_stores(hv, "SamplingIntervalDiagnosticsDataType_maxMonitoredItemCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.disabledMonitoredItemCount);
	hv_stores(hv, "SamplingIntervalDiagnosticsDataType_disabledMonitoredItemCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SamplingIntervalDiagnosticsDataType XS_unpack_UA_SamplingIntervalDiagnosticsDataType(SV *in)  __attribute__((unused));
static UA_SamplingIntervalDiagnosticsDataType
XS_unpack_UA_SamplingIntervalDiagnosticsDataType(SV *in)
{
	dTHX;
	UA_SamplingIntervalDiagnosticsDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SamplingIntervalDiagnosticsDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SamplingIntervalDiagnosticsDataType_samplingInterval", 0);
	if (svp != NULL)
		out.samplingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "SamplingIntervalDiagnosticsDataType_monitoredItemCount", 0);
	if (svp != NULL)
		out.monitoredItemCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SamplingIntervalDiagnosticsDataType_maxMonitoredItemCount", 0);
	if (svp != NULL)
		out.maxMonitoredItemCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SamplingIntervalDiagnosticsDataType_disabledMonitoredItemCount", 0);
	if (svp != NULL)
		out.disabledMonitoredItemCount = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* ServerDiagnosticsSummaryDataType */
#ifdef UA_TYPES_SERVERDIAGNOSTICSSUMMARYDATATYPE

static void XS_pack_UA_ServerDiagnosticsSummaryDataType(SV *out, UA_ServerDiagnosticsSummaryDataType in)  __attribute__((unused));
static void
XS_pack_UA_ServerDiagnosticsSummaryDataType(SV *out, UA_ServerDiagnosticsSummaryDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.serverViewCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_serverViewCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.currentSessionCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_currentSessionCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.cumulatedSessionCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_cumulatedSessionCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.securityRejectedSessionCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_securityRejectedSessionCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.rejectedSessionCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_rejectedSessionCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.sessionTimeoutCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_sessionTimeoutCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.sessionAbortCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_sessionAbortCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.currentSubscriptionCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_currentSubscriptionCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.cumulatedSubscriptionCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_cumulatedSubscriptionCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.publishingIntervalCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_publishingIntervalCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.securityRejectedRequestsCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_securityRejectedRequestsCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.rejectedRequestsCount);
	hv_stores(hv, "ServerDiagnosticsSummaryDataType_rejectedRequestsCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ServerDiagnosticsSummaryDataType XS_unpack_UA_ServerDiagnosticsSummaryDataType(SV *in)  __attribute__((unused));
static UA_ServerDiagnosticsSummaryDataType
XS_unpack_UA_ServerDiagnosticsSummaryDataType(SV *in)
{
	dTHX;
	UA_ServerDiagnosticsSummaryDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ServerDiagnosticsSummaryDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_serverViewCount", 0);
	if (svp != NULL)
		out.serverViewCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_currentSessionCount", 0);
	if (svp != NULL)
		out.currentSessionCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_cumulatedSessionCount", 0);
	if (svp != NULL)
		out.cumulatedSessionCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_securityRejectedSessionCount", 0);
	if (svp != NULL)
		out.securityRejectedSessionCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_rejectedSessionCount", 0);
	if (svp != NULL)
		out.rejectedSessionCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_sessionTimeoutCount", 0);
	if (svp != NULL)
		out.sessionTimeoutCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_sessionAbortCount", 0);
	if (svp != NULL)
		out.sessionAbortCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_currentSubscriptionCount", 0);
	if (svp != NULL)
		out.currentSubscriptionCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_cumulatedSubscriptionCount", 0);
	if (svp != NULL)
		out.cumulatedSubscriptionCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_publishingIntervalCount", 0);
	if (svp != NULL)
		out.publishingIntervalCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_securityRejectedRequestsCount", 0);
	if (svp != NULL)
		out.securityRejectedRequestsCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerDiagnosticsSummaryDataType_rejectedRequestsCount", 0);
	if (svp != NULL)
		out.rejectedRequestsCount = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* ServerStatusDataType */
#ifdef UA_TYPES_SERVERSTATUSDATATYPE

static void XS_pack_UA_ServerStatusDataType(SV *out, UA_ServerStatusDataType in)  __attribute__((unused));
static void
XS_pack_UA_ServerStatusDataType(SV *out, UA_ServerStatusDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.startTime);
	hv_stores(hv, "ServerStatusDataType_startTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.currentTime);
	hv_stores(hv, "ServerStatusDataType_currentTime", sv);

	sv = newSV(0);
	XS_pack_UA_ServerState(sv, in.state);
	hv_stores(hv, "ServerStatusDataType_state", sv);

	sv = newSV(0);
	XS_pack_UA_BuildInfo(sv, in.buildInfo);
	hv_stores(hv, "ServerStatusDataType_buildInfo", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.secondsTillShutdown);
	hv_stores(hv, "ServerStatusDataType_secondsTillShutdown", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.shutdownReason);
	hv_stores(hv, "ServerStatusDataType_shutdownReason", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ServerStatusDataType XS_unpack_UA_ServerStatusDataType(SV *in)  __attribute__((unused));
static UA_ServerStatusDataType
XS_unpack_UA_ServerStatusDataType(SV *in)
{
	dTHX;
	UA_ServerStatusDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ServerStatusDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ServerStatusDataType_startTime", 0);
	if (svp != NULL)
		out.startTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ServerStatusDataType_currentTime", 0);
	if (svp != NULL)
		out.currentTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ServerStatusDataType_state", 0);
	if (svp != NULL)
		out.state = XS_unpack_UA_ServerState(*svp);

	svp = hv_fetchs(hv, "ServerStatusDataType_buildInfo", 0);
	if (svp != NULL)
		out.buildInfo = XS_unpack_UA_BuildInfo(*svp);

	svp = hv_fetchs(hv, "ServerStatusDataType_secondsTillShutdown", 0);
	if (svp != NULL)
		out.secondsTillShutdown = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServerStatusDataType_shutdownReason", 0);
	if (svp != NULL)
		out.shutdownReason = XS_unpack_UA_LocalizedText(*svp);

	return out;
}
#endif

/* SessionSecurityDiagnosticsDataType */
#ifdef UA_TYPES_SESSIONSECURITYDIAGNOSTICSDATATYPE

static void XS_pack_UA_SessionSecurityDiagnosticsDataType(SV *out, UA_SessionSecurityDiagnosticsDataType in)  __attribute__((unused));
static void
XS_pack_UA_SessionSecurityDiagnosticsDataType(SV *out, UA_SessionSecurityDiagnosticsDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.sessionId);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_sessionId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.clientUserIdOfSession);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_clientUserIdOfSession", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.clientUserIdHistorySize);
	for (i = 0; i < in.clientUserIdHistorySize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.clientUserIdHistory[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_clientUserIdHistory", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_String(sv, in.authenticationMechanism);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_authenticationMechanism", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.encoding);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_encoding", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.transportProtocol);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_transportProtocol", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityPolicyUri);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_securityPolicyUri", sv);

	sv = newSV(0);
	XS_pack_UA_ByteString(sv, in.clientCertificate);
	hv_stores(hv, "SessionSecurityDiagnosticsDataType_clientCertificate", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SessionSecurityDiagnosticsDataType XS_unpack_UA_SessionSecurityDiagnosticsDataType(SV *in)  __attribute__((unused));
static UA_SessionSecurityDiagnosticsDataType
XS_unpack_UA_SessionSecurityDiagnosticsDataType(SV *in)
{
	dTHX;
	UA_SessionSecurityDiagnosticsDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SessionSecurityDiagnosticsDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_sessionId", 0);
	if (svp != NULL)
		out.sessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_clientUserIdOfSession", 0);
	if (svp != NULL)
		out.clientUserIdOfSession = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_clientUserIdHistory", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionSecurityDiagnosticsDataType_clientUserIdHistory");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.clientUserIdHistory = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.clientUserIdHistory == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.clientUserIdHistory[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.clientUserIdHistorySize = i;
	}

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_authenticationMechanism", 0);
	if (svp != NULL)
		out.authenticationMechanism = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_encoding", 0);
	if (svp != NULL)
		out.encoding = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_transportProtocol", 0);
	if (svp != NULL)
		out.transportProtocol = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_securityPolicyUri", 0);
	if (svp != NULL)
		out.securityPolicyUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionSecurityDiagnosticsDataType_clientCertificate", 0);
	if (svp != NULL)
		out.clientCertificate = XS_unpack_UA_ByteString(*svp);

	return out;
}
#endif

/* ServiceCounterDataType */
#ifdef UA_TYPES_SERVICECOUNTERDATATYPE

static void XS_pack_UA_ServiceCounterDataType(SV *out, UA_ServiceCounterDataType in)  __attribute__((unused));
static void
XS_pack_UA_ServiceCounterDataType(SV *out, UA_ServiceCounterDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.totalCount);
	hv_stores(hv, "ServiceCounterDataType_totalCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.errorCount);
	hv_stores(hv, "ServiceCounterDataType_errorCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ServiceCounterDataType XS_unpack_UA_ServiceCounterDataType(SV *in)  __attribute__((unused));
static UA_ServiceCounterDataType
XS_unpack_UA_ServiceCounterDataType(SV *in)
{
	dTHX;
	UA_ServiceCounterDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ServiceCounterDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ServiceCounterDataType_totalCount", 0);
	if (svp != NULL)
		out.totalCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ServiceCounterDataType_errorCount", 0);
	if (svp != NULL)
		out.errorCount = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* StatusResult */
#ifdef UA_TYPES_STATUSRESULT

static void XS_pack_UA_StatusResult(SV *out, UA_StatusResult in)  __attribute__((unused));
static void
XS_pack_UA_StatusResult(SV *out, UA_StatusResult in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_StatusCode(sv, in.statusCode);
	hv_stores(hv, "StatusResult_statusCode", sv);

	sv = newSV(0);
	XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfo);
	hv_stores(hv, "StatusResult_diagnosticInfo", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_StatusResult XS_unpack_UA_StatusResult(SV *in)  __attribute__((unused));
static UA_StatusResult
XS_unpack_UA_StatusResult(SV *in)
{
	dTHX;
	UA_StatusResult out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_StatusResult_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "StatusResult_statusCode", 0);
	if (svp != NULL)
		out.statusCode = XS_unpack_UA_StatusCode(*svp);

	svp = hv_fetchs(hv, "StatusResult_diagnosticInfo", 0);
	if (svp != NULL)
		out.diagnosticInfo = XS_unpack_UA_DiagnosticInfo(*svp);

	return out;
}
#endif

/* SubscriptionDiagnosticsDataType */
#ifdef UA_TYPES_SUBSCRIPTIONDIAGNOSTICSDATATYPE

static void XS_pack_UA_SubscriptionDiagnosticsDataType(SV *out, UA_SubscriptionDiagnosticsDataType in)  __attribute__((unused));
static void
XS_pack_UA_SubscriptionDiagnosticsDataType(SV *out, UA_SubscriptionDiagnosticsDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.sessionId);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_sessionId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.subscriptionId);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_subscriptionId", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.priority);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_priority", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.publishingInterval);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_publishingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxKeepAliveCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_maxKeepAliveCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxLifetimeCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_maxLifetimeCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxNotificationsPerPublish);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_maxNotificationsPerPublish", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.publishingEnabled);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_publishingEnabled", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.modifyCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_modifyCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.enableCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_enableCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.disableCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_disableCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.republishRequestCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_republishRequestCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.republishMessageRequestCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_republishMessageRequestCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.republishMessageCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_republishMessageCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.transferRequestCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_transferRequestCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.transferredToAltClientCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_transferredToAltClientCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.transferredToSameClientCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_transferredToSameClientCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.publishRequestCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_publishRequestCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.dataChangeNotificationsCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_dataChangeNotificationsCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.eventNotificationsCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_eventNotificationsCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.notificationsCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_notificationsCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.latePublishRequestCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_latePublishRequestCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.currentKeepAliveCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_currentKeepAliveCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.currentLifetimeCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_currentLifetimeCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.unacknowledgedMessageCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_unacknowledgedMessageCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.discardedMessageCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_discardedMessageCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.monitoredItemCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_monitoredItemCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.disabledMonitoredItemCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_disabledMonitoredItemCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.monitoringQueueOverflowCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_monitoringQueueOverflowCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.nextSequenceNumber);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_nextSequenceNumber", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.eventQueueOverFlowCount);
	hv_stores(hv, "SubscriptionDiagnosticsDataType_eventQueueOverFlowCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SubscriptionDiagnosticsDataType XS_unpack_UA_SubscriptionDiagnosticsDataType(SV *in)  __attribute__((unused));
static UA_SubscriptionDiagnosticsDataType
XS_unpack_UA_SubscriptionDiagnosticsDataType(SV *in)
{
	dTHX;
	UA_SubscriptionDiagnosticsDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SubscriptionDiagnosticsDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_sessionId", 0);
	if (svp != NULL)
		out.sessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_subscriptionId", 0);
	if (svp != NULL)
		out.subscriptionId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_priority", 0);
	if (svp != NULL)
		out.priority = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_publishingInterval", 0);
	if (svp != NULL)
		out.publishingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_maxKeepAliveCount", 0);
	if (svp != NULL)
		out.maxKeepAliveCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_maxLifetimeCount", 0);
	if (svp != NULL)
		out.maxLifetimeCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_maxNotificationsPerPublish", 0);
	if (svp != NULL)
		out.maxNotificationsPerPublish = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_publishingEnabled", 0);
	if (svp != NULL)
		out.publishingEnabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_modifyCount", 0);
	if (svp != NULL)
		out.modifyCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_enableCount", 0);
	if (svp != NULL)
		out.enableCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_disableCount", 0);
	if (svp != NULL)
		out.disableCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_republishRequestCount", 0);
	if (svp != NULL)
		out.republishRequestCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_republishMessageRequestCount", 0);
	if (svp != NULL)
		out.republishMessageRequestCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_republishMessageCount", 0);
	if (svp != NULL)
		out.republishMessageCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_transferRequestCount", 0);
	if (svp != NULL)
		out.transferRequestCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_transferredToAltClientCount", 0);
	if (svp != NULL)
		out.transferredToAltClientCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_transferredToSameClientCount", 0);
	if (svp != NULL)
		out.transferredToSameClientCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_publishRequestCount", 0);
	if (svp != NULL)
		out.publishRequestCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_dataChangeNotificationsCount", 0);
	if (svp != NULL)
		out.dataChangeNotificationsCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_eventNotificationsCount", 0);
	if (svp != NULL)
		out.eventNotificationsCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_notificationsCount", 0);
	if (svp != NULL)
		out.notificationsCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_latePublishRequestCount", 0);
	if (svp != NULL)
		out.latePublishRequestCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_currentKeepAliveCount", 0);
	if (svp != NULL)
		out.currentKeepAliveCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_currentLifetimeCount", 0);
	if (svp != NULL)
		out.currentLifetimeCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_unacknowledgedMessageCount", 0);
	if (svp != NULL)
		out.unacknowledgedMessageCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_discardedMessageCount", 0);
	if (svp != NULL)
		out.discardedMessageCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_monitoredItemCount", 0);
	if (svp != NULL)
		out.monitoredItemCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_disabledMonitoredItemCount", 0);
	if (svp != NULL)
		out.disabledMonitoredItemCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_monitoringQueueOverflowCount", 0);
	if (svp != NULL)
		out.monitoringQueueOverflowCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_nextSequenceNumber", 0);
	if (svp != NULL)
		out.nextSequenceNumber = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SubscriptionDiagnosticsDataType_eventQueueOverFlowCount", 0);
	if (svp != NULL)
		out.eventQueueOverFlowCount = XS_unpack_UA_UInt32(*svp);

	return out;
}
#endif

/* ModelChangeStructureVerbMask */
#ifdef UA_TYPES_MODELCHANGESTRUCTUREVERBMASK

static void XS_pack_UA_ModelChangeStructureVerbMask(SV *out, UA_ModelChangeStructureVerbMask in)  __attribute__((unused));
static void
XS_pack_UA_ModelChangeStructureVerbMask(SV *out, UA_ModelChangeStructureVerbMask in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_ModelChangeStructureVerbMask XS_unpack_UA_ModelChangeStructureVerbMask(SV *in)  __attribute__((unused));
static UA_ModelChangeStructureVerbMask
XS_unpack_UA_ModelChangeStructureVerbMask(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ModelChangeStructureDataType */
#ifdef UA_TYPES_MODELCHANGESTRUCTUREDATATYPE

static void XS_pack_UA_ModelChangeStructureDataType(SV *out, UA_ModelChangeStructureDataType in)  __attribute__((unused));
static void
XS_pack_UA_ModelChangeStructureDataType(SV *out, UA_ModelChangeStructureDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.affected);
	hv_stores(hv, "ModelChangeStructureDataType_affected", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.affectedType);
	hv_stores(hv, "ModelChangeStructureDataType_affectedType", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.verb);
	hv_stores(hv, "ModelChangeStructureDataType_verb", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ModelChangeStructureDataType XS_unpack_UA_ModelChangeStructureDataType(SV *in)  __attribute__((unused));
static UA_ModelChangeStructureDataType
XS_unpack_UA_ModelChangeStructureDataType(SV *in)
{
	dTHX;
	UA_ModelChangeStructureDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ModelChangeStructureDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ModelChangeStructureDataType_affected", 0);
	if (svp != NULL)
		out.affected = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ModelChangeStructureDataType_affectedType", 0);
	if (svp != NULL)
		out.affectedType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ModelChangeStructureDataType_verb", 0);
	if (svp != NULL)
		out.verb = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* SemanticChangeStructureDataType */
#ifdef UA_TYPES_SEMANTICCHANGESTRUCTUREDATATYPE

static void XS_pack_UA_SemanticChangeStructureDataType(SV *out, UA_SemanticChangeStructureDataType in)  __attribute__((unused));
static void
XS_pack_UA_SemanticChangeStructureDataType(SV *out, UA_SemanticChangeStructureDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.affected);
	hv_stores(hv, "SemanticChangeStructureDataType_affected", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.affectedType);
	hv_stores(hv, "SemanticChangeStructureDataType_affectedType", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SemanticChangeStructureDataType XS_unpack_UA_SemanticChangeStructureDataType(SV *in)  __attribute__((unused));
static UA_SemanticChangeStructureDataType
XS_unpack_UA_SemanticChangeStructureDataType(SV *in)
{
	dTHX;
	UA_SemanticChangeStructureDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SemanticChangeStructureDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SemanticChangeStructureDataType_affected", 0);
	if (svp != NULL)
		out.affected = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "SemanticChangeStructureDataType_affectedType", 0);
	if (svp != NULL)
		out.affectedType = XS_unpack_UA_NodeId(*svp);

	return out;
}
#endif

/* Range */
#ifdef UA_TYPES_RANGE

static void XS_pack_UA_Range(SV *out, UA_Range in)  __attribute__((unused));
static void
XS_pack_UA_Range(SV *out, UA_Range in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.low);
	hv_stores(hv, "Range_low", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.high);
	hv_stores(hv, "Range_high", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_Range XS_unpack_UA_Range(SV *in)  __attribute__((unused));
static UA_Range
XS_unpack_UA_Range(SV *in)
{
	dTHX;
	UA_Range out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_Range_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "Range_low", 0);
	if (svp != NULL)
		out.low = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "Range_high", 0);
	if (svp != NULL)
		out.high = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* EUInformation */
#ifdef UA_TYPES_EUINFORMATION

static void XS_pack_UA_EUInformation(SV *out, UA_EUInformation in)  __attribute__((unused));
static void
XS_pack_UA_EUInformation(SV *out, UA_EUInformation in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.namespaceUri);
	hv_stores(hv, "EUInformation_namespaceUri", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.unitId);
	hv_stores(hv, "EUInformation_unitId", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.displayName);
	hv_stores(hv, "EUInformation_displayName", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "EUInformation_description", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EUInformation XS_unpack_UA_EUInformation(SV *in)  __attribute__((unused));
static UA_EUInformation
XS_unpack_UA_EUInformation(SV *in)
{
	dTHX;
	UA_EUInformation out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EUInformation_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EUInformation_namespaceUri", 0);
	if (svp != NULL)
		out.namespaceUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "EUInformation_unitId", 0);
	if (svp != NULL)
		out.unitId = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "EUInformation_displayName", 0);
	if (svp != NULL)
		out.displayName = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "EUInformation_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	return out;
}
#endif

/* AxisScaleEnumeration */
#ifdef UA_TYPES_AXISSCALEENUMERATION

static void XS_pack_UA_AxisScaleEnumeration(SV *out, UA_AxisScaleEnumeration in)  __attribute__((unused));
static void
XS_pack_UA_AxisScaleEnumeration(SV *out, UA_AxisScaleEnumeration in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_AxisScaleEnumeration XS_unpack_UA_AxisScaleEnumeration(SV *in)  __attribute__((unused));
static UA_AxisScaleEnumeration
XS_unpack_UA_AxisScaleEnumeration(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* ComplexNumberType */
#ifdef UA_TYPES_COMPLEXNUMBERTYPE

static void XS_pack_UA_ComplexNumberType(SV *out, UA_ComplexNumberType in)  __attribute__((unused));
static void
XS_pack_UA_ComplexNumberType(SV *out, UA_ComplexNumberType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Float(sv, in.real);
	hv_stores(hv, "ComplexNumberType_real", sv);

	sv = newSV(0);
	XS_pack_UA_Float(sv, in.imaginary);
	hv_stores(hv, "ComplexNumberType_imaginary", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ComplexNumberType XS_unpack_UA_ComplexNumberType(SV *in)  __attribute__((unused));
static UA_ComplexNumberType
XS_unpack_UA_ComplexNumberType(SV *in)
{
	dTHX;
	UA_ComplexNumberType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ComplexNumberType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ComplexNumberType_real", 0);
	if (svp != NULL)
		out.real = XS_unpack_UA_Float(*svp);

	svp = hv_fetchs(hv, "ComplexNumberType_imaginary", 0);
	if (svp != NULL)
		out.imaginary = XS_unpack_UA_Float(*svp);

	return out;
}
#endif

/* DoubleComplexNumberType */
#ifdef UA_TYPES_DOUBLECOMPLEXNUMBERTYPE

static void XS_pack_UA_DoubleComplexNumberType(SV *out, UA_DoubleComplexNumberType in)  __attribute__((unused));
static void
XS_pack_UA_DoubleComplexNumberType(SV *out, UA_DoubleComplexNumberType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.real);
	hv_stores(hv, "DoubleComplexNumberType_real", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.imaginary);
	hv_stores(hv, "DoubleComplexNumberType_imaginary", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DoubleComplexNumberType XS_unpack_UA_DoubleComplexNumberType(SV *in)  __attribute__((unused));
static UA_DoubleComplexNumberType
XS_unpack_UA_DoubleComplexNumberType(SV *in)
{
	dTHX;
	UA_DoubleComplexNumberType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DoubleComplexNumberType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DoubleComplexNumberType_real", 0);
	if (svp != NULL)
		out.real = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "DoubleComplexNumberType_imaginary", 0);
	if (svp != NULL)
		out.imaginary = XS_unpack_UA_Double(*svp);

	return out;
}
#endif

/* AxisInformation */
#ifdef UA_TYPES_AXISINFORMATION

static void XS_pack_UA_AxisInformation(SV *out, UA_AxisInformation in)  __attribute__((unused));
static void
XS_pack_UA_AxisInformation(SV *out, UA_AxisInformation in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_EUInformation(sv, in.engineeringUnits);
	hv_stores(hv, "AxisInformation_engineeringUnits", sv);

	sv = newSV(0);
	XS_pack_UA_Range(sv, in.eURange);
	hv_stores(hv, "AxisInformation_eURange", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.title);
	hv_stores(hv, "AxisInformation_title", sv);

	sv = newSV(0);
	XS_pack_UA_AxisScaleEnumeration(sv, in.axisScaleType);
	hv_stores(hv, "AxisInformation_axisScaleType", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.axisStepsSize);
	for (i = 0; i < in.axisStepsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Double(sv, in.axisSteps[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "AxisInformation_axisSteps", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_AxisInformation XS_unpack_UA_AxisInformation(SV *in)  __attribute__((unused));
static UA_AxisInformation
XS_unpack_UA_AxisInformation(SV *in)
{
	dTHX;
	UA_AxisInformation out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_AxisInformation_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "AxisInformation_engineeringUnits", 0);
	if (svp != NULL)
		out.engineeringUnits = XS_unpack_UA_EUInformation(*svp);

	svp = hv_fetchs(hv, "AxisInformation_eURange", 0);
	if (svp != NULL)
		out.eURange = XS_unpack_UA_Range(*svp);

	svp = hv_fetchs(hv, "AxisInformation_title", 0);
	if (svp != NULL)
		out.title = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "AxisInformation_axisScaleType", 0);
	if (svp != NULL)
		out.axisScaleType = XS_unpack_UA_AxisScaleEnumeration(*svp);

	svp = hv_fetchs(hv, "AxisInformation_axisSteps", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for AxisInformation_axisSteps");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.axisSteps = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DOUBLE]);
		if (out.axisSteps == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.axisSteps[i] = XS_unpack_UA_Double(*svp);
			}
		}
		out.axisStepsSize = i;
	}

	return out;
}
#endif

/* XVType */
#ifdef UA_TYPES_XVTYPE

static void XS_pack_UA_XVType(SV *out, UA_XVType in)  __attribute__((unused));
static void
XS_pack_UA_XVType(SV *out, UA_XVType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.x);
	hv_stores(hv, "XVType_x", sv);

	sv = newSV(0);
	XS_pack_UA_Float(sv, in.value);
	hv_stores(hv, "XVType_value", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_XVType XS_unpack_UA_XVType(SV *in)  __attribute__((unused));
static UA_XVType
XS_unpack_UA_XVType(SV *in)
{
	dTHX;
	UA_XVType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_XVType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "XVType_x", 0);
	if (svp != NULL)
		out.x = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "XVType_value", 0);
	if (svp != NULL)
		out.value = XS_unpack_UA_Float(*svp);

	return out;
}
#endif

/* ProgramDiagnosticDataType */
#ifdef UA_TYPES_PROGRAMDIAGNOSTICDATATYPE

static void XS_pack_UA_ProgramDiagnosticDataType(SV *out, UA_ProgramDiagnosticDataType in)  __attribute__((unused));
static void
XS_pack_UA_ProgramDiagnosticDataType(SV *out, UA_ProgramDiagnosticDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.createSessionId);
	hv_stores(hv, "ProgramDiagnosticDataType_createSessionId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.createClientName);
	hv_stores(hv, "ProgramDiagnosticDataType_createClientName", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.invocationCreationTime);
	hv_stores(hv, "ProgramDiagnosticDataType_invocationCreationTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.lastTransitionTime);
	hv_stores(hv, "ProgramDiagnosticDataType_lastTransitionTime", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.lastMethodCall);
	hv_stores(hv, "ProgramDiagnosticDataType_lastMethodCall", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.lastMethodSessionId);
	hv_stores(hv, "ProgramDiagnosticDataType_lastMethodSessionId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.lastMethodInputArgumentsSize);
	for (i = 0; i < in.lastMethodInputArgumentsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Argument(sv, in.lastMethodInputArguments[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ProgramDiagnosticDataType_lastMethodInputArguments", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.lastMethodOutputArgumentsSize);
	for (i = 0; i < in.lastMethodOutputArgumentsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Argument(sv, in.lastMethodOutputArguments[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ProgramDiagnosticDataType_lastMethodOutputArguments", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.lastMethodCallTime);
	hv_stores(hv, "ProgramDiagnosticDataType_lastMethodCallTime", sv);

	sv = newSV(0);
	XS_pack_UA_StatusResult(sv, in.lastMethodReturnStatus);
	hv_stores(hv, "ProgramDiagnosticDataType_lastMethodReturnStatus", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ProgramDiagnosticDataType XS_unpack_UA_ProgramDiagnosticDataType(SV *in)  __attribute__((unused));
static UA_ProgramDiagnosticDataType
XS_unpack_UA_ProgramDiagnosticDataType(SV *in)
{
	dTHX;
	UA_ProgramDiagnosticDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ProgramDiagnosticDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_createSessionId", 0);
	if (svp != NULL)
		out.createSessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_createClientName", 0);
	if (svp != NULL)
		out.createClientName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_invocationCreationTime", 0);
	if (svp != NULL)
		out.invocationCreationTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_lastTransitionTime", 0);
	if (svp != NULL)
		out.lastTransitionTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_lastMethodCall", 0);
	if (svp != NULL)
		out.lastMethodCall = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_lastMethodSessionId", 0);
	if (svp != NULL)
		out.lastMethodSessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_lastMethodInputArguments", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ProgramDiagnosticDataType_lastMethodInputArguments");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.lastMethodInputArguments = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ARGUMENT]);
		if (out.lastMethodInputArguments == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.lastMethodInputArguments[i] = XS_unpack_UA_Argument(*svp);
			}
		}
		out.lastMethodInputArgumentsSize = i;
	}

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_lastMethodOutputArguments", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ProgramDiagnosticDataType_lastMethodOutputArguments");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.lastMethodOutputArguments = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ARGUMENT]);
		if (out.lastMethodOutputArguments == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.lastMethodOutputArguments[i] = XS_unpack_UA_Argument(*svp);
			}
		}
		out.lastMethodOutputArgumentsSize = i;
	}

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_lastMethodCallTime", 0);
	if (svp != NULL)
		out.lastMethodCallTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnosticDataType_lastMethodReturnStatus", 0);
	if (svp != NULL)
		out.lastMethodReturnStatus = XS_unpack_UA_StatusResult(*svp);

	return out;
}
#endif

/* ProgramDiagnostic2DataType */
#ifdef UA_TYPES_PROGRAMDIAGNOSTIC2DATATYPE

static void XS_pack_UA_ProgramDiagnostic2DataType(SV *out, UA_ProgramDiagnostic2DataType in)  __attribute__((unused));
static void
XS_pack_UA_ProgramDiagnostic2DataType(SV *out, UA_ProgramDiagnostic2DataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.createSessionId);
	hv_stores(hv, "ProgramDiagnostic2DataType_createSessionId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.createClientName);
	hv_stores(hv, "ProgramDiagnostic2DataType_createClientName", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.invocationCreationTime);
	hv_stores(hv, "ProgramDiagnostic2DataType_invocationCreationTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.lastTransitionTime);
	hv_stores(hv, "ProgramDiagnostic2DataType_lastTransitionTime", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.lastMethodCall);
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodCall", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.lastMethodSessionId);
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodSessionId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.lastMethodInputArgumentsSize);
	for (i = 0; i < in.lastMethodInputArgumentsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Argument(sv, in.lastMethodInputArguments[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodInputArguments", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.lastMethodOutputArgumentsSize);
	for (i = 0; i < in.lastMethodOutputArgumentsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Argument(sv, in.lastMethodOutputArguments[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodOutputArguments", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.lastMethodInputValuesSize);
	for (i = 0; i < in.lastMethodInputValuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Variant(sv, in.lastMethodInputValues[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodInputValues", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.lastMethodOutputValuesSize);
	for (i = 0; i < in.lastMethodOutputValuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_Variant(sv, in.lastMethodOutputValues[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodOutputValues", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.lastMethodCallTime);
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodCallTime", sv);

	sv = newSV(0);
	XS_pack_UA_StatusResult(sv, in.lastMethodReturnStatus);
	hv_stores(hv, "ProgramDiagnostic2DataType_lastMethodReturnStatus", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ProgramDiagnostic2DataType XS_unpack_UA_ProgramDiagnostic2DataType(SV *in)  __attribute__((unused));
static UA_ProgramDiagnostic2DataType
XS_unpack_UA_ProgramDiagnostic2DataType(SV *in)
{
	dTHX;
	UA_ProgramDiagnostic2DataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ProgramDiagnostic2DataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_createSessionId", 0);
	if (svp != NULL)
		out.createSessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_createClientName", 0);
	if (svp != NULL)
		out.createClientName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_invocationCreationTime", 0);
	if (svp != NULL)
		out.invocationCreationTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastTransitionTime", 0);
	if (svp != NULL)
		out.lastTransitionTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodCall", 0);
	if (svp != NULL)
		out.lastMethodCall = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodSessionId", 0);
	if (svp != NULL)
		out.lastMethodSessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodInputArguments", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ProgramDiagnostic2DataType_lastMethodInputArguments");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.lastMethodInputArguments = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ARGUMENT]);
		if (out.lastMethodInputArguments == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.lastMethodInputArguments[i] = XS_unpack_UA_Argument(*svp);
			}
		}
		out.lastMethodInputArgumentsSize = i;
	}

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodOutputArguments", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ProgramDiagnostic2DataType_lastMethodOutputArguments");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.lastMethodOutputArguments = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ARGUMENT]);
		if (out.lastMethodOutputArguments == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.lastMethodOutputArguments[i] = XS_unpack_UA_Argument(*svp);
			}
		}
		out.lastMethodOutputArgumentsSize = i;
	}

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodInputValues", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ProgramDiagnostic2DataType_lastMethodInputValues");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.lastMethodInputValues = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_VARIANT]);
		if (out.lastMethodInputValues == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.lastMethodInputValues[i] = XS_unpack_UA_Variant(*svp);
			}
		}
		out.lastMethodInputValuesSize = i;
	}

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodOutputValues", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ProgramDiagnostic2DataType_lastMethodOutputValues");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.lastMethodOutputValues = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_VARIANT]);
		if (out.lastMethodOutputValues == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.lastMethodOutputValues[i] = XS_unpack_UA_Variant(*svp);
			}
		}
		out.lastMethodOutputValuesSize = i;
	}

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodCallTime", 0);
	if (svp != NULL)
		out.lastMethodCallTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ProgramDiagnostic2DataType_lastMethodReturnStatus", 0);
	if (svp != NULL)
		out.lastMethodReturnStatus = XS_unpack_UA_StatusResult(*svp);

	return out;
}
#endif

/* Annotation */
#ifdef UA_TYPES_ANNOTATION

static void XS_pack_UA_Annotation(SV *out, UA_Annotation in)  __attribute__((unused));
static void
XS_pack_UA_Annotation(SV *out, UA_Annotation in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.message);
	hv_stores(hv, "Annotation_message", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.userName);
	hv_stores(hv, "Annotation_userName", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.annotationTime);
	hv_stores(hv, "Annotation_annotationTime", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_Annotation XS_unpack_UA_Annotation(SV *in)  __attribute__((unused));
static UA_Annotation
XS_unpack_UA_Annotation(SV *in)
{
	dTHX;
	UA_Annotation out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_Annotation_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "Annotation_message", 0);
	if (svp != NULL)
		out.message = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "Annotation_userName", 0);
	if (svp != NULL)
		out.userName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "Annotation_annotationTime", 0);
	if (svp != NULL)
		out.annotationTime = XS_unpack_UA_DateTime(*svp);

	return out;
}
#endif

/* ExceptionDeviationFormat */
#ifdef UA_TYPES_EXCEPTIONDEVIATIONFORMAT

static void XS_pack_UA_ExceptionDeviationFormat(SV *out, UA_ExceptionDeviationFormat in)  __attribute__((unused));
static void
XS_pack_UA_ExceptionDeviationFormat(SV *out, UA_ExceptionDeviationFormat in)
{
	dTHX;
	sv_setiv(out, in);
}

static UA_ExceptionDeviationFormat XS_unpack_UA_ExceptionDeviationFormat(SV *in)  __attribute__((unused));
static UA_ExceptionDeviationFormat
XS_unpack_UA_ExceptionDeviationFormat(SV *in)
{
	dTHX;
	return SvIV(in);
}
#endif

/* EndpointType */
#ifdef UA_TYPES_ENDPOINTTYPE

static void XS_pack_UA_EndpointType(SV *out, UA_EndpointType in)  __attribute__((unused));
static void
XS_pack_UA_EndpointType(SV *out, UA_EndpointType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.endpointUrl);
	hv_stores(hv, "EndpointType_endpointUrl", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "EndpointType_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityPolicyUri);
	hv_stores(hv, "EndpointType_securityPolicyUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.transportProfileUri);
	hv_stores(hv, "EndpointType_transportProfileUri", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EndpointType XS_unpack_UA_EndpointType(SV *in)  __attribute__((unused));
static UA_EndpointType
XS_unpack_UA_EndpointType(SV *in)
{
	dTHX;
	UA_EndpointType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EndpointType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EndpointType_endpointUrl", 0);
	if (svp != NULL)
		out.endpointUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "EndpointType_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "EndpointType_securityPolicyUri", 0);
	if (svp != NULL)
		out.securityPolicyUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "EndpointType_transportProfileUri", 0);
	if (svp != NULL)
		out.transportProfileUri = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* StructureDescription */
#ifdef UA_TYPES_STRUCTUREDESCRIPTION

static void XS_pack_UA_StructureDescription(SV *out, UA_StructureDescription in)  __attribute__((unused));
static void
XS_pack_UA_StructureDescription(SV *out, UA_StructureDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataTypeId);
	hv_stores(hv, "StructureDescription_dataTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.name);
	hv_stores(hv, "StructureDescription_name", sv);

	sv = newSV(0);
	XS_pack_UA_StructureDefinition(sv, in.structureDefinition);
	hv_stores(hv, "StructureDescription_structureDefinition", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_StructureDescription XS_unpack_UA_StructureDescription(SV *in)  __attribute__((unused));
static UA_StructureDescription
XS_unpack_UA_StructureDescription(SV *in)
{
	dTHX;
	UA_StructureDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_StructureDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "StructureDescription_dataTypeId", 0);
	if (svp != NULL)
		out.dataTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "StructureDescription_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_QualifiedName(*svp);

	svp = hv_fetchs(hv, "StructureDescription_structureDefinition", 0);
	if (svp != NULL)
		out.structureDefinition = XS_unpack_UA_StructureDefinition(*svp);

	return out;
}
#endif

/* FieldMetaData */
#ifdef UA_TYPES_FIELDMETADATA

static void XS_pack_UA_FieldMetaData(SV *out, UA_FieldMetaData in)  __attribute__((unused));
static void
XS_pack_UA_FieldMetaData(SV *out, UA_FieldMetaData in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "FieldMetaData_name", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "FieldMetaData_description", sv);

	sv = newSV(0);
	XS_pack_UA_DataSetFieldFlags(sv, in.fieldFlags);
	hv_stores(hv, "FieldMetaData_fieldFlags", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.builtInType);
	hv_stores(hv, "FieldMetaData_builtInType", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataType);
	hv_stores(hv, "FieldMetaData_dataType", sv);

	sv = newSV(0);
	XS_pack_UA_Int32(sv, in.valueRank);
	hv_stores(hv, "FieldMetaData_valueRank", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.arrayDimensionsSize);
	for (i = 0; i < in.arrayDimensionsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_UInt32(sv, in.arrayDimensions[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "FieldMetaData_arrayDimensions", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxStringLength);
	hv_stores(hv, "FieldMetaData_maxStringLength", sv);

	sv = newSV(0);
	XS_pack_UA_Guid(sv, in.dataSetFieldId);
	hv_stores(hv, "FieldMetaData_dataSetFieldId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.propertiesSize);
	for (i = 0; i < in.propertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.properties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "FieldMetaData_properties", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_FieldMetaData XS_unpack_UA_FieldMetaData(SV *in)  __attribute__((unused));
static UA_FieldMetaData
XS_unpack_UA_FieldMetaData(SV *in)
{
	dTHX;
	UA_FieldMetaData out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_FieldMetaData_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "FieldMetaData_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_fieldFlags", 0);
	if (svp != NULL)
		out.fieldFlags = XS_unpack_UA_DataSetFieldFlags(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_builtInType", 0);
	if (svp != NULL)
		out.builtInType = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_dataType", 0);
	if (svp != NULL)
		out.dataType = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_valueRank", 0);
	if (svp != NULL)
		out.valueRank = XS_unpack_UA_Int32(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_arrayDimensions", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for FieldMetaData_arrayDimensions");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.arrayDimensions = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_UINT32]);
		if (out.arrayDimensions == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.arrayDimensions[i] = XS_unpack_UA_UInt32(*svp);
			}
		}
		out.arrayDimensionsSize = i;
	}

	svp = hv_fetchs(hv, "FieldMetaData_maxStringLength", 0);
	if (svp != NULL)
		out.maxStringLength = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_dataSetFieldId", 0);
	if (svp != NULL)
		out.dataSetFieldId = XS_unpack_UA_Guid(*svp);

	svp = hv_fetchs(hv, "FieldMetaData_properties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for FieldMetaData_properties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.properties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.properties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.properties[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.propertiesSize = i;
	}

	return out;
}
#endif

/* PublishedEventsDataType */
#ifdef UA_TYPES_PUBLISHEDEVENTSDATATYPE

static void XS_pack_UA_PublishedEventsDataType(SV *out, UA_PublishedEventsDataType in)  __attribute__((unused));
static void
XS_pack_UA_PublishedEventsDataType(SV *out, UA_PublishedEventsDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.eventNotifier);
	hv_stores(hv, "PublishedEventsDataType_eventNotifier", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.selectedFieldsSize);
	for (i = 0; i < in.selectedFieldsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SimpleAttributeOperand(sv, in.selectedFields[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishedEventsDataType_selectedFields", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ContentFilter(sv, in.filter);
	hv_stores(hv, "PublishedEventsDataType_filter", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PublishedEventsDataType XS_unpack_UA_PublishedEventsDataType(SV *in)  __attribute__((unused));
static UA_PublishedEventsDataType
XS_unpack_UA_PublishedEventsDataType(SV *in)
{
	dTHX;
	UA_PublishedEventsDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PublishedEventsDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PublishedEventsDataType_eventNotifier", 0);
	if (svp != NULL)
		out.eventNotifier = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "PublishedEventsDataType_selectedFields", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishedEventsDataType_selectedFields");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.selectedFields = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SIMPLEATTRIBUTEOPERAND]);
		if (out.selectedFields == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.selectedFields[i] = XS_unpack_UA_SimpleAttributeOperand(*svp);
			}
		}
		out.selectedFieldsSize = i;
	}

	svp = hv_fetchs(hv, "PublishedEventsDataType_filter", 0);
	if (svp != NULL)
		out.filter = XS_unpack_UA_ContentFilter(*svp);

	return out;
}
#endif

/* PubSubGroupDataType */
#ifdef UA_TYPES_PUBSUBGROUPDATATYPE

static void XS_pack_UA_PubSubGroupDataType(SV *out, UA_PubSubGroupDataType in)  __attribute__((unused));
static void
XS_pack_UA_PubSubGroupDataType(SV *out, UA_PubSubGroupDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "PubSubGroupDataType_name", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.enabled);
	hv_stores(hv, "PubSubGroupDataType_enabled", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "PubSubGroupDataType_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityGroupId);
	hv_stores(hv, "PubSubGroupDataType_securityGroupId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.securityKeyServicesSize);
	for (i = 0; i < in.securityKeyServicesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EndpointDescription(sv, in.securityKeyServices[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PubSubGroupDataType_securityKeyServices", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxNetworkMessageSize);
	hv_stores(hv, "PubSubGroupDataType_maxNetworkMessageSize", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.groupPropertiesSize);
	for (i = 0; i < in.groupPropertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.groupProperties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PubSubGroupDataType_groupProperties", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PubSubGroupDataType XS_unpack_UA_PubSubGroupDataType(SV *in)  __attribute__((unused));
static UA_PubSubGroupDataType
XS_unpack_UA_PubSubGroupDataType(SV *in)
{
	dTHX;
	UA_PubSubGroupDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PubSubGroupDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PubSubGroupDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "PubSubGroupDataType_enabled", 0);
	if (svp != NULL)
		out.enabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "PubSubGroupDataType_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "PubSubGroupDataType_securityGroupId", 0);
	if (svp != NULL)
		out.securityGroupId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "PubSubGroupDataType_securityKeyServices", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PubSubGroupDataType_securityKeyServices");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.securityKeyServices = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENDPOINTDESCRIPTION]);
		if (out.securityKeyServices == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.securityKeyServices[i] = XS_unpack_UA_EndpointDescription(*svp);
			}
		}
		out.securityKeyServicesSize = i;
	}

	svp = hv_fetchs(hv, "PubSubGroupDataType_maxNetworkMessageSize", 0);
	if (svp != NULL)
		out.maxNetworkMessageSize = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "PubSubGroupDataType_groupProperties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PubSubGroupDataType_groupProperties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.groupProperties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.groupProperties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.groupProperties[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.groupPropertiesSize = i;
	}

	return out;
}
#endif

/* WriterGroupDataType */
#ifdef UA_TYPES_WRITERGROUPDATATYPE

static void XS_pack_UA_WriterGroupDataType(SV *out, UA_WriterGroupDataType in)  __attribute__((unused));
static void
XS_pack_UA_WriterGroupDataType(SV *out, UA_WriterGroupDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "WriterGroupDataType_name", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.enabled);
	hv_stores(hv, "WriterGroupDataType_enabled", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "WriterGroupDataType_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityGroupId);
	hv_stores(hv, "WriterGroupDataType_securityGroupId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.securityKeyServicesSize);
	for (i = 0; i < in.securityKeyServicesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EndpointDescription(sv, in.securityKeyServices[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "WriterGroupDataType_securityKeyServices", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxNetworkMessageSize);
	hv_stores(hv, "WriterGroupDataType_maxNetworkMessageSize", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.groupPropertiesSize);
	for (i = 0; i < in.groupPropertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.groupProperties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "WriterGroupDataType_groupProperties", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.writerGroupId);
	hv_stores(hv, "WriterGroupDataType_writerGroupId", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.publishingInterval);
	hv_stores(hv, "WriterGroupDataType_publishingInterval", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.keepAliveTime);
	hv_stores(hv, "WriterGroupDataType_keepAliveTime", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.priority);
	hv_stores(hv, "WriterGroupDataType_priority", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.localeIdsSize);
	for (i = 0; i < in.localeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.localeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "WriterGroupDataType_localeIds", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_String(sv, in.headerLayoutUri);
	hv_stores(hv, "WriterGroupDataType_headerLayoutUri", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.transportSettings);
	hv_stores(hv, "WriterGroupDataType_transportSettings", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.messageSettings);
	hv_stores(hv, "WriterGroupDataType_messageSettings", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataSetWritersSize);
	for (i = 0; i < in.dataSetWritersSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DataSetWriterDataType(sv, in.dataSetWriters[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "WriterGroupDataType_dataSetWriters", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_WriterGroupDataType XS_unpack_UA_WriterGroupDataType(SV *in)  __attribute__((unused));
static UA_WriterGroupDataType
XS_unpack_UA_WriterGroupDataType(SV *in)
{
	dTHX;
	UA_WriterGroupDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_WriterGroupDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "WriterGroupDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_enabled", 0);
	if (svp != NULL)
		out.enabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_securityGroupId", 0);
	if (svp != NULL)
		out.securityGroupId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_securityKeyServices", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for WriterGroupDataType_securityKeyServices");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.securityKeyServices = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENDPOINTDESCRIPTION]);
		if (out.securityKeyServices == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.securityKeyServices[i] = XS_unpack_UA_EndpointDescription(*svp);
			}
		}
		out.securityKeyServicesSize = i;
	}

	svp = hv_fetchs(hv, "WriterGroupDataType_maxNetworkMessageSize", 0);
	if (svp != NULL)
		out.maxNetworkMessageSize = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_groupProperties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for WriterGroupDataType_groupProperties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.groupProperties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.groupProperties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.groupProperties[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.groupPropertiesSize = i;
	}

	svp = hv_fetchs(hv, "WriterGroupDataType_writerGroupId", 0);
	if (svp != NULL)
		out.writerGroupId = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_publishingInterval", 0);
	if (svp != NULL)
		out.publishingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_keepAliveTime", 0);
	if (svp != NULL)
		out.keepAliveTime = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_priority", 0);
	if (svp != NULL)
		out.priority = XS_unpack_UA_Byte(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_localeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for WriterGroupDataType_localeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.localeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.localeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.localeIds[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.localeIdsSize = i;
	}

	svp = hv_fetchs(hv, "WriterGroupDataType_headerLayoutUri", 0);
	if (svp != NULL)
		out.headerLayoutUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_transportSettings", 0);
	if (svp != NULL)
		out.transportSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_messageSettings", 0);
	if (svp != NULL)
		out.messageSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "WriterGroupDataType_dataSetWriters", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for WriterGroupDataType_dataSetWriters");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataSetWriters = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATASETWRITERDATATYPE]);
		if (out.dataSetWriters == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataSetWriters[i] = XS_unpack_UA_DataSetWriterDataType(*svp);
			}
		}
		out.dataSetWritersSize = i;
	}

	return out;
}
#endif

/* FieldTargetDataType */
#ifdef UA_TYPES_FIELDTARGETDATATYPE

static void XS_pack_UA_FieldTargetDataType(SV *out, UA_FieldTargetDataType in)  __attribute__((unused));
static void
XS_pack_UA_FieldTargetDataType(SV *out, UA_FieldTargetDataType in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_Guid(sv, in.dataSetFieldId);
	hv_stores(hv, "FieldTargetDataType_dataSetFieldId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.receiverIndexRange);
	hv_stores(hv, "FieldTargetDataType_receiverIndexRange", sv);

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.targetNodeId);
	hv_stores(hv, "FieldTargetDataType_targetNodeId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.attributeId);
	hv_stores(hv, "FieldTargetDataType_attributeId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.writeIndexRange);
	hv_stores(hv, "FieldTargetDataType_writeIndexRange", sv);

	sv = newSV(0);
	XS_pack_UA_OverrideValueHandling(sv, in.overrideValueHandling);
	hv_stores(hv, "FieldTargetDataType_overrideValueHandling", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.overrideValue);
	hv_stores(hv, "FieldTargetDataType_overrideValue", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_FieldTargetDataType XS_unpack_UA_FieldTargetDataType(SV *in)  __attribute__((unused));
static UA_FieldTargetDataType
XS_unpack_UA_FieldTargetDataType(SV *in)
{
	dTHX;
	UA_FieldTargetDataType out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_FieldTargetDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "FieldTargetDataType_dataSetFieldId", 0);
	if (svp != NULL)
		out.dataSetFieldId = XS_unpack_UA_Guid(*svp);

	svp = hv_fetchs(hv, "FieldTargetDataType_receiverIndexRange", 0);
	if (svp != NULL)
		out.receiverIndexRange = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "FieldTargetDataType_targetNodeId", 0);
	if (svp != NULL)
		out.targetNodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "FieldTargetDataType_attributeId", 0);
	if (svp != NULL)
		out.attributeId = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "FieldTargetDataType_writeIndexRange", 0);
	if (svp != NULL)
		out.writeIndexRange = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "FieldTargetDataType_overrideValueHandling", 0);
	if (svp != NULL)
		out.overrideValueHandling = XS_unpack_UA_OverrideValueHandling(*svp);

	svp = hv_fetchs(hv, "FieldTargetDataType_overrideValue", 0);
	if (svp != NULL)
		out.overrideValue = XS_unpack_UA_Variant(*svp);

	return out;
}
#endif

/* SubscribedDataSetMirrorDataType */
#ifdef UA_TYPES_SUBSCRIBEDDATASETMIRRORDATATYPE

static void XS_pack_UA_SubscribedDataSetMirrorDataType(SV *out, UA_SubscribedDataSetMirrorDataType in)  __attribute__((unused));
static void
XS_pack_UA_SubscribedDataSetMirrorDataType(SV *out, UA_SubscribedDataSetMirrorDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.parentNodeName);
	hv_stores(hv, "SubscribedDataSetMirrorDataType_parentNodeName", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.rolePermissionsSize);
	for (i = 0; i < in.rolePermissionsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_RolePermissionType(sv, in.rolePermissions[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SubscribedDataSetMirrorDataType_rolePermissions", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SubscribedDataSetMirrorDataType XS_unpack_UA_SubscribedDataSetMirrorDataType(SV *in)  __attribute__((unused));
static UA_SubscribedDataSetMirrorDataType
XS_unpack_UA_SubscribedDataSetMirrorDataType(SV *in)
{
	dTHX;
	UA_SubscribedDataSetMirrorDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SubscribedDataSetMirrorDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SubscribedDataSetMirrorDataType_parentNodeName", 0);
	if (svp != NULL)
		out.parentNodeName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SubscribedDataSetMirrorDataType_rolePermissions", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SubscribedDataSetMirrorDataType_rolePermissions");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.rolePermissions = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ROLEPERMISSIONTYPE]);
		if (out.rolePermissions == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.rolePermissions[i] = XS_unpack_UA_RolePermissionType(*svp);
			}
		}
		out.rolePermissionsSize = i;
	}

	return out;
}
#endif

/* EnumDefinition */
#ifdef UA_TYPES_ENUMDEFINITION

static void XS_pack_UA_EnumDefinition(SV *out, UA_EnumDefinition in)  __attribute__((unused));
static void
XS_pack_UA_EnumDefinition(SV *out, UA_EnumDefinition in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.fieldsSize);
	for (i = 0; i < in.fieldsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EnumField(sv, in.fields[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EnumDefinition_fields", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EnumDefinition XS_unpack_UA_EnumDefinition(SV *in)  __attribute__((unused));
static UA_EnumDefinition
XS_unpack_UA_EnumDefinition(SV *in)
{
	dTHX;
	UA_EnumDefinition out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EnumDefinition_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EnumDefinition_fields", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EnumDefinition_fields");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.fields = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENUMFIELD]);
		if (out.fields == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.fields[i] = XS_unpack_UA_EnumField(*svp);
			}
		}
		out.fieldsSize = i;
	}

	return out;
}
#endif

/* ReadEventDetails */
#ifdef UA_TYPES_READEVENTDETAILS

static void XS_pack_UA_ReadEventDetails(SV *out, UA_ReadEventDetails in)  __attribute__((unused));
static void
XS_pack_UA_ReadEventDetails(SV *out, UA_ReadEventDetails in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.numValuesPerNode);
	hv_stores(hv, "ReadEventDetails_numValuesPerNode", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.startTime);
	hv_stores(hv, "ReadEventDetails_startTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.endTime);
	hv_stores(hv, "ReadEventDetails_endTime", sv);

	sv = newSV(0);
	XS_pack_UA_EventFilter(sv, in.filter);
	hv_stores(hv, "ReadEventDetails_filter", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadEventDetails XS_unpack_UA_ReadEventDetails(SV *in)  __attribute__((unused));
static UA_ReadEventDetails
XS_unpack_UA_ReadEventDetails(SV *in)
{
	dTHX;
	UA_ReadEventDetails out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadEventDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadEventDetails_numValuesPerNode", 0);
	if (svp != NULL)
		out.numValuesPerNode = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ReadEventDetails_startTime", 0);
	if (svp != NULL)
		out.startTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ReadEventDetails_endTime", 0);
	if (svp != NULL)
		out.endTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ReadEventDetails_filter", 0);
	if (svp != NULL)
		out.filter = XS_unpack_UA_EventFilter(*svp);

	return out;
}
#endif

/* ReadProcessedDetails */
#ifdef UA_TYPES_READPROCESSEDDETAILS

static void XS_pack_UA_ReadProcessedDetails(SV *out, UA_ReadProcessedDetails in)  __attribute__((unused));
static void
XS_pack_UA_ReadProcessedDetails(SV *out, UA_ReadProcessedDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.startTime);
	hv_stores(hv, "ReadProcessedDetails_startTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.endTime);
	hv_stores(hv, "ReadProcessedDetails_endTime", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.processingInterval);
	hv_stores(hv, "ReadProcessedDetails_processingInterval", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.aggregateTypeSize);
	for (i = 0; i < in.aggregateTypeSize; i++) {
		sv = newSV(0);
		XS_pack_UA_NodeId(sv, in.aggregateType[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReadProcessedDetails_aggregateType", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_AggregateConfiguration(sv, in.aggregateConfiguration);
	hv_stores(hv, "ReadProcessedDetails_aggregateConfiguration", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReadProcessedDetails XS_unpack_UA_ReadProcessedDetails(SV *in)  __attribute__((unused));
static UA_ReadProcessedDetails
XS_unpack_UA_ReadProcessedDetails(SV *in)
{
	dTHX;
	UA_ReadProcessedDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReadProcessedDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReadProcessedDetails_startTime", 0);
	if (svp != NULL)
		out.startTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ReadProcessedDetails_endTime", 0);
	if (svp != NULL)
		out.endTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ReadProcessedDetails_processingInterval", 0);
	if (svp != NULL)
		out.processingInterval = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "ReadProcessedDetails_aggregateType", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReadProcessedDetails_aggregateType");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.aggregateType = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_NODEID]);
		if (out.aggregateType == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.aggregateType[i] = XS_unpack_UA_NodeId(*svp);
			}
		}
		out.aggregateTypeSize = i;
	}

	svp = hv_fetchs(hv, "ReadProcessedDetails_aggregateConfiguration", 0);
	if (svp != NULL)
		out.aggregateConfiguration = XS_unpack_UA_AggregateConfiguration(*svp);

	return out;
}
#endif

/* ModificationInfo */
#ifdef UA_TYPES_MODIFICATIONINFO

static void XS_pack_UA_ModificationInfo(SV *out, UA_ModificationInfo in)  __attribute__((unused));
static void
XS_pack_UA_ModificationInfo(SV *out, UA_ModificationInfo in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.modificationTime);
	hv_stores(hv, "ModificationInfo_modificationTime", sv);

	sv = newSV(0);
	XS_pack_UA_HistoryUpdateType(sv, in.updateType);
	hv_stores(hv, "ModificationInfo_updateType", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.userName);
	hv_stores(hv, "ModificationInfo_userName", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ModificationInfo XS_unpack_UA_ModificationInfo(SV *in)  __attribute__((unused));
static UA_ModificationInfo
XS_unpack_UA_ModificationInfo(SV *in)
{
	dTHX;
	UA_ModificationInfo out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ModificationInfo_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ModificationInfo_modificationTime", 0);
	if (svp != NULL)
		out.modificationTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "ModificationInfo_updateType", 0);
	if (svp != NULL)
		out.updateType = XS_unpack_UA_HistoryUpdateType(*svp);

	svp = hv_fetchs(hv, "ModificationInfo_userName", 0);
	if (svp != NULL)
		out.userName = XS_unpack_UA_String(*svp);

	return out;
}
#endif

/* HistoryModifiedData */
#ifdef UA_TYPES_HISTORYMODIFIEDDATA

static void XS_pack_UA_HistoryModifiedData(SV *out, UA_HistoryModifiedData in)  __attribute__((unused));
static void
XS_pack_UA_HistoryModifiedData(SV *out, UA_HistoryModifiedData in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataValuesSize);
	for (i = 0; i < in.dataValuesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DataValue(sv, in.dataValues[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryModifiedData_dataValues", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.modificationInfosSize);
	for (i = 0; i < in.modificationInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ModificationInfo(sv, in.modificationInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryModifiedData_modificationInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryModifiedData XS_unpack_UA_HistoryModifiedData(SV *in)  __attribute__((unused));
static UA_HistoryModifiedData
XS_unpack_UA_HistoryModifiedData(SV *in)
{
	dTHX;
	UA_HistoryModifiedData out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryModifiedData_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryModifiedData_dataValues", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryModifiedData_dataValues");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataValues = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATAVALUE]);
		if (out.dataValues == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataValues[i] = XS_unpack_UA_DataValue(*svp);
			}
		}
		out.dataValuesSize = i;
	}

	svp = hv_fetchs(hv, "HistoryModifiedData_modificationInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryModifiedData_modificationInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.modificationInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_MODIFICATIONINFO]);
		if (out.modificationInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.modificationInfos[i] = XS_unpack_UA_ModificationInfo(*svp);
			}
		}
		out.modificationInfosSize = i;
	}

	return out;
}
#endif

/* HistoryEvent */
#ifdef UA_TYPES_HISTORYEVENT

static void XS_pack_UA_HistoryEvent(SV *out, UA_HistoryEvent in)  __attribute__((unused));
static void
XS_pack_UA_HistoryEvent(SV *out, UA_HistoryEvent in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.eventsSize);
	for (i = 0; i < in.eventsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_HistoryEventFieldList(sv, in.events[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "HistoryEvent_events", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_HistoryEvent XS_unpack_UA_HistoryEvent(SV *in)  __attribute__((unused));
static UA_HistoryEvent
XS_unpack_UA_HistoryEvent(SV *in)
{
	dTHX;
	UA_HistoryEvent out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_HistoryEvent_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "HistoryEvent_events", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for HistoryEvent_events");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.events = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_HISTORYEVENTFIELDLIST]);
		if (out.events == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.events[i] = XS_unpack_UA_HistoryEventFieldList(*svp);
			}
		}
		out.eventsSize = i;
	}

	return out;
}
#endif

/* UpdateEventDetails */
#ifdef UA_TYPES_UPDATEEVENTDETAILS

static void XS_pack_UA_UpdateEventDetails(SV *out, UA_UpdateEventDetails in)  __attribute__((unused));
static void
XS_pack_UA_UpdateEventDetails(SV *out, UA_UpdateEventDetails in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.nodeId);
	hv_stores(hv, "UpdateEventDetails_nodeId", sv);

	sv = newSV(0);
	XS_pack_UA_PerformUpdateType(sv, in.performInsertReplace);
	hv_stores(hv, "UpdateEventDetails_performInsertReplace", sv);

	sv = newSV(0);
	XS_pack_UA_EventFilter(sv, in.filter);
	hv_stores(hv, "UpdateEventDetails_filter", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.eventDataSize);
	for (i = 0; i < in.eventDataSize; i++) {
		sv = newSV(0);
		XS_pack_UA_HistoryEventFieldList(sv, in.eventData[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UpdateEventDetails_eventData", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UpdateEventDetails XS_unpack_UA_UpdateEventDetails(SV *in)  __attribute__((unused));
static UA_UpdateEventDetails
XS_unpack_UA_UpdateEventDetails(SV *in)
{
	dTHX;
	UA_UpdateEventDetails out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UpdateEventDetails_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UpdateEventDetails_nodeId", 0);
	if (svp != NULL)
		out.nodeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "UpdateEventDetails_performInsertReplace", 0);
	if (svp != NULL)
		out.performInsertReplace = XS_unpack_UA_PerformUpdateType(*svp);

	svp = hv_fetchs(hv, "UpdateEventDetails_filter", 0);
	if (svp != NULL)
		out.filter = XS_unpack_UA_EventFilter(*svp);

	svp = hv_fetchs(hv, "UpdateEventDetails_eventData", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UpdateEventDetails_eventData");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.eventData = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_HISTORYEVENTFIELDLIST]);
		if (out.eventData == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.eventData[i] = XS_unpack_UA_HistoryEventFieldList(*svp);
			}
		}
		out.eventDataSize = i;
	}

	return out;
}
#endif

/* DataChangeNotification */
#ifdef UA_TYPES_DATACHANGENOTIFICATION

static void XS_pack_UA_DataChangeNotification(SV *out, UA_DataChangeNotification in)  __attribute__((unused));
static void
XS_pack_UA_DataChangeNotification(SV *out, UA_DataChangeNotification in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.monitoredItemsSize);
	for (i = 0; i < in.monitoredItemsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_MonitoredItemNotification(sv, in.monitoredItems[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataChangeNotification_monitoredItems", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.diagnosticInfosSize);
	for (i = 0; i < in.diagnosticInfosSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DiagnosticInfo(sv, in.diagnosticInfos[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataChangeNotification_diagnosticInfos", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataChangeNotification XS_unpack_UA_DataChangeNotification(SV *in)  __attribute__((unused));
static UA_DataChangeNotification
XS_unpack_UA_DataChangeNotification(SV *in)
{
	dTHX;
	UA_DataChangeNotification out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataChangeNotification_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataChangeNotification_monitoredItems", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataChangeNotification_monitoredItems");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.monitoredItems = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_MONITOREDITEMNOTIFICATION]);
		if (out.monitoredItems == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.monitoredItems[i] = XS_unpack_UA_MonitoredItemNotification(*svp);
			}
		}
		out.monitoredItemsSize = i;
	}

	svp = hv_fetchs(hv, "DataChangeNotification_diagnosticInfos", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataChangeNotification_diagnosticInfos");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.diagnosticInfos = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DIAGNOSTICINFO]);
		if (out.diagnosticInfos == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.diagnosticInfos[i] = XS_unpack_UA_DiagnosticInfo(*svp);
			}
		}
		out.diagnosticInfosSize = i;
	}

	return out;
}
#endif

/* EventNotificationList */
#ifdef UA_TYPES_EVENTNOTIFICATIONLIST

static void XS_pack_UA_EventNotificationList(SV *out, UA_EventNotificationList in)  __attribute__((unused));
static void
XS_pack_UA_EventNotificationList(SV *out, UA_EventNotificationList in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.eventsSize);
	for (i = 0; i < in.eventsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EventFieldList(sv, in.events[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "EventNotificationList_events", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EventNotificationList XS_unpack_UA_EventNotificationList(SV *in)  __attribute__((unused));
static UA_EventNotificationList
XS_unpack_UA_EventNotificationList(SV *in)
{
	dTHX;
	UA_EventNotificationList out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EventNotificationList_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EventNotificationList_events", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for EventNotificationList_events");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.events = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_EVENTFIELDLIST]);
		if (out.events == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.events[i] = XS_unpack_UA_EventFieldList(*svp);
			}
		}
		out.eventsSize = i;
	}

	return out;
}
#endif

/* SessionDiagnosticsDataType */
#ifdef UA_TYPES_SESSIONDIAGNOSTICSDATATYPE

static void XS_pack_UA_SessionDiagnosticsDataType(SV *out, UA_SessionDiagnosticsDataType in)  __attribute__((unused));
static void
XS_pack_UA_SessionDiagnosticsDataType(SV *out, UA_SessionDiagnosticsDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.sessionId);
	hv_stores(hv, "SessionDiagnosticsDataType_sessionId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.sessionName);
	hv_stores(hv, "SessionDiagnosticsDataType_sessionName", sv);

	sv = newSV(0);
	XS_pack_UA_ApplicationDescription(sv, in.clientDescription);
	hv_stores(hv, "SessionDiagnosticsDataType_clientDescription", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.serverUri);
	hv_stores(hv, "SessionDiagnosticsDataType_serverUri", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.endpointUrl);
	hv_stores(hv, "SessionDiagnosticsDataType_endpointUrl", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.localeIdsSize);
	for (i = 0; i < in.localeIdsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.localeIds[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "SessionDiagnosticsDataType_localeIds", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.actualSessionTimeout);
	hv_stores(hv, "SessionDiagnosticsDataType_actualSessionTimeout", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxResponseMessageSize);
	hv_stores(hv, "SessionDiagnosticsDataType_maxResponseMessageSize", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.clientConnectionTime);
	hv_stores(hv, "SessionDiagnosticsDataType_clientConnectionTime", sv);

	sv = newSV(0);
	XS_pack_UA_DateTime(sv, in.clientLastContactTime);
	hv_stores(hv, "SessionDiagnosticsDataType_clientLastContactTime", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.currentSubscriptionsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_currentSubscriptionsCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.currentMonitoredItemsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_currentMonitoredItemsCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.currentPublishRequestsInQueue);
	hv_stores(hv, "SessionDiagnosticsDataType_currentPublishRequestsInQueue", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.totalRequestCount);
	hv_stores(hv, "SessionDiagnosticsDataType_totalRequestCount", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.unauthorizedRequestCount);
	hv_stores(hv, "SessionDiagnosticsDataType_unauthorizedRequestCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.readCount);
	hv_stores(hv, "SessionDiagnosticsDataType_readCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.historyReadCount);
	hv_stores(hv, "SessionDiagnosticsDataType_historyReadCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.writeCount);
	hv_stores(hv, "SessionDiagnosticsDataType_writeCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.historyUpdateCount);
	hv_stores(hv, "SessionDiagnosticsDataType_historyUpdateCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.callCount);
	hv_stores(hv, "SessionDiagnosticsDataType_callCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.createMonitoredItemsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_createMonitoredItemsCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.modifyMonitoredItemsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_modifyMonitoredItemsCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.setMonitoringModeCount);
	hv_stores(hv, "SessionDiagnosticsDataType_setMonitoringModeCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.setTriggeringCount);
	hv_stores(hv, "SessionDiagnosticsDataType_setTriggeringCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.deleteMonitoredItemsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_deleteMonitoredItemsCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.createSubscriptionCount);
	hv_stores(hv, "SessionDiagnosticsDataType_createSubscriptionCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.modifySubscriptionCount);
	hv_stores(hv, "SessionDiagnosticsDataType_modifySubscriptionCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.setPublishingModeCount);
	hv_stores(hv, "SessionDiagnosticsDataType_setPublishingModeCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.publishCount);
	hv_stores(hv, "SessionDiagnosticsDataType_publishCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.republishCount);
	hv_stores(hv, "SessionDiagnosticsDataType_republishCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.transferSubscriptionsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_transferSubscriptionsCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.deleteSubscriptionsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_deleteSubscriptionsCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.addNodesCount);
	hv_stores(hv, "SessionDiagnosticsDataType_addNodesCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.addReferencesCount);
	hv_stores(hv, "SessionDiagnosticsDataType_addReferencesCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.deleteNodesCount);
	hv_stores(hv, "SessionDiagnosticsDataType_deleteNodesCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.deleteReferencesCount);
	hv_stores(hv, "SessionDiagnosticsDataType_deleteReferencesCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.browseCount);
	hv_stores(hv, "SessionDiagnosticsDataType_browseCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.browseNextCount);
	hv_stores(hv, "SessionDiagnosticsDataType_browseNextCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.translateBrowsePathsToNodeIdsCount);
	hv_stores(hv, "SessionDiagnosticsDataType_translateBrowsePathsToNodeIdsCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.queryFirstCount);
	hv_stores(hv, "SessionDiagnosticsDataType_queryFirstCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.queryNextCount);
	hv_stores(hv, "SessionDiagnosticsDataType_queryNextCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.registerNodesCount);
	hv_stores(hv, "SessionDiagnosticsDataType_registerNodesCount", sv);

	sv = newSV(0);
	XS_pack_UA_ServiceCounterDataType(sv, in.unregisterNodesCount);
	hv_stores(hv, "SessionDiagnosticsDataType_unregisterNodesCount", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_SessionDiagnosticsDataType XS_unpack_UA_SessionDiagnosticsDataType(SV *in)  __attribute__((unused));
static UA_SessionDiagnosticsDataType
XS_unpack_UA_SessionDiagnosticsDataType(SV *in)
{
	dTHX;
	UA_SessionDiagnosticsDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_SessionDiagnosticsDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_sessionId", 0);
	if (svp != NULL)
		out.sessionId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_sessionName", 0);
	if (svp != NULL)
		out.sessionName = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_clientDescription", 0);
	if (svp != NULL)
		out.clientDescription = XS_unpack_UA_ApplicationDescription(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_serverUri", 0);
	if (svp != NULL)
		out.serverUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_endpointUrl", 0);
	if (svp != NULL)
		out.endpointUrl = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_localeIds", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for SessionDiagnosticsDataType_localeIds");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.localeIds = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.localeIds == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.localeIds[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.localeIdsSize = i;
	}

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_actualSessionTimeout", 0);
	if (svp != NULL)
		out.actualSessionTimeout = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_maxResponseMessageSize", 0);
	if (svp != NULL)
		out.maxResponseMessageSize = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_clientConnectionTime", 0);
	if (svp != NULL)
		out.clientConnectionTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_clientLastContactTime", 0);
	if (svp != NULL)
		out.clientLastContactTime = XS_unpack_UA_DateTime(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_currentSubscriptionsCount", 0);
	if (svp != NULL)
		out.currentSubscriptionsCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_currentMonitoredItemsCount", 0);
	if (svp != NULL)
		out.currentMonitoredItemsCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_currentPublishRequestsInQueue", 0);
	if (svp != NULL)
		out.currentPublishRequestsInQueue = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_totalRequestCount", 0);
	if (svp != NULL)
		out.totalRequestCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_unauthorizedRequestCount", 0);
	if (svp != NULL)
		out.unauthorizedRequestCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_readCount", 0);
	if (svp != NULL)
		out.readCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_historyReadCount", 0);
	if (svp != NULL)
		out.historyReadCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_writeCount", 0);
	if (svp != NULL)
		out.writeCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_historyUpdateCount", 0);
	if (svp != NULL)
		out.historyUpdateCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_callCount", 0);
	if (svp != NULL)
		out.callCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_createMonitoredItemsCount", 0);
	if (svp != NULL)
		out.createMonitoredItemsCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_modifyMonitoredItemsCount", 0);
	if (svp != NULL)
		out.modifyMonitoredItemsCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_setMonitoringModeCount", 0);
	if (svp != NULL)
		out.setMonitoringModeCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_setTriggeringCount", 0);
	if (svp != NULL)
		out.setTriggeringCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_deleteMonitoredItemsCount", 0);
	if (svp != NULL)
		out.deleteMonitoredItemsCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_createSubscriptionCount", 0);
	if (svp != NULL)
		out.createSubscriptionCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_modifySubscriptionCount", 0);
	if (svp != NULL)
		out.modifySubscriptionCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_setPublishingModeCount", 0);
	if (svp != NULL)
		out.setPublishingModeCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_publishCount", 0);
	if (svp != NULL)
		out.publishCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_republishCount", 0);
	if (svp != NULL)
		out.republishCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_transferSubscriptionsCount", 0);
	if (svp != NULL)
		out.transferSubscriptionsCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_deleteSubscriptionsCount", 0);
	if (svp != NULL)
		out.deleteSubscriptionsCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_addNodesCount", 0);
	if (svp != NULL)
		out.addNodesCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_addReferencesCount", 0);
	if (svp != NULL)
		out.addReferencesCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_deleteNodesCount", 0);
	if (svp != NULL)
		out.deleteNodesCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_deleteReferencesCount", 0);
	if (svp != NULL)
		out.deleteReferencesCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_browseCount", 0);
	if (svp != NULL)
		out.browseCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_browseNextCount", 0);
	if (svp != NULL)
		out.browseNextCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_translateBrowsePathsToNodeIdsCount", 0);
	if (svp != NULL)
		out.translateBrowsePathsToNodeIdsCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_queryFirstCount", 0);
	if (svp != NULL)
		out.queryFirstCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_queryNextCount", 0);
	if (svp != NULL)
		out.queryNextCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_registerNodesCount", 0);
	if (svp != NULL)
		out.registerNodesCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	svp = hv_fetchs(hv, "SessionDiagnosticsDataType_unregisterNodesCount", 0);
	if (svp != NULL)
		out.unregisterNodesCount = XS_unpack_UA_ServiceCounterDataType(*svp);

	return out;
}
#endif

/* EnumDescription */
#ifdef UA_TYPES_ENUMDESCRIPTION

static void XS_pack_UA_EnumDescription(SV *out, UA_EnumDescription in)  __attribute__((unused));
static void
XS_pack_UA_EnumDescription(SV *out, UA_EnumDescription in)
{
	dTHX;
	SV *sv;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_NodeId(sv, in.dataTypeId);
	hv_stores(hv, "EnumDescription_dataTypeId", sv);

	sv = newSV(0);
	XS_pack_UA_QualifiedName(sv, in.name);
	hv_stores(hv, "EnumDescription_name", sv);

	sv = newSV(0);
	XS_pack_UA_EnumDefinition(sv, in.enumDefinition);
	hv_stores(hv, "EnumDescription_enumDefinition", sv);

	sv = newSV(0);
	XS_pack_UA_Byte(sv, in.builtInType);
	hv_stores(hv, "EnumDescription_builtInType", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_EnumDescription XS_unpack_UA_EnumDescription(SV *in)  __attribute__((unused));
static UA_EnumDescription
XS_unpack_UA_EnumDescription(SV *in)
{
	dTHX;
	UA_EnumDescription out;
	SV **svp;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_EnumDescription_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "EnumDescription_dataTypeId", 0);
	if (svp != NULL)
		out.dataTypeId = XS_unpack_UA_NodeId(*svp);

	svp = hv_fetchs(hv, "EnumDescription_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_QualifiedName(*svp);

	svp = hv_fetchs(hv, "EnumDescription_enumDefinition", 0);
	if (svp != NULL)
		out.enumDefinition = XS_unpack_UA_EnumDefinition(*svp);

	svp = hv_fetchs(hv, "EnumDescription_builtInType", 0);
	if (svp != NULL)
		out.builtInType = XS_unpack_UA_Byte(*svp);

	return out;
}
#endif

/* UABinaryFileDataType */
#ifdef UA_TYPES_UABINARYFILEDATATYPE

static void XS_pack_UA_UABinaryFileDataType(SV *out, UA_UABinaryFileDataType in)  __attribute__((unused));
static void
XS_pack_UA_UABinaryFileDataType(SV *out, UA_UABinaryFileDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.namespacesSize);
	for (i = 0; i < in.namespacesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.namespaces[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UABinaryFileDataType_namespaces", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.structureDataTypesSize);
	for (i = 0; i < in.structureDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StructureDescription(sv, in.structureDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UABinaryFileDataType_structureDataTypes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.enumDataTypesSize);
	for (i = 0; i < in.enumDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EnumDescription(sv, in.enumDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UABinaryFileDataType_enumDataTypes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.simpleDataTypesSize);
	for (i = 0; i < in.simpleDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SimpleTypeDescription(sv, in.simpleDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UABinaryFileDataType_simpleDataTypes", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_String(sv, in.schemaLocation);
	hv_stores(hv, "UABinaryFileDataType_schemaLocation", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.fileHeaderSize);
	for (i = 0; i < in.fileHeaderSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.fileHeader[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "UABinaryFileDataType_fileHeader", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.body);
	hv_stores(hv, "UABinaryFileDataType_body", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_UABinaryFileDataType XS_unpack_UA_UABinaryFileDataType(SV *in)  __attribute__((unused));
static UA_UABinaryFileDataType
XS_unpack_UA_UABinaryFileDataType(SV *in)
{
	dTHX;
	UA_UABinaryFileDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_UABinaryFileDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "UABinaryFileDataType_namespaces", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UABinaryFileDataType_namespaces");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.namespaces = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.namespaces == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.namespaces[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.namespacesSize = i;
	}

	svp = hv_fetchs(hv, "UABinaryFileDataType_structureDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UABinaryFileDataType_structureDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.structureDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRUCTUREDESCRIPTION]);
		if (out.structureDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.structureDataTypes[i] = XS_unpack_UA_StructureDescription(*svp);
			}
		}
		out.structureDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "UABinaryFileDataType_enumDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UABinaryFileDataType_enumDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.enumDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENUMDESCRIPTION]);
		if (out.enumDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.enumDataTypes[i] = XS_unpack_UA_EnumDescription(*svp);
			}
		}
		out.enumDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "UABinaryFileDataType_simpleDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UABinaryFileDataType_simpleDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.simpleDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SIMPLETYPEDESCRIPTION]);
		if (out.simpleDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.simpleDataTypes[i] = XS_unpack_UA_SimpleTypeDescription(*svp);
			}
		}
		out.simpleDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "UABinaryFileDataType_schemaLocation", 0);
	if (svp != NULL)
		out.schemaLocation = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "UABinaryFileDataType_fileHeader", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for UABinaryFileDataType_fileHeader");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.fileHeader = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.fileHeader == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.fileHeader[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.fileHeaderSize = i;
	}

	svp = hv_fetchs(hv, "UABinaryFileDataType_body", 0);
	if (svp != NULL)
		out.body = XS_unpack_UA_Variant(*svp);

	return out;
}
#endif

/* DataSetMetaDataType */
#ifdef UA_TYPES_DATASETMETADATATYPE

static void XS_pack_UA_DataSetMetaDataType(SV *out, UA_DataSetMetaDataType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetMetaDataType(SV *out, UA_DataSetMetaDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.namespacesSize);
	for (i = 0; i < in.namespacesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.namespaces[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetMetaDataType_namespaces", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.structureDataTypesSize);
	for (i = 0; i < in.structureDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StructureDescription(sv, in.structureDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetMetaDataType_structureDataTypes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.enumDataTypesSize);
	for (i = 0; i < in.enumDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EnumDescription(sv, in.enumDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetMetaDataType_enumDataTypes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.simpleDataTypesSize);
	for (i = 0; i < in.simpleDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SimpleTypeDescription(sv, in.simpleDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetMetaDataType_simpleDataTypes", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "DataSetMetaDataType_name", sv);

	sv = newSV(0);
	XS_pack_UA_LocalizedText(sv, in.description);
	hv_stores(hv, "DataSetMetaDataType_description", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.fieldsSize);
	for (i = 0; i < in.fieldsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_FieldMetaData(sv, in.fields[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetMetaDataType_fields", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Guid(sv, in.dataSetClassId);
	hv_stores(hv, "DataSetMetaDataType_dataSetClassId", sv);

	sv = newSV(0);
	XS_pack_UA_ConfigurationVersionDataType(sv, in.configurationVersion);
	hv_stores(hv, "DataSetMetaDataType_configurationVersion", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataSetMetaDataType XS_unpack_UA_DataSetMetaDataType(SV *in)  __attribute__((unused));
static UA_DataSetMetaDataType
XS_unpack_UA_DataSetMetaDataType(SV *in)
{
	dTHX;
	UA_DataSetMetaDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataSetMetaDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataSetMetaDataType_namespaces", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetMetaDataType_namespaces");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.namespaces = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.namespaces == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.namespaces[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.namespacesSize = i;
	}

	svp = hv_fetchs(hv, "DataSetMetaDataType_structureDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetMetaDataType_structureDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.structureDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRUCTUREDESCRIPTION]);
		if (out.structureDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.structureDataTypes[i] = XS_unpack_UA_StructureDescription(*svp);
			}
		}
		out.structureDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "DataSetMetaDataType_enumDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetMetaDataType_enumDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.enumDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENUMDESCRIPTION]);
		if (out.enumDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.enumDataTypes[i] = XS_unpack_UA_EnumDescription(*svp);
			}
		}
		out.enumDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "DataSetMetaDataType_simpleDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetMetaDataType_simpleDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.simpleDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SIMPLETYPEDESCRIPTION]);
		if (out.simpleDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.simpleDataTypes[i] = XS_unpack_UA_SimpleTypeDescription(*svp);
			}
		}
		out.simpleDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "DataSetMetaDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "DataSetMetaDataType_description", 0);
	if (svp != NULL)
		out.description = XS_unpack_UA_LocalizedText(*svp);

	svp = hv_fetchs(hv, "DataSetMetaDataType_fields", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetMetaDataType_fields");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.fields = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_FIELDMETADATA]);
		if (out.fields == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.fields[i] = XS_unpack_UA_FieldMetaData(*svp);
			}
		}
		out.fieldsSize = i;
	}

	svp = hv_fetchs(hv, "DataSetMetaDataType_dataSetClassId", 0);
	if (svp != NULL)
		out.dataSetClassId = XS_unpack_UA_Guid(*svp);

	svp = hv_fetchs(hv, "DataSetMetaDataType_configurationVersion", 0);
	if (svp != NULL)
		out.configurationVersion = XS_unpack_UA_ConfigurationVersionDataType(*svp);

	return out;
}
#endif

/* PublishedDataSetDataType */
#ifdef UA_TYPES_PUBLISHEDDATASETDATATYPE

static void XS_pack_UA_PublishedDataSetDataType(SV *out, UA_PublishedDataSetDataType in)  __attribute__((unused));
static void
XS_pack_UA_PublishedDataSetDataType(SV *out, UA_PublishedDataSetDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "PublishedDataSetDataType_name", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataSetFolderSize);
	for (i = 0; i < in.dataSetFolderSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.dataSetFolder[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishedDataSetDataType_dataSetFolder", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_DataSetMetaDataType(sv, in.dataSetMetaData);
	hv_stores(hv, "PublishedDataSetDataType_dataSetMetaData", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.extensionFieldsSize);
	for (i = 0; i < in.extensionFieldsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.extensionFields[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PublishedDataSetDataType_extensionFields", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.dataSetSource);
	hv_stores(hv, "PublishedDataSetDataType_dataSetSource", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PublishedDataSetDataType XS_unpack_UA_PublishedDataSetDataType(SV *in)  __attribute__((unused));
static UA_PublishedDataSetDataType
XS_unpack_UA_PublishedDataSetDataType(SV *in)
{
	dTHX;
	UA_PublishedDataSetDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PublishedDataSetDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PublishedDataSetDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "PublishedDataSetDataType_dataSetFolder", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishedDataSetDataType_dataSetFolder");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataSetFolder = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.dataSetFolder == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataSetFolder[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.dataSetFolderSize = i;
	}

	svp = hv_fetchs(hv, "PublishedDataSetDataType_dataSetMetaData", 0);
	if (svp != NULL)
		out.dataSetMetaData = XS_unpack_UA_DataSetMetaDataType(*svp);

	svp = hv_fetchs(hv, "PublishedDataSetDataType_extensionFields", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PublishedDataSetDataType_extensionFields");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.extensionFields = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.extensionFields == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.extensionFields[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.extensionFieldsSize = i;
	}

	svp = hv_fetchs(hv, "PublishedDataSetDataType_dataSetSource", 0);
	if (svp != NULL)
		out.dataSetSource = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* DataSetReaderDataType */
#ifdef UA_TYPES_DATASETREADERDATATYPE

static void XS_pack_UA_DataSetReaderDataType(SV *out, UA_DataSetReaderDataType in)  __attribute__((unused));
static void
XS_pack_UA_DataSetReaderDataType(SV *out, UA_DataSetReaderDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "DataSetReaderDataType_name", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.enabled);
	hv_stores(hv, "DataSetReaderDataType_enabled", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.publisherId);
	hv_stores(hv, "DataSetReaderDataType_publisherId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.writerGroupId);
	hv_stores(hv, "DataSetReaderDataType_writerGroupId", sv);

	sv = newSV(0);
	XS_pack_UA_UInt16(sv, in.dataSetWriterId);
	hv_stores(hv, "DataSetReaderDataType_dataSetWriterId", sv);

	sv = newSV(0);
	XS_pack_UA_DataSetMetaDataType(sv, in.dataSetMetaData);
	hv_stores(hv, "DataSetReaderDataType_dataSetMetaData", sv);

	sv = newSV(0);
	XS_pack_UA_DataSetFieldContentMask(sv, in.dataSetFieldContentMask);
	hv_stores(hv, "DataSetReaderDataType_dataSetFieldContentMask", sv);

	sv = newSV(0);
	XS_pack_UA_Double(sv, in.messageReceiveTimeout);
	hv_stores(hv, "DataSetReaderDataType_messageReceiveTimeout", sv);

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.keyFrameCount);
	hv_stores(hv, "DataSetReaderDataType_keyFrameCount", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.headerLayoutUri);
	hv_stores(hv, "DataSetReaderDataType_headerLayoutUri", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "DataSetReaderDataType_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityGroupId);
	hv_stores(hv, "DataSetReaderDataType_securityGroupId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.securityKeyServicesSize);
	for (i = 0; i < in.securityKeyServicesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EndpointDescription(sv, in.securityKeyServices[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetReaderDataType_securityKeyServices", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataSetReaderPropertiesSize);
	for (i = 0; i < in.dataSetReaderPropertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.dataSetReaderProperties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataSetReaderDataType_dataSetReaderProperties", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.transportSettings);
	hv_stores(hv, "DataSetReaderDataType_transportSettings", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.messageSettings);
	hv_stores(hv, "DataSetReaderDataType_messageSettings", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.subscribedDataSet);
	hv_stores(hv, "DataSetReaderDataType_subscribedDataSet", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataSetReaderDataType XS_unpack_UA_DataSetReaderDataType(SV *in)  __attribute__((unused));
static UA_DataSetReaderDataType
XS_unpack_UA_DataSetReaderDataType(SV *in)
{
	dTHX;
	UA_DataSetReaderDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataSetReaderDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataSetReaderDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_enabled", 0);
	if (svp != NULL)
		out.enabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_publisherId", 0);
	if (svp != NULL)
		out.publisherId = XS_unpack_UA_Variant(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_writerGroupId", 0);
	if (svp != NULL)
		out.writerGroupId = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_dataSetWriterId", 0);
	if (svp != NULL)
		out.dataSetWriterId = XS_unpack_UA_UInt16(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_dataSetMetaData", 0);
	if (svp != NULL)
		out.dataSetMetaData = XS_unpack_UA_DataSetMetaDataType(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_dataSetFieldContentMask", 0);
	if (svp != NULL)
		out.dataSetFieldContentMask = XS_unpack_UA_DataSetFieldContentMask(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_messageReceiveTimeout", 0);
	if (svp != NULL)
		out.messageReceiveTimeout = XS_unpack_UA_Double(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_keyFrameCount", 0);
	if (svp != NULL)
		out.keyFrameCount = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_headerLayoutUri", 0);
	if (svp != NULL)
		out.headerLayoutUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_securityGroupId", 0);
	if (svp != NULL)
		out.securityGroupId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_securityKeyServices", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetReaderDataType_securityKeyServices");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.securityKeyServices = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENDPOINTDESCRIPTION]);
		if (out.securityKeyServices == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.securityKeyServices[i] = XS_unpack_UA_EndpointDescription(*svp);
			}
		}
		out.securityKeyServicesSize = i;
	}

	svp = hv_fetchs(hv, "DataSetReaderDataType_dataSetReaderProperties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataSetReaderDataType_dataSetReaderProperties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataSetReaderProperties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.dataSetReaderProperties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataSetReaderProperties[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.dataSetReaderPropertiesSize = i;
	}

	svp = hv_fetchs(hv, "DataSetReaderDataType_transportSettings", 0);
	if (svp != NULL)
		out.transportSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_messageSettings", 0);
	if (svp != NULL)
		out.messageSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "DataSetReaderDataType_subscribedDataSet", 0);
	if (svp != NULL)
		out.subscribedDataSet = XS_unpack_UA_ExtensionObject(*svp);

	return out;
}
#endif

/* TargetVariablesDataType */
#ifdef UA_TYPES_TARGETVARIABLESDATATYPE

static void XS_pack_UA_TargetVariablesDataType(SV *out, UA_TargetVariablesDataType in)  __attribute__((unused));
static void
XS_pack_UA_TargetVariablesDataType(SV *out, UA_TargetVariablesDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.targetVariablesSize);
	for (i = 0; i < in.targetVariablesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_FieldTargetDataType(sv, in.targetVariables[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "TargetVariablesDataType_targetVariables", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_TargetVariablesDataType XS_unpack_UA_TargetVariablesDataType(SV *in)  __attribute__((unused));
static UA_TargetVariablesDataType
XS_unpack_UA_TargetVariablesDataType(SV *in)
{
	dTHX;
	UA_TargetVariablesDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_TargetVariablesDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "TargetVariablesDataType_targetVariables", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for TargetVariablesDataType_targetVariables");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.targetVariables = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_FIELDTARGETDATATYPE]);
		if (out.targetVariables == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.targetVariables[i] = XS_unpack_UA_FieldTargetDataType(*svp);
			}
		}
		out.targetVariablesSize = i;
	}

	return out;
}
#endif

/* DataTypeSchemaHeader */
#ifdef UA_TYPES_DATATYPESCHEMAHEADER

static void XS_pack_UA_DataTypeSchemaHeader(SV *out, UA_DataTypeSchemaHeader in)  __attribute__((unused));
static void
XS_pack_UA_DataTypeSchemaHeader(SV *out, UA_DataTypeSchemaHeader in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.namespacesSize);
	for (i = 0; i < in.namespacesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_String(sv, in.namespaces[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataTypeSchemaHeader_namespaces", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.structureDataTypesSize);
	for (i = 0; i < in.structureDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_StructureDescription(sv, in.structureDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataTypeSchemaHeader_structureDataTypes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.enumDataTypesSize);
	for (i = 0; i < in.enumDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EnumDescription(sv, in.enumDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataTypeSchemaHeader_enumDataTypes", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.simpleDataTypesSize);
	for (i = 0; i < in.simpleDataTypesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_SimpleTypeDescription(sv, in.simpleDataTypes[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "DataTypeSchemaHeader_simpleDataTypes", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_DataTypeSchemaHeader XS_unpack_UA_DataTypeSchemaHeader(SV *in)  __attribute__((unused));
static UA_DataTypeSchemaHeader
XS_unpack_UA_DataTypeSchemaHeader(SV *in)
{
	dTHX;
	UA_DataTypeSchemaHeader out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_DataTypeSchemaHeader_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "DataTypeSchemaHeader_namespaces", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataTypeSchemaHeader_namespaces");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.namespaces = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRING]);
		if (out.namespaces == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.namespaces[i] = XS_unpack_UA_String(*svp);
			}
		}
		out.namespacesSize = i;
	}

	svp = hv_fetchs(hv, "DataTypeSchemaHeader_structureDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataTypeSchemaHeader_structureDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.structureDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_STRUCTUREDESCRIPTION]);
		if (out.structureDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.structureDataTypes[i] = XS_unpack_UA_StructureDescription(*svp);
			}
		}
		out.structureDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "DataTypeSchemaHeader_enumDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataTypeSchemaHeader_enumDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.enumDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENUMDESCRIPTION]);
		if (out.enumDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.enumDataTypes[i] = XS_unpack_UA_EnumDescription(*svp);
			}
		}
		out.enumDataTypesSize = i;
	}

	svp = hv_fetchs(hv, "DataTypeSchemaHeader_simpleDataTypes", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for DataTypeSchemaHeader_simpleDataTypes");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.simpleDataTypes = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_SIMPLETYPEDESCRIPTION]);
		if (out.simpleDataTypes == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.simpleDataTypes[i] = XS_unpack_UA_SimpleTypeDescription(*svp);
			}
		}
		out.simpleDataTypesSize = i;
	}

	return out;
}
#endif

/* ReaderGroupDataType */
#ifdef UA_TYPES_READERGROUPDATATYPE

static void XS_pack_UA_ReaderGroupDataType(SV *out, UA_ReaderGroupDataType in)  __attribute__((unused));
static void
XS_pack_UA_ReaderGroupDataType(SV *out, UA_ReaderGroupDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "ReaderGroupDataType_name", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.enabled);
	hv_stores(hv, "ReaderGroupDataType_enabled", sv);

	sv = newSV(0);
	XS_pack_UA_MessageSecurityMode(sv, in.securityMode);
	hv_stores(hv, "ReaderGroupDataType_securityMode", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.securityGroupId);
	hv_stores(hv, "ReaderGroupDataType_securityGroupId", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.securityKeyServicesSize);
	for (i = 0; i < in.securityKeyServicesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_EndpointDescription(sv, in.securityKeyServices[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReaderGroupDataType_securityKeyServices", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_UInt32(sv, in.maxNetworkMessageSize);
	hv_stores(hv, "ReaderGroupDataType_maxNetworkMessageSize", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.groupPropertiesSize);
	for (i = 0; i < in.groupPropertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.groupProperties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReaderGroupDataType_groupProperties", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.transportSettings);
	hv_stores(hv, "ReaderGroupDataType_transportSettings", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.messageSettings);
	hv_stores(hv, "ReaderGroupDataType_messageSettings", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.dataSetReadersSize);
	for (i = 0; i < in.dataSetReadersSize; i++) {
		sv = newSV(0);
		XS_pack_UA_DataSetReaderDataType(sv, in.dataSetReaders[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "ReaderGroupDataType_dataSetReaders", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_ReaderGroupDataType XS_unpack_UA_ReaderGroupDataType(SV *in)  __attribute__((unused));
static UA_ReaderGroupDataType
XS_unpack_UA_ReaderGroupDataType(SV *in)
{
	dTHX;
	UA_ReaderGroupDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_ReaderGroupDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "ReaderGroupDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ReaderGroupDataType_enabled", 0);
	if (svp != NULL)
		out.enabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "ReaderGroupDataType_securityMode", 0);
	if (svp != NULL)
		out.securityMode = XS_unpack_UA_MessageSecurityMode(*svp);

	svp = hv_fetchs(hv, "ReaderGroupDataType_securityGroupId", 0);
	if (svp != NULL)
		out.securityGroupId = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "ReaderGroupDataType_securityKeyServices", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReaderGroupDataType_securityKeyServices");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.securityKeyServices = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_ENDPOINTDESCRIPTION]);
		if (out.securityKeyServices == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.securityKeyServices[i] = XS_unpack_UA_EndpointDescription(*svp);
			}
		}
		out.securityKeyServicesSize = i;
	}

	svp = hv_fetchs(hv, "ReaderGroupDataType_maxNetworkMessageSize", 0);
	if (svp != NULL)
		out.maxNetworkMessageSize = XS_unpack_UA_UInt32(*svp);

	svp = hv_fetchs(hv, "ReaderGroupDataType_groupProperties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReaderGroupDataType_groupProperties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.groupProperties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.groupProperties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.groupProperties[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.groupPropertiesSize = i;
	}

	svp = hv_fetchs(hv, "ReaderGroupDataType_transportSettings", 0);
	if (svp != NULL)
		out.transportSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "ReaderGroupDataType_messageSettings", 0);
	if (svp != NULL)
		out.messageSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "ReaderGroupDataType_dataSetReaders", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for ReaderGroupDataType_dataSetReaders");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.dataSetReaders = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_DATASETREADERDATATYPE]);
		if (out.dataSetReaders == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.dataSetReaders[i] = XS_unpack_UA_DataSetReaderDataType(*svp);
			}
		}
		out.dataSetReadersSize = i;
	}

	return out;
}
#endif

/* PubSubConnectionDataType */
#ifdef UA_TYPES_PUBSUBCONNECTIONDATATYPE

static void XS_pack_UA_PubSubConnectionDataType(SV *out, UA_PubSubConnectionDataType in)  __attribute__((unused));
static void
XS_pack_UA_PubSubConnectionDataType(SV *out, UA_PubSubConnectionDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	sv = newSV(0);
	XS_pack_UA_String(sv, in.name);
	hv_stores(hv, "PubSubConnectionDataType_name", sv);

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.enabled);
	hv_stores(hv, "PubSubConnectionDataType_enabled", sv);

	sv = newSV(0);
	XS_pack_UA_Variant(sv, in.publisherId);
	hv_stores(hv, "PubSubConnectionDataType_publisherId", sv);

	sv = newSV(0);
	XS_pack_UA_String(sv, in.transportProfileUri);
	hv_stores(hv, "PubSubConnectionDataType_transportProfileUri", sv);

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.address);
	hv_stores(hv, "PubSubConnectionDataType_address", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.connectionPropertiesSize);
	for (i = 0; i < in.connectionPropertiesSize; i++) {
		sv = newSV(0);
		XS_pack_UA_KeyValuePair(sv, in.connectionProperties[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PubSubConnectionDataType_connectionProperties", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_ExtensionObject(sv, in.transportSettings);
	hv_stores(hv, "PubSubConnectionDataType_transportSettings", sv);

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.writerGroupsSize);
	for (i = 0; i < in.writerGroupsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_WriterGroupDataType(sv, in.writerGroups[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PubSubConnectionDataType_writerGroups", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.readerGroupsSize);
	for (i = 0; i < in.readerGroupsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_ReaderGroupDataType(sv, in.readerGroups[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PubSubConnectionDataType_readerGroups", newRV_inc((SV*)av));

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PubSubConnectionDataType XS_unpack_UA_PubSubConnectionDataType(SV *in)  __attribute__((unused));
static UA_PubSubConnectionDataType
XS_unpack_UA_PubSubConnectionDataType(SV *in)
{
	dTHX;
	UA_PubSubConnectionDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PubSubConnectionDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PubSubConnectionDataType_name", 0);
	if (svp != NULL)
		out.name = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "PubSubConnectionDataType_enabled", 0);
	if (svp != NULL)
		out.enabled = XS_unpack_UA_Boolean(*svp);

	svp = hv_fetchs(hv, "PubSubConnectionDataType_publisherId", 0);
	if (svp != NULL)
		out.publisherId = XS_unpack_UA_Variant(*svp);

	svp = hv_fetchs(hv, "PubSubConnectionDataType_transportProfileUri", 0);
	if (svp != NULL)
		out.transportProfileUri = XS_unpack_UA_String(*svp);

	svp = hv_fetchs(hv, "PubSubConnectionDataType_address", 0);
	if (svp != NULL)
		out.address = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "PubSubConnectionDataType_connectionProperties", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PubSubConnectionDataType_connectionProperties");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.connectionProperties = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_KEYVALUEPAIR]);
		if (out.connectionProperties == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.connectionProperties[i] = XS_unpack_UA_KeyValuePair(*svp);
			}
		}
		out.connectionPropertiesSize = i;
	}

	svp = hv_fetchs(hv, "PubSubConnectionDataType_transportSettings", 0);
	if (svp != NULL)
		out.transportSettings = XS_unpack_UA_ExtensionObject(*svp);

	svp = hv_fetchs(hv, "PubSubConnectionDataType_writerGroups", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PubSubConnectionDataType_writerGroups");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.writerGroups = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_WRITERGROUPDATATYPE]);
		if (out.writerGroups == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.writerGroups[i] = XS_unpack_UA_WriterGroupDataType(*svp);
			}
		}
		out.writerGroupsSize = i;
	}

	svp = hv_fetchs(hv, "PubSubConnectionDataType_readerGroups", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PubSubConnectionDataType_readerGroups");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.readerGroups = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_READERGROUPDATATYPE]);
		if (out.readerGroups == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.readerGroups[i] = XS_unpack_UA_ReaderGroupDataType(*svp);
			}
		}
		out.readerGroupsSize = i;
	}

	return out;
}
#endif

/* PubSubConfigurationDataType */
#ifdef UA_TYPES_PUBSUBCONFIGURATIONDATATYPE

static void XS_pack_UA_PubSubConfigurationDataType(SV *out, UA_PubSubConfigurationDataType in)  __attribute__((unused));
static void
XS_pack_UA_PubSubConfigurationDataType(SV *out, UA_PubSubConfigurationDataType in)
{
	dTHX;
	SV *sv;
	AV *av;
	size_t i;
	HV *hv = newHV();

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.publishedDataSetsSize);
	for (i = 0; i < in.publishedDataSetsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_PublishedDataSetDataType(sv, in.publishedDataSets[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PubSubConfigurationDataType_publishedDataSets", newRV_inc((SV*)av));

	av = (AV*)sv_2mortal((SV*)newAV());
	av_extend(av, in.connectionsSize);
	for (i = 0; i < in.connectionsSize; i++) {
		sv = newSV(0);
		XS_pack_UA_PubSubConnectionDataType(sv, in.connections[i]);
		av_push(av, sv);
	}
	hv_stores(hv, "PubSubConfigurationDataType_connections", newRV_inc((SV*)av));

	sv = newSV(0);
	XS_pack_UA_Boolean(sv, in.enabled);
	hv_stores(hv, "PubSubConfigurationDataType_enabled", sv);

	sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hv)));
}

static UA_PubSubConfigurationDataType XS_unpack_UA_PubSubConfigurationDataType(SV *in)  __attribute__((unused));
static UA_PubSubConfigurationDataType
XS_unpack_UA_PubSubConfigurationDataType(SV *in)
{
	dTHX;
	UA_PubSubConfigurationDataType out;
	SV **svp;
	AV *av;
	ssize_t i, top;
	HV *hv;

	SvGETMAGIC(in);
	if (!SvROK(in) || SvTYPE(SvRV(in)) != SVt_PVHV) {
		CROAK("Not a HASH reference");
	}
	UA_PubSubConfigurationDataType_init(&out);
	hv = (HV*)SvRV(in);

	svp = hv_fetchs(hv, "PubSubConfigurationDataType_publishedDataSets", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PubSubConfigurationDataType_publishedDataSets");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.publishedDataSets = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_PUBLISHEDDATASETDATATYPE]);
		if (out.publishedDataSets == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.publishedDataSets[i] = XS_unpack_UA_PublishedDataSetDataType(*svp);
			}
		}
		out.publishedDataSetsSize = i;
	}

	svp = hv_fetchs(hv, "PubSubConfigurationDataType_connections", 0);
	if (svp != NULL) {
		if (!SvROK(*svp) || SvTYPE(SvRV(*svp)) != SVt_PVAV) {
			CROAK("No ARRAY reference for PubSubConfigurationDataType_connections");
		}
		av = (AV*)SvRV(*svp);
		top = av_top_index(av);
		out.connections = UA_Array_new(top + 1, &UA_TYPES[UA_TYPES_PUBSUBCONNECTIONDATATYPE]);
		if (out.connections == NULL) {
			CROAKE("UA_Array_new");
		}
		for (i = 0; i <= top; i++) {
			svp = av_fetch(av, i, 0);
			if (svp != NULL) {
				out.connections[i] = XS_unpack_UA_PubSubConnectionDataType(*svp);
			}
		}
		out.connectionsSize = i;
	}

	svp = hv_fetchs(hv, "PubSubConfigurationDataType_enabled", 0);
	if (svp != NULL)
		out.enabled = XS_unpack_UA_Boolean(*svp);

	return out;
}
#endif
